/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.EffectType;
import com.intellij.database.dialects.base.generator.Node;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.OperationType;
import com.intellij.database.dialects.base.generator.Producer;
import com.intellij.database.dialects.base.generator.RequiredEffect;
import com.intellij.database.dialects.base.generator.ScenarioOperations;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0017J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\bH\u0016J$\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0010\u00a2\u0006\u0002\b\u001eR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/base/generator/BaseTruncateGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "prepared", "", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/dialects/base/generator/Operation;", "getPrepared", "()Ljava/util/Map;", "breakByJoinedTruncate", "", "cycle", "", "breakCycle", "elements", "", "fillDependencies", "", "fillTruncateDependants", "e", "makeOperation", "element", "makeTruncateOperation", "root", "prepareElement", "forceRoot", "prepareScenario", "preparedOperations", "preparedOperations$intellij_database_dialects_base", "Companion", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseTruncateGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseTruncateGenerator.kt\ncom/intellij/database/dialects/base/generator/BaseTruncateGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1855#2,2:73\n766#2:75\n857#2,2:76\n1855#2,2:78\n1855#2,2:80\n1855#2,2:82\n1#3:84\n*S KotlinDebug\n*F\n+ 1 BaseTruncateGenerator.kt\ncom/intellij/database/dialects/base/generator/BaseTruncateGenerator\n*L\n20#1:73,2\n42#1:75\n42#1:76,2\n42#1:78,2\n50#1:80,2\n54#1:82,2\n*E\n"})
public class BaseTruncateGenerator
extends AbstractCodeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<BasicElement, Operation> prepared;
    @NotNull
    private static final OperationType TRUNCATE = new OperationType("truncate");

    public BaseTruncateGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, null, 2, null);
        this.prepared = new LinkedHashMap();
    }

    @NotNull
    public final Map<BasicElement, Operation> getPrepared() {
        return this.prepared;
    }

    @Override
    @TestOnly
    @Nullable
    public Operation makeOperation(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.makeTruncateOperation(element2, this.getScenario().getRoot());
    }

    @Override
    public void prepareScenario() {
        Iterable $this$forEach$iv = this.elements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it2 = (BasicElement)element$iv;
            boolean bl = false;
            this.makeTruncateOperation(it2, this.getScenario().getRoot());
        }
        this.fillDependencies();
    }

    @Override
    @NotNull
    public List<Operation> preparedOperations$intellij_database_dialects_base() {
        return CollectionsKt.toList((Iterable)this.prepared.values());
    }

    @Override
    protected boolean breakCycle(@NotNull List<Operation> cycle) {
        Intrinsics.checkNotNullParameter(cycle, (String)"cycle");
        if (this.breakByJoinedTruncate(cycle)) {
            return true;
        }
        return super.breakCycle(cycle);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakByJoinedTruncate(List<Operation> cycle) {
        for (Operation op : cycle) {
            if (op.getProducer() instanceof TruncateProducer) continue;
            return false;
        }
        Operation root2 = (Operation)CollectionsKt.first(cycle);
        Producer producer = root2.getProducer();
        Intrinsics.checkNotNull((Object)producer, (String)"null cannot be cast to non-null type com.intellij.database.dialects.base.generator.producers.TruncateProducer<*>");
        if (!((TruncateProducer)producer).canGroup()) {
            return false;
        }
        for (Operation op : cycle) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            if (Intrinsics.areEqual((Object)op, (Object)root2)) continue;
            op.setParent((Node)root2);
            Iterable $this$filter$iv = op.getNestedOperations();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Operation it2 = (Operation)element$iv$iv;
                boolean bl = false;
                if (!(it2.getProducer() instanceof TruncateProducer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Operation it3 = (Operation)element$iv;
                boolean bl = false;
                it3.setParent((Node)root2);
            }
        }
        return true;
    }

    private final void fillDependencies() {
        Iterable $this$forEach$iv = this.prepared.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it2 = (BasicElement)element$iv;
            boolean bl = false;
            this.fillTruncateDependants(it2);
        }
    }

    private final void fillTruncateDependants(BasicElement e2) {
        block1: {
            Family<? extends BasicElement> family = e2.familyOf(ObjectKind.FOREIGN_KEY);
            if (family == null) break block1;
            Iterable $this$forEach$iv = family;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicElement it2 = (BasicElement)element$iv;
                boolean bl = false;
                BasicNamedElement basicNamedElement = it2 instanceof BasicForeignKey ? (BasicForeignKey)it2 : null;
                if (basicNamedElement == null || (basicNamedElement = basicNamedElement.getRefTable()) == null) continue;
                BasicNamedElement basicNamedElement2 = basicNamedElement;
                Intrinsics.checkNotNull((Object)basicNamedElement2);
                BasicNamedElement tab2 = basicNamedElement2;
                Operation operation2 = this.prepared.get(tab2);
                if (operation2 == null) continue;
                RequiredEffect[] requiredEffectArray = new RequiredEffect[]{ScenarioOperations.matches$default(EffectType.NoData, e2, null, 2, null)};
                ScenarioOperations.requires(operation2, requiredEffectArray);
            }
        }
    }

    private final Collection<BasicElement> elements() {
        ScriptingTask scriptingTask = this.getContext().getTask();
        Object object = scriptingTask instanceof ScriptingSingleModelTask ? (ScriptingSingleModelTask)scriptingTask : null;
        if (object == null || (object = ((ScriptingSingleModelTask)object).getElements()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public Operation prepareElement(@NotNull BasicElement element2, @NotNull Operation root2, boolean forceRoot) {
        Operation operation2;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Operation operation3 = this.prepared.get(element2);
        if (operation3 != null) {
            Operation operation4;
            Operation $this$prepareElement_u24lambda_u245 = operation4 = operation3;
            boolean bl = false;
            if (forceRoot) {
                $this$prepareElement_u24lambda_u245.setParent((Node)root2);
            }
            operation2 = operation4;
        } else {
            operation2 = this.makeTruncateOperation(element2, root2);
        }
        return operation2;
    }

    public static /* synthetic */ Operation prepareElement$default(BaseTruncateGenerator baseTruncateGenerator, BasicElement basicElement, Operation operation2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return baseTruncateGenerator.prepareElement(basicElement, operation2, bl);
    }

    @NotNull
    public Operation makeTruncateOperation(@NotNull BasicElement element2, @NotNull Operation root2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        return this.getContext().getHelper().createTruncateProducer(this.getContext(), element2).register(this, root2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/base/generator/BaseTruncateGenerator$Companion;", "", "()V", "TRUNCATE", "Lcom/intellij/database/dialects/base/generator/OperationType;", "getTRUNCATE", "()Lcom/intellij/database/dialects/base/generator/OperationType;", "intellij.database.dialects.base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OperationType getTRUNCATE() {
            return TRUNCATE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

