/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingInternalTask;
import com.intellij.database.script.generator.ScriptingNativeDefinitionTask;
import com.intellij.database.script.generator.ScriptingOrder;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0014J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H$J\b\u0010\u0015\u001a\u00020\u0011H\u0014J\b\u0010\u0016\u001a\u00020\u0011H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0010\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0004J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J)\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"H\u0014\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractTransitionCodeGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "deck", "Ljava/util/Deque;", "Lcom/intellij/database/model/basic/BasicElement;", "getDeck", "()Ljava/util/Deque;", "generated", "", "getGenerated", "()Ljava/util/Set;", "postponed", "Lcom/intellij/util/containers/MultiMap;", "finishElement", "", "element", "generate", "generateElement", "generateFooting", "generateHeading", "isNewCodeGen", "", "preparedOperations", "", "Lcom/intellij/database/dialects/base/generator/Operation;", "preparedOperations$intellij_database_dialects_base", "process", "processElement", "processInnerElements", "kinds", "", "Lcom/intellij/database/model/ObjectKind;", "(Lcom/intellij/database/model/basic/BasicElement;[Lcom/intellij/database/model/ObjectKind;)V", "setElementsToGenerate", "elements", "", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nAbstractTransitionCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTransitionCodeGenerator.kt\ncom/intellij/database/dialects/base/generator/AbstractTransitionCodeGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public abstract class AbstractTransitionCodeGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final Deque<BasicElement> deck;
    @NotNull
    private final MultiMap<BasicElement, BasicElement> postponed;
    @NotNull
    private final Set<BasicElement> generated;

    /*
     * WARNING - void declaration
     */
    public AbstractTransitionCodeGenerator(@NotNull ScriptingContext context) {
        Collection collection2;
        void it2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, null, 2, null);
        this.deck = new ArrayDeque();
        this.postponed = new MultiMap();
        this.generated = new HashSet();
        ScriptingTask scriptingTask = context.getTask();
        AbstractTransitionCodeGenerator abstractTransitionCodeGenerator = this;
        boolean bl = false;
        void var4_5 = it2;
        if (var4_5 instanceof ScriptingSingleModelTask) {
            collection2 = ((ScriptingSingleModelTask)it2).getElements();
        } else if (var4_5 instanceof ScriptingNativeDefinitionTask) {
            collection2 = ((ScriptingNativeDefinitionTask)it2).getElements();
        } else if (var4_5 instanceof ScriptingAlterTask) {
            collection2 = CollectionsKt.emptyList();
        } else if (var4_5 instanceof ScriptingInternalTask) {
            collection2 = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        abstractTransitionCodeGenerator.setElementsToGenerate(collection2);
    }

    @NotNull
    protected final Deque<BasicElement> getDeck() {
        return this.deck;
    }

    @NotNull
    protected final Set<BasicElement> getGenerated() {
        return this.generated;
    }

    @Override
    @NotNull
    public List<Operation> preparedOperations$intellij_database_dialects_base() {
        List<Operation> list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
        return list;
    }

    @Override
    protected boolean isNewCodeGen() {
        return false;
    }

    private final void setElementsToGenerate(Iterable<? extends BasicElement> elements2) {
        MultiMap sorted = new MultiMap((Map)new TreeMap());
        for (BasicElement basicElement : elements2) {
            sorted.putValue((Object)this.getContext().getHelper().getObjectPreliminaryOrder(basicElement), (Object)basicElement);
        }
        for (BasicElement basicElement : sorted.values()) {
            this.deck.offer(basicElement);
        }
    }

    public void generate() {
        this.generateHeading();
        while (true) {
            BasicElement basicElement = this.getContext().getTask().getCategory().getOrder() == ScriptingOrder.REVERS_ORDER ? this.deck.pollLast() : this.deck.poll();
            if (basicElement == null) break;
            BasicElement element2 = basicElement;
            if (element2.isAutoCreated()) continue;
            this.process(element2);
        }
        this.generateFooting();
    }

    protected void generateHeading() {
    }

    protected void generateFooting() {
    }

    protected final void process(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!this.generated.contains(element2)) {
            if (this.getContext().getTask().getCategory().getOrder() == ScriptingOrder.NORMAL_ORDER && !this.isNewCodeGen()) {
                Iterable<? extends BasicElement> iterable = element2.getPredecessors();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getPredecessors(...)");
                Iterable<? extends BasicElement> predecessors = iterable;
                boolean postpone = false;
                for (BasicElement basicElement : predecessors) {
                    if (this.generated.contains(basicElement) || !this.deck.contains(basicElement)) continue;
                    this.postponed.putValue((Object)basicElement, (Object)element2);
                    postpone = true;
                }
                if (postpone) {
                    return;
                }
            }
            this.processElement(element2);
            if (!this.generated.contains(element2)) {
                return;
            }
        }
        if (this.getContext().getLocus() == ScriptLocus.IN_SCHEMA || this.getContext().getLocus() == ScriptLocus.OUTSIDE) {
            boolean bl;
            Collection collection2 = this.postponed.get((Object)element2);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
            Iterable pendingElements = collection2;
            boolean bl2 = bl = !this.isNewCodeGen() || this.postponed.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            for (BasicElement pendingElement : pendingElements) {
                this.process(pendingElement);
            }
        }
    }

    private final void processElement(BasicElement element2) {
        this.generateElement(element2);
        this.finishElement(element2);
    }

    protected abstract void generateElement(@NotNull BasicElement var1);

    protected void finishElement(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.generated.add(element2);
    }

    protected void processInnerElements(@NotNull BasicElement element2, ObjectKind ... kinds) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)kinds, (String)"kinds");
        ArrayList innerElements = new ArrayList();
        for (ObjectKind kind : kinds) {
            Family<? extends BasicElement> f = element2.familyOf(kind);
            if (f == null) continue;
            CollectionsKt.addAll((Collection)innerElements, (Iterable)f);
        }
        int n = innerElements.size();
        if (n == 0) {
            return;
        }
        if (n >= 2 && this.getContext().getTask().getCategory().getOrder() == ScriptingOrder.REVERS_ORDER) {
            Collections.reverse(innerElements);
        }
        for (BasicElement innerElement : innerElements) {
            Intrinsics.checkNotNull((Object)innerElement);
            this.process(innerElement);
        }
    }
}

