/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeNames {
    private static final Pattern SCALE_OPT = Pattern.compile("\\[([^\\[\\]]*)\\$s([^\\[\\]]*)]");
    private final MultiMap<String, Integer> myTypeNames = new MyMultiMap<String, Integer>(CollectionFactory.createCaseInsensitiveStringMap());
    private final Int2ObjectMap<MultiMap<Integer, String>> myTypeMap = new Int2ObjectOpenHashMap();

    private Collection<String> get(int jdbcType) {
        return this.getImpl(jdbcType, false).get((Object)Integer.MAX_VALUE);
    }

    private MultiMap<Integer, String> getImpl(int jdbcType, boolean createIfMissing) {
        MyMultiMap map2 = (MyMultiMap)((Object)this.myTypeMap.get(jdbcType));
        if (map2 == null && createIfMissing) {
            map2 = new MyMultiMap();
            this.myTypeMap.put(jdbcType, map2);
        }
        return map2 == null ? MultiMap.empty() : map2;
    }

    @Nullable
    public String get(int jdbcType, int size, int precision, int scale) {
        MultiMap map2 = (MultiMap)this.myTypeMap.get(jdbcType);
        if (map2 != null && map2.size() > 0) {
            for (Map.Entry o2 : map2.entrySet()) {
                if (size > (Integer)o2.getKey()) continue;
                return TypeNames.replace((String)ContainerUtil.iterateAndGetLastItem((Iterable)((Iterable)o2.getValue())), size, precision, scale);
            }
        }
        return TypeNames.replace((String)ContainerUtil.iterateAndGetLastItem(this.get(jdbcType)), size, precision, scale);
    }

    @Nullable
    private static String replace(String type, int size, int precision, int scale) {
        type = TypeNames.replaceOnceOrOpt(type, "$s", SCALE_OPT, scale);
        type = TypeNames.replaceOnce(type, "$l", size);
        return TypeNames.replaceOnce(type, "$p", precision);
    }

    public void put(int jdbcType, int capacity, String value2) {
        this.myTypeNames.putValue((Object)DataTypeFactory.of((String)value2).typeName, (Object)jdbcType);
        MyMultiMap map2 = (MyMultiMap)((Object)this.myTypeMap.get(jdbcType));
        if (map2 == null) {
            map2 = new MyMultiMap();
            this.myTypeMap.put(jdbcType, map2);
        }
        map2.putValue(capacity, value2);
    }

    public void put(int jdbcType, String value2) {
        this.myTypeNames.putValue((Object)DataTypeFactory.of((String)value2).typeName, (Object)jdbcType);
        this.getImpl(jdbcType, true).putValue((Object)Integer.MAX_VALUE, (Object)value2);
    }

    @NotNull
    public String getType(@NotNull String name2, int length, int precision, int scale) {
        if (name2 == null) {
            TypeNames.$$$reportNull$$$0(0);
        }
        int minSize = Integer.MAX_VALUE;
        String minName = name2;
        Iterator iterator = this.myTypeNames.get((Object)name2).iterator();
        while (iterator.hasNext()) {
            int jdbcType = (Integer)iterator.next();
            MultiMap map2 = (MultiMap)this.myTypeMap.get(jdbcType);
            for (Map.Entry e2 : map2.entrySet()) {
                int upperBound = (Integer)e2.getKey();
                if (length > 0 && length > upperBound || upperBound > minSize) continue;
                for (String s2 : (Collection)e2.getValue()) {
                    String replace = TypeNames.replace(s2, length, precision, scale);
                    if (replace == null || !TypeNames.isSamePrefix(name2, replace)) continue;
                    minName = replace;
                    minSize = upperBound;
                }
            }
        }
        String string = minName;
        if (string == null) {
            TypeNames.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static String replaceOnce(@Nullable String template, @NotNull String placeholder, int replacement) {
        if (placeholder == null) {
            TypeNames.$$$reportNull$$$0(2);
        }
        if (template == null) {
            return null;
        }
        if (template.contains(placeholder) && replacement < 0) {
            return null;
        }
        return template.replace(placeholder, String.valueOf(replacement));
    }

    @Nullable
    private static String replaceOnceOrOpt(@Nullable String template, @NotNull String placeholder, @NotNull Pattern pattern2, int replacement) {
        if (placeholder == null) {
            TypeNames.$$$reportNull$$$0(3);
        }
        if (pattern2 == null) {
            TypeNames.$$$reportNull$$$0(4);
        }
        if (template == null) {
            return null;
        }
        Matcher matcher = pattern2.matcher(template);
        if (!matcher.find()) {
            return TypeNames.replaceOnce(template, placeholder, replacement);
        }
        return matcher.replaceFirst((String)(replacement <= 0 ? "" : "$1" + Matcher.quoteReplacement(String.valueOf(replacement)) + "$2"));
    }

    private static boolean isSamePrefix(@NotNull String typeName, @NotNull String replaced) {
        if (typeName == null) {
            TypeNames.$$$reportNull$$$0(5);
        }
        if (replaced == null) {
            TypeNames.$$$reportNull$$$0(6);
        }
        if (!replaced.startsWith(typeName)) {
            return false;
        }
        if (replaced.length() == typeName.length()) {
            return true;
        }
        return replaced.charAt(typeName.length()) == '(';
    }

    public int findTypeCode(@NotNull String spec2) {
        if (spec2 == null) {
            TypeNames.$$$reportNull$$$0(7);
        }
        DataType dataType = DataTypeFactory.of(spec2);
        int length = dataType.getLength();
        int def = 1111;
        Iterator iterator = this.myTypeNames.get((Object)dataType.typeName).iterator();
        while (iterator.hasNext()) {
            int jdbcType = (Integer)iterator.next();
            MultiMap map2 = (MultiMap)this.myTypeMap.get(jdbcType);
            for (Map.Entry e2 : map2.entrySet()) {
                if (length > 0 && length > (Integer)e2.getKey()) continue;
                for (String s2 : (Collection)e2.getValue()) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)s2, (CharSequence)spec2)) continue;
                    return jdbcType;
                }
                if ((Integer)e2.getKey() == Integer.MAX_VALUE) {
                    def = jdbcType;
                    continue;
                }
                return jdbcType;
            }
        }
        return def;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/TypeNames";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaced";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/TypeNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceOnce";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceOnceOrOpt";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSamePrefix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTypeCode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class MyMultiMap<K, V>
    extends MultiMap<K, V> {
        private MyMultiMap() {
            this(new TreeMap());
        }

        private MyMultiMap(Map<K, Collection<V>> map2) {
            super(map2);
        }

        @NotNull
        protected Collection<V> createCollection() {
            Set set = CollectionFactory.createSmallMemoryFootprintLinkedSet();
            if (set == null) {
                MyMultiMap.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/base/TypeNames$MyMultiMap", "createCollection"));
        }
    }
}

