/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.LimitPlace;
import com.intellij.database.dialects.base.generator.dml.BaseColumnsOrderByGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseDeleteRowsGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseInsertRowsGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseMultiInsertRowsGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseQueryColumnsGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseSelectGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseUpdateRowGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseWhereClauseGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseWrapInSelectGenerator;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.script.generator.dml.ColumnsOrderByTask;
import com.intellij.database.script.generator.dml.DeleteRowsTask;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.ExpressionColumn;
import com.intellij.database.script.generator.dml.InsertRowsTask;
import com.intellij.database.script.generator.dml.MultiInsertRowsTask;
import com.intellij.database.script.generator.dml.QueryColumnsTask;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.UpdateRowTask;
import com.intellij.database.script.generator.dml.WhereClauseTask;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J*\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016J:\u0010\u001e\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\bH\u0016J\u001e\u0010&\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020#J(\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\bH\u0016J \u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u001a\u00100\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u00101\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u00102\u001a\u00020#H\u0004J!\u00103\u001a\u0002H4\"\u0004\b\u0000\u001042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H406H\u0016\u00a2\u0006\u0002\u00107J0\u00108\u001a\u0016\u0012\u0004\u0012\u0002H4\u0012\n\u0012\b\u0012\u0004\u0012\u0002H406\u0018\u000109\"\u0004\b\u0000\u001042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H406H\u0014J\b\u0010:\u001a\u00020;H\u0016J\u001a\u0010<\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0012\u0010@\u001a\u00020\b2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J \u0010C\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u00102\u001a\u00020#2\u0006\u0010%\u001a\u00020\bH\u0004J\u0012\u0010D\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001aH\u0016J \u0010E\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006G"}, d2={"Lcom/intellij/database/dialects/base/BaseDmlHelper;", "Lcom/intellij/database/script/generator/dml/DmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "hideRowId", "", "getHideRowId", "()Z", "needAliasInDeleteStatement", "getNeedAliasInDeleteStatement", "needAliasInUpdateStatement", "getNeedAliasInUpdateStatement", "supportsInsertDefaultValues", "getSupportsInsertDefaultValues", "appendExpressionColumn", "", "output", "Lcom/intellij/database/util/DdlBuilder;", "e", "Lcom/intellij/database/script/generator/dml/ExpressionColumn;", "appendFromTable", "builder", "dasTable", "Lcom/intellij/database/model/DasObject;", "alias", "", "tableSamplingSize", "appendLimit", "table", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "appendNumericProperty", "property", "value", "appendPlaceholderForInsert", "d", "Lcom/intellij/database/datagrid/AutoValueDescriptor;", "forcePlaceholderForDefaults", "appendPlaceholderForUpdate", "data", "Lcom/intellij/database/datagrid/mutating/ColumnQueryData;", "appendRowId", "fetchFirst", "rows", "generate", "OUT", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "(Lcom/intellij/database/script/generator/dml/DmlTask;)Ljava/lang/Object;", "getGenerator", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/LimitPlace;", "hasRowId", "Lcom/intellij/database/model/DasTable;", "version", "Lcom/intellij/database/util/Version;", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "rowNumLimit", "supportsOffset", "top", "topWord", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseDmlHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseDmlHelper.kt\ncom/intellij/database/dialects/base/BaseDmlHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public class BaseDmlHelper
implements DmlHelper {
    @NotNull
    private final Dbms dbms;

    public BaseDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @Override
    public boolean getSupportsInsertDefaultValues() {
        return false;
    }

    @Override
    public boolean getNeedAliasInDeleteStatement() {
        return false;
    }

    @Override
    public boolean getNeedAliasInUpdateStatement() {
        return true;
    }

    @Override
    public boolean getHideRowId() {
        return true;
    }

    @Override
    public <OUT> OUT generate(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlGenerator<OUT, DmlTask<OUT>> dmlGenerator = this.getGenerator(task);
        if (dmlGenerator == null) {
            throw new UnsupportedOperationException("Task is not supported " + task);
        }
        DmlGenerator<OUT, DmlTask<OUT>> generator = dmlGenerator;
        return generator.generate();
    }

    @Nullable
    protected <OUT> DmlGenerator<OUT, DmlTask<OUT>> getGenerator(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlTask<? extends OUT> dmlTask = task;
        DmlGenerator dmlGenerator = dmlTask instanceof DeleteRowsTask ? (DmlGenerator)new BaseDeleteRowsGenerator((DeleteRowsTask)task, this.dbms) : (dmlTask instanceof WhereClauseTask ? (DmlGenerator)new BaseWhereClauseGenerator((WhereClauseTask)task, this.dbms) : (dmlTask instanceof ColumnsOrderByTask ? (DmlGenerator)new BaseColumnsOrderByGenerator((ColumnsOrderByTask)task, this.dbms) : (dmlTask instanceof InsertRowsTask ? (DmlGenerator)new BaseInsertRowsGenerator((InsertRowsTask)task, this.dbms) : (dmlTask instanceof WrapInSelectTask ? (DmlGenerator)new BaseWrapInSelectGenerator((WrapInSelectTask)task, this.dbms) : (dmlTask instanceof QueryColumnsTask ? (DmlGenerator)new BaseQueryColumnsGenerator((QueryColumnsTask)task, this.dbms, this) : (dmlTask instanceof SelectTask ? (DmlGenerator)new BaseSelectGenerator((SelectTask)task, this.dbms, this) : (dmlTask instanceof MultiInsertRowsTask ? (DmlGenerator)new BaseMultiInsertRowsGenerator((MultiInsertRowsTask)task, this.dbms) : (dmlTask instanceof UpdateRowTask ? (DmlGenerator)new BaseUpdateRowGenerator((UpdateRowTask)task, this.dbms) : null))))))));
        return dmlGenerator instanceof DmlGenerator ? dmlGenerator : null;
    }

    @NotNull
    public LimitPlace getPlaceForLimit() {
        return LimitPlace.END;
    }

    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return builder;
    }

    @Override
    public boolean hasRowId(@NotNull DasTable table, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return false;
    }

    public void appendFromTable(@NotNull DdlBuilder builder, @NotNull DasObject dasTable, @NotNull String alias, @Nullable String tableSamplingSize) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dasTable, (String)"dasTable");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        builder.keyword("FROM").space().qualifiedRef(dasTable).space().alias(alias);
    }

    @NotNull
    public DdlBuilder appendLimit(@Nullable DasObject table, @NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        DdlBuilder b2 = builder;
        if (!GridUtilCore.isPageSizeUnlimited((int)limit)) {
            b2 = this.appendNumericProperty(builder, "LIMIT", limit);
        }
        if (offset != 0 && this.supportsOffset(table)) {
            b2 = this.appendNumericProperty(builder, "OFFSET", offset);
        }
        return b2;
    }

    @NotNull
    protected final DdlBuilder top(@NotNull DdlBuilder builder, @NotNull String topWord, int limit) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)topWord, (String)"topWord");
        DdlBuilder ddlBuilder = builder.keyword(topWord).space().literal(String.valueOf(limit)).space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        return ddlBuilder;
    }

    @NotNull
    public final DdlBuilder appendNumericProperty(@NotNull DdlBuilder builder, @NotNull String property, int value2) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        DdlBuilder ddlBuilder = builder.newLine().keyword(property).space().literal(String.valueOf(value2));
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"literal(...)");
        return ddlBuilder;
    }

    @NotNull
    protected final DdlBuilder fetchFirst(@NotNull DdlBuilder builder, int rows) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        String[] stringArray = new String[]{"FETCH", "FIRST"};
        DdlBuilder ddlBuilder = builder.newLine().keywords(stringArray).space().literal(String.valueOf(rows)).space();
        stringArray = new String[]{"ROWS", "ONLY"};
        DdlBuilder ddlBuilder2 = ddlBuilder.keywords(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"keywords(...)");
        return ddlBuilder2;
    }

    @NotNull
    protected final DdlBuilder rowNumLimit(@NotNull DdlBuilder builder, int rows, boolean atBeginning) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (atBeginning) {
            DdlBuilder ddlBuilder2 = builder.keyword("SELECT").space().symbol("*").space().keyword("FROM").space().symbol("(").indent("    ").newLine();
            ddlBuilder = ddlBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"newLine(...)");
        } else {
            DdlBuilder ddlBuilder3 = builder.indent(null).newLine().symbol(")").space().keyword("WHERE").space().keyword("ROWNUM").space().symbol("<=").space().literal(String.valueOf(rows));
            ddlBuilder = ddlBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder3, (String)"literal(...)");
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsOffset(@Nullable DasObject table) {
        return false;
    }

    @Override
    public boolean isEditableTable(@Nullable ObjectKind kind) {
        ObjectKind objectKind = kind;
        return (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE) ? true : Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIRTUAL_TABLE)) ? true : Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE);
    }

    @Override
    public void appendPlaceholderForInsert(@NotNull AutoValueDescriptor d2, @NotNull DasObject table, @NotNull DdlBuilder builder, boolean forcePlaceholderForDefaults) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!forcePlaceholderForDefaults && (d2.isAutogenerated() || d2.hasDefault())) {
            builder.plain("DEFAULT");
        } else {
            builder.placeholder();
        }
    }

    @Override
    public boolean appendPlaceholderForUpdate(@NotNull ColumnQueryData data, @NotNull DasObject table, @NotNull DdlBuilder builder) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Object value2 = data.getObject();
        if (value2 == ReservedCellValue.DEFAULT) {
            builder.keyword("DEFAULT");
            bl = false;
        } else if (JdbcEngineUtils.shouldValueBeInlined(value2, data.getColumn().getTypeName(), this.dbms)) {
            builder.plain(String.valueOf(value2));
            bl = false;
        } else {
            builder.placeholder();
            bl = true;
        }
        return bl;
    }

    public final void appendExpressionColumn(@NotNull DdlBuilder output, @NotNull ExpressionColumn e2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            output.symbol(", ").plain(e2.getExpr());
            String string = e2.getAlias();
            if (string == null) break block0;
            String it2 = string;
            boolean bl = false;
            output.symbol(" ").identifier(it2);
        }
    }
}

