/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.url.ui.DynamicJdbcUrlEditor;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.dialects.DatabaseAlterLoginHelper;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseFixFactoryImpl
implements DatabaseFixFactory {
    @Override
    @Nullable
    public ErrorInfo.Fix changeDriverClass(@Nullable DatabaseDriver driver2) {
        return driver2 == null ? null : DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message("DatabaseErrorHandler.change.driver.class", new Object[0]), driver2, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)DatabaseDriverConfigurable::focusDriverClassSelector));
    }

    @Override
    @Nullable
    public ErrorInfo.Fix changeKeepAliveQuery(@Nullable DatabaseDriver driver2) {
        return driver2 == null ? null : DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message("change.driver.keep.alive.query", new Object[0]), driver2, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)DatabaseDriverConfigurable::focusKeepAliveField));
    }

    @Override
    @Nullable
    public ErrorInfo.Fix editDriver(@Nullable DatabaseDriver driver2) {
        return driver2 == null ? null : DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message("DatabaseErrorHandler.edit.driver", new Object[0]), driver2, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> {}));
    }

    @Override
    @Nullable
    public ErrorInfo.Fix addLibraryPath(@NotNull @Nls String message2, @Nullable DatabaseDriver driver2, boolean isNative) {
        if (message2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(0);
        }
        return driver2 == null ? null : DatabaseFixFactoryImpl.settingsFix(message2, driver2, true, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> c2.getClassPathPanel().addCustomDrivers(true)));
    }

    @Override
    @NotNull
    public ErrorInfo.Fix switchToLatestDriver(final @NotNull LocalDataSource dataSource2, final boolean downloaded) {
        if (dataSource2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(1);
        }
        return new ErrorInfo.Fix(){

            public String getName() {
                return DatabaseBundle.message(downloaded ? "DataSourceConfigurable.switch.to.latest" : "DataSourceConfigurable.download.driver", new Object[0]);
            }

            public void apply(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                DatabaseConfigEditor editor2 = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                final NamedProgressive task = DatabaseDriverValidator.createDownloaderTask(dataSource2, editor2);
                new Task.Modal(project, task.getName(), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        task.run(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/DatabaseFixFactoryImpl$1$1", "run"));
                    }
                }.queue();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseFixFactoryImpl$1", "apply"));
            }
        };
    }

    @Override
    @Nullable
    public ErrorInfo.Fix changePassword(final @NotNull DatabaseConnectionConfig config) {
        if (config == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(2);
        }
        return !DatabaseAlterLoginHelper.canAlterLogin(config) ? null : new ErrorInfo.Fix(){

            @Nls
            public String getName() {
                return DatabaseBundle.message("change.password", new Object[0]);
            }

            public void apply(@NotNull DataContext dataContext) {
                String text2;
                Project project;
                String newPass;
                if (dataContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = newPass = (project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null ? null : DatabaseUiService.getInstance().askChangePassword(project);
                if (newPass == null) {
                    return;
                }
                DatabaseRefactoringHandler handler2 = new DatabaseRefactoringHandler(project, config.getDataSource(), null){

                    @Override
                    protected boolean checkOutdated() {
                        return false;
                    }
                };
                DatabaseConfigEditor editor2 = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext);
                DatabaseCredentials credentials = editor2 == null ? DatabaseCredentials.getInstance() : editor2.getSecretService();
                OneTimeString oldPass = credentials.loadPassword(config);
                ScriptingResult script2 = DatabaseAlterLoginHelper.generatePasswordChangeScript(project, config, oldPass, new OneTimeString(newPass));
                boolean hasError = script2 != null && ContainerUtil.find(script2.getScript().getFragments(), f -> f.getError() != null) != null;
                String string2 = text2 = script2 == null ? "" : script2.getScriptText();
                if (StringUtil.isEmpty((String)text2) || hasError) {
                    ((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)DatabaseBundle.message("dialog.title.failed.to.generate.script", new Object[0]), (String)(!hasError ? DatabaseBundle.message("dialog.message.unable.to.generate.password.alteration.script", new Object[0]) : DatabaseBundle.message("dialog.message.generated.script.contains.errors.1", text2))).icon(UIUtil.getErrorIcon())).ask(project);
                    return;
                }
                handler2.setStatement(text2);
                handler2.runStatements(true).whenComplete(AsyncUtil.getPoolExecutor(), (r, th) -> {
                    DataSourceConfigurable configurable;
                    if (th != null) {
                        return;
                    }
                    DatabaseAuthProvider provider = DatabaseAuthProvider.get(config);
                    ConsoleRunConfiguration configuration = JdbcDriverManager.getDriverManager(project).getDefaultRunConfiguration(config.getDataSource(), credentials);
                    DatabaseConnectionInterceptor.ProtoConnection proto2 = DatabaseConnectionEstablisher.createProtoConnection(configuration, config, null, false);
                    provider.setNewPassword(proto2, newPass);
                    if (editor2 != null && (configurable = editor2.getConfigurable(config.getDataSource(), false, DataSourceConfigurable.class)) != null) {
                        configurable.reloadCredentials();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseFixFactoryImpl$2", "apply"));
            }
        };
    }

    @Override
    @Nullable
    public ErrorInfo.Fix setVmEnv(@Nls @NotNull String text2, @NotNull LocalDataSource dataSource2, @NotNull String name2, @Nullable String val) {
        if (text2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(3);
        }
        if (dataSource2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(5);
        }
        return DatabaseFixFactoryImpl.settingsFix(text2, dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> {
            DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> ds.getVmEnv().put(name2, val)));
            DatabaseFixFactoryImpl.focusVmEnv(c2);
        }));
    }

    @Override
    @Nullable
    public ErrorInfo.Fix setOption(@Nls @NotNull String text2, @NotNull LocalDataSource dataSource2, @NotNull String name2, @Nullable String val) {
        if (text2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(6);
        }
        if (dataSource2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(7);
        }
        if (name2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(8);
        }
        return DatabaseFixFactoryImpl.settingsFix(text2, dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> {
            DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> ds.setVmOptions(DatabaseFixFactoryImpl.setOption(ds.getVmOptions(), name2, val))));
            DatabaseFixFactoryImpl.focusVmOptions(c2);
        }));
    }

    @Override
    @Nullable
    public <Target, V> ErrorInfo.Fix setOption(@Nls @NotNull String text2, @NotNull Target target2, @NotNull DbOptionProvider<Target, V> option, V val) {
        if (text2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(9);
        }
        if (target2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(10);
        }
        if (option == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(11);
        }
        if (target2 instanceof LocalDataSource) {
            LocalDataSource targetDs = (LocalDataSource)target2;
            return DatabaseFixFactoryImpl.setOption(text2, targetDs, option, val);
        }
        if (target2 instanceof DatabaseDriver) {
            DatabaseDriver targetDr = (DatabaseDriver)target2;
            return DatabaseFixFactoryImpl.setOption(text2, targetDr, option, val);
        }
        return null;
    }

    @NotNull
    private static <V> ErrorInfo.Fix setOption(@Nls @NotNull String text2, LocalDataSource target2, DbOptionProvider<LocalDataSource, V> option, V val) {
        if (text2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(12);
        }
        return DatabaseFixFactoryImpl.settingsFix(text2, target2, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> option.store((LocalDataSource)ds, val)))));
    }

    @NotNull
    private static <V> ErrorInfo.Fix setOption(@Nls @NotNull String text2, DatabaseDriver target2, DbOptionProvider<DatabaseDriver, V> option, V val) {
        if (text2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(13);
        }
        ErrorInfo.Fix fix = DatabaseFixFactoryImpl.settingsFix(text2, target2, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)ds -> option.store((DatabaseDriver)ds, val)), c2)));
        if (fix == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(14);
        }
        return fix;
    }

    @Override
    @Nullable
    public ErrorInfo.Fix setOption(@Nls @NotNull String text2, @NotNull DatabaseDriver driver2, @NotNull String name2, @Nullable String val) {
        if (text2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(15);
        }
        if (driver2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(16);
        }
        if (name2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(17);
        }
        return DatabaseFixFactoryImpl.settingsFix(text2, driver2, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> {
            DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)dr -> dr.setVmOptions(DatabaseFixFactoryImpl.setOption(dr.getVmOptions(), name2, val))), c2);
            DatabaseFixFactoryImpl.focusVmOptions(c2);
        }));
    }

    @Override
    @Nullable
    public ErrorInfo.Fix enableSSL(@Nullable LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            return null;
        }
        DataSourceSslConfiguration ssl = dataSource2.getSslCfg();
        if (ssl == null || !ssl.myEnabled) {
            return DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message("enable.ssl", new Object[0]), dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> {
                DataSourceSslConfiguration cur = ds.getSslCfg();
                if (cur == null) {
                    cur = new DataSourceSslConfiguration(true, JdbcSettings.SslMode.REQUIRE);
                } else {
                    cur.myEnabled = true;
                }
                ds.setSslCfg(cur);
            }))));
        }
        return null;
    }

    @Override
    @Nullable
    public ErrorInfo.Fix setDriverProperty(@Nullable LocalDataSource dataSource2, @Nls @NotNull String message2, @NotNull String prop, @Nullable String value2) {
        if (message2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(18);
        }
        if (prop == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(19);
        }
        return dataSource2 == null ? null : DatabaseFixFactoryImpl.settingsFix(message2, dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)configurable -> DatabaseFixFactoryImpl.setDriverProperty(configurable, prop, value2)));
    }

    private static void setDriverProperty(@NotNull DataSourceConfigurable configurable, @NotNull String prop, @Nullable String value2) {
        if (configurable == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(20);
        }
        if (prop == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(21);
        }
        DataSourceUiUtil.modify(configurable, (Consumer<? super LocalDataSource>)((Consumer)ds -> {
            if (value2 != null) {
                ds.getDriverProperties().put(prop, value2);
            } else {
                ds.getDriverProperties().remove(prop);
            }
        }));
        JComponent panel2 = configurable.selectAdvancedPanel();
        IdeFocusManager.getInstance((Project)configurable.getProject()).doWhenFocusSettlesDown(() -> {
            TableView props = (TableView)UIUtil.uiTraverser((Component)panel2).filter(TableView.class).first();
            if (props != null) {
                for (int i2 = 0; i2 < props.getRowCount(); ++i2) {
                    if (!prop.equals(props.getModel().getValueAt(i2, 0))) continue;
                    int vi = props.getRowSorter() == null ? i2 : props.getRowSorter().convertRowIndexToView(i2);
                    props.setRowSelectionInterval(vi, vi);
                    TableUtil.scrollSelectionToVisible((JTable)props);
                    break;
                }
            }
        });
    }

    public static void focusVmOptions(AbstractDatabaseConfigurable<?> c2) {
        JComponent panel2;
        String ex;
        if (c2 instanceof DataSourceConfigurable) {
            DataSourceConfigurable dsc = (DataSourceConfigurable)c2;
            ex = dsc.getTempDataSource().getVmOptions();
            panel2 = dsc.selectAdvancedPanel();
        } else if (c2 instanceof DatabaseDriverConfigurable) {
            DatabaseDriverConfigurable drc = (DatabaseDriverConfigurable)c2;
            ex = drc.getTempDriver().getVmOptions();
            panel2 = drc.selectAdvancedPanel();
        } else {
            return;
        }
        Condition filter2 = e2 -> e2.getText().equals(ex);
        Project project = c2.getProject();
        DatabaseFixFactoryImpl.findComponent(project, panel2, RawCommandLineEditor.class, filter2, e2 -> {
            if (e2 != null) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)e2.getTextField(), true);
            }
        });
    }

    public static void focusVmEnv(AbstractDatabaseConfigurable<?> c2) {
        JComponent panel2;
        if (c2 instanceof DataSourceConfigurable) {
            DataSourceConfigurable dsc = (DataSourceConfigurable)c2;
            panel2 = dsc.selectAdvancedPanel();
        } else if (c2 instanceof DatabaseDriverConfigurable) {
            DatabaseDriverConfigurable drc = (DatabaseDriverConfigurable)c2;
            panel2 = drc.selectAdvancedPanel();
        } else {
            return;
        }
        Project project = c2.getProject();
        DatabaseFixFactoryImpl.findComponent(project, panel2, EnvironmentVariablesTextFieldWithBrowseButton.class, null, e2 -> {
            if (e2 != null) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)e2.getTextField(), true);
            }
        });
    }

    private static <T extends Component> void findComponent(Project project, JComponent panel2, Class<T> clazz, Condition<? super T> filter2, Consumer<? super T> consumer2) {
        IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
            JBIterable editors = UIUtil.uiTraverser((Component)panel2).filter(clazz).collect();
            consumer2.consume((filter2 == null ? editors : editors.filter(filter2)).append((Iterable)editors).first());
        });
    }

    @Nullable
    private static String setOption(@Nullable String options2, @NotNull String name2, @Nullable String val) {
        if (name2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(22);
        }
        ParametersList list = new ParametersList();
        list.addParametersString(options2);
        if (val == null) {
            list.replaceOrAppend("-D" + name2, "");
        } else {
            list.addProperty(name2, val);
        }
        return StringUtil.nullize((String)list.getParametersString());
    }

    @Override
    @Nullable
    public ErrorInfo.Fix setVmOptions(@NotNull @Nls String message2, @Nullable LocalDataSource dataSource2, @NotNull String options2) {
        if (message2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(23);
        }
        if (options2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(24);
        }
        return dataSource2 == null ? null : DatabaseFixFactoryImpl.settingsFix(message2, dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)configurable -> {
            DataSourceUiUtil.modify(configurable, (Consumer<? super LocalDataSource>)((Consumer)ds -> ds.setVmOptions(options2)));
            DatabaseFixFactoryImpl.focusVmOptions(configurable);
        }));
    }

    @NotNull
    public static ErrorInfo.Fix settingsFix(final @Nls @NotNull String name2, final @NotNull LocalDataSource ds, final @NotNull Consumer<? super DataSourceConfigurable> consumer2) {
        if (name2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(25);
        }
        if (ds == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(26);
        }
        if (consumer2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(27);
        }
        return new ErrorInfo.Fix(){

            public String getName() {
                return name2;
            }

            public boolean isSilent() {
                return false;
            }

            public void apply(@NotNull DataContext dataContext) {
                DatabaseConfigEditor editor2;
                if (dataContext == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((editor2 = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext)) == null) {
                    return;
                }
                DataSourceUiUtil.navigate(editor2, ds, (Consumer<? super DataSourceConfigurable>)consumer2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseFixFactoryImpl$3", "apply"));
            }
        };
    }

    @Nullable
    private static ErrorInfo.Fix settingsFix(@Nls @NotNull String name2, @Nullable DatabaseDriver dr, @NotNull Consumer<? super DatabaseDriverConfigurable> consumer2) {
        if (name2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(28);
        }
        if (consumer2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(29);
        }
        return dr == null ? null : DatabaseFixFactoryImpl.settingsFix(name2, dr, true, consumer2);
    }

    @NotNull
    private static ErrorInfo.Fix settingsFix(final @Nls @NotNull String name2, final @NotNull DatabaseDriver dr, final boolean navigate, final @NotNull Consumer<? super DatabaseDriverConfigurable> consumer2) {
        if (name2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(30);
        }
        if (dr == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(31);
        }
        if (consumer2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(32);
        }
        return new ErrorInfo.Fix(){

            public String getName() {
                return name2;
            }

            public boolean isSilent() {
                return false;
            }

            public void apply(@NotNull DataContext dataContext) {
                DatabaseConfigEditor editor2;
                if (dataContext == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((editor2 = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext)) == null) {
                    return;
                }
                if (navigate) {
                    DataSourceUiUtil.navigate(editor2, dr, (Consumer<? super DatabaseDriverConfigurable>)consumer2);
                } else {
                    DatabaseDriverConfigurable configurable = editor2.getConfigurable(dr, true, DatabaseDriverConfigurable.class);
                    if (configurable != null) {
                        consumer2.consume((Object)configurable);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseFixFactoryImpl$4", "apply"));
            }
        };
    }

    @Override
    @Nullable
    public ErrorInfo.Fix setUpArtifact(DatabaseDriver driver2, boolean navigate, Supplier<@Nullable DatabaseArtifactList.ArtifactVersion> artifact) {
        return DatabaseFixFactoryImpl.settingsFix(DatabaseBundle.message("set.up.required.libraries", new Object[0]), driver2, navigate, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)configurable -> {
            DatabaseArtifactList.ArtifactVersion version = (DatabaseArtifactList.ArtifactVersion)artifact.get();
            if (version == null) {
                return;
            }
            DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)d2 -> d2.getArtifacts().add(DatabaseDriverImpl.createArtifactRef(version.artifact.id, version.version, "stable"))), configurable);
            DatabaseFixFactoryImpl.download(driver2, configurable, version);
        }));
    }

    public static void download(DatabaseDriver driver2, DatabaseDriverConfigurable configurable, DatabaseArtifactList.ArtifactVersion artifact) {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        final NamedProgressive downloader = DatabaseDriverValidator.createDownloadTask(artifact, driver2, configurable.getController());
        if (indicator != null) {
            downloader.run(indicator);
        } else {
            new Task.Modal(configurable.getProject(), configurable.getCommonBar(), downloader.getName(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    downloader.run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/DatabaseFixFactoryImpl$5", "run"));
                }
            }.queue();
        }
    }

    @Override
    @NotNull
    public ErrorInfo.Fix setAuthProvider(@NotNull LocalDataSource target2, @NotNull @Nls String message2, String providerId) {
        if (target2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(33);
        }
        if (message2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(34);
        }
        return DatabaseFixFactoryImpl.settingsFix(message2, target2, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> {
            DatabaseAuthProvider provider = DatabaseAuthProvider.get(providerId);
            c2.getUrlEditor().getAuthPanel().validateAuthTypes(target2, provider);
        }));
    }

    @Override
    @NotNull
    public ErrorInfo.Fix setUrl(@NotNull LocalDataSource target2, @Nls @NotNull String message2, String url) {
        if (target2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(35);
        }
        if (message2 == null) {
            DatabaseFixFactoryImpl.$$$reportNull$$$0(36);
        }
        return DatabaseFixFactoryImpl.settingsFix(message2, target2, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> {
            DynamicJdbcUrlEditor editor2 = c2.getUrlEditor();
            editor2.setUrl(StringUtil.notNullize((String)url), editor2.isUrlOnly());
            editor2.requestUrlFocus();
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 8: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/DatabaseFixFactoryImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/DatabaseFixFactoryImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "switchToLatestDriver";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "changePassword";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 14: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setDriverProperty";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setVmOptions";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "settingsFix";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setAuthProvider";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }
}

