/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.DbmsExtension;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebugFunKt;
import com.intellij.database.debugger.SqlDebugProfile;
import com.intellij.database.debugger.SqlDebugSessionRunner;
import com.intellij.database.debugger.SqlDebuggerFacade;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.run.audit.DatabaseSessionLogger;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010J\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\rH&R \u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner;", "", "onFinish", "Lkotlin/Function0;", "", "getOnFinish", "()Lkotlin/jvm/functions/Function0;", "setOnFinish", "(Lkotlin/jvm/functions/Function0;)V", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Handler", "Runner", "SqlDebugAvailability", "intellij.database.impl"})
public interface SqlDebugSessionRunner {
    @Nullable
    public Function0<Unit> getOnFinish();

    public void setOnFinish(@Nullable Function0<Unit> var1);

    @NotNull
    public Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007JB\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJN\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u0006\u0012\u0004\u0018\u00010\u00160 H\u0002JL\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\"H\u0002J0\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u00182\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJV\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010)\u001a\u00020*2\u0018\u0010\u001f\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u0006\u0012\u0004\u0018\u00010\u00160 H\u0007J\u000e\u0010+\u001a\u0004\u0018\u00010\u0005*\u00020\tH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$Handler;", "", "()V", "FACADE_EP", "Lcom/intellij/database/DbmsExtension;", "Lcom/intellij/database/debugger/SqlDebuggerFacade;", "checkDebuggerAvailability", "Lcom/intellij/database/debugger/SqlDebugSessionRunner$SqlDebugAvailability;", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "facade", "element", "Lcom/intellij/psi/PsiElement;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "routine", "Lcom/intellij/database/model/basic/BasicSourceAware;", "createRunner", "Lcom/intellij/database/debugger/SqlDebugSessionRunner;", "transactionOwner", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "request", "Lcom/intellij/database/datagrid/GridDataRequest;", "scriptIsMeaningful", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "requestFactory", "Lkotlin/Function1;", "Lcom/intellij/database/script/ScriptModel;", "Lkotlin/Function0;", "obtainActualScriptModel", "project", "Lcom/intellij/openapi/project/Project;", "firstOnly", "startDebugProcess", "", "consoleTitle", "", "obtainDebuggerFacadeWhenApplicable", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlDebugSessionRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlDebugSessionRunner.kt\ncom/intellij/database/debugger/SqlDebugSessionRunner$Handler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();
        @NotNull
        private static final DbmsExtension<SqlDebuggerFacade> FACADE_EP = new DbmsExtension("com.intellij.database.debuggerFacade");

        private Handler() {
        }

        @JvmStatic
        @NotNull
        public static final SqlDebugAvailability checkDebuggerAvailability(@NotNull LocalDataSource localDataSource, @NotNull SqlDebuggerFacade facade, @NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)localDataSource, (String)"localDataSource");
            Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            SqlStatement statement2 = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element2, SqlStatement.class);
            if (statement2 == null) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            if (!facade.isApplicableToDebugStatement(statement2)) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            return facade.canDebug(localDataSource) ? SqlDebugAvailability.DEBUGGER_ENABLED : SqlDebugAvailability.DEBUGGER_DISABLED;
        }

        @JvmStatic
        @NotNull
        public static final SqlDebugAvailability checkDebuggerAvailability(@Nullable DasDataSource dataSource2, @Nullable BasicSourceAware routine2) {
            SqlDebuggerFacade sqlDebuggerFacade;
            LocalDataSource localDataSource;
            block8: {
                block7: {
                    DasDataSource dasDataSource = dataSource2;
                    if (dasDataSource != null) {
                        DasDataSource it2 = dasDataSource;
                        boolean bl = false;
                        v1 = DbImplUtil.getMaybeLocalDataSource(it2);
                    } else {
                        v1 = localDataSource = null;
                    }
                    if (localDataSource == null) break block7;
                    sqlDebuggerFacade = Handler.obtainDebuggerFacadeWhenApplicable(localDataSource);
                    if (sqlDebuggerFacade != null) break block8;
                }
                return SqlDebugAvailability.DEBUGGER_ABSENT;
            }
            SqlDebuggerFacade facade = sqlDebuggerFacade;
            if (routine2 == null) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            if (!facade.isApplicableToDebugRoutine(routine2)) {
                return SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
            }
            return facade.canDebug(localDataSource) ? SqlDebugAvailability.DEBUGGER_ENABLED : SqlDebugAvailability.DEBUGGER_DISABLED;
        }

        @JvmStatic
        @Nullable
        public static final SqlDebuggerFacade obtainDebuggerFacadeWhenApplicable(@NotNull LocalDataSource $this$obtainDebuggerFacadeWhenApplicable) {
            Intrinsics.checkNotNullParameter((Object)$this$obtainDebuggerFacadeWhenApplicable, (String)"<this>");
            if (!SqlDebugFunKt.sqlDebuggerIsEnabled()) {
                return null;
            }
            return FACADE_EP.forDbms($this$obtainDebuggerFacadeWhenApplicable.getDbms());
        }

        @Nullable
        public final ScriptModel<?> obtainActualScriptModel(@NotNull Project project, @NotNull VirtualFile virtualFile, boolean firstOnly, @Nullable RangeMarker rangeMarker) {
            RangeMarker range;
            Object object;
            FileDocumentManager fileDocumentManager;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            FileDocumentManager $this$obtainActualScriptModel_u24lambda_u243 = fileDocumentManager = FileDocumentManager.getInstance();
            boolean bl = false;
            Document document = $this$obtainActualScriptModel_u24lambda_u243.getCachedDocument(virtualFile);
            if (document != null) {
                Document doc = document;
                boolean bl2 = false;
                WriteAction.runAndWait(() -> Handler.obtainActualScriptModel$lambda$3$lambda$2$lambda$1($this$obtainActualScriptModel_u24lambda_u243, doc));
            }
            ScriptModel scriptModel = SqlPsiFacade.getInstance((Project)project).createScriptModel(virtualFile, null);
            Intrinsics.checkNotNullExpressionValue((Object)scriptModel, (String)"createScriptModel(...)");
            ScriptModel sm = scriptModel;
            if (firstOnly) {
                object = rangeMarker;
                if (object == null || (object = UtilsKt.getRange((RangeMarker)object)) == null) {
                    JBIterable jBIterable = sm.statements();
                    Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"statements(...)");
                    ScriptModel.StatementIt statementIt = (ScriptModel.StatementIt)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
                    object = statementIt != null ? statementIt.range() : null;
                }
            } else {
                RangeMarker rangeMarker2 = rangeMarker;
                if (rangeMarker2 == null || (rangeMarker2 = UtilsKt.getRange((RangeMarker)rangeMarker2)) == null) {
                    rangeMarker2 = object = sm.getTextRange();
                }
                if (rangeMarker2 == null) {
                    object = new TextRange(0, (int)virtualFile.getLength());
                }
            }
            if ((range = object) == null) {
                return null;
            }
            return sm.subModel((TextRange)range);
        }

        public static /* synthetic */ ScriptModel obtainActualScriptModel$default(Handler handler2, Project project, VirtualFile virtualFile, boolean bl, RangeMarker rangeMarker, int n, Object object) {
            if ((n & 8) != 0) {
                rangeMarker = null;
            }
            return handler2.obtainActualScriptModel(project, virtualFile, bl, rangeMarker);
        }

        @JvmStatic
        public static final void startDebugProcess(@NotNull DatabaseSessionClient transactionOwner, boolean scriptIsMeaningful, @NotNull VirtualFile virtualFile, @Nullable RangeMarker rangeMarker, @Nullable SearchPath searchPath, @NotNull String consoleTitle, @NotNull Function1<? super ScriptModel<?>, ? extends GridDataRequest> requestFactory) {
            Intrinsics.checkNotNullParameter((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)consoleTitle, (String)"consoleTitle");
            Intrinsics.checkNotNullParameter(requestFactory, (String)"requestFactory");
            DatabaseSession session2 = (DatabaseSession)transactionOwner.getSession();
            Project project = session2.getProject();
            Object object = session2.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTarget(...)");
            DatabaseConnectionPoint connectionPoint = (DatabaseConnectionPoint)object;
            SqlDebugSessionRunner runner = INSTANCE.createRunner(transactionOwner, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, requestFactory);
            Set set = JBIterable.from((Iterable)RunContentManager.getInstance((Project)project).getAllDescriptors()).map(arg_0 -> Handler.startDebugProcess$lambda$4(startDebugProcess.existingTitles.1.INSTANCE, arg_0)).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
            Set existingTitles2 = set;
            String string = UniqueNameGenerator.generateUniqueName((String)consoleTitle, (String)"", (String)"", (String)" (", (String)")", arg_0 -> Handler.startDebugProcess$lambda$5((Function1)new Function1<String, Boolean>((Set<String>)existingTitles2){
                final /* synthetic */ Set<String> $existingTitles;
                {
                    this.$existingTitles = $existingTitles;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(String it2) {
                    return !this.$existingTitles.contains(it2);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
            String uniqueTitle2 = string;
            Executor debugExecutor = DefaultDebugExecutor.getDebugExecutorInstance();
            try {
                AsyncProgramRunner<RunnerSettings> asyncRunner2 = new AsyncProgramRunner<RunnerSettings>(runner){
                    final /* synthetic */ SqlDebugSessionRunner $runner;
                    {
                        this.$runner = $runner;
                    }

                    @NotNull
                    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
                        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        return this.$runner.execute(environment);
                    }

                    @NotNull
                    public String getRunnerId() {
                        return "sqlDebugSessionRunner";
                    }

                    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
                        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
                        return false;
                    }
                };
                Intrinsics.checkNotNull((Object)debugExecutor);
                ExecutionEnvironmentBuilder executionEnvironmentBuilder = new ExecutionEnvironmentBuilder(project, debugExecutor);
                Icon icon = connectionPoint.getDataSource().getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
                ExecutionEnvironment environment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)executionEnvironmentBuilder.runProfile((RunProfile)new SqlDebugProfile(consoleTitle, icon)).runner((ProgramRunner)asyncRunner2), null, (int)1, null);
                asyncRunner2.execute(environment);
            }
            catch (ExecutionException e2) {
                ExecutionUtil.handleExecutionError((Project)project, (String)debugExecutor.getToolWindowId(), (String)uniqueTitle2, (Throwable)e2);
            }
        }

        private final SqlDebugSessionRunner createRunner(DatabaseSessionClient transactionOwner, boolean scriptIsMeaningful, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, Function1<? super ScriptModel<?>, ? extends GridDataRequest> requestFactory) {
            return this.createRunner(transactionOwner, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, (Function0<? extends GridDataRequest>)((Function0)new Function0<GridDataRequest>(transactionOwner, virtualFile, rangeMarker, requestFactory){
                final /* synthetic */ DatabaseSessionClient $transactionOwner;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ RangeMarker $rangeMarker;
                final /* synthetic */ Function1<ScriptModel<?>, GridDataRequest> $requestFactory;
                {
                    this.$transactionOwner = $transactionOwner;
                    this.$virtualFile = $virtualFile;
                    this.$rangeMarker = $rangeMarker;
                    this.$requestFactory = $requestFactory;
                    super(0);
                }

                @Nullable
                public final GridDataRequest invoke() {
                    GridDataRequest gridDataRequest;
                    ScriptModel<?> scriptModel = Handler.INSTANCE.obtainActualScriptModel(((DatabaseSession)this.$transactionOwner.getSession()).getProject(), this.$virtualFile, true, this.$rangeMarker);
                    if (scriptModel != null) {
                        ScriptModel<?> scriptModel2 = scriptModel;
                        Function1<ScriptModel<?>, GridDataRequest> function1 = this.$requestFactory;
                        ScriptModel<?> it2 = scriptModel2;
                        boolean bl = false;
                        gridDataRequest = (GridDataRequest)function1.invoke(it2);
                    } else {
                        gridDataRequest = null;
                    }
                    return gridDataRequest;
                }
            }));
        }

        @NotNull
        public final SqlDebugSessionRunner createRunner(@NotNull DatabaseSessionClient transactionOwner, @NotNull GridDataRequest request, boolean scriptIsMeaningful, @Nullable VirtualFile virtualFile, @Nullable RangeMarker rangeMarker, @Nullable SearchPath searchPath) {
            Intrinsics.checkNotNullParameter((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            return this.createRunner(transactionOwner, scriptIsMeaningful, virtualFile, rangeMarker, searchPath, (Function0<? extends GridDataRequest>)((Function0)new Function0<GridDataRequest>(request){
                final /* synthetic */ GridDataRequest $request;
                {
                    this.$request = $request;
                    super(0);
                }

                @Nullable
                public final GridDataRequest invoke() {
                    return this.$request;
                }
            }));
        }

        public static /* synthetic */ SqlDebugSessionRunner createRunner$default(Handler handler2, DatabaseSessionClient databaseSessionClient, GridDataRequest gridDataRequest, boolean bl, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, int n, Object object) {
            if ((n & 8) != 0) {
                virtualFile = null;
            }
            if ((n & 0x10) != 0) {
                rangeMarker = null;
            }
            if ((n & 0x20) != 0) {
                searchPath = null;
            }
            return handler2.createRunner(databaseSessionClient, gridDataRequest, bl, virtualFile, rangeMarker, searchPath);
        }

        private final SqlDebugSessionRunner createRunner(DatabaseSessionClient transactionOwner, boolean scriptIsMeaningful, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, Function0<? extends GridDataRequest> requestFactory) {
            DatabaseSession session2 = (DatabaseSession)transactionOwner.getSession();
            SqlDebuggerFacade facade = FACADE_EP.forDbms(((DatabaseConnectionPoint)session2.getTarget()).getDbms());
            SqlDebugController sqlDebugController = facade.createController(session2.getProject(), (DatabaseConnectionPoint)session2.getTarget(), transactionOwner, scriptIsMeaningful, virtualFile, rangeMarker, searchPath);
            Intrinsics.checkNotNullExpressionValue((Object)sqlDebugController, (String)"createController(...)");
            SqlDebugController controller = sqlDebugController;
            GridDataRequest executingRequest = (GridDataRequest)requestFactory.invoke();
            DatabaseSessionLogger.SILENT_REQUEST.set((UserDataHolder)executingRequest, (Object)true);
            return new Runner(rangeMarker, transactionOwner, controller, executingRequest);
        }

        static /* synthetic */ SqlDebugSessionRunner createRunner$default(Handler handler2, DatabaseSessionClient databaseSessionClient, boolean bl, VirtualFile virtualFile, RangeMarker rangeMarker, SearchPath searchPath, Function0 function0, int n, Object object) {
            if ((n & 4) != 0) {
                virtualFile = null;
            }
            if ((n & 8) != 0) {
                rangeMarker = null;
            }
            if ((n & 0x10) != 0) {
                searchPath = null;
            }
            return handler2.createRunner(databaseSessionClient, bl, virtualFile, rangeMarker, searchPath, (Function0<? extends GridDataRequest>)function0);
        }

        private static final void obtainActualScriptModel$lambda$3$lambda$2$lambda$1(FileDocumentManager $this_apply, Document $doc) {
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            Intrinsics.checkNotNullParameter((Object)$doc, (String)"$doc");
            $this_apply.saveDocument($doc);
        }

        private static final String startDebugProcess$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        private static final boolean startDebugProcess$lambda$5(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner;", "Lcom/intellij/database/debugger/SqlDebugSessionRunner;", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "transactionOwner", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "controller", "Lcom/intellij/database/debugger/SqlDebugController;", "executingRequest", "Lcom/intellij/database/datagrid/GridDataRequest;", "(Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/database/console/client/DatabaseSessionClient;Lcom/intellij/database/debugger/SqlDebugController;Lcom/intellij/database/datagrid/GridDataRequest;)V", "auditor", "Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner$MyAdapter;", "disposable", "Lcom/intellij/openapi/Disposable;", "onFinish", "Lkotlin/Function0;", "", "getOnFinish", "()Lkotlin/jvm/functions/Function0;", "setOnFinish", "(Lkotlin/jvm/functions/Function0;)V", "close", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "startTheRequestSequence", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "MyAdapter", "intellij.database.impl"})
    private static final class Runner
    implements SqlDebugSessionRunner {
        @NotNull
        private final DatabaseSessionClient transactionOwner;
        @NotNull
        private final SqlDebugController controller;
        @Nullable
        private final GridDataRequest executingRequest;
        @Nullable
        private Function0<Unit> onFinish;
        @NotNull
        private final Disposable disposable;
        @NotNull
        private final MyAdapter auditor;

        public Runner(@Nullable RangeMarker marker, @NotNull DatabaseSessionClient transactionOwner, @NotNull SqlDebugController controller, @Nullable GridDataRequest executingRequest) {
            Intrinsics.checkNotNullParameter((Object)transactionOwner, (String)"transactionOwner");
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            this.transactionOwner = transactionOwner;
            this.controller = controller;
            this.executingRequest = executingRequest;
            this.disposable = () -> Runner.disposable$lambda$0(marker);
            this.auditor = new MyAdapter();
            this.transactionOwner.getMessageBus().addAuditor(this.auditor);
            Disposer.register((Disposable)this.disposable, (Disposable)this.auditor);
        }

        @Override
        @Nullable
        public Function0<Unit> getOnFinish() {
            return this.onFinish;
        }

        @Override
        public void setOnFinish(@Nullable Function0<Unit> function0) {
            this.onFinish = function0;
        }

        @Override
        @NotNull
        public Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            if (!((DatabaseSession)this.transactionOwner.getSession()).isIdle()) {
                Disposer.dispose((Disposable)this.disposable);
                if (this.getOnFinish() != null) {
                    Function0<Unit> function0 = this.getOnFinish();
                    Intrinsics.checkNotNull(function0);
                    function0.invoke();
                }
                return Promises.resolvedPromise(null);
            }
            XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)((DatabaseSession)this.transactionOwner.getSession()).getProject());
            XDebugProcessStarter xDebugProcessStarter = this.controller.getStarter();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugProcessStarter, (String)"getStarter(...)");
            XDebugProcessStarter debugProcessStarter = xDebugProcessStarter;
            XDebugSession xDebugSession = debuggerManager.startSession(environment, debugProcessStarter);
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSession(...)");
            XDebugSession xDebugSession2 = xDebugSession;
            Disposer.register((Disposable)((Disposable)xDebugSession2.getConsoleView()), (Disposable)this.disposable);
            this.controller.getReady();
            ConsoleView consoleView = xDebugSession2.getConsoleView();
            Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsoleView(...)");
            this.startTheRequestSequence(consoleView);
            return Promises.resolvedPromise((Object)xDebugSession2.getRunContentDescriptor());
        }

        private final void startTheRequestSequence(ConsoleView consoleView) {
            SqlDebugController.AuxiliaryRequest preparationRequest = this.controller.new SqlDebugController.AuxiliaryRequest(this.transactionOwner);
            if (this.executingRequest == null) {
                consoleView.print("Cannot find script to execute.", ConsoleViewContentType.LOG_ERROR_OUTPUT);
                this.close();
                return;
            }
            DataProducer dataProducer = this.transactionOwner.getMessageBus().getDataProducer();
            preparationRequest.getPromise().onSuccess(arg_0 -> Runner.startTheRequestSequence$lambda$1((Function1)new Function1<Void, Unit>(dataProducer, this){
                final /* synthetic */ DataProducer $dataProducer;
                final /* synthetic */ Runner this$0;
                {
                    this.$dataProducer = $dataProducer;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Void it2) {
                    this.$dataProducer.processRequest(Runner.access$getExecutingRequest$p(this.this$0));
                }
            }, arg_0));
            preparationRequest.getPromise().onError(arg_0 -> Runner.startTheRequestSequence$lambda$2((Function1)new Function1<Throwable, Unit>(this){
                final /* synthetic */ Runner this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Throwable it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    Runner.access$close(this.this$0);
                }
            }, arg_0));
            this.executingRequest.getPromise().onProcessed(arg_0 -> Runner.startTheRequestSequence$lambda$3((Function1)new Function1<Void, Unit>(this){
                final /* synthetic */ Runner this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@Nullable Void it2) {
                    Runner.access$close(this.this$0);
                }
            }, arg_0));
            dataProducer.processRequest((GridDataRequest)preparationRequest);
        }

        private final void close() {
            if (this.getOnFinish() != null) {
                Function0<Unit> function0 = this.getOnFinish();
                Intrinsics.checkNotNull(function0);
                Disposer.dispose(() -> Runner.close$lambda$4(function0));
            }
            this.controller.close();
        }

        private static final void disposable$lambda$0(RangeMarker $marker) {
            block0: {
                RangeMarker rangeMarker = $marker;
                if (rangeMarker == null) break block0;
                rangeMarker.dispose();
            }
        }

        private static final void startTheRequestSequence$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void startTheRequestSequence$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void startTheRequestSequence$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void close$lambda$4(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke();
        }

        public static final /* synthetic */ void access$close(Runner $this) {
            $this.close();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner$MyAdapter;", "Lcom/intellij/database/datagrid/DataAuditor;", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/database/debugger/SqlDebugSessionRunner$Runner;)V", "afterStatement", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "beforeStatement", "dispose", "isApplicable", "", "intellij.database.impl"})
        private final class MyAdapter
        implements DataAuditor,
        Disposable {
            private final boolean isApplicable(DataRequest.Context context) {
                return context.request == Runner.this.executingRequest;
            }

            @Override
            public void beforeStatement(@NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                if (this.isApplicable(context)) {
                    Runner.this.controller.debugBegin();
                }
            }

            @Override
            public void afterStatement(@NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                if (this.isApplicable(context)) {
                    Runner.this.controller.debugEnd();
                }
            }

            public void dispose() {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/debugger/SqlDebugSessionRunner$SqlDebugAvailability;", "", "visible", "", "enabled", "(Ljava/lang/String;IZZ)V", "DEBUGGER_ABSENT", "DEBUGGER_INAPPLICABLE", "DEBUGGER_DISABLED", "DEBUGGER_CONSOLE_BUSY", "DEBUGGER_ENABLED", "intellij.database.impl"})
    public static final class SqlDebugAvailability
    extends Enum<SqlDebugAvailability> {
        @JvmField
        public final boolean visible;
        @JvmField
        public final boolean enabled;
        public static final /* enum */ SqlDebugAvailability DEBUGGER_ABSENT = new SqlDebugAvailability(false, false);
        public static final /* enum */ SqlDebugAvailability DEBUGGER_INAPPLICABLE = new SqlDebugAvailability(true, false);
        public static final /* enum */ SqlDebugAvailability DEBUGGER_DISABLED = new SqlDebugAvailability(true, false);
        public static final /* enum */ SqlDebugAvailability DEBUGGER_CONSOLE_BUSY = new SqlDebugAvailability(true, false);
        public static final /* enum */ SqlDebugAvailability DEBUGGER_ENABLED = new SqlDebugAvailability(true, true);
        private static final /* synthetic */ SqlDebugAvailability[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SqlDebugAvailability(boolean visible, boolean enabled) {
            this.visible = visible;
            this.enabled = enabled;
        }

        public static SqlDebugAvailability[] values() {
            return (SqlDebugAvailability[])$VALUES.clone();
        }

        public static SqlDebugAvailability valueOf(String value2) {
            return Enum.valueOf(SqlDebugAvailability.class, value2);
        }

        @NotNull
        public static EnumEntries<SqlDebugAvailability> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sqlDebugAvailabilityArray = new SqlDebugAvailability[]{SqlDebugAvailability.DEBUGGER_ABSENT, SqlDebugAvailability.DEBUGGER_INAPPLICABLE, SqlDebugAvailability.DEBUGGER_DISABLED, SqlDebugAvailability.DEBUGGER_CONSOLE_BUSY, SqlDebugAvailability.DEBUGGER_ENABLED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

