/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.actions.ImportSourceType;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.openapi.Disposable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvTableEditorComponent
extends TableEditorComponent {
    private static final int MAX_COLUMNS_COUNT_FOR_CACHE = 200;
    private final Map<List<? extends ColumnDescriptor>, ImportDatabaseTableEditor<?>> myMap;

    public CsvTableEditorComponent(@NotNull Disposable disposable, @NotNull ImportSourceType sourceType, @Nullable List<? extends ColumnDescriptor> producers, @Nullable List<? extends GridRow> initialRows, @Nullable List<? extends ColumnDescriptor> visibleProducers, @Nullable String initialTargetTableName, @NotNull String producerName) {
        if (disposable == null) {
            CsvTableEditorComponent.$$$reportNull$$$0(0);
        }
        if (sourceType == null) {
            CsvTableEditorComponent.$$$reportNull$$$0(1);
        }
        if (producerName == null) {
            CsvTableEditorComponent.$$$reportNull$$$0(2);
        }
        super(disposable, sourceType, initialRows, producerName, initialTargetTableName, producers, visibleProducers);
        this.myMap = new HashMap();
    }

    @Override
    @NotNull
    public CompletionStage<DdlPreviewComponent.DdlPreviewComponentInfo> notifyChanged(@NotNull TableEditorComponent.TableEditorComponentInfo object) {
        if (object == null) {
            CsvTableEditorComponent.$$$reportNull$$$0(3);
        }
        if (object.myProducers != null) {
            this.myCurrentProducers = object.myProducers;
            this.myCurrentRows = object.myRows;
        }
        ImportEditorContext context = Objects.requireNonNullElse(object.myContext, this.myCurrentContext);
        List<? extends ColumnDescriptor> columns2 = this.getDescriptors();
        if (columns2.size() <= 200 && this.myMap.containsKey(columns2) && this.myCurrentContext == context) {
            ImportDatabaseTableEditor<?> oldOne = Objects.requireNonNull(this.getEditor());
            DeTable table = oldOne.getTable();
            ImportDatabaseTableEditor<?> newEditor = this.myMap.get(columns2);
            newEditor.update(table.name, table.comment);
            newEditor.addToForm(this.myForm);
            this.setEditor(newEditor);
            CompletableFuture<DdlPreviewComponent.DdlPreviewComponentInfo> completableFuture = CompletableFuture.completedFuture(new DdlPreviewComponent.DdlPreviewComponentInfo(newEditor, context));
            if (completableFuture == null) {
                CsvTableEditorComponent.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        this.myCurrentContext = context;
        this.recreateEditor(object.myShouldUpdateTableName);
        CompletableFuture<DdlPreviewComponent.DdlPreviewComponentInfo> completableFuture = CompletableFuture.completedFuture(new DdlPreviewComponent.DdlPreviewComponentInfo(Objects.requireNonNull(this.getEditor()), context));
        if (completableFuture == null) {
            CsvTableEditorComponent.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    @Override
    protected void recreateEditor() {
        this.recreateEditor(false);
    }

    private void recreateEditor(boolean shouldUpdateName) {
        List<? extends ColumnDescriptor> columns2 = this.getDescriptors();
        List rows = this.myCurrentRows != null ? this.myCurrentRows : this.myInitialRows;
        ImportDatabaseTableEditor<?> editor2 = this.createEditor(columns2, rows, this.myCurrentContext, shouldUpdateName);
        this.setEditor(editor2);
        if (columns2.size() <= 200) {
            this.myMap.put(columns2, editor2);
        }
    }

    @Override
    public boolean isParentFor(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            CsvTableEditorComponent.$$$reportNull$$$0(6);
        }
        return observer instanceof DdlPreviewComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/csv/CsvTableEditorComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/csv/CsvTableEditorComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyChanged";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isParentFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

