/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.editor.DbImportAutoTableManager;
import com.intellij.database.dbimport.editor.DbImportCachedDataManager;
import com.intellij.database.dbimport.editor.DbImportDataPreviewManager;
import com.intellij.database.dbimport.editor.DbImportDdlPreviewManager;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.dbimport.editor.DbImportDialogPanel;
import com.intellij.database.dbimport.editor.DbImportEditorBuilder;
import com.intellij.database.dbimport.editor.DbImportRunner;
import com.intellij.database.dbimport.editor.data.DataSourceData;
import com.intellij.database.dbimport.editor.data.FakeRootData;
import com.intellij.database.dbimport.editor.data.MappingData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.WrapperElement;
import com.intellij.database.schemaEditor.DbEditorDialogBase;
import com.intellij.database.schemaEditor.DbEditorDialogModel;
import com.intellij.database.schemaEditor.DbEditorDialogUi;
import com.intellij.database.schemaEditor.DbEditorModality;
import com.intellij.database.schemaEditor.DbModelTransactionManager;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.DbObjectEditorDialogPanelBase;
import com.intellij.database.schemaEditor.DbObjectEditorDialogPanelBaseKt;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementMatcherImpl;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorUtilsKt;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditor;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Dimension;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExceptionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 X2\u00020\u0001:\u0003XYZB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020 H\u0002J\u001c\u0010$\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020 H\u0002J\u001c\u0010%\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020'H\u0002J \u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0)2\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"H\u0002J\u001e\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0,2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J&\u0010-\u001a\u0012\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u000100\u0018\u00010.2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\"H\u0002J(\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"H\u0002J,\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\f\u0010=\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010>\u001a\u00020;H\u0002J\u000e\u0010?\u001a\u00020;H\u0082@\u00a2\u0006\u0002\u0010@J2\u0010A\u001a\u00020;2\"\u0010B\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020D\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0E\u0012\u0006\u0012\u0004\u0018\u00010F0CH\u0086@\u00a2\u0006\u0002\u0010GJ\u001a\u0010H\u001a\u00020'2\u0010\u0010I\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0JH\u0002J2\u0010K\u001a\u00020;2\"\u0010B\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020D\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0E\u0012\u0006\u0012\u0004\u0018\u00010F0CH\u0082@\u00a2\u0006\u0002\u0010GJ\u001c\u0010L\u001a\u00020;2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\"H\u0082@\u00a2\u0006\u0002\u0010MJ\u000e\u0010N\u001a\u00020;H\u0082@\u00a2\u0006\u0002\u0010@J\u0017\u0010O\u001a\u00020'2\r\u0010P\u001a\t\u0018\u00010Q\u00a2\u0006\u0002\bRH\u0002J\u000e\u0010S\u001a\u00020'H\u0082@\u00a2\u0006\u0002\u0010@J\u0016\u0010T\u001a\u00020'2\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"H\u0002J$\u0010T\u001a\u00020'2\u0010\u0010I\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0J2\b\u0010U\u001a\u0004\u0018\u00010VH\u0002J\u000e\u0010W\u001a\u00020;H\u0082@\u00a2\u0006\u0002\u0010@R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006["}, d2={"Lcom/intellij/database/dbimport/editor/DbImportDialogPanel;", "Lcom/intellij/database/schemaEditor/DbEditorDialogBase$DbEditorDialogPanel;", "editorDialogUi", "Lcom/intellij/database/schemaEditor/DbEditorDialogUi;", "(Lcom/intellij/database/schemaEditor/DbEditorDialogUi;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "dialogModel", "Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogModel;", "getDialogModel", "()Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogModel;", "editor", "Lcom/intellij/database/schemaEditor/ui/DbStructureEditor;", "getEditor", "()Lcom/intellij/database/schemaEditor/ui/DbStructureEditor;", "getEditorDialogUi", "()Lcom/intellij/database/schemaEditor/DbEditorDialogUi;", "myErrorWrapper", "Lcom/intellij/database/schemaEditor/DbObjectEditorDialogPanelBase$ErrorWrapperPanel;", "getMyErrorWrapper", "()Lcom/intellij/database/schemaEditor/DbObjectEditorDialogPanelBase$ErrorWrapperPanel;", "mySplitter", "Lcom/intellij/openapi/ui/Splitter;", "getMySplitter", "()Lcom/intellij/openapi/ui/Splitter;", "myTabs", "Lcom/intellij/ui/tabs/impl/JBEditorTabs;", "getMyTabs", "()Lcom/intellij/ui/tabs/impl/JBEditorTabs;", "addDataPreview", "", "id", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "index", "addDdlPreview", "addPreview", "addPreviewListeners", "", "collectPreviewIds", "", "identity", "extraPreviews", "Lcom/intellij/util/containers/JBIterable;", "generateScript", "Lkotlin/Pair;", "Lcom/intellij/database/script/generator/ScriptingResult;", "Lcom/intellij/database/util/SearchPath;", "dsRootId", "Lcom/intellij/database/model/basic/BasicRoot;", "getSearchPathObject", "Lcom/intellij/database/model/basic/BasicNamespace;", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "owner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "exampleId", "isAncestor", "", "ancestor", "it", "strict", "joinManagers", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performOperations", "importExecutor", "Lkotlin/Function2;", "Lcom/intellij/database/dbimport/editor/DbImportRunner;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeUndesiredAndUnorderedPreviews", "desired", "", "runImport", "runScript", "(Lcom/intellij/database/schemaEditor/ElementIdentity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runScripts", "showErrorNotification", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "updateFromEditor", "updatePreviews", "prevSelection", "Lcom/intellij/ui/tabs/TabInfo;", "waitManagers", "Companion", "ImportDialogBootstrapper", "ImportDialogModel", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbImportDialogPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbImportDialogPanel.kt\ncom/intellij/database/dbimport/editor/DbImportDialogPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n1864#2,3:398\n1864#2,3:401\n1855#2,2:405\n1#3:404\n*S KotlinDebug\n*F\n+ 1 DbImportDialogPanel.kt\ncom/intellij/database/dbimport/editor/DbImportDialogPanel\n*L\n105#1:398,3\n121#1:401,3\n212#1:405,2\n*E\n"})
public final class DbImportDialogPanel
implements DbEditorDialogBase.DbEditorDialogPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DbEditorDialogUi editorDialogUi;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final DbObjectEditorDialogPanelBase.ErrorWrapperPanel myErrorWrapper;
    @NotNull
    private final JBEditorTabs myTabs;
    @NotNull
    private final JComponent component;
    @NotNull
    private static final Logger LOG;

    protected DbImportDialogPanel(@NotNull DbEditorDialogUi editorDialogUi) {
        Intrinsics.checkNotNullParameter((Object)editorDialogUi, (String)"editorDialogUi");
        this.editorDialogUi = editorDialogUi;
        this.getEditorDialogUi().setOnChanged((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>((Object)this){

            @Nullable
            public final Object invoke(@NotNull Continuation<? super Unit> $completion) {
                return ((DbImportDialogPanel)this.receiver).updateFromEditor((Continuation<? super Unit>)$completion);
            }
        }));
        Project project = this.getEditorDialogUi().getEditorController().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        this.myTabs = new DbStructureEditor.ProperTabs(project2, this.getEditorDialogUi());
        this.myTabs.setEmptyText(DatabaseBundle.message("status.text.select.source.to.see.preview", new Object[0]));
        this.myTabs.setMinimumSize((Dimension)JBUI.size((int)300, (int)120));
        this.myTabs.setPreferredSize((Dimension)JBUI.size((int)300, (int)300));
        this.mySplitter = new Splitter(true, 0.6f);
        this.mySplitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.DISTRIBUTE);
        this.mySplitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_FIRST_MIN_SIZE);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setHonorComponentsPreferredSize(false);
        this.mySplitter.setUseViewportViewSizes(true);
        this.mySplitter.setFirstComponent(this.getEditorDialogUi().getEditor().getComponent());
        this.mySplitter.setSecondComponent(this.myTabs.getComponent());
        this.myErrorWrapper = new DbObjectEditorDialogPanelBase.ErrorWrapperPanel();
        this.addPreviewListeners();
        this.component = this.myErrorWrapper.placeAfter((JComponent)this.mySplitter);
    }

    @Override
    @NotNull
    public DbEditorDialogUi getEditorDialogUi() {
        return this.editorDialogUi;
    }

    @NotNull
    protected final Splitter getMySplitter() {
        return this.mySplitter;
    }

    @NotNull
    protected final DbObjectEditorDialogPanelBase.ErrorWrapperPanel getMyErrorWrapper() {
        return this.myErrorWrapper;
    }

    @NotNull
    protected final JBEditorTabs getMyTabs() {
        return this.myTabs;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public ImportDialogModel getDialogModel() {
        DbEditorDialogModel dbEditorDialogModel = this.getEditorDialogUi().getDialogModel();
        Intrinsics.checkNotNull((Object)dbEditorDialogModel, (String)"null cannot be cast to non-null type com.intellij.database.dbimport.editor.DbImportDialogPanel.ImportDialogModel");
        return (ImportDialogModel)dbEditorDialogModel;
    }

    private final DbStructureEditor<?> getEditor() {
        DbVisualEditor<?, ?> dbVisualEditor = this.getEditorDialogUi().getEditor();
        Intrinsics.checkNotNull(dbVisualEditor, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.ui.DbStructureEditor<*>");
        return (DbStructureEditor)dbVisualEditor;
    }

    private final void addPreviewListeners() {
        this.getEditor().addTabsListener(arg_0 -> DbImportDialogPanel.addPreviewListeners$lambda$0(this, arg_0));
        DbModelTransactionManager dbModelTransactionManager = this.getEditorDialogUi().getEditorController().getModelController().getTransactionManager();
        Runnable runnable = () -> DbImportDialogPanel.addPreviewListeners$lambda$2(this);
        DbEditorModelController dbEditorModelController = this.getEditorDialogUi().getEditorController().getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        dbModelTransactionManager.whenFinished(runnable, dbEditorModelController);
    }

    private final void updatePreviews(ElementIdentity<?> identity) {
        Set<ElementIdentity<?>> desired = this.collectPreviewIds(identity);
        TabInfo prevSelection = this.myTabs.getSelectedInfo();
        this.removeUndesiredAndUnorderedPreviews(desired);
        this.updatePreviews(desired, prevSelection);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeUndesiredAndUnorderedPreviews(Set<? extends ElementIdentity<?>> desired) {
        Object2IntOpenHashMap indices = new Object2IntOpenHashMap();
        indices.defaultReturnValue(-1);
        Iterable $this$forEachIndexed$iv = desired;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void id;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ElementIdentity elementIdentity = (ElementIdentity)item$iv;
            int index2 = n;
            boolean bl = false;
            Integer n3 = index2;
            ((Map)indices).put(id, n3);
        }
        int prevIdx = 0;
        for (TabInfo tab2 : CollectionsKt.toList((Iterable)this.myTabs.getVisibleInfos())) {
            int idx = indices.getInt(tab2.getObject());
            if (idx < prevIdx) {
                this.myTabs.removeTab(tab2);
                continue;
            }
            prevIdx = idx;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePreviews(Set<? extends ElementIdentity<?>> desired, TabInfo prevSelection) {
        block7: {
            Object object;
            block6: {
                Object object2;
                Object2IntOpenHashMap indices = new Object2IntOpenHashMap();
                indices.defaultReturnValue(-1);
                Iterable $this$forEachIndexed$iv = this.myTabs.getVisibleInfos();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void tab2;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    object2 = (TabInfo)item$iv;
                    int index2 = n;
                    boolean bl = false;
                    Map map2 = (Map)indices;
                    Object object3 = tab2.getObject();
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.ElementIdentity<*>");
                    ElementIdentity elementIdentity = (ElementIdentity)object3;
                    Integer n3 = index2;
                    map2.put(elementIdentity, n3);
                }
                int offset = 0;
                int index3 = 0;
                for (ElementIdentity<?> id : desired) {
                    int existing = indices.getInt(id);
                    if (existing != -1) {
                        index3 = existing + offset + 1;
                        continue;
                    }
                    int count = this.addPreview(id, index3);
                    offset += count;
                    index3 += count;
                }
                if (prevSelection == null || this.myTabs.getVisibleInfos().contains(prevSelection)) break block7;
                Iterable existing = this.myTabs.getVisibleInfos();
                Iterator count = existing.iterator();
                while (count.hasNext()) {
                    Object it2 = object2 = count.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getText(), (Object)prevSelection.getText())) continue;
                    object = object2;
                    break block6;
                }
                object = null;
            }
            TabInfo tabInfo = object;
            if (tabInfo != null) {
                TabInfo it3 = tabInfo;
                boolean bl = false;
                this.myTabs.select(it3, false);
            }
        }
    }

    private final int addPreview(ElementIdentity<?> id, int index2) {
        int count = this.addDataPreview(id, index2);
        count += this.addDdlPreview(id, index2 + count);
        return count;
    }

    private final int addDataPreview(ElementIdentity<?> id, int index2) {
        JComponent jComponent = this.getDialogModel().getDataPreviewManager().getPreviewComponent(id);
        if (jComponent == null) {
            return 0;
        }
        JComponent component2 = jComponent;
        TabInfo tab2 = new TabInfo(component2);
        tab2.setText(DatabaseBundle.message("database.data.import.data.preview.tab.title", new Object[0]));
        tab2.setObject(id);
        this.myTabs.addTab(tab2, index2);
        return 1;
    }

    private final int addDdlPreview(ElementIdentity<?> id, int index2) {
        SqlPreviewComponent sqlPreviewComponent = this.getDialogModel().getDdlPreviewManager().getPreview(id);
        if (sqlPreviewComponent == null) {
            return 0;
        }
        SqlPreviewComponent preview = sqlPreviewComponent;
        TabInfo tab2 = new TabInfo((JComponent)preview.getEditor());
        tab2.setText(DatabaseBundle.message("database.data.import.ddl.preview.tab.title", new Object[0]));
        tab2.setObject(id);
        this.myTabs.addTab(tab2, index2);
        return 1;
    }

    private final Set<ElementIdentity<?>> collectPreviewIds(ElementIdentity<?> identity) {
        Collection collection2 = MultiElementIdentity.expand(identity).flatten(arg_0 -> DbImportDialogPanel.collectPreviewIds$lambda$7((Function1)new Function1<ElementIdentity<?>, Iterable<? extends ElementIdentity<?>>>(this){
            final /* synthetic */ DbImportDialogPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterable<ElementIdentity<?>> invoke(ElementIdentity<?> id) {
                JBIterable jBIterable = JBIterable.generate(id, arg_0 -> collectPreviewIds.1.invoke$lambda$0((Function1)new Function1<ElementIdentity<?>, ElementIdentity<?>>(this.this$0){
                    final /* synthetic */ DbImportDialogPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final ElementIdentity<?> invoke(ElementIdentity<?> identity) {
                        return this.this$0.getDialogModel().getTargetOwner().getParent(identity);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"generate(...)");
                return CollectionsKt.reversed((Iterable)((Iterable)jBIterable));
            }

            private static final ElementIdentity invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (ElementIdentity)$tmp0.invoke(p0);
            }
        }, arg_0)).flatten(arg_0 -> DbImportDialogPanel.collectPreviewIds$lambda$8((Function1)new Function1<ElementIdentity<?>, Iterable<? extends ElementIdentity<?>>>(this){
            final /* synthetic */ DbImportDialogPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterable<ElementIdentity<?>> invoke(ElementIdentity<?> id) {
                Intrinsics.checkNotNull(id);
                return (Iterable)DbImportDialogPanel.access$extraPreviews(this.this$0, id).append(id);
            }
        }, arg_0)).addAllTo((Collection)new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"addAllTo(...)");
        return (Set)collection2;
    }

    private final JBIterable<ElementIdentity<?>> extraPreviews(ElementIdentity<?> id) {
        if (id.getMetaObject().kind == MappingData.KIND) {
            ElementIdentity<BasicTable> tableId = DbReferenceModelState.resolveReference(this.getEditorDialogUi().getEditorController().getModelController(), id, MappingData.TABLE_REF);
            JBIterable jBIterable = JBIterable.of(tableId);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        return jBIterable;
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateFromEditor(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof updateFromEditor.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$updateFromEditor(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.getEditorDialogUi().apply((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (DbImportDialogPanel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this.getDialogModel().getDdlPreviewManager().updatePreviews((Continuation<? super Unit>)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl31
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitManagers(Continuation<? super Boolean> var1_1) {
        if (!(var1_1 instanceof waitManagers.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$waitManagers(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                while (true) {
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.joinManagers((Continuation<? super Boolean>)$continuation);
                    if (v0 != var4_4) continue;
                    return var4_4;
                }
            }
            case 1: {
                this = (DbImportDialogPanel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                if (!((Boolean)v0).booleanValue()) ** continue;
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object joinManagers(Continuation<? super Boolean> var1_1) {
        if (!(var1_1 instanceof joinManagers.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$joinManagers(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.getEditorDialogUi().apply((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (DbImportDialogPanel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this.getDialogModel().waitBackgroundTasks((Continuation<? super Boolean>)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl31
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object performOperations(@NotNull Function2<? super DbImportRunner, ? super Continuation<? super Boolean>, ? extends Object> var1_1, @NotNull Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof performOperations.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.performOperations(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = importExecutor;
                $continuation.label = 1;
                v0 = this.waitManagers((Continuation<? super Boolean>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                importExecutor = (Function2)$continuation.L$1;
                this = (DbImportDialogPanel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = importExecutor;
                $continuation.label = 2;
                v1 = this.runScripts((Continuation<? super Boolean>)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl38
            }
            case 2: {
                importExecutor = (Function2)$continuation.L$1;
                this = (DbImportDialogPanel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                if (!((Boolean)v1).booleanValue()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v2 = this.runImport((Function2<? super DbImportRunner, ? super Continuation<? super Boolean>, ? extends Object>)importExecutor, (Continuation<? super Boolean>)$continuation);
                if (v2 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl50
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl50:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object runScripts(Continuation<? super Boolean> var1_1) {
        if (!(var1_1 instanceof runScripts.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$runScripts(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getDialogModel().getTargetOwner();
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.ElementMatcherImpl.ElementOwnerImpl");
                v1 = JBIterable.from(((ElementMatcherImpl.ElementOwnerImpl)v0).getCached()).filterMap((Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, runScripts$lambda$9(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Lcom/intellij/database/schemaEditor/ElementIdentity;)((Function1)runScripts.2.INSTANCE));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filterMap(...)");
                $this$forEach$iv = (Iterable)v1;
                $i$f$forEach = false;
                var4_7 = $this$forEach$iv.iterator();
lbl19:
                // 2 sources

                while (var4_7.hasNext()) {
                    element$iv = var4_7.next();
                    dsRootId = (ElementIdentity)element$iv;
                    $i$a$-forEach-DbImportDialogPanel$runScripts$3 = false;
                    Intrinsics.checkNotNull((Object)dsRootId);
                    $continuation.L$0 = this;
                    $continuation.L$1 = var4_7;
                    $continuation.label = 1;
                    v2 = this.runScript(dsRootId, (Continuation<? super Boolean>)$continuation);
                    if (v2 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl39
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-DbImportDialogPanel$runScripts$3 = false;
                var4_7 = (Iterator<T>)$continuation.L$1;
                this = (DbImportDialogPanel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl39:
                // 2 sources

                if (((Boolean)v2).booleanValue()) ** GOTO lbl19
                return Boxing.boxBoolean((boolean)false);
            }
        }
        return Boxing.boxBoolean((boolean)true);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object runScript(ElementIdentity<BasicRoot> var1_1, Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof runScript.1)) ** GOTO lbl-1000
        var10_3 = var2_2;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$runScript(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getEditorDialogUi().getEditorController().getModelController();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getModelController(...)");
                var5_6 = DataSourceData.Companion.getDataSource(v0, this.getDialogModel().getTargetOwner().getParent((ElementIdentity<?>)dsRootId));
                v1 = var5_6 instanceof LocalDataSource != false ? (LocalDataSource)var5_6 : null;
                if (v1 == null) {
                    return Boxing.boxBoolean((boolean)true);
                }
                dataSource = v1;
                v2 = this.generateScript((ElementIdentity<BasicRoot>)dsRootId);
                if (v2 == null) {
                    return Boxing.boxBoolean((boolean)true);
                }
                var4_8 = v2;
                script = (ScriptingResult)var4_8.component1();
                searchPath = (SearchPath)var4_8.component2();
                var8_10 = this.getEditorDialogUi().getEditorController().getProject();
                handler = new DatabaseRefactoringHandler(dataSource, searchPath, this, var8_10){
                    final /* synthetic */ DbImportDialogPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1, $dataSource, $searchPath);
                    }

                    @NotNull
                    protected AsyncTask<Boolean> runSync(boolean nonModalSync, @NotNull Ref<String> shownSummary, boolean res2, @NotNull Throwable th) {
                        Intrinsics.checkNotNullParameter(shownSummary, (String)"shownSummary");
                        Intrinsics.checkNotNullParameter((Object)th, (String)"th");
                        return AsyncTask.Companion.completed(res2, th);
                    }

                    protected void showError(@NotNull Project project, @NotNull ErrorHandler handler2) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                        DbImportDialogPanel.access$showErrorNotification(this.this$0, handler2.getSummary());
                    }
                };
                handler.setStatement(script.getScriptText());
                $continuation.label = 1;
                v3 = DbObjectEditorDialogPanelBaseKt.runStatementsAsync(handler, false, (Continuation<? super Boolean>)$continuation);
                if (v3 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl37
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl37:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"runStatementsAsync(...)");
                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void showErrorNotification(String text2) {
        if (text2 == null) {
            this.myErrorWrapper.close();
            return;
        }
        this.myErrorWrapper.setError(this.myErrorWrapper.create(EditorNotificationPanel.Status.Error).text(text2));
    }

    private final Pair<ScriptingResult, SearchPath> generateScript(ElementIdentity<BasicRoot> dsRootId) {
        BasicModel srcModel;
        BasicRoot basicRoot;
        ImportDialogModel dialogModel = this.getDialogModel();
        DbEditorModelController controller = dialogModel.getModelController();
        ElementOwner targetOwner = dialogModel.getTargetOwner();
        BasicRoot tgtRoot = targetOwner.find(dsRootId);
        if (targetOwner.getOriginal() == null) {
            basicRoot = null;
        } else {
            ElementOwner elementOwner = targetOwner.getOriginal();
            Intrinsics.checkNotNull((Object)elementOwner);
            basicRoot = elementOwner.find(dsRootId);
        }
        BasicRoot srcRoot = basicRoot;
        BasicRoot basicRoot2 = tgtRoot;
        BasicModel tgtModel = basicRoot2 != null ? basicRoot2.getModel() : null;
        BasicRoot basicRoot3 = srcRoot;
        BasicModel basicModel = srcModel = basicRoot3 != null ? basicRoot3.getModel() : null;
        if (tgtModel == null || srcModel == null) {
            return null;
        }
        LinkedHashSet correspondence = new LinkedHashSet();
        Function1 filter2 = new Function1<ElementIdentity<?>, Boolean>(this, dsRootId){
            final /* synthetic */ DbImportDialogPanel this$0;
            final /* synthetic */ ElementIdentity<BasicRoot> $dsRootId;
            {
                this.this$0 = $receiver;
                this.$dsRootId = $dsRootId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ElementIdentity<?> id) {
                Intrinsics.checkNotNullParameter(id, (String)"id");
                return DbImportDialogPanel.access$isAncestor(this.this$0, this.$dsRootId, id, false);
            }
        };
        DbEditorDialogModel.Companion.fillCorrespondence(correspondence, targetOwner.getOriginal(), targetOwner, controller, arg_0 -> DbImportDialogPanel.generateScript$lambda$11(filter2, arg_0));
        if (correspondence.isEmpty()) {
            return null;
        }
        ElementIdentity<?> spExample = DbEditorDialogModel.Companion.findSearchPathExample(targetOwner, controller, arg_0 -> DbImportDialogPanel.generateScript$lambda$12(filter2, arg_0));
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(srcModel, tgtModel);
        builder.getCorrespondence().addAll(correspondence);
        BasicNamespace spObject = this.getSearchPathObject(controller, targetOwner, spExample);
        builder.setCurrentNamespace(spObject);
        Project project = dialogModel.getModelController().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return TuplesKt.to((Object)ScriptGenerators.INSTANCE.makeScript(project, builder.build()), (Object)ObjectPaths.searchPathOf(spObject));
    }

    private final BasicNamespace getSearchPathObject(DbEditorModelController controller, ElementOwner owner, ElementIdentity<?> exampleId) {
        ElementIdentity<BasicNamespace> elementIdentity;
        block6: {
            block5: {
                if (exampleId == null) {
                    return null;
                }
                ElementMatcher elementMatcher = controller.getMatcher();
                Intrinsics.checkNotNullExpressionValue((Object)elementMatcher, (String)"getMatcher(...)");
                elementIdentity = DbEditorUtilsKt.skipTo(elementMatcher, exampleId, BasicNamespace.class);
                if (elementIdentity == null) break block5;
                ElementIdentity<BasicNamespace> it2 = elementIdentity;
                boolean bl = false;
                ElementOwner elementOwner = owner.getOriginal();
                BasicNamespace basicNamespace = elementOwner != null ? elementOwner.find(it2) : null;
                elementIdentity = basicNamespace;
                if (basicNamespace != null) break block6;
            }
            return null;
        }
        ElementIdentity<BasicNamespace> spCandidate = elementIdentity;
        RawDataSource rawDataSource = DataSourceData.Companion.getDataSource(controller, exampleId);
        LocalDataSource dataSource2 = rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
        Object object = dataSource2;
        if (object == null || (object = ((LocalDataSource)object).getDbms()) == null) {
            object = controller.getDbms(exampleId);
        }
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect((Dbms)object);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
        DatabaseDialectEx databaseDialect2 = databaseDialectEx;
        DasNamespace dasNamespace = DbImplUtilCore.getSearchPathObjectForSwitch(dataSource2, databaseDialect2, (DasObject)((Object)spCandidate));
        return dasNamespace instanceof BasicNamespace ? (BasicNamespace)dasNamespace : null;
    }

    private final boolean isAncestor(ElementIdentity<?> ancestor, ElementIdentity<?> it2, boolean strict) {
        ElementIdentity<?> tmp;
        if (it2 == null || ancestor == null) {
            return !strict && it2 == ancestor;
        }
        ElementOwner targetOwner = this.getDialogModel().getTargetOwner();
        ElementIdentity<?> elementIdentity = tmp = strict ? targetOwner.getParent(it2) : it2;
        while (tmp != null && tmp != ancestor) {
            tmp = targetOwner.getParent(tmp);
        }
        return tmp == ancestor;
    }

    /*
     * Unable to fully structure code
     */
    private final Object runImport(Function2<? super DbImportRunner, ? super Continuation<? super Boolean>, ? extends Object> var1_1, Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof runImport.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DbImportDialogPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbImportDialogPanel.access$runImport(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                dialogModel = this.getDialogModel();
                v0 = dialogModel.getModelController().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
                importRunner = DbImportRunner.Companion.create(v0, dialogModel.getTargetOwner(), dialogModel.getIdentity(), dialogModel.getCachedDataManager());
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = importExecutor.invoke((Object)importRunner, (Object)$continuation);
                ** if (v1 != var8_5) goto lbl23
lbl22:
                // 1 sources

                return var8_5;
lbl23:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                this = (DbImportDialogPanel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl30:
                    // 2 sources

                    var3_7 = (Boolean)v1;
                }
                catch (CancellationException c) {
                    var5_11 = c.getMessage();
                    if (!(var5_11 == null || var5_11.length() == 0)) {
                        this.showErrorNotification(c.getMessage());
                    }
                    throw c;
                }
                catch (Throwable th) {
                    DbImportDialogPanel.LOG.warn(th);
                    this.showErrorNotification(th.getMessage());
                    throw ExceptionsKt.CancellationException((String)"Import failed", (Throwable)th);
                }
                return Boxing.boxBoolean((boolean)(var3_7 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void addPreviewListeners$lambda$0(DbImportDialogPanel this$0, ElementIdentity identity) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updatePreviews(identity);
    }

    private static final void addPreviewListeners$lambda$2$lambda$1(DbImportDialogPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DbEditor<?, ?> dbEditor = this$0.getEditor().getSelectedEditor();
        ElementIdentity<?> selId = dbEditor != null ? dbEditor.getIdentity() : null;
        this$0.updatePreviews(selId);
    }

    private static final void addPreviewListeners$lambda$2(DbImportDialogPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ApplicationManager.getApplication().invokeLater(() -> DbImportDialogPanel.addPreviewListeners$lambda$2$lambda$1(this$0));
    }

    private static final Iterable collectPreviewIds$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable collectPreviewIds$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final ElementIdentity runScripts$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ElementIdentity)$tmp0.invoke(p0);
    }

    private static final boolean generateScript$lambda$11(Function1 $tmp0, ElementIdentity p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }

    private static final boolean generateScript$lambda$12(Function1 $tmp0, ElementIdentity p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }

    public static final /* synthetic */ JBIterable access$extraPreviews(DbImportDialogPanel $this, ElementIdentity id) {
        return $this.extraPreviews(id);
    }

    public static final /* synthetic */ Object access$waitManagers(DbImportDialogPanel $this, Continuation $completion) {
        return $this.waitManagers((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$joinManagers(DbImportDialogPanel $this, Continuation $completion) {
        return $this.joinManagers((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$runScripts(DbImportDialogPanel $this, Continuation $completion) {
        return $this.runScripts((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$runScript(DbImportDialogPanel $this, ElementIdentity dsRootId, Continuation $completion) {
        return $this.runScript(dsRootId, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ void access$showErrorNotification(DbImportDialogPanel $this, String text2) {
        $this.showErrorNotification(text2);
    }

    public static final /* synthetic */ boolean access$isAncestor(DbImportDialogPanel $this, ElementIdentity ancestor, ElementIdentity it2, boolean strict) {
        return $this.isAncestor(ancestor, it2, strict);
    }

    public static final /* synthetic */ Object access$runImport(DbImportDialogPanel $this, Function2 importExecutor, Continuation $completion) {
        return $this.runImport((Function2<? super DbImportRunner, ? super Continuation<? super Boolean>, ? extends Object>)importExecutor, (Continuation<? super Boolean>)$completion);
    }

    static {
        Logger logger2 = Logger.getInstance(DbImportDialogPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u0010*\u0004\u0018\u00010\u0010H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "create", "Lcom/intellij/database/dbimport/editor/DbImportDialogPanel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "bootstrapper", "Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;Lcom/intellij/openapi/Disposable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "assertDialogModality", "Lcom/intellij/openapi/application/ModalityState;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object create(@NotNull CoroutineScope coroutineScope, @NotNull ImportDialogBootstrapper bootstrapper, @NotNull Disposable disposable, @NotNull Continuation<? super DbImportDialogPanel> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DbImportDialogPanel>, Object>(bootstrapper, coroutineScope, disposable, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ ImportDialogBootstrapper $bootstrapper;
                final /* synthetic */ CoroutineScope $coroutineScope;
                final /* synthetic */ Disposable $disposable;
                {
                    this.$bootstrapper = $bootstrapper;
                    this.$coroutineScope = $coroutineScope;
                    this.$disposable = $disposable;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$withContext = (CoroutineScope)this.L$0;
                            modalityState = com.intellij.database.dbimport.editor.DbImportDialogPanel$Companion.access$assertDialogModality(DbImportDialogPanel.Companion, ModalityKt.contextModality((CoroutineContext)$this$withContext.getCoroutineContext()));
                            this.label = 1;
                            v0 = this.$bootstrapper.createDialogModel(this.$coroutineScope, modalityState, (Continuation<? super DbEditorDialogModel>)((Continuation)this));
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            dialogModel = (DbEditorDialogModel)v0;
                            Disposer.register((Disposable)this.$disposable, (Disposable)dialogModel);
                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DbImportDialogPanel>, Object>(dialogModel, this.$disposable, this.$bootstrapper, null){
                                Object L$0;
                                int label;
                                final /* synthetic */ DbEditorDialogModel $dialogModel;
                                final /* synthetic */ Disposable $disposable;
                                final /* synthetic */ ImportDialogBootstrapper $bootstrapper;
                                {
                                    this.$dialogModel = $dialogModel;
                                    this.$disposable = $disposable;
                                    this.$bootstrapper = $bootstrapper;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            editorDialogUi = new DbEditorDialogUi(this.$dialogModel);
                                            Disposer.register((Disposable)this.$disposable, (Disposable)editorDialogUi);
                                            this.L$0 = editorDialogUi;
                                            this.label = 1;
                                            v0 = editorDialogUi.reset((Continuation<? super Unit>)((Continuation)this));
                                            if (v0 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl17
                                        }
                                        case 1: {
                                            editorDialogUi = (DbEditorDialogUi)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl17:
                                            // 2 sources

                                            this.L$0 = editorDialogUi;
                                            this.label = 2;
                                            v1 = this.$bootstrapper.initUi(editorDialogUi, (Continuation<? super Unit>)((Continuation)this));
                                            if (v1 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl27
                                        }
                                        case 2: {
                                            editorDialogUi = (DbEditorDialogUi)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl27:
                                            // 2 sources

                                            this.L$0 = null;
                                            this.label = 3;
                                            v2 = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<DbImportDialogPanel>(editorDialogUi){
                                                final /* synthetic */ DbEditorDialogUi $editorDialogUi;
                                                {
                                                    this.$editorDialogUi = $editorDialogUi;
                                                    super(0);
                                                }

                                                @NotNull
                                                public final DbImportDialogPanel invoke() {
                                                    return new DbImportDialogPanel(this.$editorDialogUi);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v2 == var3_2) {
                                                return var3_2;
                                            }
                                            ** GOTO lbl36
                                        }
                                        case 3: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl36:
                                            // 2 sources

                                            return v2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super DbImportDialogPanel> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v1 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl25
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl25:
                            // 2 sources

                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super DbImportDialogPanel> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private final ModalityState assertDialogModality(ModalityState $this$assertDialogModality) {
            ModalityState modalityState = DbEditorModality.assertDialogModality($this$assertDialogModality);
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"assertDialogModality(...)");
            return modalityState;
        }

        public static final /* synthetic */ ModalityState access$assertDialogModality(Companion $this, ModalityState $receiver) {
            return $this.assertDialogModality($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020$H\u0016J&\u0010%\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0014J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0096@\u00a2\u0006\u0002\u0010/J\u001c\u00100\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010'\u001a\u00020(2\u0006\u00101\u001a\u000202H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00063"}, d2={"Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;", "Lcom/intellij/database/schemaEditor/DbObjectEditorDialogPanelBase$DialogBootstrapper;", "project", "Lcom/intellij/openapi/project/Project;", "invocation", "Lcom/intellij/database/dbimport/editor/DbImportDialog$InvocationType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dbimport/editor/DbImportDialog$InvocationType;)V", "getInvocation", "()Lcom/intellij/database/dbimport/editor/DbImportDialog$InvocationType;", "myAutoTableManager", "Lcom/intellij/database/dbimport/editor/DbImportAutoTableManager;", "getMyAutoTableManager", "()Lcom/intellij/database/dbimport/editor/DbImportAutoTableManager;", "setMyAutoTableManager", "(Lcom/intellij/database/dbimport/editor/DbImportAutoTableManager;)V", "myCachedDataManager", "Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;", "getMyCachedDataManager", "()Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;", "setMyCachedDataManager", "(Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;)V", "myDataPreviewManager", "Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;", "getMyDataPreviewManager", "()Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;", "setMyDataPreviewManager", "(Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;)V", "myDdlPreviewManager", "Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;", "getMyDdlPreviewManager", "()Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;", "setMyDdlPreviewManager", "(Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;)V", "createDialogModelImpl", "Lcom/intellij/database/schemaEditor/DbEditorDialogModel;", "createEditorBuilder", "Lcom/intellij/database/schemaEditor/DbObjectEditorBuilder;", "createEditorModelImpl", "Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "targetId", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "initUi", "", "dialogUi", "Lcom/intellij/database/schemaEditor/DbEditorDialogUi;", "(Lcom/intellij/database/schemaEditor/DbEditorDialogUi;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareTargetIdentity", "targetOwner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "intellij.database.impl"})
    public static class ImportDialogBootstrapper
    extends DbObjectEditorDialogPanelBase.DialogBootstrapper {
        @NotNull
        private final DbImportDialog.InvocationType invocation;
        public DbImportDataPreviewManager myDataPreviewManager;
        public DbImportDdlPreviewManager myDdlPreviewManager;
        public DbImportAutoTableManager myAutoTableManager;
        public DbImportCachedDataManager myCachedDataManager;

        public ImportDialogBootstrapper(@NotNull Project project, @NotNull DbImportDialog.InvocationType invocation) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)invocation), (String)"invocation");
            super(project);
            this.invocation = invocation;
        }

        @NotNull
        public final DbImportDialog.InvocationType getInvocation() {
            return this.invocation;
        }

        @NotNull
        public final DbImportDataPreviewManager getMyDataPreviewManager() {
            DbImportDataPreviewManager dbImportDataPreviewManager = this.myDataPreviewManager;
            if (dbImportDataPreviewManager != null) {
                return dbImportDataPreviewManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDataPreviewManager");
            return null;
        }

        public final void setMyDataPreviewManager(@NotNull DbImportDataPreviewManager dbImportDataPreviewManager) {
            Intrinsics.checkNotNullParameter((Object)dbImportDataPreviewManager, (String)"<set-?>");
            this.myDataPreviewManager = dbImportDataPreviewManager;
        }

        @NotNull
        public final DbImportDdlPreviewManager getMyDdlPreviewManager() {
            DbImportDdlPreviewManager dbImportDdlPreviewManager = this.myDdlPreviewManager;
            if (dbImportDdlPreviewManager != null) {
                return dbImportDdlPreviewManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDdlPreviewManager");
            return null;
        }

        public final void setMyDdlPreviewManager(@NotNull DbImportDdlPreviewManager dbImportDdlPreviewManager) {
            Intrinsics.checkNotNullParameter((Object)dbImportDdlPreviewManager, (String)"<set-?>");
            this.myDdlPreviewManager = dbImportDdlPreviewManager;
        }

        @NotNull
        public final DbImportAutoTableManager getMyAutoTableManager() {
            DbImportAutoTableManager dbImportAutoTableManager = this.myAutoTableManager;
            if (dbImportAutoTableManager != null) {
                return dbImportAutoTableManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myAutoTableManager");
            return null;
        }

        public final void setMyAutoTableManager(@NotNull DbImportAutoTableManager dbImportAutoTableManager) {
            Intrinsics.checkNotNullParameter((Object)dbImportAutoTableManager, (String)"<set-?>");
            this.myAutoTableManager = dbImportAutoTableManager;
        }

        @NotNull
        public final DbImportCachedDataManager getMyCachedDataManager() {
            DbImportCachedDataManager dbImportCachedDataManager = this.myCachedDataManager;
            if (dbImportCachedDataManager != null) {
                return dbImportCachedDataManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCachedDataManager");
            return null;
        }

        public final void setMyCachedDataManager(@NotNull DbImportCachedDataManager dbImportCachedDataManager) {
            Intrinsics.checkNotNullParameter((Object)dbImportCachedDataManager, (String)"<set-?>");
            this.myCachedDataManager = dbImportCachedDataManager;
        }

        @Override
        @NotNull
        public DbObjectEditorBuilder createEditorBuilder() {
            return new DbImportEditorBuilder();
        }

        @Override
        @NotNull
        protected DbEditorDialogModel createDialogModelImpl() {
            return new ImportDialogModel(this);
        }

        @Override
        @NotNull
        public ElementIdentity<?> prepareTargetIdentity(@NotNull DbEditorModelController controller, @NotNull ElementOwner targetOwner) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
            this.setMyDataPreviewManager(new DbImportDataPreviewManager(controller));
            this.setMyDdlPreviewManager(new DbImportDdlPreviewManager(controller));
            this.setMyAutoTableManager(new DbImportAutoTableManager(controller));
            this.setMyCachedDataManager(new DbImportCachedDataManager(controller));
            ElementOwner elementOwner = targetOwner.getOriginal();
            Intrinsics.checkNotNull((Object)elementOwner);
            ElementIdentity<WrapperElement<FakeRootData>> elementIdentity = elementOwner.identify(FakeRootData.META.newDataObject());
            Intrinsics.checkNotNullExpressionValue(elementIdentity, (String)"identify(...)");
            return elementIdentity;
        }

        @Override
        @Nullable
        public Object initUi(@NotNull DbEditorDialogUi dialogUi2, @NotNull Continuation<? super Unit> $completion) {
            return ImportDialogBootstrapper.initUi$suspendImpl(this, dialogUi2, $completion);
        }

        static /* synthetic */ Object initUi$suspendImpl(ImportDialogBootstrapper $this, DbEditorDialogUi dialogUi2, Continuation<? super Unit> $completion) {
            DbEditorDialogModel dialogModel = dialogUi2.getDialogModel();
            ElementOwner elementOwner = dialogModel.getTargetOwner();
            Intrinsics.checkNotNull((Object)elementOwner, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.ElementMatcherImpl.ElementOwnerImpl");
            JBIterable jBIterable = JBIterable.from(((ElementMatcherImpl.ElementOwnerImpl)elementOwner).getCached());
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
            JBIterable ids = jBIterable;
            Object[] objectArray = new JBIterable[]{ids.filter(arg_0 -> ImportDialogBootstrapper.initUi$lambda$0(initUi.openIds.1.INSTANCE, arg_0)), ids.filter(arg_0 -> ImportDialogBootstrapper.initUi$lambda$1(initUi.openIds.2.INSTANCE, arg_0))};
            List openIds2 = (List)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)initUi.openIds.3.INSTANCE), (Function1)initUi.openIds.4.INSTANCE));
            if (openIds2 != null) {
                Object object = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Unit>(openIds2, dialogUi2){
                    final /* synthetic */ List<ElementIdentity<?>> $openIds;
                    final /* synthetic */ DbEditorDialogUi $dialogUi;
                    {
                        this.$openIds = $openIds;
                        this.$dialogUi = $dialogUi;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$forEachIndexed$iv;
                        Sequence sequence = SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)this.$openIds), (int)5);
                        DbEditorDialogUi dbEditorDialogUi = this.$dialogUi;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (E item$iv : $this$forEachIndexed$iv) {
                            void id;
                            int n;
                            if ((n = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            ElementIdentity elementIdentity = (ElementIdentity)item$iv;
                            int index2 = n;
                            boolean bl = false;
                            boolean isLead = index2 == 0;
                            Intrinsics.checkNotNull((Object)id);
                            dbEditorDialogUi.edit((ElementIdentity<?>)id, true, isLead, !isLead, false, false);
                        }
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        }

        @Override
        @Nullable
        protected DbEditorModel<?, ?> createEditorModelImpl(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> targetId) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter(targetId, (String)"targetId");
            DbEditorModel<?, DbStructureModelState> dbEditorModel = controller.getBuilder().createStructureModel(controller, targetId);
            Intrinsics.checkNotNullExpressionValue(dbEditorModel, (String)"createStructureModel(...)");
            DbEditorModel<?, DbStructureModelState> model2 = dbEditorModel;
            controller.createStructureNodeModel(targetId);
            return model2;
        }

        private static final boolean initUi$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean initUi$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogModel;", "Lcom/intellij/database/schemaEditor/DbEditorDialogModel;", "bootstrapper", "Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;", "(Lcom/intellij/database/dbimport/editor/DbImportDialogPanel$ImportDialogBootstrapper;)V", "autoTableManager", "Lcom/intellij/database/dbimport/editor/DbImportAutoTableManager;", "cachedDataManager", "Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;", "getCachedDataManager", "()Lcom/intellij/database/dbimport/editor/DbImportCachedDataManager;", "dataPreviewManager", "Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;", "getDataPreviewManager", "()Lcom/intellij/database/dbimport/editor/DbImportDataPreviewManager;", "ddlPreviewManager", "Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;", "getDdlPreviewManager", "()Lcom/intellij/database/dbimport/editor/DbImportDdlPreviewManager;", "joinManagers", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitBackgroundTasks", "intellij.database.impl"})
    public static final class ImportDialogModel
    extends DbEditorDialogModel {
        @NotNull
        private final DbImportDataPreviewManager dataPreviewManager;
        @NotNull
        private final DbImportDdlPreviewManager ddlPreviewManager;
        @NotNull
        private final DbImportAutoTableManager autoTableManager;
        @NotNull
        private final DbImportCachedDataManager cachedDataManager;

        public ImportDialogModel(@NotNull ImportDialogBootstrapper bootstrapper) {
            Intrinsics.checkNotNullParameter((Object)bootstrapper, (String)"bootstrapper");
            super(bootstrapper);
            this.dataPreviewManager = bootstrapper.getMyDataPreviewManager();
            this.ddlPreviewManager = bootstrapper.getMyDdlPreviewManager();
            this.autoTableManager = bootstrapper.getMyAutoTableManager();
            this.cachedDataManager = bootstrapper.getMyCachedDataManager();
        }

        @NotNull
        public final DbImportDataPreviewManager getDataPreviewManager() {
            return this.dataPreviewManager;
        }

        @NotNull
        public final DbImportDdlPreviewManager getDdlPreviewManager() {
            return this.ddlPreviewManager;
        }

        @NotNull
        public final DbImportCachedDataManager getCachedDataManager() {
            return this.cachedDataManager;
        }

        /*
         * Unable to fully structure code
         */
        private final Object joinManagers(Continuation<? super Boolean> var1_1) {
            if (!(var1_1 instanceof joinManagers.1)) ** GOTO lbl-1000
            var3_2 = var1_1;
            if ((var3_2.label & -2147483648) != 0) {
                var3_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ImportDialogModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ImportDialogModel.access$joinManagers(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.dataPreviewManager.join((Continuation<? super Boolean>)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (ImportDialogModel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) break;
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v1 = this.autoTableManager.join((Continuation<? super Boolean>)$continuation);
                    if (v1 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl33
                }
                case 2: {
                    this = (ImportDialogModel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl33:
                    // 2 sources

                    if (!((Boolean)v1).booleanValue()) break;
                    $continuation.L$0 = null;
                    $continuation.label = 3;
                    v2 = this.ddlPreviewManager.join((Continuation<? super Boolean>)$continuation);
                    if (v2 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl43
                }
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl43:
                    // 2 sources

                    return v2;
                }
            }
            return Boxing.boxBoolean((boolean)false);
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object waitBackgroundTasks(@NotNull Continuation<? super Boolean> var1_1) {
            if (!(var1_1 instanceof waitBackgroundTasks.1)) ** GOTO lbl-1000
            var3_2 = var1_1;
            if ((var3_2.label & -2147483648) != 0) {
                var3_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ImportDialogModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.waitBackgroundTasks((Continuation<? super Boolean>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = super.waitBackgroundTasks((Continuation<? super Boolean>)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (ImportDialogModel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) break;
                    $continuation.L$0 = null;
                    $continuation.label = 2;
                    v1 = this.joinManagers((Continuation<? super Boolean>)$continuation);
                    if (v1 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl32
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl32:
                    // 2 sources

                    return v1;
                }
            }
            return Boxing.boxBoolean((boolean)false);
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static final /* synthetic */ Object access$joinManagers(ImportDialogModel $this, Continuation $completion) {
            return $this.joinManagers((Continuation<? super Boolean>)$completion);
        }
    }
}

