/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.actions.ImportSourceType;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.csv.CsvPreviewModel;
import com.intellij.database.dbimport.csv.CsvSource;
import com.intellij.database.dbimport.ui.ImportSettingsComponent;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.csv.CharsetComponent;
import com.intellij.database.dbimport.ui.csv.CsvFormatComponent;
import com.intellij.database.dbimport.ui.csv.CsvPreviewComponent;
import com.intellij.database.dbimport.ui.csv.CsvTableEditorComponent;
import com.intellij.database.dbimport.ui.database.TargetSchemaComponent;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvSourceType
implements ImportAction.SourceType {
    private final VirtualFile myFile;
    private final int myCharCount;

    public CsvSourceType(@NotNull VirtualFile file, int charCountToRead) {
        if (file == null) {
            CsvSourceType.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.myCharCount = charCountToRead;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            CsvSourceType.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public ReaderTask.Source createSource(@NotNull ImportInfo info2) {
        if (info2 == null) {
            CsvSourceType.$$$reportNull$$$0(2);
        }
        return new CsvSource((ThrowableComputable<InputStream, IOException>)((ThrowableComputable)() -> ImportUtil.getInputStream(this.myFile)), this.myFile.getCharset(), info2, this.myCharCount, this.myFile.getLength());
    }

    @Override
    @NotNull
    public List<ImportComponent<?, ?>> getComponents(@NotNull CheckedDisposable disposable, @NotNull Project project, @NotNull ImportSourceType sourceType, @Nullable List<? extends ColumnDescriptor> producers, @Nullable List<? extends GridRow> rows, @Nullable List<? extends ColumnDescriptor> visibleProducers, @NotNull String producerName, @Nullable String initialTargetTableName, boolean multipleSources) throws Exception {
        if (disposable == null) {
            CsvSourceType.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CsvSourceType.$$$reportNull$$$0(4);
        }
        if (sourceType == null) {
            CsvSourceType.$$$reportNull$$$0(5);
        }
        if (producerName == null) {
            CsvSourceType.$$$reportNull$$$0(6);
        }
        CsvPreviewModel model2 = new CsvPreviewModel(this.myFile);
        List<ImportComponent<?, ?>> list = Arrays.asList(new TargetSchemaComponent(project, multipleSources), new CsvPreviewComponent((Disposable)disposable, project, model2), new CsvFormatComponent(this.myFile, (Disposable)disposable), new CsvTableEditorComponent((Disposable)disposable, sourceType, producers, rows, visibleProducers, initialTargetTableName, producerName), new DdlPreviewComponent(), new CharsetComponent(model2), new ImportSettingsComponent(initialTargetTableName));
        if (list == null) {
            CsvSourceType.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    public DasDataSource getProducerSystem() {
        return null;
    }

    @Override
    @Nullable
    public FormatterCreator getFormatterCreator() {
        return null;
    }

    @Override
    @NotNull
    public String getDialogTitle() {
        String string = DatabaseBundle.message("import.0.file", this.myFile.getName());
        if (string == null) {
            CsvSourceType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getProducerName() {
        String string = this.myFile.getName();
        if (string == null) {
            CsvSourceType.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            CsvSourceType.$$$reportNull$$$0(10);
        }
        return dbms;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportEditorContext context, @NotNull DeModel deModel, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @Nullable List<? extends ColumnDescriptor> visibleProducers, @NotNull String tableName) {
        if (context == null) {
            CsvSourceType.$$$reportNull$$$0(11);
        }
        if (deModel == null) {
            CsvSourceType.$$$reportNull$$$0(12);
        }
        if (descriptors == null) {
            CsvSourceType.$$$reportNull$$$0(13);
        }
        if (tableName == null) {
            CsvSourceType.$$$reportNull$$$0(14);
        }
        DeTable deTable = ImportUtil.createTable(context, deModel, descriptors, rows, (Function<? super ImportUtil.ColumnTypePredictorInfo, String>)((Function)info2 -> ImportUtil.getPreferredTypeBasedOnContent(info2.column, info2.rows, info2.dbms, DbImplUtilCore.getDatabaseVersion(info2.dataSource))), visibleProducers, tableName);
        if (deTable == null) {
            CsvSourceType.$$$reportNull$$$0(15);
        }
        return deTable;
    }

    @Override
    @NotNull
    public BasicModTable createNewTable(@NotNull ImportEditorContext context, @NotNull BasicModModel model2, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @Nullable List<? extends ColumnDescriptor> visibleProducers, @NotNull String tableName) {
        if (context == null) {
            CsvSourceType.$$$reportNull$$$0(16);
        }
        if (model2 == null) {
            CsvSourceType.$$$reportNull$$$0(17);
        }
        if (descriptors == null) {
            CsvSourceType.$$$reportNull$$$0(18);
        }
        if (tableName == null) {
            CsvSourceType.$$$reportNull$$$0(19);
        }
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        BasicModTable table = ImportUtil.instantiateTable(context, model2);
        Objects.requireNonNull(table);
        table.setName(tableName);
        Version version = DbImplUtilCore.getDatabaseVersion(context.getDataSource());
        Dbms dbms = context.getDbms();
        ImportUtil.fillTableColumns(table, producers, (Function<? super Integer, String>)((Function)i2 -> ImportUtil.getPreferredTypeBasedOnContent((ColumnDescriptor)producers.get((int)i2), rows, dbms, version)));
        BasicModTable basicModTable = table;
        if (basicModTable == null) {
            CsvSourceType.$$$reportNull$$$0(20);
        }
        return basicModTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 8, 9, 10, 15, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/csv/CsvSourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerName";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deModel";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/csv/CsvSourceType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 15: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSource";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createNewTable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 8, 9, 10, 15, 20 -> new IllegalStateException(string);
        };
    }
}

