/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.CsvImportUtil;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportUtilCore {
    protected ImportUtilCore() {
    }

    @NotNull
    public static String pluralize(@NotNull String word, long count) {
        if (word == null) {
            ImportUtilCore.$$$reportNull$$$0(0);
        }
        String string = count == 1L ? word : StringUtil.pluralize((String)word);
        if (string == null) {
            ImportUtilCore.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull JdbcColumnDescriptor delegate, boolean autogenerated, boolean hasDefault, boolean computed) {
        if (delegate == null) {
            ImportUtilCore.$$$reportNull$$$0(2);
        }
        return new AutoValueDescriptor.DelegateDescriptor(delegate, autogenerated, hasDefault, computed);
    }

    @NotNull
    public static String pluralizeRows(long count) {
        return ImportUtilCore.pluralize("row", count);
    }

    @NotNull
    public static DeTable createDeTableFromDasObject(@NotNull DasModel dasModel, @NotNull BasicElement element2, @NotNull DeModel model2) {
        if (dasModel == null) {
            ImportUtilCore.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            ImportUtilCore.$$$reportNull$$$0(4);
        }
        if (model2 == null) {
            ImportUtilCore.$$$reportNull$$$0(5);
        }
        DeTable deTable = (DeTable)model2.getExportHelper().exportDeep(dasModel, element2, true);
        if (deTable == null) {
            ImportUtilCore.$$$reportNull$$$0(6);
        }
        return deTable;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull DeColumn column2, boolean mapped) {
        if (column2 == null) {
            ImportUtilCore.$$$reportNull$$$0(7);
        }
        return new MyDeColumnDescriptor(column2, mapped);
    }

    @Nullable
    public static Domain getConsumerDomain(@NotNull Dbms producerDbms, @NotNull Dbms consumerDbms, @Nullable Version consumerVersion, @Nullable Domain producerDomain) {
        if (producerDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(8);
        }
        if (consumerDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(9);
        }
        return producerDomain == null ? null : (consumerDbms != Dbms.UNKNOWN && producerDbms == consumerDbms && (consumerVersion == null || producerDomain.supportedIn(consumerVersion)) ? producerDomain : BaseDomainRegistry.getMostRecentDomain(producerDomain, consumerDbms, consumerVersion));
    }

    @NlsSafe
    @NotNull
    public static String getSqlTypeName(@Nullable Domain domain, @NotNull ColumnDescriptor column2, @Nullable List<? extends GridRow> rows, @NotNull Dbms producerDbms, @NotNull Dbms consumerDbms, @Nullable Version consumerVersion) {
        if (column2 == null) {
            ImportUtilCore.$$$reportNull$$$0(10);
        }
        if (producerDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(11);
        }
        if (consumerDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(12);
        }
        String typeName = column2.getTypeName();
        return domain != null ? domain.name() : (producerDbms == consumerDbms && typeName != null ? ExecutionEnvironmentHelper.EP.forDbms(producerDbms).jdbcTypeNameToSqlTypeName(typeName) : ImportUtilCore.getPreferredTypeBasedOnContent(column2, rows, consumerDbms, consumerVersion));
    }

    @NlsSafe
    @NotNull
    public static String getPreferredTypeBasedOnContent(@NotNull ColumnDescriptor column2, @Nullable List<? extends GridRow> rows, @NotNull Dbms dbms, @Nullable Version version) {
        if (column2 == null) {
            ImportUtilCore.$$$reportNull$$$0(13);
        }
        if (dbms == null) {
            ImportUtilCore.$$$reportNull$$$0(14);
        }
        ImportManager manager = ImportManager.of(dbms, version);
        if (rows == null || !(column2 instanceof GridColumn)) {
            String string = manager.getStringMerger().getName();
            if (string == null) {
                ImportUtilCore.$$$reportNull$$$0(15);
            }
            return string;
        }
        GridColumn gc = (GridColumn)column2;
        JBIterable values2 = JBIterable.from(rows).map(row -> gc.getValue(row)).map(o2 -> o2 == null ? null : o2.toString());
        String string = CsvImportUtil.getPreferredTypeMergerBasedOnContent((Iterable)values2, (TypeMerger)manager.getStringMerger(), (TypeMerger[])manager.getMergers()).getName();
        if (string == null) {
            ImportUtilCore.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static DasType convertTypeName(@NotNull Dbms fromDbms, @NotNull Version fromVersion, @NotNull Dbms toDbms, @NotNull Version toVersion, @NotNull DasType colType) {
        if (fromDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(17);
        }
        if (fromVersion == null) {
            ImportUtilCore.$$$reportNull$$$0(18);
        }
        if (toDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(19);
        }
        if (toVersion == null) {
            ImportUtilCore.$$$reportNull$$$0(20);
        }
        if (colType == null) {
            ImportUtilCore.$$$reportNull$$$0(21);
        }
        TypeNameColumnDescriptor descriptor2 = ImportUtilCore.asDescriptor("", colType);
        String name2 = ImportUtilCore.convertTypeName(fromDbms, fromVersion, toDbms, toVersion, descriptor2);
        if (Objects.equals(descriptor2.getTypeName(), name2)) {
            DasType dasType = DasUnresolvedTypeReference.of(colType.toDataType());
            if (dasType == null) {
                ImportUtilCore.$$$reportNull$$$0(22);
            }
            return dasType;
        }
        DasType dasType = DasUnresolvedTypeReference.of(name2);
        if (dasType == null) {
            ImportUtilCore.$$$reportNull$$$0(23);
        }
        return dasType;
    }

    public static String convertTypeName(@NotNull Dbms fromDbms, @NotNull Version fromVersion, @NotNull Dbms toDbms, @NotNull Version version, @NotNull ColumnDescriptor descriptor2) {
        if (fromDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(24);
        }
        if (fromVersion == null) {
            ImportUtilCore.$$$reportNull$$$0(25);
        }
        if (toDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(26);
        }
        if (version == null) {
            ImportUtilCore.$$$reportNull$$$0(27);
        }
        if (descriptor2 == null) {
            ImportUtilCore.$$$reportNull$$$0(28);
        }
        Domain domain = BaseDomainRegistry.getDomain(fromDbms, fromVersion, descriptor2, false);
        Domain d2 = ImportUtilCore.getConsumerDomain(fromDbms, toDbms, version, domain);
        if (domain != null && Objects.equals(domain, d2)) {
            return descriptor2.getTypeName();
        }
        return ImportUtilCore.getSqlTypeName(d2, descriptor2, null, fromDbms, toDbms, version);
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull BasicLikeColumn column2) {
        if (column2 == null) {
            ImportUtilCore.$$$reportNull$$$0(29);
        }
        DasType dasType = column2.getDasType();
        DataType dataType = dasType.toDataType();
        DataConsumer.Column desc = new DataConsumer.Column((int)column2.getPosition(), column2.getName(), JdbcUtil.guessJdbcTypeByName(DasTypeUtilsKt.getTypeName(dasType)), DasTypeUtilsKt.getTypeName(dasType), null, dataType.getPrecision(), dataType.getScale(), null, DasTypeUtilsKt.getSchemaName(dasType), null);
        if (column2 instanceof BasicTableColumn) {
            BasicTableColumn tc = (BasicTableColumn)column2;
            return new AutoValueDescriptor.DelegateDescriptor((JdbcColumnDescriptor)desc, tc.isAutoInc(), column2.getDefault() != null, tc.isComputed());
        }
        return new AutoValueDescriptor.DelegateDescriptor((JdbcColumnDescriptor)desc, false, column2.getDefault() != null, false);
    }

    @NotNull
    public static TypeNameColumnDescriptor asDescriptor(String name2, DasType dasType) {
        DataType type = dasType.toDataType();
        return new TypeNameColumnDescriptor(name2, DasTypeUtilsKt.getTypeName(dasType), type.getPrecision(), type.getScale());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 15, 16, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 1: 
            case 6: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportUtilCore";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerDbms";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumerDbms";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDbms";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromVersion";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDbms";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toVersion";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeTableFromDasObject";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredTypeBasedOnContent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 1: 
            case 6: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                break;
            }
            case 2: 
            case 7: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDeTableFromDasObject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConsumerDomain";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSqlTypeName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredTypeBasedOnContent";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "convertTypeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 15, 16, 22, 23 -> new IllegalStateException(string);
        };
    }

    static final class MyDeColumnDescriptor
    implements AutoValueDescriptor {
        private final DeColumn myColumn;
        private final boolean myMapped;

        private MyDeColumnDescriptor(@NotNull DeColumn column2, boolean mapped) {
            if (column2 == null) {
                MyDeColumnDescriptor.$$$reportNull$$$0(0);
            }
            this.myColumn = column2;
            this.myMapped = mapped;
        }

        public int getScale() {
            return this.myColumn.getDataType().getScale();
        }

        public int getSize() {
            return this.myColumn.getDataType().getPrecision();
        }

        public int getType() {
            return JdbcUtil.guessJdbcTypeByName(this.myColumn.dataType);
        }

        public String getName() {
            return this.myColumn.getName();
        }

        public String getTypeName() {
            return this.myColumn.dataType;
        }

        @Nullable
        public String getJavaClassName() {
            return null;
        }

        public boolean isAutogenerated() {
            return !this.myMapped && this.myColumn.flags.contains((Object)DeColumn.Flag.AUTO_INC);
        }

        public boolean isComputed() {
            return !this.myMapped && this.myColumn.isComputed();
        }

        public boolean hasDefault() {
            return !this.myMapped && this.myColumn.defaultValue != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtilCore$MyDeColumnDescriptor", "<init>"));
        }
    }
}

