/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.dbimport.ImportErrorHandlerImpl;
import com.intellij.database.dbimport.ImportHead;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportNotificationListenerFactory;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseTableEditorForm;
import com.intellij.database.view.editors.ImportTableNameForm;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportUtil
extends ImportUtilCore {
    private ImportUtil() {
    }

    @NotNull
    public static ImportHead createImportHead(@NotNull Project project, @NotNull ImportInfo info2, @NotNull ReaderTask.Source source) {
        if (project == null) {
            ImportUtil.$$$reportNull$$$0(0);
        }
        if (info2 == null) {
            ImportUtil.$$$reportNull$$$0(1);
        }
        if (source == null) {
            ImportUtil.$$$reportNull$$$0(2);
        }
        ImportErrorHandlerImpl importErrorHandler = new ImportErrorHandlerImpl(project, info2);
        ImportNotificationListenerFactoryImpl importNotificationListenerFactory = new ImportNotificationListenerFactoryImpl();
        return new ImportHead(project, info2, source, importErrorHandler, importNotificationListenerFactory);
    }

    @NotNull
    public static InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        VirtualFileSystem system;
        if (file == null) {
            ImportUtil.$$$reportNull$$$0(3);
        }
        InputStream stream = (system = file.getFileSystem()) instanceof JarFileSystem ? ImportUtil.getInputStreamForZip(file) : new FileInputStream(file.getPath());
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
        if (inputStream == null) {
            ImportUtil.$$$reportNull$$$0(4);
        }
        return inputStream;
    }

    @NotNull
    public static ImportDatabaseTableEditor<?> createEditor(@NotNull DeTable table, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull ImportEditorContext context, @NotNull Disposable disposable, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull DatabaseTableEditorForm form2, @Nullable ImportTableNameForm tableNameForm) {
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(5);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(7);
        }
        if (disposable == null) {
            ImportUtil.$$$reportNull$$$0(8);
        }
        if (caps == null) {
            ImportUtil.$$$reportNull$$$0(9);
        }
        if (form2 == null) {
            ImportUtil.$$$reportNull$$$0(10);
        }
        SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((Project)context.getProject(), (Language)context.getSqlDialect());
        TableEditorModel tableEditorModel = new TableEditorModel(table, new EditorModelsCache(settings));
        ImportEditorState<? extends ColumnDescriptor> state = new ImportEditorState<ColumnDescriptor>(context, descriptors);
        if (tableNameForm == null) {
            tableNameForm = new ImportTableNameForm(context, caps, tableEditorModel, disposable);
        } else {
            tableNameForm.update(context, caps, tableEditorModel);
        }
        ImportDatabaseTableEditor editor2 = new ImportDatabaseTableEditor(state, caps, tableEditorModel, form2, tableNameForm);
        Disposer.register((Disposable)disposable, editor2);
        ImportDatabaseTableEditor importDatabaseTableEditor = editor2;
        if (importDatabaseTableEditor == null) {
            ImportUtil.$$$reportNull$$$0(11);
        }
        return importDatabaseTableEditor;
    }

    @NotNull
    public static List<? extends GridRow> getRows(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(12);
        }
        List list = grid.getDataModel(DataAccessType.DATABASE_DATA).getRows();
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static DeTable createDeTableFromColumns(@NotNull DeModel model2, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull String name2) {
        if (model2 == null) {
            ImportUtil.$$$reportNull$$$0(14);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            ImportUtil.$$$reportNull$$$0(16);
        }
        DeTable table = new DeTable(name2, null, model2);
        table.columns.clear();
        for (ColumnDescriptor columnDescriptor : descriptors) {
            DeColumn column2 = new DeColumn(columnDescriptor.getName(), table, model2);
            column2.dataType = StringUtil.notNullize((String)columnDescriptor.getTypeName());
            table.columns.add(column2);
        }
        DeTable deTable = table;
        if (deTable == null) {
            ImportUtil.$$$reportNull$$$0(17);
        }
        return deTable;
    }

    public static void removeUnsupportedObjects(@NotNull DeTable table, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(18);
        }
        if (caps == null) {
            ImportUtil.$$$reportNull$$$0(19);
        }
        if (!caps.getComment().isSupported()) {
            table.comment = null;
        }
        if (!caps.getColumnCaps(false).getComment().isSupported()) {
            for (DeColumn column2 : table.columns) {
                column2.comment = null;
            }
        }
    }

    public static void removeUntransferableObjects(@NotNull DeTable table) {
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(20);
        }
        table.foreignKeys.clear();
        for (DeColumn column2 : table.columns) {
            column2.defaultValue = null;
            column2.flags.clear();
        }
        table.keys.clear();
        table.indices.clear();
    }

    @NotNull
    public static DeTable createTable(@NotNull ImportEditorContext context, @NotNull DeModel deModel, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @NotNull Function<? super ColumnTypePredictorInfo, String> columnTypePredictor, @Nullable List<? extends ColumnDescriptor> visibleProducers, @NotNull String tableName) {
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(21);
        }
        if (deModel == null) {
            ImportUtil.$$$reportNull$$$0(22);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(23);
        }
        if (columnTypePredictor == null) {
            ImportUtil.$$$reportNull$$$0(24);
        }
        if (tableName == null) {
            ImportUtil.$$$reportNull$$$0(25);
        }
        DeNamespace parent2 = ImportUtil.getSchema(context, deModel);
        DeTable table = new DeTable(tableName, parent2, deModel);
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        table.columns.addAll(ImportUtil.createDeColumns(context, producers, rows, table, deModel, columnTypePredictor));
        DeTable deTable = table;
        if (deTable == null) {
            ImportUtil.$$$reportNull$$$0(26);
        }
        return deTable;
    }

    @Nullable
    public static DeNamespace getSchema(@NotNull ImportEditorContext context, @NotNull DeModel deModel) {
        BasicSchema schema2;
        BasicModel dasModel;
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(27);
        }
        if (deModel == null) {
            ImportUtil.$$$reportNull$$$0(28);
        }
        if ((dasModel = context.getModel()) == null) {
            return null;
        }
        BasicNamespace namespace = ImportUtil.getContextNamespace(context);
        if (namespace == null) {
            return null;
        }
        DeNamespace parent2 = ImportUtil.getNamespace(deModel, dasModel, namespace);
        if (parent2 == null || parent2.getKind() == ObjectKind.SCHEMA) {
            return parent2;
        }
        assert (parent2.getKind() == ObjectKind.DATABASE) : "Unexpected " + parent2.getKind().code();
        BasicDatabase db = (BasicDatabase)ObjectUtils.tryCast((Object)parent2.unwrap(), BasicDatabase.class);
        BasicSchema basicSchema = schema2 = db == null ? null : ModelFun.getCurrentSchema(db);
        if (schema2 == null) {
            DeNamespace sc2 = new DeNamespace("", ObjectKind.SCHEMA, parent2.model);
            sc2.parent = parent2;
            parent2.addLightChild(sc2);
            parent2 = sc2;
        } else {
            parent2 = (DeNamespace)parent2.model.getExportHelper().exportDeep(schema2.getModel(), schema2, false);
        }
        return parent2;
    }

    @Nullable
    public static BasicNamespace getContextNamespace(@NotNull ImportEditorContext context) {
        BasicNamespace namespace;
        BasicModel model2;
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(29);
        }
        if ((model2 = context.getModel()) == null) {
            return null;
        }
        DbNamespace dbNamespace = context.getNamespace();
        BasicNamespace basicNamespace = namespace = dbNamespace == null ? null : (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(dbNamespace), BasicNamespace.class);
        if (namespace == null) {
            namespace = (BasicNamespace)ObjectUtils.tryCast((Object)model2.getCurrentRootNamespace(), BasicNamespace.class);
        }
        return namespace;
    }

    @Nullable
    public static DeNamespace getNamespace(@NotNull DeModel model2, @NotNull DasModel dasModel, @Nullable BasicNamespace namespace) {
        if (model2 == null) {
            ImportUtil.$$$reportNull$$$0(30);
        }
        if (dasModel == null) {
            ImportUtil.$$$reportNull$$$0(31);
        }
        return namespace == null ? null : (DeNamespace)model2.getExportHelper().exportDeep(dasModel, namespace, false);
    }

    @NotNull
    public static List<? extends GridColumn> getColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(32);
        }
        List columns2 = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns2), (Condition)Conditions.not(GridUtilCore::isRowId));
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public static List<? extends GridColumn> getVisibleColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(34);
        }
        ModelIndexSet indices = grid.getVisibleColumns();
        ArrayList columns2 = new ArrayList(grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns(indices));
        ContainerUtil.sort(columns2, Comparator.comparingInt(c2 -> c2.getColumnNumber()));
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns2), (Condition)Conditions.not(GridUtilCore::isRowId));
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public static String getSqlTypeName(@Nullable Domain domain, @NotNull ColumnDescriptor column2, @Nullable List<? extends GridRow> rows, @NotNull Dbms dbms, @Nullable Version version) {
        if (column2 == null) {
            ImportUtil.$$$reportNull$$$0(36);
        }
        if (dbms == null) {
            ImportUtil.$$$reportNull$$$0(37);
        }
        String string = ImportUtil.getSqlTypeName(domain, column2, rows, dbms, dbms, version);
        if (string == null) {
            ImportUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private static List<? extends GridColumn> unambiguous(@NotNull DataGrid grid, @NotNull List<? extends GridColumn> columns2) {
        DatabaseGridDataHookUp hookUp;
        SqlTableType type;
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(39);
        }
        if (columns2 == null) {
            ImportUtil.$$$reportNull$$$0(40);
        }
        SqlTableType sqlTableType = type = (hookUp = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)grid)) == null ? null : hookUp.getTableType();
        if (type == null) {
            List<? extends GridColumn> list = columns2;
            if (list == null) {
                ImportUtil.$$$reportNull$$$0(41);
            }
            return list;
        }
        List<String> names2 = DbSqlUtil.getUnambiguousColumnNames(grid.getProject(), DataGridUtil.getDatabaseDialect(grid), type, null);
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (GridColumn gridColumn : columns2) {
            if (gridColumn.getColumnNumber() >= names2.size()) {
                result2.add(gridColumn);
                continue;
            }
            JdbcGridColumn c2 = (JdbcGridColumn)ObjectUtils.tryCast((Object)gridColumn, JdbcGridColumn.class);
            result2.add(new DataConsumer.Column(gridColumn.getColumnNumber(), names2.get(gridColumn.getColumnNumber()), gridColumn.getType(), gridColumn.getTypeName(), c2 == null ? null : c2.getJavaClassName(), c2 == null ? -1 : c2.getSize(), c2 == null ? -1 : c2.getScale(), c2 == null ? null : c2.getCatalog(), c2 == null ? null : c2.getSchema(), c2 == null ? null : c2.getTable(), c2 == null ? Collections.emptySet() : c2.getAttributes()));
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            ImportUtil.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    @NotNull
    private static List<DeColumn> createDeColumns(@NotNull ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @NotNull DeTable table, @NotNull DeModel model2, @NotNull Function<? super ColumnTypePredictorInfo, String> columnTypePredictor) {
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(43);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(44);
        }
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(45);
        }
        if (model2 == null) {
            ImportUtil.$$$reportNull$$$0(46);
        }
        if (columnTypePredictor == null) {
            ImportUtil.$$$reportNull$$$0(47);
        }
        ArrayList<DeColumn> result2 = new ArrayList<DeColumn>();
        for (ColumnDescriptor columnDescriptor : descriptors) {
            DeColumn deColumn = new DeColumn(columnDescriptor.getName(), table, model2);
            deColumn.dataType = (String)columnTypePredictor.fun((Object)new ColumnTypePredictorInfo(context.getDbms(), context.getDataSource(), columnDescriptor, rows));
            result2.add(deColumn);
        }
        ArrayList<DeColumn> arrayList = result2;
        if (arrayList == null) {
            ImportUtil.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    @NotNull
    private static InputStream getInputStreamForZip(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ImportUtil.$$$reportNull$$$0(49);
        }
        JarFileSystem instance = JarFileSystem.getInstance();
        VirtualFile jar = instance.getVirtualFileForJar(file);
        VirtualFile root2 = instance.getJarRootForLocalFile(Objects.requireNonNull(jar));
        ZipFile zipFile = new ZipFile(Objects.requireNonNull(jar).getPath());
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)Objects.requireNonNull(root2));
        ZipEntry entry = zipFile.getEntry(Objects.requireNonNull(relativePath));
        return new MyDelegateInputStream(zipFile.getInputStream(entry), zipFile);
    }

    public static boolean canBeProducer(@Nullable DbElement element2) {
        return element2 != null && DbImplUtilCore.canConnectTo(element2) && DbImplUtilCore.isDataTable(element2.getKind());
    }

    public static boolean canBeConsumer(@Nullable DbElement element2) {
        return ImportUtil.canBeConsumerFast(element2) && ImportUtil.canConnectToAndModify(element2) && !DbImplUtilCore.getDbms(element2).isDocumentOriented();
    }

    public static boolean canBeConsumerFast(@Nullable DasObject element2) {
        return element2 != null && (!(element2 instanceof DasNamespace) && !(element2 instanceof DbDataSource) || DbImplUtilCore.getTopSingleNamespace(element2) != null) && ImportType.of(element2) != null;
    }

    public static boolean canModify(@Nullable DbElement element2) {
        return element2 != null && element2.isWritable() && !DataImporter.isBusy(element2);
    }

    public static boolean canConnectToAndModify(@Nullable DbElement element2) {
        return element2 != null && element2.isWritable() && DbImplUtilCore.canConnectTo(element2) && !DataImporter.isBusy(element2);
    }

    @Nullable
    public static BasicModTable instantiateTable(@NotNull ImportEditorContext context, BasicModModel model2) {
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(50);
        }
        BasicMetaObject metaTable = (BasicMetaObject)((BasicMetaModel)model2.getMetaModel()).findMetaObjects(ObjectKind.TABLE).filterMap(m -> m.tryCast(BasicModTable.class)).first();
        Objects.requireNonNull(metaTable);
        BasicNamespace namespace = ImportUtil.getContextNamespace(context);
        Map parents2 = JBIterable.generate((Object)namespace, BasicMixinElement::getParent).toReverseMap(BasicObjectNode::getMetaObject);
        return (BasicModTable)ImportUtil.instantiate(model2.getRoot(), metaTable, parents2);
    }

    public static void fillTableColumns(@NotNull BasicModTable res2, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull Function<? super Integer, String> typeGetter) {
        if (res2 == null) {
            ImportUtil.$$$reportNull$$$0(51);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(52);
        }
        if (typeGetter == null) {
            ImportUtil.$$$reportNull$$$0(53);
        }
        for (int i2 = 0; i2 < descriptors.size(); ++i2) {
            ColumnDescriptor descriptor2 = descriptors.get(i2);
            BasicModTableOrViewColumn column2 = (BasicModTableOrViewColumn)res2.getColumns().renewAt((short)(i2 + 1), descriptor2.getName());
            String typeName = (String)typeGetter.fun((Object)i2);
            column2.setDasType(typeName == null ? DasTypeSystemBase.UNKNOWN : DasUnresolvedTypeReference.of(DataTypeFactory.of(typeName)));
        }
    }

    @Nullable
    public static <T extends BasicModElement> T instantiate(@NotNull BasicRoot r, @NotNull BasicMetaObject<T> meta, @NotNull Map<? extends BasicMetaObject<?>, BasicElement> parents2) {
        BasicModElement parent2;
        ModFamily family;
        BasicMetaObject<BasicModElement> parentMeta;
        if (r == null) {
            ImportUtil.$$$reportNull$$$0(54);
        }
        if (meta == null) {
            ImportUtil.$$$reportNull$$$0(55);
        }
        if (parents2 == null) {
            ImportUtil.$$$reportNull$$$0(56);
        }
        BasicMetaObject<BasicModElement> basicMetaObject = parentMeta = meta.getParent() == null ? null : meta.getParent().tryCast(BasicModElement.class);
        BasicModElement res2 = meta == r.getMetaObject() || parentMeta == null ? (BasicModElement)meta.tryCast(r) : ((family = (ModFamily)BasicMetaUtils.getFamily(parent2 = ImportUtil.instantiate(r, parentMeta, parents2), meta)) == null ? null : family.createNewOne());
        BasicElement example = parents2.get(meta);
        if (res2 == null || example == null) {
            return (T)res2;
        }
        ModelLightCopier.copyProperties(example, res2, false, true);
        return (T)res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 13, 17, 26, 33, 35, 38, 41, 42, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 17: 
            case 26: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportUtil";
                break;
            }
            case 5: 
            case 18: 
            case 20: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: 
            case 15: 
            case 23: 
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 7: 
            case 21: 
            case 27: 
            case 29: 
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "form";
                break;
            }
            case 12: 
            case 32: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 14: 
            case 30: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deModel";
                break;
            }
            case 24: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnTypePredictor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasModel";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeGetter";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeTableFromColumns";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTypeName";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "unambiguous";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createImportHead";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 17: 
            case 26: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 48: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDeTableFromColumns";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeUnsupportedObjects";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeUntransferableObjects";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSchema";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContextNamespace";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleColumns";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSqlTypeName";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "unambiguous";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createDeColumns";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getInputStreamForZip";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "instantiateTable";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fillTableColumns";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 13, 17, 26, 33, 35, 38, 41, 42, 48 -> new IllegalStateException(string);
        };
    }

    private static class ImportNotificationListenerFactoryImpl
    implements ImportNotificationListenerFactory {
        private ImportNotificationListenerFactoryImpl() {
        }

        @Override
        @NotNull
        public NotificationListener createNotificationListener(@NotNull Project project, DbDataSource system, String path, @NotNull ObjectPath tablePath) {
            if (project == null) {
                ImportNotificationListenerFactoryImpl.$$$reportNull$$$0(0);
            }
            if (tablePath == null) {
                ImportNotificationListenerFactoryImpl.$$$reportNull$$$0(1);
            }
            GridUtil.FileNotificationListener fileNotificationListener = path == null ? null : new GridUtil.FileNotificationListener(project, path);
            OpenTableNotificationListener openTableNotificationListener = new OpenTableNotificationListener(system, tablePath);
            NotificationListener notificationListener = (notification, event) -> {
                if (fileNotificationListener != null) {
                    fileNotificationListener.hyperlinkUpdate(notification, event);
                }
                openTableNotificationListener.hyperlinkUpdate(notification, event);
            };
            if (notificationListener == null) {
                ImportNotificationListenerFactoryImpl.$$$reportNull$$$0(2);
            }
            return notificationListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tablePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportUtil$ImportNotificationListenerFactoryImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportUtil$ImportNotificationListenerFactoryImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNotificationListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNotificationListener";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class ColumnTypePredictorInfo {
        public final Dbms dbms;
        public final DbDataSource dataSource;
        public final ColumnDescriptor column;
        public final List<? extends GridRow> rows;

        public ColumnTypePredictorInfo(@NotNull Dbms dbms, @Nullable DbDataSource dataSource2, @NotNull ColumnDescriptor column2, @Nullable List<? extends GridRow> rows) {
            if (dbms == null) {
                ColumnTypePredictorInfo.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                ColumnTypePredictorInfo.$$$reportNull$$$0(1);
            }
            this.dbms = dbms;
            this.dataSource = dataSource2;
            this.column = column2;
            this.rows = rows;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/ImportUtil$ColumnTypePredictorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyDelegateInputStream
    extends InputStream {
        private final InputStream myStream;
        private final Closeable myCloseable;

        private MyDelegateInputStream(@NotNull InputStream stream, @NotNull Closeable closeable) {
            if (stream == null) {
                MyDelegateInputStream.$$$reportNull$$$0(0);
            }
            if (closeable == null) {
                MyDelegateInputStream.$$$reportNull$$$0(1);
            }
            this.myStream = stream;
            this.myCloseable = closeable;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(byte @NotNull [] b2, int off, int len) throws IOException {
            if (b2 == null) {
                MyDelegateInputStream.$$$reportNull$$$0(2);
            }
            return this.myStream.read(b2, off, len);
        }

        @Override
        public int read(byte @NotNull [] b2) throws IOException {
            if (b2 == null) {
                MyDelegateInputStream.$$$reportNull$$$0(3);
            }
            return this.myStream.read(b2);
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
            this.myCloseable.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OpenTableNotificationListener
    implements NotificationListener {
        private final DbDataSource mySystem;
        private final ObjectPath myTablePath;

        OpenTableNotificationListener(@Nullable DbDataSource system, @NotNull ObjectPath tablePath) {
            if (tablePath == null) {
                OpenTableNotificationListener.$$$reportNull$$$0(0);
            }
            this.mySystem = system;
            this.myTablePath = tablePath;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            DbElement dbTable;
            if (notification == null) {
                OpenTableNotificationListener.$$$reportNull$$$0(1);
            }
            if (event == null) {
                OpenTableNotificationListener.$$$reportNull$$$0(2);
            }
            if (!"open_table".equals(event.getDescription())) {
                return;
            }
            DbElement dbElement = dbTable = this.mySystem == null ? null : DbSqlUtilCore.findElement(this.mySystem, this.myTablePath);
            if (dbTable != null) {
                DbNavigationUtils.navigateToData(dbTable, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tablePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ImportUtil$OpenTableNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

