/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportNotificationListenerFactory;
import com.intellij.database.dbimport.ImportTarget;
import com.intellij.database.dbimport.ImporterGenerator;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.ErrorHandler;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.messages.Topic;
import java.util.Objects;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportHead {
    public static final Topic<Listener> TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.NONE);
    public static final String OPEN_TABLE_DESC = "open_table";
    private static final Logger LOG = Logger.getInstance(ImportHead.class);
    private final ImportInfo myInfo;
    private final Project myProject;
    private final ReaderTask.Source mySource;
    private final ImportErrorHandler myHandler;
    @NotNull
    private final ImportNotificationListenerFactory myNotificationListenerFactory;

    public ImportHead(@NotNull Project project, @NotNull ImportInfo info2, @NotNull ReaderTask.Source source, @NotNull ImportErrorHandler importErrorHandler, @NotNull ImportNotificationListenerFactory notificationListenerFactory) {
        if (project == null) {
            ImportHead.$$$reportNull$$$0(0);
        }
        if (info2 == null) {
            ImportHead.$$$reportNull$$$0(1);
        }
        if (source == null) {
            ImportHead.$$$reportNull$$$0(2);
        }
        if (importErrorHandler == null) {
            ImportHead.$$$reportNull$$$0(3);
        }
        if (notificationListenerFactory == null) {
            ImportHead.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.mySource = source;
        this.myHandler = importErrorHandler;
        this.myInfo = info2;
        this.myNotificationListenerFactory = notificationListenerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(@NotNull ProgressIndicator indicator, @NotNull ImportTarget target2, @NotNull ErrorHandler errorHandler) throws Exception {
        Long timeSpent;
        if (indicator == null) {
            ImportHead.$$$reportNull$$$0(5);
        }
        if (target2 == null) {
            ImportHead.$$$reportNull$$$0(6);
        }
        if (errorHandler == null) {
            ImportHead.$$$reportNull$$$0(7);
        }
        indicator.setIndeterminate(false);
        DoubleAdder accumulator = new DoubleAdder();
        this.mySource.calculateSize((Consumer<Double>)((Consumer)accumulator::add));
        Long timeBefore = null;
        boolean error2 = false;
        Listener publisher = (Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        ImporterGenerator generator = target2.combine(this.mySource).createGenerator(this.myInfo, this.myHandler, this.mySource);
        ImportIndicatorUpdater updater = this.mySource.getIndicatorUpdater(indicator, accumulator, this.myInfo);
        try {
            ReaderTask.Importer importer;
            publisher.started(this.myProject, this.myInfo, this.mySource);
            target2.beforeImportStart(this.myInfo);
            generator.start();
            updater.start();
            timeBefore = System.currentTimeMillis();
            while ((importer = generator.generate()) != null) {
                importer.insert(this.myInfo, target2, updater, this.myHandler);
            }
            publisher.finished(this.myProject, this.myInfo, this.mySource, updater);
            timeSpent = timeBefore == null ? null : Long.valueOf(System.currentTimeMillis() - timeBefore);
        }
        catch (Throwable e2) {
            Long timeSpent2;
            boolean bl;
            try {
                publisher.failed(this.myProject, this.myInfo, this.mySource, updater, e2);
                if (e2 instanceof ProcessCanceledException) {
                    throw e2;
                }
                LOG.warn(e2);
                if (e2.getCause() != null) {
                    LOG.warn(e2.getCause());
                }
                errorHandler.addError(e2.getMessage(), e2);
                error2 = true;
                bl = false;
                timeSpent2 = timeBefore == null ? null : Long.valueOf(System.currentTimeMillis() - timeBefore);
            }
            catch (Throwable throwable) {
                Long timeSpent3 = timeBefore == null ? null : Long.valueOf(System.currentTimeMillis() - timeBefore);
                generator.stop();
                target2.afterImportEnd(this.myInfo);
                Long imported = target2.getInsertedRows();
                long errors = this.myHandler.getErrorsCount();
                Exception inputError = generator.getError();
                this.createNotification(this.myProject, timeSpent3, updater, imported, errors, error2 || inputError != null).notify(this.myProject);
                if (inputError != null) {
                    LOG.warn((Throwable)inputError);
                    DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message("notification.content.import.failed", new Object[0]), inputError.getMessage(), NotificationType.ERROR).setDisplayId("ImportHead.import.failed").notify(this.myProject);
                }
                throw throwable;
            }
            generator.stop();
            target2.afterImportEnd(this.myInfo);
            Long imported = target2.getInsertedRows();
            long errors = this.myHandler.getErrorsCount();
            Exception inputError = generator.getError();
            this.createNotification(this.myProject, timeSpent2, updater, imported, errors, error2 || inputError != null).notify(this.myProject);
            if (inputError != null) {
                LOG.warn((Throwable)inputError);
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message("notification.content.import.failed", new Object[0]), inputError.getMessage(), NotificationType.ERROR).setDisplayId("ImportHead.import.failed").notify(this.myProject);
            }
            return bl;
        }
        generator.stop();
        target2.afterImportEnd(this.myInfo);
        Long imported = target2.getInsertedRows();
        long errors = this.myHandler.getErrorsCount();
        Exception inputError = generator.getError();
        this.createNotification(this.myProject, timeSpent, updater, imported, errors, error2 || inputError != null).notify(this.myProject);
        if (inputError != null) {
            LOG.warn((Throwable)inputError);
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message("notification.content.import.failed", new Object[0]), inputError.getMessage(), NotificationType.ERROR).setDisplayId("ImportHead.import.failed").notify(this.myProject);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Notification createNotification(@NotNull Project project, @Nullable Long timeSpent, @NotNull ImportIndicatorUpdater updater, @Nullable Long importedCount, long errorsCount, boolean bl) {
        void error2;
        if (project == null) {
            ImportHead.$$$reportNull$$$0(8);
        }
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(9);
        }
        DbDataSource system = this.myInfo.getContext().getDataSource();
        String path = this.myInfo.getErrorTaskInfo().getErrorRecordsPath();
        String content = ImportHead.getContent(this.myInfo, timeSpent, path, updater, importedCount, errorsCount);
        NotificationType type = errorsCount > 0L || error2 != false ? NotificationType.ERROR : NotificationType.INFORMATION;
        NotificationListener notificationListener = this.myNotificationListenerFactory.createNotificationListener(project, system, path, this.myInfo.getTablePath());
        Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(Objects.requireNonNull(system).getName(), content, type).setDisplayId("ImportHead.import.finished").setListener(notificationListener);
        if (notification == null) {
            ImportHead.$$$reportNull$$$0(10);
        }
        return notification;
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String getContent(@NotNull ImportInfo info2, @Nullable Long timeSpent, @Nullable String path, @NotNull ImportIndicatorUpdater updater, @Nullable Long importedCount, long errorsCount) {
        if (info2 == null) {
            ImportHead.$$$reportNull$$$0(11);
        }
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(12);
        }
        String string = ImportHead.getTitle(info2) + ImportHead.getInsertedCount(importedCount) + ImportHead.getStatistics(timeSpent, updater) + ImportHead.getErrorsCountAndPath(path, errorsCount);
        if (string == null) {
            ImportHead.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String getTitle(@NotNull ImportInfo info2) {
        if (info2 == null) {
            ImportHead.$$$reportNull$$$0(14);
        }
        String string = DatabaseBundle.message("database.data.import.imported.to", info2.getProducerName(), info2.getTableName());
        if (string == null) {
            ImportHead.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String getStatistics(@Nullable Long timeSpent, @NotNull ImportIndicatorUpdater updater) {
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(16);
        }
        String time = ImportHead.getTimeSpent(timeSpent);
        String speed = ImportHead.getSpeed(timeSpent, updater);
        boolean isTimeEmpty = StringUtil.isEmpty((String)time);
        boolean isSpeedEmpty = StringUtil.isEmpty((String)speed);
        String string = isTimeEmpty && isSpeedEmpty ? "" : (isTimeEmpty || isSpeedEmpty ? String.format(" (%s)", isTimeEmpty ? speed : time) : String.format(" (%s, %s)", time, speed));
        if (string == null) {
            ImportHead.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String getInsertedCount(@Nullable Long importedCount) {
        String string = importedCount == null ? "" : DatabaseBundle.message("notification.content.choice.row.rows", importedCount, importedCount == 1L ? 0 : 1);
        if (string == null) {
            ImportHead.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String getErrorsCountAndPath(@Nullable String path, long errorsCount) {
        return errorsCount > 0L ? DatabaseBundle.message("notification.content.choice.error.errors.choice.occurred.saved.to", errorsCount, errorsCount == 1L ? 0 : 1, path == null ? 0 : 1) + (String)(path == null ? "" : " " + GridUtilCore.wrapInOpenFileLink((String)path)) : "";
    }

    @NotNull
    private static String getTimeSpent(@Nullable Long timeSpent) {
        String string = timeSpent == null ? "" : NlsMessages.formatDuration((long)timeSpent);
        if (string == null) {
            ImportHead.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String getSpeed(@Nullable Long timeSpent, @NotNull ImportIndicatorUpdater updater) {
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(20);
        }
        if (timeSpent == null || timeSpent / 1000L == 0L) {
            return "";
        }
        String string = StringUtil.notNullize((String)updater.calculateSpeed(timeSpent / 1000L));
        if (string == null) {
            ImportHead.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13, 15, 17, 18, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importErrorHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationListenerFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportHead";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportHead";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatistics";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertedCount";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeSpent";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpeed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStatistics";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSpeed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13, 15, 17, 18, 19, 21 -> new IllegalStateException(string);
        };
    }

    public static interface Listener {
        public void started(@NotNull Project var1, @NotNull ImportInfo var2, @NotNull ReaderTask.Source var3);

        public void finished(@NotNull Project var1, @NotNull ImportInfo var2, @NotNull ReaderTask.Source var3, @NotNull ImportIndicatorUpdater var4);

        public void failed(@NotNull Project var1, @NotNull ImportInfo var2, @NotNull ReaderTask.Source var3, @NotNull ImportIndicatorUpdater var4, @NotNull Throwable var5);
    }
}

