/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationProducer;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.editor.DbImportAction;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbElementDnDTarget<E extends DbElement>
implements DnDTarget {
    private final E myElement;

    public DbElementDnDTarget(@NotNull E element2) {
        if (element2 == null) {
            DbElementDnDTarget.$$$reportNull$$$0(0);
        }
        this.myElement = element2;
    }

    public void drop(DnDEvent event) {
        if (this.dropDbElement(event)) {
            return;
        }
        if (this.dropSqlFiles(event)) {
            return;
        }
        this.dropFile(event);
    }

    public boolean equals(Object obj2) {
        return this.getClass() == obj2.getClass() && Objects.equals(this.myElement, ((DbElementDnDTarget)obj2).myElement);
    }

    public int hashCode() {
        return Objects.hash(this.myElement);
    }

    @NotNull
    protected final E getElement() {
        E e2 = this.myElement;
        if (e2 == null) {
            DbElementDnDTarget.$$$reportNull$$$0(1);
        }
        return e2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myElement.getProject();
        if (project == null) {
            DbElementDnDTarget.$$$reportNull$$$0(2);
        }
        return project;
    }

    private boolean dropDbElement(@NotNull DnDEvent event) {
        JBIterable<DbElement> elements2;
        if (event == null) {
            DbElementDnDTarget.$$$reportNull$$$0(3);
        }
        if ((elements2 = DbElementDnDTarget.getProducers(event)).isEmpty()) {
            return false;
        }
        List<Pair<ImportAction.SourceType, ImportInfo.Builder>> sources = ImportAction.CopyTable.getSources(elements2);
        if (sources.isEmpty()) {
            return true;
        }
        DbImportAction.showDialog(this.myElement.getProject(), sources, this.myElement, this.myElement.getDbms(), DbImportDialog.InvocationType.DND_DATABASE_ON_DATABASE);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.copy.table");
        return true;
    }

    private boolean dropSqlFiles(DnDEvent event) {
        String description = DatabaseScriptRunConfigurationType.Companion.getInstance().getConfigurationTypeDescription();
        DataContext dataContext = this.createDataContext(event);
        return (Boolean)ActionUtil.underModalProgress((Project)this.getProject(), (String)DatabaseBundle.message("progress.title.creating", description), () -> DbElementDnDTarget.dropSqlFilesSlow(dataContext));
    }

    private static boolean dropSqlFilesSlow(DataContext dataContext) {
        ConfigurationContext configurationContext = DbElementDnDTarget.createConfigurationContext(dataContext);
        DatabaseScriptRunConfigurationProducer producer = DbElementDnDTarget.getConfigurationProducer();
        if (!producer.canCreate(configurationContext)) {
            return false;
        }
        ConfigurationFromContext configuration = producer.findOrCreateConfigurationFromContext(configurationContext);
        if (configuration == null) {
            return false;
        }
        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration.getConfigurationSettings(), (Executor)DefaultRunExecutor.getRunExecutorInstance());
        return true;
    }

    @NotNull
    private static DatabaseScriptRunConfigurationProducer getConfigurationProducer() {
        DatabaseScriptRunConfigurationProducer databaseScriptRunConfigurationProducer = (DatabaseScriptRunConfigurationProducer)RunConfigurationProducer.getInstance(DatabaseScriptRunConfigurationProducer.class);
        if (databaseScriptRunConfigurationProducer == null) {
            DbElementDnDTarget.$$$reportNull$$$0(4);
        }
        return databaseScriptRunConfigurationProducer;
    }

    @NotNull
    private ConfigurationContext createContext(DnDEvent event) {
        DataContext dataContext = this.createDataContext(event);
        return DbElementDnDTarget.createConfigurationContext(dataContext);
    }

    @NotNull
    private static ConfigurationContext createConfigurationContext(DataContext dataContext) {
        ConfigurationContext configurationContext = ConfigurationContext.getFromContext((DataContext)dataContext, (String)"DatabaseViewPopup");
        if (configurationContext == null) {
            DbElementDnDTarget.$$$reportNull$$$0(5);
        }
        return configurationContext;
    }

    @NotNull
    private DataContext createDataContext(DnDEvent event) {
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)this.getProject()).add(CommonDataKeys.PSI_ELEMENT, this.getElement()).add(CommonDataKeys.VIRTUAL_FILE_ARRAY, (Object)FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)event.getAttachedObject()).toArray(VirtualFile.EMPTY_ARRAY)).build();
        if (dataContext == null) {
            DbElementDnDTarget.$$$reportNull$$$0(6);
        }
        return dataContext;
    }

    private void dropFile(DnDEvent event) {
        List objects2 = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)event.getAttachedObject());
        List files2 = ContainerUtil.filter((Collection)objects2, file -> !Objects.requireNonNull(file).isDirectory());
        if (files2.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                DbImportAction.showDialog(this.myElement.getProject(), this.myElement, files2, DbImportDialog.InvocationType.DND_FILE_ON_DATABASE);
                FeatureUsageTracker.getInstance().triggerFeatureUsed("db.table.editor.wrapper");
            }
            catch (Throwable th) {
                Logger.getInstance(this.getClass()).error(th);
            }
        });
    }

    public boolean update(DnDEvent event) {
        return this.canRunImport(event) || this.canRunScript(event);
    }

    protected boolean canRunImport(DnDEvent event) {
        return ImportUtil.canBeConsumer(this.myElement) && (DbElementDnDTarget.updateDbElements(event, this.myElement) || this.updateFiles(event));
    }

    protected boolean canRunScript(DnDEvent event) {
        return DbElementDnDTarget.getConfigurationProducer().canCreate(this.getProject(), FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)event.getAttachedObject()), List.of(this.getElement()));
    }

    @NotNull
    private static JBIterable<DbElement> getProducers(@NotNull DnDEvent event) {
        if (event == null) {
            DbElementDnDTarget.$$$reportNull$$$0(7);
        }
        JBIterable<DbElement> jBIterable = ImportAction.CopyTable.getProducers((Iterable<DbElement>)JBIterable.of((Object[])DbElementDnDTarget.getObjects(event)).filter(DbElement.class));
        if (jBIterable == null) {
            DbElementDnDTarget.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    protected static Object @Nullable [] getObjects(@NotNull DnDEvent event) {
        if (event == null) {
            DbElementDnDTarget.$$$reportNull$$$0(9);
        }
        try {
            Object object = event.getTransferData(DnDEventImpl.ourDataFlavor);
            return (Object[])ObjectUtils.tryCast((Object)object, Object[].class);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    protected static boolean updateDbElements(DnDEvent event, DbElement consumer2) {
        JBIterable<DbElement> producers = DbElementDnDTarget.getProducers(event);
        return producers.isNotEmpty() && producers.single() != consumer2;
    }

    protected boolean updateFiles(DnDEvent event) {
        List files2 = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)event.getAttachedObject());
        return ContainerUtil.find((Iterable)files2, file -> !Objects.requireNonNull(file).isDirectory()) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/DbElementDnDTarget";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/DbElementDnDTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationProducer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dropDbElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProducers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getObjects";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }

    public static class ExpandHelper {
        private final JTree myTree;
        private final SingleAlarm myAlarm;
        private TreePath myCurrent;

        public ExpandHelper(@NotNull JTree tree, @NotNull Disposable parentDisposable) {
            if (tree == null) {
                ExpandHelper.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                ExpandHelper.$$$reportNull$$$0(1);
            }
            this.myTree = tree;
            this.myAlarm = new SingleAlarm(this::expand, 500, parentDisposable, Alarm.ThreadToUse.SWING_THREAD);
        }

        public void update(@NotNull DnDEvent event) {
            if (event == null) {
                ExpandHelper.$$$reportNull$$$0(2);
            }
            Point pt = event.getPointOn((Component)this.myTree);
            TreePath path = this.myTree.getPathForLocation(pt.x, pt.y);
            if (Objects.equals(path, this.myCurrent)) {
                return;
            }
            this.myAlarm.cancel();
            this.myCurrent = path;
            if (this.isExpandable(path)) {
                this.myAlarm.request();
            }
        }

        private boolean isExpandable(@Nullable TreePath path) {
            return path != null && !this.myTree.isExpanded(path) && !this.myTree.getModel().isLeaf(path.getLastPathComponent());
        }

        public void notHandled(@NotNull DnDEvent event) {
            TreePath path;
            if (event == null) {
                ExpandHelper.$$$reportNull$$$0(3);
            }
            if (!this.isExpandable(path = this.myCurrent)) {
                return;
            }
            event.setDropPossible(true);
            Rectangle bounds = this.myTree.getPathBounds(path);
            if (bounds != null) {
                event.setHighlighting(new RelativeRectangle((Component)this.myTree, bounds), 64);
            }
        }

        public void leave() {
            this.myAlarm.cancel();
            this.myCurrent = null;
        }

        private void expand() {
            TreePath path = this.myCurrent;
            if (path == null) {
                return;
            }
            this.myCurrent = null;
            this.myTree.expandPath(path);
            ((DnDManagerImpl)DnDManager.getInstance()).updateCurrentEvent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/DbElementDnDTarget$ExpandHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notHandled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FamilyGroupDnDTarget
    extends NamespaceDnDTarget {
        private final ObjectKind myKind;

        public FamilyGroupDnDTarget(@NotNull DbNamespaceImpl namespace, @NotNull ObjectKind kind) {
            if (namespace == null) {
                FamilyGroupDnDTarget.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                FamilyGroupDnDTarget.$$$reportNull$$$0(1);
            }
            super(namespace);
            this.myKind = kind;
        }

        @Override
        protected boolean canRunImport(DnDEvent event) {
            return super.canRunImport(event) && this.myKind == ObjectKind.TABLE;
        }

        @Override
        public boolean equals(Object obj2) {
            if (!(obj2 instanceof FamilyGroupDnDTarget)) {
                return false;
            }
            FamilyGroupDnDTarget anotherTarget = (FamilyGroupDnDTarget)obj2;
            return Objects.equals(this.myKind, anotherTarget.myKind) && Objects.equals(this.getElement(), anotherTarget.getElement());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.myKind, this.getElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/DbElementDnDTarget$FamilyGroupDnDTarget";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NamespaceDnDTarget
    extends DbElementDnDTarget<DbNamespace> {
        public NamespaceDnDTarget(@NotNull DbNamespace namespace) {
            if (namespace == null) {
                NamespaceDnDTarget.$$$reportNull$$$0(0);
            }
            super(namespace);
        }

        @Override
        protected boolean canRunImport(DnDEvent event) {
            return super.canRunImport(event) && ((DbNamespace)this.getElement()).getKind() == ObjectKind.SCHEMA;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/dbimport/DbElementDnDTarget$NamespaceDnDTarget", "<init>"));
        }
    }

    public static class DataSourceDnDTarget
    extends DbElementDnDTarget<DbDataSource> {
        public DataSourceDnDTarget(@NotNull DbDataSource dataSource2) {
            if (dataSource2 == null) {
                DataSourceDnDTarget.$$$reportNull$$$0(0);
            }
            super(dataSource2);
        }

        @Override
        public void drop(DnDEvent event) {
            List<DbDataSource> dataSources2 = DataSourceDnDTarget.getDataSources(event);
            if (dataSources2.isEmpty()) {
                super.drop(event);
                return;
            }
            dataSources2.add((DbDataSource)this.getElement());
            Project project = this.getProject();
            DatabaseViewActions.MoveToGroup.askForGroupName(project, null, (Consumer<String>)((Consumer)name2 -> {
                if (!StringUtil.isEmptyOrSpaces((String)name2)) {
                    DatabaseViewActions.MoveToGroup.assignGroup(project, name2, dataSources2);
                }
            }));
        }

        @Override
        protected boolean canRunImport(DnDEvent event) {
            List<DbDataSource> dataSources2 = DataSourceDnDTarget.getDataSources(event);
            return !dataSources2.isEmpty() && !dataSources2.contains(this.getElement()) || super.canRunImport(event) && DbImplUtilCore.getTopSingleNamespace(this.getElement()) != null;
        }

        @NotNull
        private static List<DbDataSource> getDataSources(@NotNull DnDEvent event) {
            Object[] objects2;
            if (event == null) {
                DataSourceDnDTarget.$$$reportNull$$$0(1);
            }
            if ((objects2 = DbElementDnDTarget.getObjects(event)) == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    DataSourceDnDTarget.$$$reportNull$$$0(2);
                }
                return list;
            }
            ArrayList<DbDataSource> dataSources2 = new ArrayList<DbDataSource>();
            for (Object object : objects2) {
                if (!(object instanceof DbDataSource)) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        DataSourceDnDTarget.$$$reportNull$$$0(3);
                    }
                    return list;
                }
                dataSources2.add((DbDataSource)object);
            }
            ArrayList<DbDataSource> arrayList = dataSources2;
            if (arrayList == null) {
                DataSourceDnDTarget.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/DbElementDnDTarget$DataSourceDnDTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/DbElementDnDTarget$DataSourceDnDTarget";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSources";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class DbTableDnDTarget
    extends DbElementDnDTarget<DbTable> {
        public DbTableDnDTarget(@NotNull DbTable table) {
            if (table == null) {
                DbTableDnDTarget.$$$reportNull$$$0(0);
            }
            super(table);
        }

        @Override
        protected boolean canRunImport(DnDEvent event) {
            return super.canRunImport(event) && ((DbTable)this.getElement()).getKind() == ObjectKind.TABLE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/DbElementDnDTarget$DbTableDnDTarget", "<init>"));
        }
    }
}

