/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataSourceType
implements ImportAction.SourceType {
    protected final LocalDataSource myProducerLocalDataSource;
    protected final DbDataSource myProducerSource;
    @NlsSafe
    private final String myProducerName;
    private final DbTable myTable;
    private final String myQueryText;
    private final SearchPath mySearchPath;
    private final FormatterCreator myFormatterCreator;

    protected AbstractDataSourceType(@NotNull DbDataSource dbDataSource, @NotNull LocalDataSource localDataSource, @NotNull String name2, @NotNull String queryText2, @Nullable DbTable table, @Nullable SearchPath searchPath, @NotNull FormatterCreator creator) {
        if (dbDataSource == null) {
            AbstractDataSourceType.$$$reportNull$$$0(0);
        }
        if (localDataSource == null) {
            AbstractDataSourceType.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            AbstractDataSourceType.$$$reportNull$$$0(2);
        }
        if (queryText2 == null) {
            AbstractDataSourceType.$$$reportNull$$$0(3);
        }
        if (creator == null) {
            AbstractDataSourceType.$$$reportNull$$$0(4);
        }
        this.myProducerLocalDataSource = localDataSource;
        this.myProducerSource = dbDataSource;
        this.myProducerName = name2;
        this.myTable = table;
        this.myQueryText = queryText2;
        this.myFormatterCreator = creator;
        this.mySearchPath = searchPath == null ? AbstractDataSourceType.getSearchPath(dbDataSource, this.myTable) : searchPath;
    }

    @NotNull
    public String getQueryText() {
        String string = this.myQueryText;
        if (string == null) {
            AbstractDataSourceType.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isDefaultQuery() {
        DbTable table = this.getTable();
        return table != null && this.myQueryText.equals(AbstractDataSourceType.getQueryText(table, this.myProducerLocalDataSource));
    }

    @Override
    @NotNull
    public FormatterCreator getFormatterCreator() {
        FormatterCreator formatterCreator = this.myFormatterCreator;
        if (formatterCreator == null) {
            AbstractDataSourceType.$$$reportNull$$$0(6);
        }
        return formatterCreator;
    }

    @Nullable
    public DbTable getTable() {
        return this.myTable;
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    @Override
    @NotNull
    public String getDialogTitle() {
        String string = DatabaseBundle.message("import.table", this.myProducerName);
        if (string == null) {
            AbstractDataSourceType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getProducerName() {
        String string = this.myProducerName;
        if (string == null) {
            AbstractDataSourceType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public DasDataSource getProducerSystem() {
        LocalDataSource localDataSource = this.myProducerLocalDataSource;
        if (localDataSource == null) {
            AbstractDataSourceType.$$$reportNull$$$0(9);
        }
        return localDataSource;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myProducerLocalDataSource.getDbms();
        if (dbms == null) {
            AbstractDataSourceType.$$$reportNull$$$0(10);
        }
        return dbms;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportEditorContext context, @NotNull DeModel deModel, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @Nullable List<? extends ColumnDescriptor> visibleProducers, @NotNull String tableName) {
        if (context == null) {
            AbstractDataSourceType.$$$reportNull$$$0(11);
        }
        if (deModel == null) {
            AbstractDataSourceType.$$$reportNull$$$0(12);
        }
        if (descriptors == null) {
            AbstractDataSourceType.$$$reportNull$$$0(13);
        }
        if (tableName == null) {
            AbstractDataSourceType.$$$reportNull$$$0(14);
        }
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        DeTable table = ImportUtil.createDeTableFromColumns(deModel, producers, this.myProducerName);
        table.parent = ImportUtil.getSchema(context, deModel);
        table.name = tableName;
        table.setEditedObject((DeObject)null);
        table.getChildren().forEach(child -> child.setEditedObject((DeObject)null));
        for (int i2 = 0; i2 < Math.min(producers.size(), table.columns.size()); ++i2) {
            table.columns.get((int)i2).dataType = this.getTypeName(context, rows, producers, i2);
        }
        DatabaseEditorCapabilities.TableEditorCaps caps = SchemaEditor.forDbms(context.getDbms()).getDbEditorCaps().getTableEditorCaps(false);
        ImportUtil.removeUnsupportedObjects(table, caps);
        ImportUtil.removeUntransferableObjects(table);
        DeTable deTable = table;
        if (deTable == null) {
            AbstractDataSourceType.$$$reportNull$$$0(15);
        }
        return deTable;
    }

    @NotNull
    private String getTypeName(@NotNull ImportEditorContext context, @Nullable List<? extends GridRow> rows, List<? extends ColumnDescriptor> producers, int i2) {
        if (context == null) {
            AbstractDataSourceType.$$$reportNull$$$0(16);
        }
        ColumnDescriptor column2 = producers.get(i2);
        Dbms producerDbms = this.myProducerLocalDataSource.getDbms();
        Version producerVersion = DbImplUtilCore.getDatabaseVersion(this.myProducerLocalDataSource);
        Dbms consumerDbms = context.getDbms();
        Version consumerVersion = DbImplUtilCore.getDatabaseVersion(context.getDataSource());
        Domain producerDomain = BaseDomainRegistry.getDomain(producerDbms, this.myProducerLocalDataSource.getVersion(), column2, false);
        Domain consumerDomain = ImportUtilCore.getConsumerDomain(producerDbms, consumerDbms, consumerVersion, producerDomain);
        String string = ImportUtil.getSqlTypeName(consumerDomain, column2, rows, producerDbms, context.getDbms(), consumerVersion);
        if (string == null) {
            AbstractDataSourceType.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @NotNull
    public BasicModTable createNewTable(@NotNull ImportEditorContext context, @NotNull BasicModModel model2, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @Nullable List<? extends ColumnDescriptor> visibleProducers, @NotNull String tableName) {
        if (context == null) {
            AbstractDataSourceType.$$$reportNull$$$0(18);
        }
        if (model2 == null) {
            AbstractDataSourceType.$$$reportNull$$$0(19);
        }
        if (descriptors == null) {
            AbstractDataSourceType.$$$reportNull$$$0(20);
        }
        if (tableName == null) {
            AbstractDataSourceType.$$$reportNull$$$0(21);
        }
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        BasicModTable table = ImportUtil.instantiateTable(context, model2);
        Objects.requireNonNull(table);
        table.setName(tableName);
        ImportUtil.fillTableColumns(table, producers, (Function<? super Integer, String>)((Function)i2 -> this.getTypeName(context, rows, producers, (int)i2)));
        BasicModTable basicModTable = table;
        if (basicModTable == null) {
            AbstractDataSourceType.$$$reportNull$$$0(22);
        }
        return basicModTable;
    }

    @NotNull
    protected static String getQueryText(@NotNull DasTable table, @NotNull LocalDataSource localDataSource) {
        if (table == null) {
            AbstractDataSourceType.$$$reportNull$$$0(23);
        }
        if (localDataSource == null) {
            AbstractDataSourceType.$$$reportNull$$$0(24);
        }
        SelectTask task = DmlTaskKt.allColumns(table).version(localDataSource.getVersion()).build(DbImplUtilCore.createBuilderForUIExec(localDataSource.getDbms(), (DasObject)table));
        DmlHelper generator = DmlUtilKt.dmlGenerator(localDataSource.getDbms());
        String string = generator.generate(task).getStatement();
        if (string == null) {
            AbstractDataSourceType.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    private static SearchPath getSearchPath(@NotNull DbDataSource producerDataSource, @Nullable DasTable table) {
        if (producerDataSource == null) {
            AbstractDataSourceType.$$$reportNull$$$0(26);
        }
        return ObjectPaths.searchPathOf(DbImplUtilCore.getSearchPathObjectForSwitch(producerDataSource, (DasObject)table));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 15, 17, 22, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/AbstractDataSourceType";
                break;
            }
            case 11: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deModel";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/AbstractDataSourceType";
                break;
            }
            case 5: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatterCreator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerSystem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 15: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 22: 
            case 25: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createNewTable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getQueryText";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 15, 17, 22, 25 -> new IllegalStateException(string);
        };
    }
}

