/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.data.types.DbDataTypeConversion;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CoreGridHelper;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DbGridHelper;
import com.intellij.database.datagrid.DbGridHelperKt;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.objects.DasGridDataHookUp;
import com.intellij.database.dump.DbGridHandler;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.actions.DumpSourceNameProvider;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.StartupUiUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J*\u0010\u0017\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0016J\u001c\u0010\u001a\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016JJ\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160 H\u0016J\b\u0010\"\u001a\u00020#H\u0016J0\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u001c\u0010.\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u0013\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J,\u00102\u001a\u0004\u0018\u00010\u00162\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0016J:\u00103\u001a\u0004\u0018\u0001042\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160 H\u0016J\"\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J.\u00108\u001a\u0004\u0018\u0001092\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010!\u001a\u00020\u00162\u0006\u0010:\u001a\u00020\u0012H\u0016J,\u0010;\u001a\u0004\u0018\u00010\u001e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00160 H\u0017J\u001e\u0010=\u001a\u0004\u0018\u00010\u001e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0017J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020AH\u0016J\u0014\u0010B\u001a\u0004\u0018\u00010\u001e2\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020/H\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020/H\u0016J\u001e\u0010G\u001a\u0004\u0018\u00010\u001e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\"\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001e0I2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\u001e\u0010J\u001a\u0004\u0018\u00010K2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\u001c\u0010L\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\u0010\u0010M\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020/H\u0016J\u001c\u0010N\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\b\u0010O\u001a\u00020\u0012H\u0016J\u001c\u0010P\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\b\u0010Q\u001a\u00020\u0012H\u0016J\u0010\u0010R\u001a\u00020\n2\u0006\u0010S\u001a\u00020AH\u0016J$\u0010T\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u000f\u001a\u00020UH\u0016J,\u0010V\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010W\u001a\u00020AH\u0016J\u0010\u0010X\u001a\u00020\n2\u0006\u0010S\u001a\u00020\u0012H\u0016J\u001c\u0010Y\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016R\u0014\u0010\u0006\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/intellij/database/datagrid/DbGridHelper;", "Lcom/intellij/database/datagrid/GridHelper;", "dbmsSupplier", "Lkotlin/Function0;", "Lcom/intellij/database/Dbms;", "(Lkotlin/jvm/functions/Function0;)V", "dbms", "getDbms", "()Lcom/intellij/database/Dbms;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "fix", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "editor", "", "canAddRow", "", "grid", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "canEditTogether", "columns", "", "canMutateColumns", "createCellCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "text", "", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "column", "createDataTypeConversionBuilder", "Lcom/intellij/database/data/types/DataTypeConversion$Builder;", "createDumpHandler", "Lcom/intellij/database/dump/DumpHandler;", "source", "Lcom/intellij/database/run/actions/DumpSource;", "manager", "Lcom/intellij/database/dump/ExtractionHelper;", "factory", "Lcom/intellij/database/extractors/DataExtractorFactory;", "config", "Lcom/intellij/database/extractors/ExtractionConfig;", "createDumpSource", "Lcom/intellij/database/datagrid/DataGrid;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findUniqueColumn", "getCellLanguage", "Lcom/intellij/lang/Language;", "getChildrenFromModel", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "getColumnIcon", "Ljavax/swing/Icon;", "forDisplay", "getColumnTooltipHtml", "columnIdx", "getDatabaseSystemName", "getDefaultMode", "Lcom/intellij/database/extractors/ObjectFormatterMode;", "getDefaultPageSize", "", "getLocationString", "element", "Lcom/intellij/psi/PsiElement;", "getNameForDump", "getQueryText", "getTableName", "getUnambiguousColumnNames", "", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasTargetForEditing", "isDatabaseHookUp", "isEditable", "isLimitDefaultPageSize", "isMixedTypeColumns", "isSortingApplicable", "setDefaultPageSize", "value", "setFilterSortHighlighter", "Lcom/intellij/openapi/editor/Editor;", "setFilterText", "caretPosition", "setLimitDefaultPageSize", "updateFilterSortPSI", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbGridHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbGridHelper.kt\ncom/intellij/database/datagrid/DbGridHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,336:1\n1726#2,3:337\n1#3:340\n*S KotlinDebug\n*F\n+ 1 DbGridHelper.kt\ncom/intellij/database/datagrid/DbGridHelper\n*L\n160#1:337,3\n*E\n"})
public final class DbGridHelper
implements GridHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Dbms> dbmsSupplier;
    @NotNull
    private static final DbmsExtension<CoreGridHelper> EP = new DbmsExtension("com.intellij.database.gridHelper");

    public DbGridHelper(@NotNull Function0<Dbms> dbmsSupplier) {
        Intrinsics.checkNotNullParameter(dbmsSupplier, (String)"dbmsSupplier");
        this.dbmsSupplier = dbmsSupplier;
    }

    private final Dbms getDbms() {
        return (Dbms)this.dbmsSupplier.invoke();
    }

    @NotNull
    public DumpSource<?> createDumpSource(@NotNull DataGrid grid, @NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        return (DumpSource)new DumpSource.DataGridSource(grid);
    }

    @NotNull
    public DumpHandler<?> createDumpHandler(@NotNull DumpSource<?> source, @NotNull ExtractionHelper manager, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        DumpSource.DataGridSource cfr_ignored_0 = (DumpSource.DataGridSource)source;
        return (DumpHandler)new DbGridHandler(((DumpSource.DataGridSource)source).getGrid().getProject(), ((DumpSource.DataGridSource)source).getGrid(), (DumpSourceNameProvider<DataGrid>)((DumpSource.DataGridSource)source).getNameProvider(), manager, factory, config);
    }

    public void setFilterText(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull String text2, int caretPosition) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        DbGridHelper.Companion.get(this.getDbms()).setFilterText(grid, text2, caretPosition);
    }

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return DbGridHelper.Companion.get(this.getDbms()).getCellLanguage(grid, row, column2);
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text2, @NotNull Project project, @NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return DbGridHelper.Companion.get(this.getDbms()).createCellCodeFragment(text2, project, grid, row, column2);
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getColumnTooltipHtml(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> columnIdx) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
        return DbGridHelperKt.getDbColumnTooltipHtml(grid, columnIdx);
    }

    @NotNull
    public DataTypeConversion.Builder createDataTypeConversionBuilder() {
        return (DataTypeConversion.Builder)new DbDataTypeConversion.Builder();
    }

    @NotNull
    public ObjectFormatterMode getDefaultMode() {
        return PredicatesHelperKt.predicatesHelper(this.getDbms()).getMode();
    }

    public boolean canMutateColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return DbGridHelper.Companion.get(this.getDbms()).canMutateColumns(grid);
    }

    @Nullable
    public VirtualFile getVirtualFile(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return DataGridUtil.getVirtualFile(grid);
    }

    public boolean isEditable(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return !grid.getDataHookup().isReadOnly() && GridEditGuard.get(grid) == null;
    }

    public boolean isMixedTypeColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return !(grid.getDataHookup() instanceof DasGridDataHookUp) && !(grid.getDataHookup() instanceof DataBusGridDataHookUp) || DbGridHelper.Companion.get(this.getDbms()).isMixedTypeColumns(grid);
    }

    public boolean isSortingApplicable() {
        return DbGridHelper.Companion.get(this.getDbms()).isSortingApplicable();
    }

    public void applyFix(@NotNull Project project, @NotNull ErrorInfo.Fix fix, @Nullable Object editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
        DataSourceUiUtil.applyFix(project, fix, editor2 instanceof DatabaseConfigEditor ? (DatabaseConfigEditor)editor2 : null);
    }

    @NotNull
    public List<String> getUnambiguousColumnNames(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        DatabaseGridDataHookUp databaseGridDataHookUp = hookup;
        if (databaseGridDataHookUp == null || (databaseGridDataHookUp = databaseGridDataHookUp.getTableType()) == null) {
            List list = ContainerUtil.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"emptyList(...)");
            return list;
        }
        DatabaseGridDataHookUp type = databaseGridDataHookUp;
        List<String> list = DbSqlUtil.getUnambiguousColumnNames(grid.getProject(), hookup.getDatabaseDialect(), (SqlTableType)type, null);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getUnambiguousColumnNames(...)");
        return list;
    }

    public boolean canAddRow(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(grid, (String)"grid");
            DasObject dasObject = DataGridUtilCore.getDatabaseTable(grid);
            if (dasObject == null) {
                return false;
            }
            DasObject table = dasObject;
            if (this.getDbms().eq(Dbms.MSSQL)) {
                return true;
            }
            Map map2 = CollectionFactory.createCaseInsensitiveStringMap();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createCaseInsensitiveStringMap(...)");
            Map nameToModelIndex = map2;
            GridModel gridModel = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
            GridModel gridModel2 = gridModel;
            for (ModelIndex columnIdx : gridModel2.getColumnIndices().asIterable()) {
                GridColumn column2 = (GridColumn)gridModel2.getColumn(columnIdx);
                if (column2 == null) continue;
                nameToModelIndex.put(column2.getName(), columnIdx);
            }
            ModelHelper modelHelper = DbImplUtil.getModelHelper(this.getDbms());
            Intrinsics.checkNotNullExpressionValue((Object)modelHelper, (String)"getModelHelper(...)");
            ModelHelper helper = modelHelper;
            JBIterable<? extends DasColumn> jBIterable = DasUtil.getColumns(table);
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getColumns(...)");
            Iterable $this$all$iv = (Iterable)jBIterable;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    DasColumn column3 = (DasColumn)element$iv;
                    boolean bl2 = false;
                    ModelIndex index2 = (ModelIndex)nameToModelIndex.get(column3.getName());
                    if (index2 != null && index2.isValid(grid) || !helper.mustParticipateInInsert(column3)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean hasTargetForEditing(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return DataGridUtilCore.getDatabaseTable(grid) != null;
    }

    @Nullable
    public String getTableName(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        DasObject dasObject = DataGridUtilCore.getDatabaseTable(grid);
        return dasObject != null ? dasObject.getName() : null;
    }

    @Nullable
    public String getNameForDump(@NotNull DataGrid source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String tabTitle = DataGridUtil.getResultSetName(source.getProject(), source);
        if (tabTitle != null) {
            return tabTitle;
        }
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)((CoreGrid)source));
        if (table != null) {
            return table.getName();
        }
        String query = this.getQueryText(source);
        if (query != null) {
            String string = query.substring(0, Math.min(40, query.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return GridUtil.getEditorTabName((DataGrid)source);
    }

    @Nullable
    public String getQueryText(@NotNull DataGrid source) {
        String string;
        DataBusGridDataHookUp hookUp;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DataBusGridDataHookUp dataBusGridDataHookUp = hookUp = DataGridUtil.getDataBusHookUp(source);
        if (dataBusGridDataHookUp != null) {
            string = dataBusGridDataHookUp.getUnlimitedQueryText(true);
        } else {
            Object object = GridUtil.getVirtualFile((CoreGrid)((CoreGrid)source));
            if (object != null && (object = object.getName()) != null) {
                Object it2 = object;
                boolean bl = false;
                string = FileUtil.getNameWithoutExtension((String)it2);
            } else {
                string = null;
            }
        }
        return string;
    }

    public boolean isDatabaseHookUp(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        return DataGridUtil.getDataBusHookUp(grid) != null;
    }

    public int getDefaultPageSize() {
        return DbImplUtilCore.getDefaultPageSize(this.getDbms());
    }

    public void setDefaultPageSize(int value2) {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        if (this.getDbms().isMongo()) {
            PropertiesComponent.getInstance().setValue(DbImplUtilCore.DEFAULT_PAGE_SIZE_MONGO_PROP, value2, DbImplUtilCore.DEFAULT_PAGE_SIZE_MONGO);
            settings.updatePageSizeTimestamp();
        } else {
            settings.pageSize = value2;
            settings.fireChanged();
        }
    }

    public boolean isLimitDefaultPageSize() {
        return DbImplUtilCore.isLimitDefaultPageSize(this.getDbms());
    }

    public void setLimitDefaultPageSize(boolean value2) {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        if (this.getDbms().isMongo()) {
            PropertiesComponent.getInstance().setValue(DbImplUtilCore.DEFAULT_LIMIT_PAGE_SIZE_MONGO_PROP, value2, DbImplUtilCore.DEFAULT_LIMIT_PAGE_SIZE_MONGO);
            settings.updatePageSizeTimestamp();
        } else {
            settings.setLimitPageSize(value2);
            settings.fireChanged();
        }
    }

    public void setFilterSortHighlighter(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Language language = grid.getDataHookup().getFilterSortLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getFilterSortLanguage(...)");
        Language filterSortLanguage = language;
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)filterSortLanguage, (Project)grid.getProject(), null);
        LexerEditorHighlighter lexerHighlighter = new LexerEditorHighlighter(highlighter, (EditorColorsScheme)((DataGrid)grid).getColorsScheme());
        EditorEx editorEx = editor2 instanceof EditorEx ? (EditorEx)editor2 : null;
        if (editorEx != null) {
            editorEx.setHighlighter((EditorHighlighter)lexerHighlighter);
        }
    }

    public void updateFilterSortPSI(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        grid.getDataHookup().updateFilterSortFully();
        DataGridUtil.doWhenDataSourceIsLoaded(grid, () -> DbGridHelper.updateFilterSortPSI$lambda$2(grid));
    }

    @NotNull
    public JBIterable<TreeElement> getChildrenFromModel(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        JBIterable jBIterable;
        JBIterable jBIterable2;
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        JBIterable table = DataGridUtilCore.getDatabaseTable(grid);
        JBIterable jBIterable3 = table;
        JBIterable jBIterable4 = jBIterable3 != null && (jBIterable3 = jBIterable3.getDasChildren(ObjectKind.COLUMN)) != null && (jBIterable3 = jBIterable3.filter(DbElement.class)) != null ? jBIterable3.map(arg_0 -> DbGridHelper.getChildrenFromModel$lambda$3(getChildrenFromModel.1.INSTANCE, arg_0)) : (jBIterable2 = null);
        if (jBIterable2 == null) {
            JBIterable jBIterable5 = JBIterable.empty();
            jBIterable = jBIterable5;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"empty(...)");
        } else {
            jBIterable = jBIterable2;
        }
        return jBIterable;
    }

    @Nullable
    public String getLocationString(@Nullable PsiElement element2) {
        DataGridPomTarget.Column column2 = DataGridPomTarget.unwrapColumn((PsiElement)element2);
        if (column2 == null) {
            return null;
        }
        DataGridPomTarget.Column target2 = column2;
        DataGrid dataGrid = target2.dataGrid;
        String string = DataGridUtil.getSqlType((CoreGrid<GridRow, GridColumn>)((CoreGrid)dataGrid), target2.getColumn());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSqlType(...)");
        String sqlType = string;
        Object result2 = StringUtil.isEmpty((String)sqlType) ? "" : sqlType + " ";
        RowSortOrder.Type type = dataGrid.getSortOrder(target2.column);
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getSortOrder(...)");
        RowSortOrder.Type sortOrder = type;
        int thenBySortOrder = dataGrid.getThenBySortOrder(target2.column);
        if (sortOrder != RowSortOrder.Type.UNSORTED && thenBySortOrder != 0) {
            char arrow;
            boolean isAscending = sortOrder == RowSortOrder.Type.ASC;
            char c2 = arrow = isAscending ? (char)'\u2191' : '\u2193';
            String ordering = StartupUiUtil.getLabelFont().canDisplay(arrow) ? String.valueOf(arrow) : (isAscending ? "A-" : "D-");
            result2 = (String)result2 + ordering + thenBySortOrder;
        }
        if (UISettings.Companion.getInstance().getShowInplaceComments()) {
            String comment;
            DasColumn dasColumn;
            DasColumn dasColumn2 = dasColumn = DataGridUtilCore.getDatabaseColumn((CoreGrid<GridRow, GridColumn>)((CoreGrid)dataGrid), target2.getColumn());
            String string2 = comment = dasColumn2 != null ? dasColumn2.getComment() : null;
            if (comment != null) {
                result2 = (String)result2 + "  " + DbNodeDescriptor.adjustCommentString(comment);
            }
        }
        return result2;
    }

    public boolean canEditTogether(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull List<GridColumn> columns2) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        if (columns2.size() == 1) {
            return true;
        }
        DbDataSource system = DataGridUtilCore.getDatabaseSystem(grid);
        if (system == null || system.getDbms().in(Dbms.DOCUMENT_ORIENTED)) {
            return true;
        }
        DomainRegistry domainRegistry = BaseDomainRegistry.get(this.getDbms(), system.getVersion());
        Intrinsics.checkNotNullExpressionValue((Object)domainRegistry, (String)"get(...)");
        DomainRegistry registry = domainRegistry;
        int n = columns2.size();
        for (int i2 = 0; i2 < n; ++i2) {
            GridColumn outer = columns2.get(i2);
            if (registry.getDomain((ColumnDescriptor)outer) == null) {
                return false;
            }
            int n3 = columns2.size();
            for (int j = i2 + 1; j < n3; ++j) {
                Compatibility compatibility;
                Domain innerDomain;
                Domain outerDomain;
                GridColumn inner = columns2.get(j);
                if (registry.getDomain((ColumnDescriptor)inner) == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)outerDomain.getCompatibility(innerDomain), (String)"getCompatibility(...)");
                if (compatibility.isCompatible()) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Icon getColumnIcon(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull GridColumn column2, boolean forDisplay) {
        DasColumn c2;
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        DasColumn dasColumn = c2 = forDisplay ? DataGridUtilCore.getDatabaseColumn(grid, column2) : null;
        return dasColumn != null ? DbPresentationCore.getIcon(dasColumn) : DbPresentationCore.getIcon(this.getDbms(), ObjectKind.COLUMN);
    }

    @Nullable
    public GridColumn findUniqueColumn(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull List<GridColumn> columns2) {
        Object v2;
        block5: {
            DasObject dasTable;
            Intrinsics.checkNotNullParameter(grid, (String)"grid");
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            DasObject dasObject = dasTable = DataGridUtilCore.getDatabaseTable(grid);
            JBIterable indices = dasObject == null ? JBIterable.empty() : DasUtil.getIndices(dasObject);
            Iterable iterable = columns2;
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    GridColumn column2 = (GridColumn)t;
                    boolean bl2 = false;
                    DasColumn dasColumn = DataGridUtilCore.getDatabaseColumn(grid, column2);
                    if (dasColumn == null || DasUtil.isPrimary(dasColumn) || DasUtil.isAutoGenerated(dasColumn)) {
                        bl = dasColumn != null;
                    } else {
                        for (DasIndex index2 : indices) {
                            if (!DasUtil.containsName(dasColumn.getName(), index2.getColumnsRef()) || !index2.isUnique()) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        return v2;
    }

    @NlsSafe
    @Nullable
    public String getDatabaseSystemName(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        DbDataSource dbDataSource = DataGridUtilCore.getDatabaseSystem(grid);
        return dbDataSource != null ? dbDataSource.getName() : null;
    }

    private static final void updateFilterSortPSI$lambda$2(CoreGrid $grid) {
        Intrinsics.checkNotNullParameter((Object)$grid, (String)"$grid");
        $grid.getDataHookup().updateFilterSortFully();
    }

    private static final TreeElement getChildrenFromModel$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TreeElement)$tmp0.invoke(p0);
    }

    @JvmStatic
    private static final CoreGridHelper get(Dbms dbms) {
        return DbGridHelper.Companion.get(dbms);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0003R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/datagrid/DbGridHelper$Companion;", "", "()V", "EP", "Lcom/intellij/database/DbmsExtension;", "Lcom/intellij/database/datagrid/CoreGridHelper;", "get", "dbms", "Lcom/intellij/database/Dbms;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final CoreGridHelper get(Dbms dbms) {
            Object t = EP.forDbms(dbms);
            Intrinsics.checkNotNullExpressionValue(t, (String)"forDbms(...)");
            return (CoreGridHelper)t;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

