/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseSortingModel;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridFilteringModelImpl;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.HookUpHelper;
import com.intellij.database.datagrid.HookUpVirtualFileProvider;
import com.intellij.database.datagrid.MultiPageModel;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.datagrid.MutationsStorageImpl;
import com.intellij.database.datagrid.TypesMutationsStorageImpl;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.actions.CountRowsAction;
import com.intellij.database.run.ui.grid.editors.DbGridCellEditorHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.PlainOrderBy;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.TableKindTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import com.intellij.util.concurrency.SameThreadExecutor;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DatabaseTableGridDataHookUp
extends DatabaseGridDataHookUp
implements HookUpVirtualFileProvider {
    private static final Logger LOG = Logger.getInstance(DatabaseTableGridDataHookUp.class);
    protected final VirtualFile myFile;
    @Nullable
    private final GridFilteringModelImpl myFilteringModel;
    @Nullable
    private final DatabaseSortingModel mySortingModel;
    private boolean myInitialized;
    protected boolean myDisableRowId;

    DatabaseTableGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull VirtualFile file, @NotNull DatabaseDepartment department) {
        if (project == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(2);
        }
        if (department == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(3);
        }
        super(project, session2, department, (TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean>)((TripleFunction)DbGridCellEditorHelper::areValuesEqual), DatabaseTableGridDataHookUp::createDatabaseMutationsStorage);
        this.myDisableRowId = false;
        this.myFile = file;
        boolean isVmView = DatabaseTableGridDataHookUp.getVirtualView(this.getDatabaseTable()) != null;
        this.myFilteringModel = isVmView ? null : new GridFilteringModelImpl();
        DatabaseSortingModel databaseSortingModel = this.mySortingModel = !this.sortingEnabled() || isVmView ? null : new DatabaseSortingModel(this);
        if (this.mySortingModel != null) {
            this.mySortingModel.setSortingEnabled(DatabaseSettings.getSettings().isSortViaOrderBy());
        }
        this.updateFilterSortFully();
    }

    private boolean sortingEnabled() {
        return HookUpHelper.get(this.getDbms()).isSortingApplicable(this.getDatabaseTable());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myFile.getPresentableName();
        if (string == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void updateFilterSortFully() {
        this.myLoader.updateQueryText();
        this.updateFilterFully();
        this.updateSortingFully();
    }

    private void updateFilterSortPSI() {
        this.updateFilterPSI();
        this.updateSortingPSI();
    }

    @NotNull
    public Language getFilterSortLanguage() {
        Language language = HookUpHelper.get(this.getDbms()).getFilterSortLanguage(this.getDataSource());
        if (language == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(5);
        }
        return language;
    }

    public boolean isFilterApplicable() {
        return HookUpHelper.get(this.getDbms()).isFilterApplicable(this.getDatabaseTable());
    }

    @NotNull
    public String getFilterPrefix() {
        String string = HookUpHelper.get(this.getDbms()).getFilterPrefix(this.getDatabaseTable());
        if (string == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFilterEmptyText() {
        String string = HookUpHelper.get(this.getDbms()).getFilterEmptyText(this.getDatabaseTable());
        if (string == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public GridFilteringModel getFilteringModel() {
        return this.myFilteringModel;
    }

    @NotNull
    public String getSortingPrefix() {
        String string = HookUpHelper.get(this.getDbms()).getSortingPrefix(this.getDatabaseTable());
        if (string == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getSortingEmptyText() {
        String string = HookUpHelper.get(this.getDbms()).getSortingEmptyText(this.getDatabaseTable());
        if (string == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public GridSortingModel<GridRow, GridColumn> getSortingModel() {
        return this.mySortingModel;
    }

    @Override
    public boolean isReadOnly() {
        return !this.myFile.isWritable() || super.isReadOnly();
    }

    @Override
    protected void onProcessed(@NotNull GridRequestSource source, @NotNull GridDataRequest request, DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
        boolean isSucceeded;
        if (source == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(10);
        }
        if (request == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(11);
        }
        if (!(isSucceeded = request.getPromise().isSucceeded()) && this.getDatabaseTable() != null && this.isRowIdError(source.getErrorMessage())) {
            if (this.myDisableRowId) {
                super.onProcessed(source, request, reloadPolicy);
                return;
            }
            this.myLoader.invalidateQuery();
            this.myDisableRowId = true;
            source.clearError();
            this.myLoader.reloadCurrentPage(source);
        } else {
            super.onProcessed(source, request, reloadPolicy);
        }
    }

    private boolean isRowIdError(@Nullable String message2) {
        return message2 != null && (this.getDbms().in(Dbms.POSTGRES_LIKE) && StringUtil.contains((CharSequence)message2, (CharSequence)"Column 'ctid' cannot be resolved") || this.getDbms().in(Dbms.POSTGRES_LIKE) && StringUtil.contains((CharSequence)message2, (CharSequence)"column \"ctid\" does not exist") || this.getDbms().in(Dbms.POSTGRES_LIKE) && StringUtil.contains((CharSequence)message2, (CharSequence)"System column \"ctid\" is not supported yet") || this.getDbms().is(Dbms.POSTGRES) && StringUtil.contains((CharSequence)message2, (CharSequence)"UPDATE and CTID scans not supported") || this.getDbms().is(Dbms.POSTGRES) && StringUtil.contains((CharSequence)message2, (CharSequence)"transparent decompression only supports tableoid system column") || this.getDbms().is(Dbms.SNOWFLAKE) && StringUtil.contains((CharSequence)message2, (CharSequence)"invalid identifier 'CTID'") || (this.getDbms().is(Dbms.POSTGRES) || this.getDbms().is(Dbms.UNKNOWN)) && StringUtil.contains((CharSequence)message2, (CharSequence)"System column with id -1 is not supported yet") || this.getDbms().in(Dbms.AZURE_LIKE) && StringUtil.contains((CharSequence)message2, (CharSequence)"Incorrect syntax near '%'") || this.getDbms().in(Dbms.AZURE_LIKE) && StringUtil.contains((CharSequence)message2, (CharSequence)"Invalid column name '%%'") || this.getDbms().in(Dbms.DB2_LIKE) && StringUtil.contains((CharSequence)message2, (CharSequence)"The routine \"RID\" is not supported in a partitioned database environment"));
    }

    @Override
    protected void requestFinished(@NotNull GridRequestSource source, boolean isSucceeded, DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
        if (source == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(12);
        }
        if (isSucceeded && source.phase == GridRequestSource.Phase.PREPARE) {
            this.getLoader().tablePrepared();
            return;
        }
        if (isSucceeded && source.phase == GridRequestSource.Phase.FIRST && this.isTwoPhaseRequest()) {
            source.phase = GridRequestSource.Phase.LOAD_VALUES_USING_KEYS;
            this.getLoader().reloadCurrentPage(source, reloadPolicy);
            return;
        }
        super.requestFinished(source, isSucceeded, reloadPolicy);
    }

    private boolean isTwoPhaseRequest() {
        return HookUpHelper.get(this.getDbms()).isTwoPhaseSelect(this.getDatabaseTable());
    }

    @Override
    protected int getPageSizeForRequest(@NotNull GridRequestSource source) {
        if (source == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(13);
        }
        return this.isTwoPhaseRequest() && !GridUtilCore.isPageSizeUnlimited((int)this.getPageModel().getPageSize()) && source.phase == GridRequestSource.Phase.FIRST ? this.getPageModel().getPageSize() + 1 : this.getPageModel().getPageSize();
    }

    @Override
    @Nullable
    public String getUnlimitedQueryText(boolean ordered) {
        SelectGenerationResult res2 = ((DatabaseGridDataHookUp.DatabaseLoader)this.myLoader).createQueryTextPure(DataBusGridDataHookUp.QueryAttributes.unlimited(ordered), null);
        return res2 == null ? super.getUnlimitedQueryText(ordered) : res2.getStatement();
    }

    @Override
    @Nullable
    public DasObject getDatabaseTable() {
        DasObject table = super.getDatabaseTable();
        if (table == null && this.myFile.isValid()) {
            table = DbImplUtilCore.findElement(this.getProject(), this.myFile);
            this.setDatabaseTable(table);
        }
        return table;
    }

    @Override
    @NotNull
    protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
        return new DatabaseTableLoader();
    }

    private void updateFilterFully() {
        if (this.myFilteringModel == null) {
            return;
        }
        if (this.isFilterApplicable()) {
            this.myFilteringModel.fireApplicableUpdated();
        }
        this.myFilteringModel.firePrefixUpdated();
        this.updateFilterPSI();
    }

    private void updateFilterPSI() {
        if (this.myFilteringModel == null) {
            return;
        }
        Document document = this.myFilteringModel.getFilterDocument();
        String filterText = document.getText();
        PsiCodeFragment fragment = HookUpHelper.get(this.getDbms()).createFilterCodeFragment(this.getProject(), filterText, this.getQueryText(), this.getDataSource(), this.getDatabaseTable());
        this.updatePSI(document, filterText, (PsiFile)fragment);
        this.myFilteringModel.firePSIUpdated();
    }

    private void updateSortingFully() {
        if (this.mySortingModel == null) {
            return;
        }
        this.mySortingModel.firePrefixUpdated();
        this.updateSortingPSI();
    }

    private void updateSortingPSI() {
        if (this.mySortingModel == null) {
            return;
        }
        Document document = this.mySortingModel.getDocument();
        String sortingText = document.getText();
        PsiCodeFragment fragment = HookUpHelper.get(this.getDbms()).createSortingCodeFragment(this.getProject(), sortingText, this.getQueryText(), this.getDataSource(), this.getDatabaseTable());
        this.updatePSI(document, sortingText, (PsiFile)fragment);
        this.mySortingModel.firePSIUpdated();
    }

    private void updatePSI(@NotNull Document document, @NotNull String text2, @Nullable PsiFile fragment) {
        if (document == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(15);
        }
        if (fragment == null) {
            fragment = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText((Language)PlainTextLanguage.INSTANCE, (CharSequence)text2);
        }
        ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.getProject())).associatePsi(document, fragment);
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(16);
        }
        return virtualFile;
    }

    @NotNull
    public static TypesMutationsStorageImpl<Object> createDatabaseMutationsStorage(GridModel<GridRow, GridColumn> model2) {
        return new TypesMutationsStorageImpl((MutationsStorage)new MutationsStorageImpl(model2, 500, 10), model2);
    }

    @Override
    public void processRequest(@NotNull GridRequestSource source, @NotNull GridDataRequest request, DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
        if (source == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(17);
        }
        if (request == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(18);
        }
        this.initialize().onProcessed(__ -> super.processRequest(source, request, reloadPolicy));
    }

    @NotNull
    private Promise<Void> initialize() {
        if (this.myInitialized) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DatabaseTableGridDataHookUp.$$$reportNull$$$0(19);
            }
            return promise;
        }
        this.myInitialized = true;
        DatabaseDialectEx dialect = this.getDatabaseDialect();
        DasNamespace object = DbImplUtilCore.getSearchPathObject(dialect, this.getDatabaseTable());
        if (object == null) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DatabaseTableGridDataHookUp.$$$reportNull$$$0(20);
            }
            return promise;
        }
        LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource(this.getDataSource());
        SearchPath path = DbImplUtil.getAutoSwitchPath(dataSource2, ObjectPaths.searchPathOf(object));
        if (path == null) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DatabaseTableGridDataHookUp.$$$reportNull$$$0(21);
            }
            return promise;
        }
        GridDataRequest request = DataRequest.newSchemaSwitchRequest(this, path, false);
        this.getMessageBus().getDataProducer().processRequest(request);
        AsyncPromise asyncPromise = request.getPromise();
        if (asyncPromise == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(22);
        }
        return asyncPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 16, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterSortLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterPrefix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterEmptyText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingEmptyText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "initialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onProcessed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "requestFinished";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPageSizeForRequest";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updatePSI";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 16, 19, 20, 21, 22 -> new IllegalStateException(string);
        };
    }

    private class DatabaseTableLoader
    extends DatabaseGridDataHookUp.DatabaseLoader {
        private boolean myTablePrepared = false;

        private DatabaseTableLoader() {
        }

        private void prepareTableIfNeeded(@NotNull GridRequestSource source, Runnable loaderRunnable) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(0);
            }
            if (!this.myTablePrepared) {
                DbElement table = (DbElement)ObjectUtils.tryCast((Object)DatabaseTableGridDataHookUp.this.getDatabaseTable(), DbElement.class);
                if (this.needToPrepareTable(table)) {
                    source.phase = GridRequestSource.Phase.PREPARE;
                    this.prepareTable(source, table).onSuccess(__ -> {
                        source.phase = GridRequestSource.Phase.FIRST;
                        loaderRunnable.run();
                    });
                    return;
                }
                this.myTablePrepared = true;
            }
            loaderRunnable.run();
        }

        private boolean needToPrepareTable(@Nullable DbElement table) {
            return table != null && HookUpHelper.get(DatabaseTableGridDataHookUp.this.getDbms()).needToObtainTableKind(table) && !HookUpHelper.Companion.getOBTAINED_TABLE_KIND().isIn((UserDataHolder)table);
        }

        @NotNull
        private Promise<Void> prepareTable(@NotNull GridRequestSource source, final @NotNull DbElement table) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(1);
            }
            if (table == null) {
                DatabaseTableLoader.$$$reportNull$$$0(2);
            }
            Project project = DatabaseTableGridDataHookUp.this.getProject();
            Dbms dbms = DatabaseTableGridDataHookUp.this.getDbms();
            DbDataSource system = DatabaseTableGridDataHookUp.this.getDataSource();
            DdlBuilder builder = DbImplUtil.createBuilderForUIExec(DbImplUtilCore.getDatabaseDialect(dbms), (DasObject)system);
            String alias = DbImplUtil.findFreeAlias(project, dbms, "", "t");
            TableKindTask task = DmlTaskKt.tableKind(table).alias(alias).build(builder);
            final String query = DmlUtilKt.dmlGenerator(dbms).generate(task).getStatement();
            DataRequest.RawRequest request = new DataRequest.RawRequest(DatabaseTableGridDataHookUp.this){

                @Override
                public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) throws SQLException {
                    ObjectKind kind = DbImplUtil.getTableKind((DatabaseConnection)connection2, query);
                    HookUpHelper.Companion.getOBTAINED_TABLE_KIND().set((UserDataHolder)table, (Object)kind);
                }
            };
            DatabaseTableGridDataHookUp.this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.DO_NOT_RELOAD);
            AsyncPromise asyncPromise = request.getPromise();
            if (asyncPromise == null) {
                DatabaseTableLoader.$$$reportNull$$$0(3);
            }
            return asyncPromise;
        }

        @Override
        protected void tablePrepared() {
            DatabaseTableGridDataHookUp.this.updateFilterSortFully();
        }

        @Override
        protected void queryTextUpdated() {
            DatabaseTableGridDataHookUp.this.updateFilterSortPSI();
        }

        @Override
        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns2, int firstRowNum) {
            if (context == null) {
                DatabaseTableLoader.$$$reportNull$$$0(4);
            }
            if (columns2 == null) {
                DatabaseTableLoader.$$$reportNull$$$0(5);
            }
            boolean columnsChanged = !this.sameColumnsAsInModel(columns2);
            super.setColumns(context, subQueryIndex, resultSetIndex, columns2, firstRowNum);
            if (columnsChanged) {
                DatabaseTableGridDataHookUp.this.updateFilterSortPSI();
            }
        }

        @Override
        protected boolean canCountRows(@Nullable String query) {
            return true;
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(6);
            }
            this.prepareTableIfNeeded(source, () -> {
                this.invalidateQuery();
                super.loadFirstPage(source);
            });
        }

        @Override
        public void loadLastPage(final @NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(7);
            }
            this.prepareTableIfNeeded(source, () -> {
                int offset;
                this.invalidateQuery();
                int pageSize = DatabaseTableGridDataHookUp.this.getPageModel().getPageSize();
                int n = offset = pageSize > 0 ? -pageSize : -100;
                if (this.canUseOffset()) {
                    AsyncFutureResult result2 = CountRowsAction.countRows((GridDataHookUp)DatabaseTableGridDataHookUp.this);
                    result2.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new ResultConsumer<Long>(){

                        public void onSuccess(Long rowsCount) {
                            DatabaseTableLoader.this.load(source, Math.max(0, (int)(rowsCount + (long)offset)));
                        }

                        public void onFailure(@NotNull Throwable t) {
                            if (t == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            LOG.error(t);
                            DatabaseTableLoader.this.load(source, offset - 1);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader$2", "onFailure"));
                        }
                    });
                } else {
                    this.load(source, offset - 1);
                }
            });
        }

        @Override
        public void reloadCurrentPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(8);
            }
            this.prepareTableIfNeeded(source, () -> {
                this.invalidateQuery();
                super.reloadCurrentPage(source);
            });
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(9);
            }
            this.prepareTableIfNeeded(source, () -> {
                this.invalidateQuery();
                super.loadNextPage(source);
            });
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(10);
            }
            this.prepareTableIfNeeded(source, () -> {
                this.invalidateQuery();
                super.loadPreviousPage(source);
            });
        }

        @Override
        protected void load(@NotNull GridRequestSource source, int offset, @Nullable DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(11);
            }
            this.prepareTableIfNeeded(source, () -> {
                this.invalidateQuery();
                super.load(source, offset, reloadPolicy);
            });
        }

        @Override
        public void applyFilterAndSorting(@NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(12);
            }
            this.prepareTableIfNeeded(source, () -> {
                this.invalidateQuery();
                this.invalidateRowCount();
                this.loadFirstPage(source);
            });
        }

        @Override
        @NotNull
        protected SelectTask.Companion.Builder selectTask(@NotNull DasObject dbTable) {
            if (dbTable == null) {
                DatabaseTableLoader.$$$reportNull$$$0(13);
            }
            SelectTask.Companion.Builder builder = super.selectTask(dbTable).keysOnly(DatabaseTableGridDataHookUp.this.isTwoPhaseRequest());
            if (builder == null) {
                DatabaseTableLoader.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @Override
        protected boolean disableRowId() {
            return DatabaseTableGridDataHookUp.this.myDisableRowId;
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(15);
            }
            this.prepareTableIfNeeded(source, () -> {
                source.phase = GridRequestSource.Phase.COUNT;
                DasObject table = DatabaseTableGridDataHookUp.this.getDatabaseTable();
                if (table == null || !DatabaseTableGridDataHookUp.this.isTwoPhaseRequest()) {
                    super.updateTotalRowCount(source);
                    return;
                }
                SelectTask task = this.selectTask(table).keysOnly(false).build(DbImplUtil.createBuilderForUIExec(DatabaseTableGridDataHookUp.this.getDatabaseDialect(), table));
                String unlimitedQuery = DmlUtilKt.dmlGenerator(DatabaseTableGridDataHookUp.this.getDbms()).generate(task).getStatement();
                this.updateTotalRowCount(source, unlimitedQuery);
            });
        }

        @Override
        protected void setTotalRowCount(@Nullable GridRequestSource source, int total) {
            int realPageEnd;
            boolean isFirstPhaseOfTwo = source != null && source.phase == GridRequestSource.Phase.FIRST && DatabaseTableGridDataHookUp.this.isTwoPhaseRequest();
            int n = realPageEnd = isFirstPhaseOfTwo ? DatabaseTableGridDataHookUp.this.getPageModel().getPageEnd() - 1 : DatabaseTableGridDataHookUp.this.getPageModel().getPageEnd();
            if ((long)total > DatabaseTableGridDataHookUp.this.getPageModel().getTotalRowCount() || realPageEnd == total) {
                ((MultiPageModel)DatabaseTableGridDataHookUp.this.getPageModel()).setTotalRowCount((long)total, realPageEnd >= total);
            }
        }

        @Override
        @Nullable
        protected OrderBy getOrderBy() {
            if (DatabaseTableGridDataHookUp.this.mySortingModel == null) {
                return null;
            }
            String text2 = DatabaseTableGridDataHookUp.this.mySortingModel.getAppliedSortingText();
            return StringUtil.isEmptyOrSpaces((String)text2) ? null : new PlainOrderBy(text2);
        }

        @Override
        protected WhereClause getWhereClause() {
            String filter2 = DatabaseTableGridDataHookUp.this.myFilteringModel.getAppliedText();
            boolean emptyFilter = StringUtil.isEmptyOrSpaces((String)filter2) || filter2.startsWith("--") || filter2.startsWith("#") || filter2.startsWith("//") || filter2.startsWith("/*");
            return emptyFilter ? null : new PlainWhereClause(filter2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareTable";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareTableIfNeeded";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareTable";
                    break;
                }
                case 3: 
                case 14: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumns";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFirstPage";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "loadLastPage";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "reloadCurrentPage";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "loadNextPage";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "loadPreviousPage";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFilterAndSorting";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "selectTask";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "updateTotalRowCount";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 14 -> new IllegalStateException(string);
            };
        }
    }
}

