/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.datagrid.AbstractGridSortingModel;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderByKt;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseSortingModel
extends AbstractGridSortingModel<GridRow, GridColumn> {
    private final Document myDocument;
    private String appliedSortingText;
    private final DatabaseGridDataHookUp myHookUp;

    DatabaseSortingModel(@NotNull DatabaseGridDataHookUp hookUp) {
        if (hookUp == null) {
            DatabaseSortingModel.$$$reportNull$$$0(0);
        }
        super(() -> DatabaseSettings.getSettings());
        this.myHookUp = hookUp;
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)hookUp.getSortingEmptyText());
        this.myHookUp.getModel(DataAccessType.DATA_WITH_MUTATIONS).addListener((GridModel.Listener)new GridModel.Listener<GridRow, GridColumn>(){

            public void columnsAdded(ModelIndexSet<GridColumn> columns2) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    DatabaseSortingModel.this.setAppliedOrdering(DatabaseSortingModel.parseOrdering(DatabaseSortingModel.this.myHookUp.getProject(), DatabaseSortingModel.this.myDocument, DatabaseSortingModel.this.myHookUp.getDataModel(), DatabaseSortingModel.this.myHookUp.getDbms()));
                    ((GridSortingModel.Listener)DatabaseSortingModel.this.getEventDispatcher().getMulticaster()).orderingChanged();
                });
            }

            public void columnsRemoved(ModelIndexSet<GridColumn> columns2) {
            }

            public void rowsAdded(ModelIndexSet<GridRow> rows) {
            }

            public void rowsRemoved(ModelIndexSet<GridRow> rows) {
            }

            public void cellsUpdated(ModelIndexSet<GridRow> rows, ModelIndexSet<GridColumn> columns2, @Nullable GridRequestSource.RequestPlace place) {
            }
        }, (Disposable)hookUp);
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            DatabaseSortingModel.$$$reportNull$$$0(1);
        }
        return document;
    }

    public boolean supportsAdditiveSorting() {
        return true;
    }

    public void setOrdering(@NotNull List<RowSortOrder<ModelIndex<GridColumn>>> ordering) {
        if (ordering == null) {
            DatabaseSortingModel.$$$reportNull$$$0(2);
        }
        super.setOrdering(ordering);
        ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)this.generateSortingText(ordering)));
    }

    @NotNull
    public String getAppliedSortingText() {
        return this.isSortingEnabled() ? this.appliedSortingText : "";
    }

    public void apply() {
        this.myOrdering = DatabaseSortingModel.parseOrdering(this.myHookUp.getProject(), this.myDocument, this.myHookUp.getDataModel(), this.myHookUp.getDbms());
        this.appliedSortingText = this.myDocument.getText().trim();
        this.addToHistory(this.appliedSortingText);
        super.apply();
    }

    private static List<RowSortOrder<ModelIndex<GridColumn>>> parseOrdering(@NotNull Project project, @NotNull Document document, @NotNull GridModel<GridRow, GridColumn> model2, @NotNull Dbms dbms) {
        if (project == null) {
            DatabaseSortingModel.$$$reportNull$$$0(3);
        }
        if (document == null) {
            DatabaseSortingModel.$$$reportNull$$$0(4);
        }
        if (model2 == null) {
            DatabaseSortingModel.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            DatabaseSortingModel.$$$reportNull$$$0(6);
        }
        if (model2.getColumnCount() == 0) {
            return Collections.emptyList();
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull(ExecutionEnvironmentHelper.EP.forDbms(dbms).getOrderByElements(psiFile), order2 -> {
            ModelIndex idx = GridUtilCore.findColumn((GridModel)model2, (String)((String)order2.getColumn()), (boolean)false);
            return idx.asInteger() == -1 ? null : (order2.getOrder() == RowSortOrder.Type.ASC ? RowSortOrder.asc((Object)idx) : RowSortOrder.desc((Object)idx));
        });
    }

    @NotNull
    private String generateSortingText(@NotNull List<RowSortOrder<ModelIndex<GridColumn>>> ordering) {
        if (ordering == null) {
            DatabaseSortingModel.$$$reportNull$$$0(7);
        }
        Dbms dbms = this.myHookUp.getDbms();
        ColumnsOrderBy orderBy = OrderByKt.orderBy(ordering, this.myHookUp.getModel(DataAccessType.DATABASE_DATA));
        DmlHelper dmlHelper = DmlUtilKt.dmlGenerator(dbms);
        if (orderBy == null) {
            String string = this.myHookUp.getSortingEmptyText();
            if (string == null) {
                DatabaseSortingModel.$$$reportNull$$$0(8);
            }
            return string;
        }
        DdlBuilder builder = DbImplUtilCore.createBuilderForUIExec(this.myHookUp.getDatabaseDialect(), this.myHookUp.getDatabaseTable());
        dmlHelper.generate(DmlTaskKt.orderBy(orderBy).build(builder));
        String string = builder.getStatement();
        if (string == null) {
            DatabaseSortingModel.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseSortingModel";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseSortingModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSortingText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setOrdering";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseOrdering";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateSortingText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 9 -> new IllegalStateException(string);
        };
    }
}

