/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.JdbcTemplateParser;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StatelessTextDecompositionBuilder
implements JdbcTemplateParser.EventProcessor {
    private final Builder myBuilder;
    private String myError;
    private final TextDecomposition.PatternFactory myPatternFactory;
    private final List<String> myPropSeparators;

    public static StatelessTextDecomposition.Node build(@NotNull String template, @NotNull TextDecomposition.PatternFactory patterns2) throws StatelessTextDecomposition.InvalidTemplateException {
        if (template == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(0);
        }
        if (patterns2 == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(1);
        }
        try {
            StatelessTextDecompositionBuilder builder = new StatelessTextDecompositionBuilder(template, patterns2);
            StatelessTextDecomposition.Node node2 = builder.getNode();
            StatelessTextDecomposition.FollowBuilder.buildFollow(node2);
            return node2;
        }
        catch (TemplateBuildingException | PatternSyntaxException e2) {
            throw new StatelessTextDecomposition.InvalidTemplateException(e2.getMessage(), e2);
        }
    }

    private StatelessTextDecompositionBuilder(@NotNull String template, @NotNull TextDecomposition.PatternFactory patterns2) {
        if (template == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(2);
        }
        if (patterns2 == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(3);
        }
        this.myBuilder = new Builder();
        this.myPropSeparators = new ArrayList<String>();
        this.myPatternFactory = patterns2;
        this.myBuilder.enter();
        if (!JdbcTemplateParser.parse(template, this)) {
            throw new TemplateBuildingException(this.myError);
        }
        this.myBuilder.leave();
    }

    @Override
    public void processString(@NotNull String s2) {
        if (s2 == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(4);
        }
        this.myBuilder.push(new StatelessTextDecomposition.TextNode(s2));
    }

    @Override
    public void processGroupStart() {
        this.myBuilder.enter();
    }

    @Override
    public void processGroupFinish() {
        this.myBuilder.leave();
    }

    @Override
    public void processOptionality() {
        this.myBuilder.optionalize();
    }

    @Override
    public void processNegation() {
        this.myBuilder.negate();
    }

    @Override
    public void processParameter(@Nullable String name2, @Nullable String type, @Nullable String defValue, @Nullable String configuration, @Nullable String quote) {
        String patternOverride;
        assert (type != null || name2 != null);
        String tgt = type == null ? name2 : type;
        int len = tgt.length();
        int patIdx = tgt.indexOf("/");
        if (patIdx == -1) {
            patIdx = len;
        }
        String string = patternOverride = patIdx < len ? tgt.substring(patIdx + 1) : null;
        if (patIdx < len) {
            tgt = tgt.substring(0, patIdx);
        }
        if (type != null) {
            type = tgt;
        } else {
            name2 = tgt;
        }
        this.pushParameter(name2, (String)ObjectUtils.chooseNotNull((Object)type, (Object)name2), patternOverride, defValue, configuration, quote);
    }

    @Override
    public void processError(@NotNull String error2) {
        if (error2 == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(5);
        }
        this.myError = error2;
    }

    @Override
    public void processListBranch(boolean mandatory) {
        this.myBuilder.leaveListBranch(mandatory);
        this.myBuilder.enter();
    }

    @Override
    public void processListStart(@NotNull String separator) {
        if (separator == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(6);
        }
        this.myPropSeparators.add(separator);
        this.myBuilder.enter();
        this.myBuilder.enter();
    }

    @Override
    public void processListFinish() {
        this.myBuilder.leaveListBranch(false);
        this.myBuilder.leaveList(this.myPropSeparators.remove(this.myPropSeparators.size() - 1));
    }

    @NotNull
    private Pattern getPatternOrThrow(@NotNull String type, @Nullable String configuration, @Nullable String patternOverride) {
        String typeClean;
        Pattern checkPattern;
        if (type == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(7);
        }
        if ((checkPattern = this.myPatternFactory.getPattern(typeClean = StatelessTextDecomposition.ParameterNode.clearTypeName(type), configuration, patternOverride)) == null) {
            throw new TemplateBuildingException("Invalid type name: " + typeClean);
        }
        Pattern pattern2 = checkPattern;
        if (pattern2 == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(8);
        }
        return pattern2;
    }

    private void pushParameter(@Nullable String name2, @NotNull String type, @Nullable String patternOverride, @Nullable String defValue, @Nullable String configuration, @Nullable String quote) {
        if (type == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(9);
        }
        Pattern pattern2 = this.getPatternOrThrow(type, configuration, patternOverride);
        StatelessTextDecomposition.QuoteHandler handler2 = null;
        if (quote != null && (handler2 = StatelessTextDecomposition.QuoteHandler.byName(quote)) == null) {
            throw new TemplateBuildingException("Unknown quote " + quote);
        }
        StatelessTextDecomposition.ParameterNode node2 = new StatelessTextDecomposition.ParameterNode(name2, type, defValue, configuration, handler2, pattern2);
        this.myBuilder.push(node2);
    }

    @NotNull
    private StatelessTextDecomposition.Node getNode() {
        StatelessTextDecomposition.Node node2 = this.myBuilder.getResult();
        if (node2 == null) {
            StatelessTextDecompositionBuilder.$$$reportNull$$$0(10);
        }
        return node2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternOrThrow";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processListStart";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPatternOrThrow";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "pushParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10 -> new IllegalStateException(string);
        };
    }

    public static class TemplateBuildingException
    extends RuntimeException {
        public TemplateBuildingException(@NotNull String msg) {
            if (msg == null) {
                TemplateBuildingException.$$$reportNull$$$0(0);
            }
            super(msg);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$TemplateBuildingException", "<init>"));
        }
    }

    private static class Builder {
        private final List<StatelessTextDecomposition.Node> myCurrentNodes = new ArrayList<StatelessTextDecomposition.Node>();
        private final IntStack myStack = new IntArrayList(3);

        private Builder() {
        }

        void push(@NotNull StatelessTextDecomposition.Node node2) {
            if (node2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myCurrentNodes.add(node2);
        }

        void enter() {
            this.myStack.push(this.myCurrentNodes.size());
        }

        private <N extends StatelessTextDecomposition.Node> N[] extractArray(int mark2, IntFunction<N[]> factory) {
            StatelessTextDecomposition.Node[] res2 = (StatelessTextDecomposition.Node[])factory.apply(this.myCurrentNodes.size() - mark2);
            for (int i2 = this.myCurrentNodes.size() - 1; i2 >= mark2; --i2) {
                res2[i2 - mark2] = this.myCurrentNodes.get(i2);
                this.myCurrentNodes.remove(i2);
            }
            return res2;
        }

        void leave() {
            int mark2 = this.myStack.popInt();
            assert (mark2 <= this.myCurrentNodes.size());
            if (this.myCurrentNodes.size() - mark2 > 1) {
                StatelessTextDecomposition.CompositeNode n = new StatelessTextDecomposition.CompositeNode(this.extractArray(mark2, StatelessTextDecomposition.Node[]::new));
                this.myCurrentNodes.add(n);
            }
        }

        void leaveListBranch(boolean mandatory) {
            int mark2 = this.myStack.topInt();
            this.leave();
            if (mark2 == this.myCurrentNodes.size() - 1) {
                this.myCurrentNodes.set(mark2, new StatelessTextDecomposition.ListChoiceNode(this.myCurrentNodes.get(mark2), mandatory));
            }
        }

        void leaveList(@NotNull String sep2) {
            if (sep2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            int mark2 = this.myStack.popInt();
            assert (mark2 <= this.myCurrentNodes.size());
            StatelessTextDecomposition.ListChoiceNode[] nodes = (StatelessTextDecomposition.ListChoiceNode[])this.extractArray(mark2, StatelessTextDecomposition.ListChoiceNode[]::new);
            if (nodes.length == 0) {
                throw new TemplateBuildingException("No choices in list");
            }
            StatelessTextDecomposition.ListNode n = new StatelessTextDecomposition.ListNode(new StatelessTextDecomposition.ListChoicesNode(nodes), sep2);
            this.myCurrentNodes.add(n);
        }

        void optionalize() {
            int size = this.myCurrentNodes.size();
            if (size > 0 && !(this.myCurrentNodes.get(size - 1) instanceof StatelessTextDecomposition.OptionalNode)) {
                StatelessTextDecomposition.Node node2 = this.myCurrentNodes.get(size - 1);
                this.myCurrentNodes.set(size - 1, new StatelessTextDecomposition.OptionalNode(node2));
            }
        }

        void negate() {
            int size = this.myCurrentNodes.size();
            if (size > 0) {
                StatelessTextDecomposition.Node node2 = this.myCurrentNodes.get(size - 1);
                this.myCurrentNodes.set(size - 1, new StatelessTextDecomposition.AntiNode(node2));
            }
        }

        void finish() {
            assert (this.myCurrentNodes.size() <= 1);
            if (this.myCurrentNodes.isEmpty()) {
                this.myCurrentNodes.add(new StatelessTextDecomposition.TextNode(""));
            }
        }

        @NotNull
        StatelessTextDecomposition.Node getResult() {
            this.finish();
            StatelessTextDecomposition.Node node2 = this.myCurrentNodes.get(0);
            if (node2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return node2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sep";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "push";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "leaveList";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

