/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterEditorModel
extends UrlEditorModelBase {
    private final Map<String, String> myParameters;
    private final List<JdbcUrlParser> myParsers;
    private final String myName;
    private int myActive;
    @NotNull
    private String myUrl;

    public ParameterEditorModel(@NotNull String name2, @NotNull Collection<StatelessJdbcUrlParser> parsers) {
        if (name2 == null) {
            ParameterEditorModel.$$$reportNull$$$0(0);
        }
        if (parsers == null) {
            ParameterEditorModel.$$$reportNull$$$0(1);
        }
        this.myActive = 0;
        this.myUrl = "";
        this.myParameters = new LinkedHashMap<String, String>(JBIterable.from(parsers).flatten(parser1 -> parser1.getParameterNames()).toMap(o2 -> ""));
        this.myParsers = new ArrayList<JdbcUrlParser>(parsers.size());
        for (StatelessJdbcUrlParser parser2 : parsers) {
            this.myParsers.add(parser2.createStateful());
        }
        this.myName = name2;
    }

    @Override
    @Nullable
    public StatelessParametersHolder getParametersHolderDelegate() {
        return this.getActiveParser();
    }

    public boolean commit(@Nullable Object arg) {
        if (this.getState() == UrlEditorModelBase.State.VALID) {
            return false;
        }
        boolean changed = this.chooseParser();
        return this.validate(changed |= this.updateActiveParser(), arg);
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            ParameterEditorModel.$$$reportNull$$$0(2);
        }
        if (this.myUrl.equals(url)) {
            return;
        }
        this.invalidate(UrlEditorModelBase.State.URL_CHANGED);
        this.myUrl = url;
    }

    @Override
    public void setParameter(@NotNull String param, @NotNull String value2) {
        String val;
        if (param == null) {
            ParameterEditorModel.$$$reportNull$$$0(3);
        }
        if (value2 == null) {
            ParameterEditorModel.$$$reportNull$$$0(4);
        }
        if ((val = this.myParameters.get(param)) == null || val.equals(value2)) {
            return;
        }
        this.invalidate(UrlEditorModelBase.State.PARAMS_CHANGED);
        this.myParameters.put(param, value2);
    }

    @Nullable
    JdbcUrlParser getActiveParser() {
        return this.myParsers.isEmpty() ? null : this.myParsers.get(this.myActive);
    }

    private boolean updateActiveParser() {
        if (this.getActiveParser() == null) {
            return UrlEditorModelBase.State.URL_CHANGED == this.getState();
        }
        boolean changed = false;
        if (this.getState() == UrlEditorModelBase.State.PARAMS_CHANGED) {
            for (Map.Entry<String, String> entry : this.myParameters.entrySet()) {
                if (entry.getValue().equals(this.getActiveParser().getParameter(entry.getKey()))) continue;
                this.getActiveParser().setParameter(entry.getKey(), entry.getValue());
                changed = true;
            }
            String newUrl = this.getActiveParser().getUrlText();
            if (!this.myUrl.equals(newUrl)) {
                this.myUrl = newUrl;
                changed = true;
            }
        } else if (this.getState() == UrlEditorModelBase.State.URL_CHANGED) {
            if (!this.myUrl.equals(this.getActiveParser().getUrlText())) {
                this.getActiveParser().setUrlTextTolerantly(this.myUrl);
                changed = true;
            }
            for (Map.Entry<String, String> entry : this.myParameters.entrySet()) {
                String newVal = StringUtil.notNullize((String)this.getActiveParser().getParameter(entry.getKey()));
                if (entry.getValue().equals(newVal)) continue;
                this.myParameters.put(entry.getKey(), newVal);
                changed = true;
            }
        }
        return changed;
    }

    @Nullable
    public StatelessJdbcUrlParser getMeaningfulParser(@NotNull String url) {
        if (url == null) {
            ParameterEditorModel.$$$reportNull$$$0(5);
        }
        for (JdbcUrlParser parser2 : this.myParsers) {
            if (!parser2.isUrlValueValid(url)) continue;
            return parser2;
        }
        return null;
    }

    private boolean chooseParser() {
        block6: {
            block5: {
                if (this.getActiveParser() == null) {
                    return false;
                }
                if (this.getState() != UrlEditorModelBase.State.URL_CHANGED) break block5;
                if (this.getActiveParser().isUrlValueValid(this.myUrl)) {
                    return false;
                }
                for (int i2 = 0; i2 < this.myParsers.size(); ++i2) {
                    if (i2 == this.myActive || !this.myParsers.get(i2).isUrlValueValid(this.myUrl)) continue;
                    this.myActive = i2;
                    return true;
                }
                break block6;
            }
            if (this.getState() != UrlEditorModelBase.State.PARAMS_CHANGED) break block6;
            if (JdbcUrlParserUtil.areParametersValidFor(this.getActiveParser(), this.myParameters)) {
                return false;
            }
            for (int i3 = 0; i3 < this.myParsers.size(); ++i3) {
                if (i3 == this.myActive || !JdbcUrlParserUtil.areParametersValidFor(this.myParsers.get(i3), this.myParameters)) continue;
                this.myActive = i3;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getUrl() {
        assert (this.getState() != UrlEditorModelBase.State.PARAMS_CHANGED);
        String string = this.myUrl;
        if (string == null) {
            ParameterEditorModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isUrlValueValid(@NotNull String url) {
        if (url == null) {
            ParameterEditorModel.$$$reportNull$$$0(7);
        }
        if (this.getActiveParser() == null || this.getActiveParser().isUrlValueValid(url)) {
            return true;
        }
        for (int i2 = 0; i2 < this.myParsers.size(); ++i2) {
            if (i2 == this.myActive || !this.myParsers.get(i2).isUrlValueValid(url)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ParameterEditorModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public String getParameter(@NotNull String param) {
        if (param == null) {
            ParameterEditorModel.$$$reportNull$$$0(9);
        }
        assert (this.getState() != UrlEditorModelBase.State.URL_CHANGED);
        return this.myParameters.get(param);
    }

    @NotNull
    public Collection<TextRange> getInvalidRanges() {
        List<TextRange> list = this.getActiveParser() == null ? Collections.emptyList() : this.getActiveParser().getInvalidRanges();
        if (list == null) {
            ParameterEditorModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public TextRange getParameterRange(@NotNull String param) {
        if (param == null) {
            ParameterEditorModel.$$$reportNull$$$0(11);
        }
        return this.getActiveParser() == null ? null : this.getActiveParser().getParameterRange(param);
    }

    public boolean isParserValid() {
        return this.getActiveParser() == null || this.getActiveParser().isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsers";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/ParameterEditorModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/ParameterEditorModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setParameter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMeaningfulParser";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUrlValueValid";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParameterRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

