/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.google.common.base.Objects;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.KeepAliveActionDescriptor;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionManager;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.SearchWebAction;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.awt.Color;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 A2\u00020\u0001:\u0007ABCDEFGB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0002J4\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0015\u0010%\u001a\u00070\t\u00a2\u0006\u0002\b&2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010'\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010\tJ\u0018\u0010)\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020*H\u0002J\u001a\u0010+\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010(\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010,\u001a\u00020\u0015H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020.H\u0002J&\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u00101\u001a\u00020\u0015J,\u00102\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u001fH\u0002J\u0016\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020:2\u0006\u0010\u0013\u001a\u00020\nJ\u0015\u0010;\u001a\u00070<\u00a2\u0006\u0002\b=2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u001e\u0010>\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\b\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010?\u001a\u00020\u001fJ\u0010\u0010@\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\nH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bj\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager;", "", "configurable", "Lcom/intellij/database/dataSource/DataSourceConfigurable;", "(Lcom/intellij/database/dataSource/DataSourceConfigurable;)V", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "cached", "Ljava/util/HashMap;", "", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestInfo;", "Lkotlin/collections/HashMap;", "getConfigurable", "()Lcom/intellij/database/dataSource/DataSourceConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "actionsChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "kotlin.jvm.PlatformType", "info", "applyTestConnectionResult", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "r", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "e", "", "areArtifactsValid", "", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "createBalloon", "description", "detailsChunk", "detailsHtml", "Lcom/intellij/openapi/util/NlsContexts$PopupContent;", "getInfo", "sessionTemplateId", "handleDetailsLink", "Ljavax/swing/event/HyperlinkEvent;", "handleIncompleteConfiguration", "hideDetails", "manuallySpecifyDbVersion", "Lcom/intellij/database/dataSource/DataSourceInfo;", "performTestConnection", "Lcom/intellij/database/util/AsyncTask;", "resetStatus", "setStatus", "status", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "cancel", "showDetails", "pt", "Lcom/intellij/ui/awt/RelativePoint;", "statusChunk", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "Lorg/jetbrains/annotations/NotNull;", "testConnection", "checkConfiguration", "update", "Companion", "Listener", "ProcessedTestConnectionResult", "Status", "TestConnectionInProgress", "TestConnectionResult", "TestInfo", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceTestConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceTestConnectionManager.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,560:1\n1#2:561\n*E\n"})
public final class DataSourceTestConnectionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSourceConfigurable configurable;
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<String, TestInfo> cached;
    @Nullable
    private volatile Balloon balloon;
    @NotNull
    private static final Topic<Listener> TOPIC = new Topic("DataSourceTestConnectionManager.Listener", Listener.class);

    public DataSourceTestConnectionManager(@NotNull DataSourceConfigurable configurable) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        this.configurable = configurable;
        Project project = this.configurable.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.cached = new HashMap();
    }

    @NotNull
    public final DataSourceConfigurable getConfigurable() {
        return this.configurable;
    }

    @Nullable
    public final AsyncTask<?> testConnection(@Nullable String sessionTemplateId, boolean checkConfiguration) {
        DatabaseConnectionConfig config;
        TestInfo testInfo = this.cached.computeIfAbsent(sessionTemplateId, arg_0 -> DataSourceTestConnectionManager.testConnection$lambda$0(testConnection.info.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)testInfo, (String)"computeIfAbsent(...)");
        TestInfo info2 = testInfo;
        this.setStatus(info2, null, null, true);
        LocalDataSource localDataSource = this.configurable.getTempDataSourceForConnection();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getTempDataSourceForConnection(...)");
        LocalDataSource tempDataSource = localDataSource;
        info2.setInfo(tempDataSource.getInfo().copy());
        if (checkConfiguration && !this.areArtifactsValid(tempDataSource) && !this.handleIncompleteConfiguration(tempDataSource, sessionTemplateId)) {
            return null;
        }
        CharSequence charSequence = tempDataSource.getUrl();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Messages.showErrorDialog((String)DatabaseBundle.message("message.text.specify.database.url", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.connect", new Object[0]));
            this.configurable.getUrlEditor().requestUrlFocus();
            return null;
        }
        if (sessionTemplateId != null) {
            Object v3;
            block6: {
                List<DataSourceSessionTemplate> list = tempDataSource.getSessionTemplates();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getSessionTemplates(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    DataSourceSessionTemplate it2 = (DataSourceSessionTemplate)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getTemplateId(), (Object)sessionTemplateId)) continue;
                    v3 = t;
                    break block6;
                }
                v3 = null;
            }
            v4 = v3;
        } else {
            v4 = config = (DatabaseConnectionConfig)tempDataSource;
        }
        if (config == null) {
            return null;
        }
        this.configurable.hidePasswords();
        DatabaseAuthProvider prevAuthProvider = DatabaseAuthProvider.Companion.get(config);
        Object prevCredentials = prevAuthProvider.loadAuthConfig(config, this.configurable.getSecretService(), true);
        LocalDataSource localDataSource2 = tempDataSource.copy(true);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource2, (String)"copy(...)");
        LocalDataSource prevDs = localDataSource2;
        ErrorHandler handler2 = new ErrorHandler();
        AsyncTask<TestConnectionResult> testResult = this.performTestConnection(config, info2, handler2);
        return testResult.whenComplete((Executor)EdtExecutorService.getInstance(), (arg_0, arg_1) -> DataSourceTestConnectionManager.testConnection$lambda$2((Function2)new Function2<TestConnectionResult, Throwable, Unit>(handler2, config, prevDs, tempDataSource, this, prevAuthProvider, prevCredentials, info2){
            final /* synthetic */ ErrorHandler $handler;
            final /* synthetic */ DatabaseConnectionConfig $config;
            final /* synthetic */ LocalDataSource $prevDs;
            final /* synthetic */ LocalDataSource $tempDataSource;
            final /* synthetic */ DataSourceTestConnectionManager this$0;
            final /* synthetic */ DatabaseAuthProvider $prevAuthProvider;
            final /* synthetic */ Object $prevCredentials;
            final /* synthetic */ TestInfo $info;
            {
                this.$handler = $handler;
                this.$config = $config;
                this.$prevDs = $prevDs;
                this.$tempDataSource = $tempDataSource;
                this.this$0 = $receiver;
                this.$prevAuthProvider = $prevAuthProvider;
                this.$prevCredentials = $prevCredentials;
                this.$info = $info;
                super(2);
            }

            public final void invoke(@Nullable TestConnectionResult r, @Nullable Throwable e2) {
                boolean eqCredentials;
                AsyncUtil.addUnhandledError(this.$handler, e2, this.$config.getDataSource());
                if (!this.$prevDs.equalConfiguration(this.$tempDataSource)) {
                    this.this$0.getConfigurable().reset(this.$tempDataSource, false);
                }
                if (eqCredentials = Intrinsics.areEqual((Object)DatabaseAuthProvider.Companion.get(this.$config), (Object)this.$prevAuthProvider)) {
                    Object curCredentials = this.$prevAuthProvider.loadAuthConfig(this.$config, this.this$0.getConfigurable().getSecretService(), true);
                    eqCredentials = Objects.equal((Object)curCredentials, (Object)this.$prevCredentials);
                }
                if (!eqCredentials) {
                    this.this$0.getConfigurable().reloadCredentials();
                }
                DataSourceTestConnectionManager.access$applyTestConnectionResult(this.this$0, this.$config, this.$info, this.$handler, r, e2);
            }
        }, arg_0, arg_1));
    }

    private final boolean handleIncompleteConfiguration(LocalDataSource ds, String sessionTemplateId) {
        String[] stringArray = (String[])ds.getUrl();
        if (stringArray == null || StringsKt.isBlank((CharSequence)stringArray)) {
            stringArray = new String[]{Messages.getOkButton()};
            Messages.showDialog((Project)this.project, (String)DatabaseBundle.message("DataSourceConfigurable.no.url", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.incomplete", new Object[0]), (String[])stringArray, (int)0, (Icon)Messages.getErrorIcon());
            return false;
        }
        if (!this.areArtifactsValid(ds)) {
            Object v2;
            List artifacts;
            DatabaseDriver driver2;
            block9: {
                DatabaseDriver databaseDriver = driver2 = ds.getDatabaseDriver();
                List list = databaseDriver != null ? databaseDriver.getArtifacts() : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                if ((artifacts = list).isEmpty()) {
                    int res2 = Messages.showYesNoDialog((Project)this.project, (String)DatabaseBundle.message("DataSourceConfigurable.no.driver.files", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.incomplete", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.configure.driver", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon());
                    if (driver2 != null && res2 == 0) {
                        this.configurable.getController().navigateTo(driver2, true);
                    }
                    return false;
                }
                Iterable iterable = artifacts;
                for (Object object : iterable) {
                    DatabaseDriver.ArtifactRef it2 = (DatabaseDriver.ArtifactRef)object;
                    boolean bl = false;
                    if (!(DatabaseArtifactManager.resolveVersion(driver2, it2) == null)) continue;
                    v2 = object;
                    break block9;
                }
                v2 = null;
            }
            DatabaseDriver.ArtifactRef invalidArtifact = v2;
            if (invalidArtifact != null) {
                int res3 = Messages.showYesNoDialog((Project)this.project, (String)DatabaseBundle.message("DataSourceConfigurable.invalid.provided", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.incomplete", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.configure.driver", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon());
                if (res3 == 0) {
                    this.configurable.getController().navigateTo(driver2, true);
                }
                return false;
            }
            DatabaseArtifactList databaseArtifactList = DatabaseArtifactManager.getArtifacts();
            DatabaseDriver databaseDriver = driver2;
            Intrinsics.checkNotNull((Object)databaseDriver);
            boolean downloaded = DatabaseDriverUtils.isDriverFilesUpToDate(databaseArtifactList, databaseDriver, artifacts);
            int res4 = Messages.showYesNoDialog((Project)this.project, (String)DatabaseBundle.message(downloaded ? "DataSourceConfigurable.drivers.not.configured" : "DataSourceConfigurable.drivers.not.downloaded", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.incomplete", new Object[0]), (String)DatabaseBundle.message(downloaded ? "DataSourceConfigurable.switch.to.latest" : "DataSourceConfigurable.download.driver", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon());
            if (res4 == 0) {
                Object object;
                NamedProgressive namedProgressive = DatabaseDriverValidator.createDownloaderTask(ds, this.configurable.getController());
                Intrinsics.checkNotNullExpressionValue((Object)namedProgressive, (String)"createDownloaderTask(...)");
                NamedProgressive task = namedProgressive;
                object = this.project;
                String string = task.getName();
                new Task.Modal(task, this, sessionTemplateId, (Project)object, string){
                    final /* synthetic */ NamedProgressive $task;
                    final /* synthetic */ DataSourceTestConnectionManager this$0;
                    final /* synthetic */ String $sessionTemplateId;
                    {
                        this.$task = $task;
                        this.this$0 = $receiver;
                        this.$sessionTemplateId = $sessionTemplateId;
                        super($super_call_param$1, $super_call_param$2, true);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        this.$task.run(indicator);
                    }

                    public void onSuccess() {
                        ApplicationManager.getApplication().invokeLater(() -> handleIncompleteConfiguration.1.onSuccess$lambda$0(this.this$0, this.$sessionTemplateId));
                    }

                    private static final void onSuccess$lambda$0(DataSourceTestConnectionManager this$0, String $sessionTemplateId) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        this$0.testConnection($sessionTemplateId, true);
                    }
                }.queue();
                return false;
            }
        }
        return false;
    }

    private final boolean areArtifactsValid(LocalDataSource ds) {
        DatabaseDriver driver2 = ds.getDatabaseDriver();
        return driver2 != null && DatabaseDriverUtils.isDriverFilesValid(DatabaseArtifactManager.getArtifacts(), driver2.getArtifacts(), (Collection<SimpleClasspathElement>)ds.getOwnClasspath());
    }

    private final AsyncTask<TestConnectionResult> performTestConnection(DatabaseConnectionConfig config, TestInfo info2, ErrorHandler handler2) {
        DatabaseCredentials databaseCredentials = this.configurable.getSecretService();
        Intrinsics.checkNotNullExpressionValue((Object)databaseCredentials, (String)"getSecretService(...)");
        TestConnectionInProgress result2 = Companion.performTestConnection(this.project, config, databaseCredentials, handler2, true);
        this.setStatus(info2, null, result2.getIndicator(), true);
        return result2.getTask();
    }

    private final void applyTestConnectionResult(DatabaseConnectionConfig config, TestInfo info2, ErrorHandler handler2, TestConnectionResult r, Throwable e2) {
        ProcessedTestConnectionResult processed;
        if (AsyncUtil.isCancellation(e2) && !handler2.hasErrors()) {
            this.setStatus(info2, null, null, false);
            return;
        }
        ProcessedTestConnectionResult $this$applyTestConnectionResult_u24lambda_u244 = processed = Companion.processTestConnectionResult(r, config, handler2);
        boolean bl = false;
        boolean specifyVersion = $this$applyTestConnectionResult_u24lambda_u244.getState() == ThreeState.YES && Version.ZERO.eqCoarse(config.getDataSource().getVersion()) && $this$applyTestConnectionResult_u24lambda_u244.getFixes().isEmpty();
        ProcessedTestConnectionResult $this$applyTestConnectionResult_u24lambda_u245 = processed;
        boolean bl2 = false;
        Status status = new Status($this$applyTestConnectionResult_u24lambda_u245.getState(), $this$applyTestConnectionResult_u24lambda_u245.getDataSourceInfo(), $this$applyTestConnectionResult_u24lambda_u245.getStateText(), $this$applyTestConnectionResult_u24lambda_u245.getSummary(), $this$applyTestConnectionResult_u24lambda_u245.getFixes(), specifyVersion);
        this.setStatus(info2, status, null, false);
        info2.setInfo(config.getDataSource().getInfo().copy());
        this.configurable.updateDatabaseInfo(config.getDataSource());
        this.configurable.getController().refresh();
    }

    private final void setStatus(TestInfo info2, Status status, ProgressIndicator indicator, boolean cancel2) {
        info2.setStatus(status);
        if (cancel2) {
            ProgressIndicator progressIndicator = info2.getIndicator();
            if (progressIndicator != null) {
                progressIndicator.cancel();
            }
            info2.setIndicator(null);
        }
        if (indicator != null) {
            info2.setIndicator(indicator);
        }
        this.update(info2);
    }

    private final void update(TestInfo info2) {
        ProgressIndicator it2 = info2.getIndicator();
        boolean bl = false;
        boolean bl2 = it2 != null && !it2.isRunning();
        if (bl2) {
            info2.setIndicator(null);
        }
        this.configurable.onTestConnectionUpdate(info2);
    }

    private final void hideDetails() {
        block0: {
            Balloon prev = this.balloon;
            this.balloon = null;
            Balloon balloon = prev;
            if (balloon == null) break block0;
            balloon.hide();
        }
    }

    public final void showDetails(@NotNull RelativePoint pt, @NotNull TestInfo info2) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.hideDetails();
        Balloon tmp = this.createBalloon(info2);
        tmp.show(pt, Balloon.Position.above);
        this.balloon = tmp;
    }

    @NotNull
    public final Balloon createBalloon(@NotNull TestInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.detailsHtml(info2), null, UIUtil.getLabelTextForeground(), UIUtil.getPanelBackground(), arg_0 -> DataSourceTestConnectionManager.createBalloon$lambda$7(this, info2, arg_0)).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon tmp = balloon;
        return tmp;
    }

    private final String detailsHtml(TestInfo info2) {
        String string = HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)this.statusChunk(info2).wrapWith("td")).child((HtmlChunk)this.actionsChunk(info2).wrapWith("td").style("text-align: right"))).child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)this.detailsChunk(info2).wrapWith("td").attr("colspan", "2"))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final HtmlChunk detailsChunk(TestInfo info2) {
        Status status = info2.getStatus();
        if (status == null) {
            String string = DataSourceUtil.formatDataSourceInfoString(this.configurable.getTempDataSource());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDataSourceInfoString(...)");
            status = new Status(ThreeState.NO, string, "", null, CollectionsKt.emptyList(), false, 32, null);
        }
        return status.asHtml();
    }

    private final HtmlChunk.Element statusChunk(TestInfo info2) {
        String string;
        if (info2.getStatus() != null) {
            Status status = info2.getStatus();
            Intrinsics.checkNotNull((Object)status);
            string = status.getStateText();
        } else if (info2.getIndicator() != null) {
            String string2 = DatabaseBundle.message("test.connection.status.in.progress", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = DatabaseBundle.message("test.connection.status.last.known", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        HtmlChunk.Element element2 = HtmlChunk.text((String)string).bold();
        Status status = info2.getStatus();
        Object object = status != null ? status.getFail() : null;
        HtmlChunk.Element element3 = element2.style("color: " + ColorUtil.toHtmlColor((Color)(switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> (Color)JBColor.RED;
            case 2 -> JBColor.ORANGE.getDarkVariant();
            case 3 -> (Color)DatabaseConfigSideTab.DIM_GREEN;
            default -> (Color)JBColor.GRAY;
        })));
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"style(...)");
        return element3;
    }

    private final HtmlChunk actionsChunk(TestInfo info2) {
        HtmlBuilder htmlBuilder;
        HtmlBuilder $this$actionsChunk_u24lambda_u248 = htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        $this$actionsChunk_u24lambda_u248.appendRaw("&emsp;&emsp;");
        if (info2.getIndicator() != null) {
            $this$actionsChunk_u24lambda_u248.appendLink("cancel", DatabaseBundle.message("test.connection.action.cancel", new Object[0]));
            $this$actionsChunk_u24lambda_u248.appendRaw("&emsp;");
        }
        $this$actionsChunk_u24lambda_u248.appendLink("copy", DatabaseBundle.message("test.connection.action.copy", new Object[0]));
        Status status = info2.getStatus();
        if ((status != null ? status.getFail() : null) == ThreeState.YES) {
            $this$actionsChunk_u24lambda_u248.appendRaw("&emsp;");
            $this$actionsChunk_u24lambda_u248.appendLink("search", DatabaseBundle.message("test.connection.action.search.error", new Object[0]));
            $this$actionsChunk_u24lambda_u248.appendRaw("&emsp;");
            $this$actionsChunk_u24lambda_u248.appendLink("troubleshooting", DatabaseBundle.message("DataSourceTestConnectionPanel.troubleshooting", new Object[0]));
        }
        return htmlBuilder.toFragment();
    }

    /*
     * Unable to fully structure code
     */
    private final boolean handleDetailsLink(TestInfo info, HyperlinkEvent e) {
        block18: {
            block14: {
                block16: {
                    block17: {
                        block15: {
                            if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                                return false;
                            }
                            var3_3 = e.getDescription();
                            if (var3_3 == null) break block14;
                            switch (var3_3.hashCode()) {
                                case -1367724422: {
                                    if (!var3_3.equals("cancel")) {
                                        ** break;
                                    }
                                    break block15;
                                }
                                case -906336856: {
                                    if (var3_3.equals("search")) break;
                                    ** break;
                                }
                                case -350764011: {
                                    if (!var3_3.equals("edit-version")) {
                                        ** break;
                                    }
                                    break block16;
                                }
                                case -1272712614: {
                                    if (!var3_3.equals("troubleshooting")) {
                                        ** break;
                                    }
                                    break block17;
                                }
                                case 3059573: {
                                    if (!var3_3.equals("copy")) ** break;
                                    CopyPasteManager.copyTextToClipboard((String)this.description(info));
                                    break block18;
                                }
                            }
                            SearchWebAction.search((String)this.description(info));
                            break block18;
                        }
                        v0 = info.getIndicator();
                        if (v0 != null) {
                            v0.cancel();
                        }
                        break block18;
                    }
                    DataSourceUiUtil.showTroubleshooting();
                    break block18;
                }
                this.manuallySpecifyDbVersion(info);
                break block18;
            }
            v1 = info.getStatus();
            if (v1 != null) {
                v2 = e.getDescription();
                v3 = this.configurable.getController();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getController(...)");
                v4 = v1.handleLink(v2, this.project, v3);
            } else {
                v4 = false;
            }
            return v4;
        }
        return true;
    }

    private final void manuallySpecifyDbVersion(TestInfo info2) {
        DataSourceInfo dsInfo = this.configurable.getDatabaseInfo();
        info2.setInfo(dsInfo);
        Intrinsics.checkNotNull((Object)dsInfo);
        if (this.manuallySpecifyDbVersion(this.project, dsInfo)) {
            this.configurable.updateDatabaseInfo(dsInfo);
            this.configurable.onTestConnectionUpdate(info2);
            this.configurable.getController().refresh();
        }
    }

    private final boolean manuallySpecifyDbVersion(Project project, DataSourceInfo info2) {
        boolean bl;
        Version initial = info2.getExactVersion();
        if (Intrinsics.areEqual((Object)initial, (Object)Version.ZERO)) {
            initial = null;
        }
        Version version = initial;
        String string = Messages.showInputDialog((Project)project, (String)DatabaseBundle.message("dialog.message.enter.database.version", new Object[0]), (String)DatabaseBundle.message("dialog.title.database.version", new Object[0]), null, (String)(version != null ? version.toString() : null), (InputValidator)new InputValidator(){

            public boolean checkInput(@NotNull String inputString) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                try {
                    Version.of(inputString);
                    bl = true;
                }
                catch (Exception e2) {
                    bl = false;
                }
                return bl;
            }

            public boolean canClose(@NotNull String inputString) {
                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                return true;
            }
        });
        if (string == null) {
            return false;
        }
        String verStr2 = string;
        try {
            Version ver = Version.of(verStr2);
            info2.setDatabaseVersion(ver);
            bl = true;
        }
        catch (Exception e2) {
            bl = false;
        }
        return bl;
    }

    private final String description(TestInfo info2) {
        Object object = info2.getStatus();
        if (object == null || (object = ((Status)object).describe()) == null) {
            String string = DataSourceUtil.formatDataSourceInfoString((LocalDataSource)this.configurable.getDataSource());
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDataSourceInfoString(...)");
        }
        return object;
    }

    @NotNull
    public final TestInfo getInfo(@Nullable String sessionTemplateId) {
        TestInfo testInfo = this.cached.computeIfAbsent(sessionTemplateId, arg_0 -> DataSourceTestConnectionManager.getInfo$lambda$9(getInfo.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)testInfo, (String)"computeIfAbsent(...)");
        return testInfo;
    }

    public final void resetStatus() {
        for (TestInfo value2 : this.cached.values()) {
            Intrinsics.checkNotNull((Object)value2);
            this.setStatus(value2, null, null, false);
        }
    }

    private static final TestInfo testConnection$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TestInfo)$tmp0.invoke(p0);
    }

    private static final void testConnection$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void createBalloon$lambda$7(DataSourceTestConnectionManager this$0, TestInfo $info, HyperlinkEvent it2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$info, (String)"$info");
        Intrinsics.checkNotNull((Object)it2);
        if (this$0.handleDetailsLink($info, it2)) {
            this$0.hideDetails();
        }
    }

    private static final TestInfo getInfo$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TestInfo)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$applyTestConnectionResult(DataSourceTestConnectionManager $this, DatabaseConnectionConfig config, TestInfo info2, ErrorHandler handler2, TestConnectionResult r, Throwable e2) {
        $this.applyTestConnectionResult(config, info2, handler2, r, e2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0015\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J'\u0010\u0014\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001f\u0010\u0019\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u001a\u001a\u00020\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0016J \u0010&\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u000eH\u0002J \u0010(\u001a\u00020)2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006+"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Companion;", "", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Listener;", "kotlin.jvm.PlatformType", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "addWarningsAndErrors", "", "handler", "Lcom/intellij/database/util/ErrorHandler;", "testConnectionResult", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "createSuccessSummary", "", "Lorg/jetbrains/annotations/Nls;", "createSummary", "failed", "", "getState", "Lcom/intellij/util/ThreeState;", "getTextForState", "state", "handleWarnings", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "r", "performTestConnection", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionInProgress;", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "askPassword", "pingDatabase", "result", "processTestConnectionResult", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$ProcessedTestConnectionResult;", "testConnection", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDataSourceTestConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceTestConnectionManager.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StringFun.kt\ncom/intellij/database/util/common/StringFun\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,560:1\n1855#2,2:561\n1549#2:565\n1620#2,3:566\n133#3:563\n1#4:564\n*S KotlinDebug\n*F\n+ 1 DataSourceTestConnectionManager.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Companion\n*L\n235#1:561,2\n299#1:565\n299#1:566,3\n255#1:563\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<Listener> getTOPIC() {
            return TOPIC;
        }

        @NotNull
        public final ProcessedTestConnectionResult processTestConnectionResult(@Nullable TestConnectionResult testConnectionResult, @NotNull DatabaseConnectionConfig config, @NotNull ErrorHandler handler2) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            boolean failed = handler2.hasErrors();
            this.addWarningsAndErrors(handler2, testConnectionResult, config);
            String summary = this.createSummary(handler2, testConnectionResult, failed);
            ThreeState state = this.getState(handler2, testConnectionResult);
            String stateText = this.getTextForState(state, testConnectionResult);
            String string = DataSourceUtil.formatDataSourceInfoString(config.getDataSource());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDataSourceInfoString(...)");
            String dataSourceInfo = string;
            List list = handler2.getFixes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFixes(...)");
            return new ProcessedTestConnectionResult(state, dataSourceInfo, stateText, summary, list);
        }

        @NotNull
        public final TestConnectionInProgress performTestConnection(@NotNull Project project, @NotNull DatabaseConnectionConfig config, @NotNull DatabaseCredentials credentials, @NotNull ErrorHandler handler2, boolean askPassword) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            Listener publisher = (Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(this.getTOPIC());
            publisher.started(project, config);
            String string = DatabaseBundle.message("message.text.connection.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            AsyncTask.Frame frame = AsyncTask.Companion.withBgIndicatorIfNeeded(AsyncTask.Companion.frame(string), project, null);
            ProgressIndicator indicator = AsyncUtil.getIfAsyncFriendly(AsyncTask.Companion.getIndicator(frame));
            AsyncTask<TestConnectionResult> task = frame.computeAsync(AppExecutorUtil.getAppExecutorService(), () -> Companion.performTestConnection$lambda$1(project, config, askPassword, credentials, handler2));
            task.whenComplete(null, (arg_0, arg_1) -> Companion.performTestConnection$lambda$2((Function2)new Function2<TestConnectionResult, Throwable, Unit>(publisher, project, config){
                final /* synthetic */ Listener $publisher;
                final /* synthetic */ Project $project;
                final /* synthetic */ DatabaseConnectionConfig $config;
                {
                    this.$publisher = $publisher;
                    this.$project = $project;
                    this.$config = $config;
                    super(2);
                }

                public final void invoke(@Nullable TestConnectionResult r, @Nullable Throwable th) {
                    this.$publisher.finished(this.$project, this.$config, r, th);
                }
            }, arg_0, arg_1));
            return new TestConnectionInProgress(task, indicator);
        }

        private final void addWarningsAndErrors(ErrorHandler handler2, TestConnectionResult testConnectionResult, DatabaseConnectionConfig config) {
            block3: {
                Object object;
                Object object2 = testConnectionResult;
                if (object2 != null && (object2 = ((TestConnectionResult)object2).getWarnings()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ErrorInfo it2 = (ErrorInfo)element$iv;
                        boolean bl = false;
                        handler2.add(it2);
                    }
                }
                if ((object = testConnectionResult) == null || (object = ((TestConnectionResult)object).getKeepAliveError()) == null) break block3;
                Object it3 = object;
                boolean bl = false;
                LocalDataSource localDataSource = config.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                handler2.add(DatabaseConnectionManager.Companion.getSpecialErrorInfo((Throwable)it3, localDataSource));
                DatabaseFixFactory databaseFixFactory = DatabaseFixFactory.getInstance();
                if (databaseFixFactory != null) {
                    DatabaseFixFactory databaseFixFactory2;
                    DatabaseFixFactory $this$addWarningsAndErrors_u24lambda_u245_u24lambda_u244 = databaseFixFactory2 = databaseFixFactory;
                    boolean bl2 = false;
                    handler2.getFixes().add($this$addWarningsAndErrors_u24lambda_u245_u24lambda_u244.changeKeepAliveQuery(config.getDatabaseDriver()));
                }
            }
        }

        private final String createSummary(ErrorHandler handler2, TestConnectionResult testConnectionResult, boolean failed) {
            Object summary = "";
            if (!failed && testConnectionResult != null) {
                summary = (String)summary + this.createSuccessSummary(testConnectionResult);
            }
            if (handler2.hasErrors()) {
                CharSequence $this$isNotNullOrEmpty$iv = (CharSequence)summary;
                boolean $i$f$isNotNullOrEmpty = false;
                boolean bl = $this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0;
                if (bl) {
                    summary = (String)summary + "\n\n";
                }
                summary = (String)summary + handler2.getSummary();
            }
            return summary;
        }

        private final String createSuccessSummary(TestConnectionResult testConnectionResult) {
            Object[] objectArray = new Object[]{NlsMessages.formatDuration((long)testConnectionResult.getPing()), !testConnectionResult.getKeepAliveResult() ? 0 : 1, testConnectionResult.getSslState() == null ? "" : StringUtil.toLowerCase((String)String.valueOf(testConnectionResult.getSslState())), testConnectionResult.getSslState() != null && testConnectionResult.getSslState() != ThreeState.UNSURE ? 0 : 1};
            String string = DatabaseBundle.message("text.ping.choice.keep.alive.query.results.in.error.choice.ssl", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        private final ThreeState getState(ErrorHandler handler2, TestConnectionResult testConnectionResult) {
            ThreeState threeState;
            if (handler2.hasErrors()) {
                threeState = ThreeState.YES;
            } else {
                boolean bl;
                TestConnectionResult testConnectionResult2 = testConnectionResult;
                if (testConnectionResult2 != null) {
                    TestConnectionResult it2 = testConnectionResult2;
                    boolean bl2 = false;
                    boolean bl3 = it2.getKeepAliveResult() && it2.getWarnings().isEmpty();
                    bl = !bl3;
                } else {
                    bl = false;
                }
                threeState = bl ? ThreeState.UNSURE : ThreeState.NO;
            }
            return threeState;
        }

        private final String getTextForState(ThreeState state, TestConnectionResult testConnectionResult) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    String string2 = DatabaseBundle.message("test.connection.status.failed", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    break;
                }
                case 2: {
                    String string3 = DatabaseBundle.message("test.connection.status.succeeded", new Object[0]);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    break;
                }
                default: {
                    String string4;
                    Object[] objectArray = new String[2];
                    String string5 = string4 = DatabaseBundle.message("test.connection.status.keep.alive.fail", new Object[0]);
                    int n = 0;
                    Object[] objectArray2 = objectArray;
                    boolean bl = false;
                    TestConnectionResult testConnectionResult2 = testConnectionResult;
                    boolean bl2 = testConnectionResult2 != null ? !testConnectionResult2.getKeepAliveResult() : false;
                    objectArray2[n] = bl2 ? string4 : null;
                    String it2 = string4 = DatabaseBundle.message("test.connection.status.database.returned.warning", new Object[0]);
                    n = 1;
                    objectArray2 = objectArray;
                    boolean bl3 = false;
                    Object object = testConnectionResult;
                    bl2 = object != null && (object = ((TestConnectionResult)object).getWarnings()) != null ? !object.isEmpty() : false;
                    objectArray2[n] = bl2 ? string4 : null;
                    string = SequencesKt.joinToString$default((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (CharSequence)" / ", null, null, (int)0, null, null, (int)62, null);
                }
            }
            return string;
        }

        private final TestConnectionResult testConnection(Project project, DatabaseConnection connection2) {
            TestConnectionResult testConnectionResult;
            TestConnectionResult it2 = testConnectionResult = new TestConnectionResult();
            boolean bl = false;
            Companion.handleWarnings(connection2, it2);
            Companion.pingDatabase(project, connection2, it2);
            return testConnectionResult;
        }

        /*
         * WARNING - void declaration
         */
        private final void handleWarnings(DatabaseConnection connection2, TestConnectionResult r) {
            void $this$mapTo$iv$iv;
            DatabaseErrorHandler eh = DatabaseErrorHandler.EP.forDbms(connection2.getDbms());
            LocalDataSource localDataSource = connection2.getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource2 = localDataSource;
            Collection collection2 = r.getWarnings();
            List list = connection2.getRemoteConnection().getAllWarnings();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllWarnings(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                SQLWarning sQLWarning = (SQLWarning)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                ErrorInfo errorInfo = eh.getErrorInfo(dataSource2, (Throwable)it2);
                Intrinsics.checkNotNullExpressionValue((Object)errorInfo, (String)"getErrorInfo(...)");
                collection3.add(errorInfo);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)collection2, (Iterable)iterable2);
        }

        private final void pingDatabase(Project project, DatabaseConnection connection2, TestConnectionResult result2) {
            String string = KeepAliveActionDescriptor.getKeepAliveQuery(project, connection2.getConnectionPoint().getDataSource());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeepAliveQuery(...)");
            String query = string;
            BarrenStatement<String> stmt2 = SmartStatements.Companion.poweredBy(connection2).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).barren();
            long start2 = System.currentTimeMillis();
            try {
                stmt2.execute(query);
                result2.setKeepAliveResult(true);
            }
            catch (Exception e2) {
                result2.setKeepAliveResult(false);
                result2.setKeepAliveError(e2);
            }
            result2.setPing(System.currentTimeMillis() - start2);
            result2.setSslState(ExecutionEnvironmentHelper.EP.forDbms(connection2.getDbms()).getSslState(connection2));
        }

        private static final TestConnectionResult performTestConnection$lambda$1$lambda$0(Project $project, DatabaseConnection it2) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return Companion.testConnection($project, it2);
        }

        private static final AsyncTask performTestConnection$lambda$1(Project $project, DatabaseConnectionConfig $config, boolean $askPassword, DatabaseCredentials $credentials, ErrorHandler $handler) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
            Intrinsics.checkNotNullParameter((Object)$credentials, (String)"$credentials");
            Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
            return DatabaseConnectionManager.Companion.getInstance().build($project, $config).setAskPassword($askPassword).setCredentialsStore($credentials).async(arg_0 -> Companion.performTestConnection$lambda$1$lambda$0($project, arg_0), $handler);
        }

        private static final void performTestConnection$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ThreeState.values().length];
                try {
                    nArray[ThreeState.YES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ThreeState.NO.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Listener;", "", "finished", "", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "result", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "th", "", "started", "intellij.database.impl"})
    public static interface Listener {
        public void started(@NotNull Project var1, @NotNull DatabaseConnectionPoint var2);

        public void finished(@NotNull Project var1, @NotNull DatabaseConnectionPoint var2, @Nullable TestConnectionResult var3, @Nullable Throwable var4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0010\u0010\b\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u001b\u0010\b\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$ProcessedTestConnectionResult;", "", "state", "Lcom/intellij/util/ThreeState;", "dataSourceInfo", "", "Lorg/jetbrains/annotations/Nls;", "stateText", "summary", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "fixes", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "(Lcom/intellij/util/ThreeState;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getDataSourceInfo", "()Ljava/lang/String;", "getFixes", "()Ljava/util/List;", "getState", "()Lcom/intellij/util/ThreeState;", "getStateText", "getSummary", "intellij.database.impl"})
    public static final class ProcessedTestConnectionResult {
        @NotNull
        private final ThreeState state;
        @NotNull
        private final String dataSourceInfo;
        @NotNull
        private final String stateText;
        @NotNull
        private final String summary;
        @NotNull
        private final List<ErrorInfo.Fix> fixes;

        public ProcessedTestConnectionResult(@NotNull ThreeState state, @NotNull String dataSourceInfo, @NotNull String stateText, @NotNull String summary, @NotNull List<? extends ErrorInfo.Fix> fixes) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)dataSourceInfo, (String)"dataSourceInfo");
            Intrinsics.checkNotNullParameter((Object)stateText, (String)"stateText");
            Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            this.state = state;
            this.dataSourceInfo = dataSourceInfo;
            this.stateText = stateText;
            this.summary = summary;
            this.fixes = fixes;
        }

        @NotNull
        public final ThreeState getState() {
            return this.state;
        }

        @NotNull
        public final String getDataSourceInfo() {
            return this.dataSourceInfo;
        }

        @NotNull
        public final String getStateText() {
            return this.stateText;
        }

        @NotNull
        public final String getSummary() {
            return this.summary;
        }

        @NotNull
        public final List<ErrorInfo.Fix> getFixes() {
            return this.fixes;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0012\u0010\b\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0005J\r\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b H\u0002J \u0010!\u001a\u00020\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0015\u0010'\u001a\u00070\u001f\u00a2\u0006\u0002\b 2\u0006\u0010'\u001a\u00020(H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006)"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;", "", "fail", "Lcom/intellij/util/ThreeState;", "dataSourceInfo", "", "Lorg/jetbrains/annotations/Nls;", "stateText", "details", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "fixes", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "specifyVersion", "", "(Lcom/intellij/util/ThreeState;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Z)V", "getDetails", "()Ljava/lang/String;", "getFail", "()Lcom/intellij/util/ThreeState;", "getFixes", "()Ljava/util/List;", "getStateText", "appendFixes", "", "sb", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "asHtml", "Lcom/intellij/openapi/util/text/HtmlChunk;", "describe", "editIcon", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "Lorg/jetbrains/annotations/NotNull;", "handleLink", "desc", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/database/view/ui/DatabaseConfigEditor;", "icon", "Ljavax/swing/Icon;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDataSourceTestConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceTestConnectionManager.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,560:1\n1#2:561\n*E\n"})
    public static final class Status {
        @NotNull
        private final ThreeState fail;
        @NotNull
        private final String dataSourceInfo;
        @NotNull
        private final String stateText;
        @Nullable
        private final String details;
        @NotNull
        private final List<ErrorInfo.Fix> fixes;
        private final boolean specifyVersion;

        public Status(@NotNull ThreeState fail, @NotNull String dataSourceInfo, @NotNull String stateText, @Nullable String details, @NotNull List<? extends ErrorInfo.Fix> fixes, boolean specifyVersion) {
            Intrinsics.checkNotNullParameter((Object)fail, (String)"fail");
            Intrinsics.checkNotNullParameter((Object)dataSourceInfo, (String)"dataSourceInfo");
            Intrinsics.checkNotNullParameter((Object)stateText, (String)"stateText");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            this.fail = fail;
            this.dataSourceInfo = dataSourceInfo;
            this.stateText = stateText;
            this.details = details;
            this.fixes = fixes;
            this.specifyVersion = specifyVersion;
        }

        public /* synthetic */ Status(ThreeState threeState, String string, String string2, String string3, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                bl = false;
            }
            this(threeState, string, string2, string3, list, bl);
        }

        @NotNull
        public final ThreeState getFail() {
            return this.fail;
        }

        @NotNull
        public final String getStateText() {
            return this.stateText;
        }

        @Nullable
        public final String getDetails() {
            return this.details;
        }

        @NotNull
        public final List<ErrorInfo.Fix> getFixes() {
            return this.fixes;
        }

        @NotNull
        public final HtmlChunk asHtml() {
            Integer idx;
            HtmlBuilder builder = new HtmlBuilder();
            Integer n = StringsKt.indexOf$default((CharSequence)this.dataSourceInfo, (char)'\n', (int)0, (boolean)false, (int)6, null);
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            Integer n3 = idx = it2 != -1 ? n : null;
            String string = this.dataSourceInfo.substring(0, n3 != null ? n3.intValue() : this.dataSourceInfo.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            builder.append(string);
            builder.append((HtmlChunk)HtmlChunk.link((String)"edit-version", (HtmlChunk)((HtmlChunk)this.editIcon())));
            if (idx != null) {
                int n4 = idx;
                String string2 = this.dataSourceInfo.substring(n4);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                builder.append(string2);
            }
            if (this.fail == ThreeState.YES) {
                builder.clearAndAppend((HtmlChunk)builder.wrapWith("div").style("color: " + ColorUtil.toHtmlColor((Color)((Color)JBColor.gray))));
            }
            if (this.details != null || !((Collection)this.fixes).isEmpty()) {
                builder.br();
                String string3 = this.details;
                if (string3 == null) {
                    string3 = "";
                }
                builder.append(string3);
                this.appendFixes(builder);
            }
            if (this.specifyVersion) {
                builder.append((HtmlChunk)HtmlChunk.br());
                builder.appendRaw("&emsp;");
                builder.append((HtmlChunk)HtmlChunk.link((String)"edit-version", (String)DatabaseBundle.message("specify.version", new Object[0])));
            }
            HtmlChunk htmlChunk = builder.toFragment();
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"toFragment(...)");
            return htmlChunk;
        }

        @NotNull
        public final String describe() {
            return this.details == null ? this.dataSourceInfo : this.dataSourceInfo + "\n" + this.details;
        }

        private final HtmlChunk.Element editIcon() {
            Icon icon = AllIcons.Actions.Edit;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Edit");
            return this.icon(icon);
        }

        private final HtmlChunk.Element icon(Icon icon) {
            HtmlChunk.Element element2 = HtmlChunk.tag((String)"icon").attr("src", GridUtil.getIconPath((Icon)icon));
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"attr(...)");
            return element2;
        }

        private final void appendFixes(HtmlBuilder sb) {
            if (this.fixes.isEmpty()) {
                return;
            }
            sb.append((HtmlChunk)HtmlChunk.br());
            int n = this.fixes.size();
            for (int i2 = 0; i2 < n; ++i2) {
                sb.appendRaw("&emsp;");
                sb.append((HtmlChunk)HtmlChunk.link((String)("fix" + i2), (String)this.fixes.get(i2).getName()));
            }
        }

        public final boolean handleLink(@Nullable String desc, @NotNull Project project, @NotNull DatabaseConfigEditor editor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (desc == null || !StringsKt.startsWith$default((String)desc, (String)"fix", (boolean)false, (int)2, null)) {
                return false;
            }
            int idx = StringUtil.parseInt((String)StringsKt.removePrefix((String)desc, (CharSequence)"fix"), (int)-1);
            if (idx < 0 || idx >= this.fixes.size()) {
                return false;
            }
            DataSourceUiUtil.applyFix(project, this.fixes.get(idx), editor2);
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionInProgress;", "", "task", "Lcom/intellij/database/util/AsyncTask;", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/database/util/AsyncTask;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "getTask", "()Lcom/intellij/database/util/AsyncTask;", "intellij.database.impl"})
    public static final class TestConnectionInProgress {
        @NotNull
        private final AsyncTask<TestConnectionResult> task;
        @Nullable
        private final ProgressIndicator indicator;

        public TestConnectionInProgress(@NotNull AsyncTask<TestConnectionResult> task, @Nullable ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            this.task = task;
            this.indicator = indicator;
        }

        @NotNull
        public final AsyncTask<TestConnectionResult> getTask() {
            return this.task;
        }

        @Nullable
        public final ProgressIndicator getIndicator() {
            return this.indicator;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "", "()V", "keepAliveError", "", "getKeepAliveError", "()Ljava/lang/Throwable;", "setKeepAliveError", "(Ljava/lang/Throwable;)V", "keepAliveResult", "", "getKeepAliveResult", "()Z", "setKeepAliveResult", "(Z)V", "ping", "", "getPing", "()J", "setPing", "(J)V", "sslState", "Lcom/intellij/util/ThreeState;", "getSslState", "()Lcom/intellij/util/ThreeState;", "setSslState", "(Lcom/intellij/util/ThreeState;)V", "warnings", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "getWarnings", "()Ljava/util/List;", "intellij.database.impl"})
    public static final class TestConnectionResult {
        private long ping;
        private boolean keepAliveResult;
        @Nullable
        private Throwable keepAliveError;
        @Nullable
        private ThreeState sslState = ThreeState.UNSURE;
        @NotNull
        private final List<ErrorInfo> warnings = new ArrayList();

        public final long getPing() {
            return this.ping;
        }

        public final void setPing(long l) {
            this.ping = l;
        }

        public final boolean getKeepAliveResult() {
            return this.keepAliveResult;
        }

        public final void setKeepAliveResult(boolean bl) {
            this.keepAliveResult = bl;
        }

        @Nullable
        public final Throwable getKeepAliveError() {
            return this.keepAliveError;
        }

        public final void setKeepAliveError(@Nullable Throwable throwable) {
            this.keepAliveError = throwable;
        }

        @Nullable
        public final ThreeState getSslState() {
            return this.sslState;
        }

        public final void setSslState(@Nullable ThreeState threeState) {
            this.sslState = threeState;
        }

        @NotNull
        public final List<ErrorInfo> getWarnings() {
            return this.warnings;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0019\u001a\u0014 \u001c*\t\u0018\u00010\u001a\u00a2\u0006\u0002\b\u001b0\u001a\u00a2\u0006\u0002\b\u001bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestInfo;", "", "sessionTemplateId", "", "(Ljava/lang/String;)V", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "info", "Lcom/intellij/database/dataSource/DataSourceInfo;", "getInfo", "()Lcom/intellij/database/dataSource/DataSourceInfo;", "setInfo", "(Lcom/intellij/database/dataSource/DataSourceInfo;)V", "getSessionTemplateId", "()Ljava/lang/String;", "status", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;", "getStatus", "()Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;", "setStatus", "(Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;)V", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "intellij.database.impl"})
    public static final class TestInfo {
        @Nullable
        private final String sessionTemplateId;
        @Nullable
        private ProgressIndicator indicator;
        @Nullable
        private Status status;
        @Nullable
        private DataSourceInfo info;

        public TestInfo(@Nullable String sessionTemplateId) {
            this.sessionTemplateId = sessionTemplateId;
        }

        @Nullable
        public final String getSessionTemplateId() {
            return this.sessionTemplateId;
        }

        @Nullable
        public final ProgressIndicator getIndicator() {
            return this.indicator;
        }

        public final void setIndicator(@Nullable ProgressIndicator progressIndicator) {
            this.indicator = progressIndicator;
        }

        @Nullable
        public final Status getStatus() {
            return this.status;
        }

        public final void setStatus(@Nullable Status status) {
            this.status = status;
        }

        @Nullable
        public final DataSourceInfo getInfo() {
            return this.info;
        }

        public final void setInfo(@Nullable DataSourceInfo dataSourceInfo) {
            this.info = dataSourceInfo;
        }

        public final Icon getIcon() {
            Icon icon;
            Status status = this.status;
            if ((status != null ? status.getFail() : null) == ThreeState.YES) {
                icon = AllIcons.General.Error;
            } else {
                Status status2 = this.status;
                if ((status2 != null ? status2.getFail() : null) == ThreeState.UNSURE) {
                    icon = AllIcons.General.BalloonWarning;
                } else {
                    Status status3 = this.status;
                    icon = (status3 != null ? status3.getFail() : null) == ThreeState.NO ? AllIcons.RunConfigurations.TestPassed : (this.indicator != null ? (Icon)AnimatedIcon.Default.INSTANCE : EmptyIcon.ICON_16);
                }
            }
            return icon;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

