/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.MergingRenameQueue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.DbSrcMigrationUtils;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DbSrcModificationSession {
    private static final Logger LOG = Logger.getInstance(DbSrcModificationSession.class);
    private static final CountedThreadExecutor ourStorageWriter = new CountedThreadExecutor(10);
    @Nullable
    private final Project myContextProject;
    private final List<ObjectPath> myDeleteQueue;
    private final MergingRenameQueue<ObjectPath> myRenameQueue;
    private final Set<ObjectPath> myInvalidatedSchemas;
    private final Set<ObjectPath> myDirtySrc;
    private final MergingRenameQueue.RenameProcessor<ObjectPath> myRenameProcessor;
    private volatile Pair<BasicSourceAware, CompositeText> myCurrentSource;
    private final boolean myGlobal;
    private final boolean myFormatOnSync;
    private final DbSrcStorage myStorage;
    private final ModalityState myModality;

    DbSrcModificationSession(@Nullable Project contextProject, boolean global, @NotNull DbSrcStorage storage, @NotNull ModalityState modality) {
        if (storage == null) {
            DbSrcModificationSession.$$$reportNull$$$0(0);
        }
        if (modality == null) {
            DbSrcModificationSession.$$$reportNull$$$0(1);
        }
        this.myDeleteQueue = new ArrayList<ObjectPath>();
        this.myRenameQueue = new MergingRenameQueue();
        this.myInvalidatedSchemas = new LinkedHashSet<ObjectPath>();
        this.myDirtySrc = new LinkedHashSet<ObjectPath>();
        this.myRenameProcessor = new MyRenameProcessor();
        this.myCurrentSource = null;
        this.myContextProject = contextProject;
        this.myGlobal = global;
        this.myStorage = storage;
        this.myModality = modality;
        LocalDataSource dataSource2 = DbSrcUtilsCore.findDataSource(contextProject, this.myStorage.getDataSourceId());
        DatabaseDriver driver2 = dataSource2 != null ? dataSource2.getDatabaseDriver() : null;
        this.myFormatOnSync = driver2 != null && DatabaseDriver.OPTION_FORMAT_SOURCES_ON_SYNC.get(driver2) != false;
    }

    public synchronized void save(@NotNull BasicSourceAware object, @Nullable CompositeText text2) {
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(2);
        }
        this.flushDeleteQueue();
        this.flushRenameQueue();
        ObjectPath srcPath = ObjectPaths.of(object, object.getModel());
        if (text2 == null) {
            ourStorageWriter.execute(() -> this.processDelete(srcPath));
        } else {
            CompositeText generated = this.generate(object, text2);
            Dbms dbms = DbSrcModificationSession.getDbms(object);
            int genVersion = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(object).getCreateVersion();
            int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(dbms, object.getKind());
            ourStorageWriter.execute(() -> this.processSave(srcPath, dbms, generated, introVersion, genVersion));
        }
    }

    public void clear() {
        ourStorageWriter.execute(() -> this.myStorage.drop());
    }

    @NotNull
    private static Dbms getDbms(@NotNull BasicSourceAware object) {
        BasicModel model2;
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(3);
        }
        Dbms dbms = (model2 = object.getModel()) == null ? object.getMetaObject().getModel().dbms : model2.getDbms();
        if (dbms == null) {
            DbSrcModificationSession.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    public void queueRename(@NotNull BasicElement object, @NotNull ObjectNamePart oldName) {
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(5);
        }
        if (oldName == null) {
            DbSrcModificationSession.$$$reportNull$$$0(6);
        }
        BasicModel model2 = object.getModel();
        ObjectPath srcPath = ObjectPaths.of(object, model2);
        ObjectPath oldPath = ObjectPath.create(oldName.name, srcPath.kind, oldName.isQuoted(), oldName.getIdentity(), srcPath.parent);
        this.queueRename(srcPath, oldPath, object.hashCode());
    }

    public synchronized void queueRename(@NotNull ObjectPath srcPath, @NotNull ObjectPath oldPath, int mark2) {
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(7);
        }
        if (oldPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(8);
        }
        this.flushDeleteQueue();
        this.myRenameQueue.queueRename(srcPath, oldPath, mark2);
    }

    public synchronized void queueDelete(@NotNull BasicElement object) {
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(9);
        }
        ObjectPath srcPath = ObjectPaths.of(object, object.getModel());
        this.flushRenameQueue();
        this.myDeleteQueue.add(srcPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompositeText generate(@NotNull BasicSourceAware object, @NotNull CompositeText text2) {
        CompositeText compositeText;
        BasicModel model2;
        block11: {
            if (object == null) {
                DbSrcModificationSession.$$$reportNull$$$0(10);
            }
            if (text2 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(11);
            }
            this.myCurrentSource = Pair.create((Object)object, (Object)text2);
            model2 = object.getModel();
            if (model2 != null && this.myContextProject != null && !this.myContextProject.isDisposed()) break block11;
            CompositeText compositeText2 = text2;
            this.myCurrentSource = null;
            CompositeText compositeText3 = compositeText2;
            if (compositeText3 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(12);
            }
            return compositeText3;
        }
        try {
            ScriptingSingleModelTaskBuilder task = new ScriptingSingleModelTaskBuilder(model2, ScriptCategory.CREATE_DEFINITION);
            task.setReformat(false);
            task.getElements().add(object);
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.getSearchPathObject(DbImplUtilCore.getDatabaseDialect(model2.getDbms()), object), BasicNamespace.class);
            task.setCurrentNamespace(namespace);
            ScriptingResult result2 = ScriptGenerators.INSTANCE.makeScript(this.myContextProject, task.build());
            CompositeText compositeText4 = result2.getScript();
            this.myCurrentSource = null;
            compositeText = compositeText4;
        }
        catch (Throwable e2) {
            CompositeText compositeText5;
            try {
                LOG.warn("Code generation failed", e2);
                CompositeText compositeText6 = text2;
                compositeText5 = compositeText6;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.myCurrentSource = null;
            }
            if (compositeText5 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(14);
            }
            return compositeText5;
        }
        if (compositeText == null) {
            DbSrcModificationSession.$$$reportNull$$$0(13);
        }
        return compositeText;
    }

    private void flushDeleteQueue() {
        if (this.myDeleteQueue.isEmpty()) {
            return;
        }
        List<ObjectPath> toRemove = DbSrcModificationSession.collectRoots(this.myDeleteQueue);
        this.myDeleteQueue.clear();
        ourStorageWriter.execute(() -> this.runWriteAction(() -> {
            for (ObjectPath path : toRemove) {
                try {
                    this.processDrop(path);
                }
                catch (Throwable e2) {
                    LOG.warn(e2);
                }
            }
        }));
    }

    void regenSources(@NotNull BasicModModel model2) {
        if (model2 == null) {
            DbSrcModificationSession.$$$reportNull$$$0(15);
        }
        this.waitExecutionFinished();
        this.regenSourcesImpl(model2);
    }

    synchronized void regenSourcesImpl(@NotNull BasicModModel model2) {
        if (model2 == null) {
            DbSrcModificationSession.$$$reportNull$$$0(16);
        }
        if (this.myDirtySrc.isEmpty()) {
            return;
        }
        List<ObjectPath> regenRoots = DbSrcModificationSession.collectRoots(new ArrayList<ObjectPath>(this.myDirtySrc));
        this.myDirtySrc.clear();
        for (BasicModSourceAware obj2 : ((JBTreeTraverser)model2.basicTraverser().withRoots((Iterable)JBIterable.from(regenRoots).flatten(p2 -> QNameUtil.findByPath(model2, p2)).filter(BasicElement.class))).filter(BasicModSourceAware.class)) {
            this.regenSource(obj2);
        }
    }

    @NotNull
    private static List<ObjectPath> collectRoots(List<ObjectPath> paths2) {
        Object2IntOpenHashMap lens = new Object2IntOpenHashMap(paths2.size());
        lens.defaultReturnValue(-1);
        for (ObjectPath path : paths2) {
            lens.put((Object)path, ObjectPaths.getLength(path));
        }
        paths2.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)lens).getInt(arg_0)));
        LinkedHashSet<ObjectPath> processed = new LinkedHashSet<ObjectPath>();
        ArrayList<ObjectPath> regenRoots = new ArrayList<ObjectPath>();
        block1: for (ObjectPath cur : paths2) {
            if (!processed.add(cur)) continue;
            ObjectPath p2 = cur.parent;
            while (p2 != null) {
                if (processed.contains(p2)) continue block1;
                p2 = p2.parent;
            }
            regenRoots.add(cur);
        }
        ArrayList<ObjectPath> arrayList = regenRoots;
        if (arrayList == null) {
            DbSrcModificationSession.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private void regenSource(@NotNull BasicModSourceAware element2) {
        if (element2 == null) {
            DbSrcModificationSession.$$$reportNull$$$0(18);
        }
        ObjectPath path = BasicPaths.of(element2, element2.getModel());
        byte[] content = new byte[]{};
        try {
            content = this.myStorage.getContent(path, DbSrcFileSystemCore.ItemType.ORIG);
        }
        catch (IOException e2) {
            LOG.warn("Failed to get sources of " + path.getDisplayName(), (Throwable)e2);
        }
        if (content == null) {
            return;
        }
        DbSrcStorageDsMetadata.MetaData metaData = this.myStorage.getMetaData(path);
        String text2 = new String(content, StandardCharsets.UTF_8);
        CompositeText markup = metaData == null ? new SimpleCompositeText((CharSequence)text2, CompositeText.Kind.ORIGINAL_TEXT) : new PersistentMarkup(text2, metaData.offsets, metaData.kinds, null);
        this.save(element2, markup);
    }

    private void flushRenameQueue() {
        List<MergingRenameQueue.RenameItem<ObjectPath>> renames = this.myRenameQueue.clear();
        if (renames.isEmpty()) {
            return;
        }
        ourStorageWriter.execute(() -> this.myRenameProcessor.perform(renames));
    }

    public synchronized void beginWrite() {
    }

    public synchronized void endWrite() {
        this.flushDeleteQueue();
        this.flushRenameQueue();
    }

    @Nullable
    public CompositeText getTmpSource(@NotNull BasicSourceAware object) {
        Pair<BasicSourceAware, CompositeText> src2;
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(19);
        }
        return (src2 = this.myCurrentSource) == null || src2.first != object ? null : (CompositeText)src2.second;
    }

    private void processDelete(@NotNull ObjectPath srcPath) {
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(20);
        }
        try {
            this.myStorage.putOriginalContent(srcPath, null, DbSrcStorageDsMetadata.MetaData.EMPTY);
        }
        catch (Exception e2) {
            LOG.warn((Throwable)e2);
        }
        this.invalidateSchema(srcPath);
    }

    private void processDrop(@NotNull ObjectPath srcPath) {
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(21);
        }
        try {
            this.myStorage.dropObject(srcPath, true);
        }
        catch (Exception e2) {
            LOG.warn((Throwable)e2);
        }
        this.invalidateSchema(srcPath);
    }

    @NotNull
    private PersistentMarkup format(@NotNull ObjectPath srcPath, @NotNull Dbms dbms, @NotNull CompositeText text2) {
        PersistentMarkup persistentMarkup;
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(22);
        }
        if (dbms == null) {
            DbSrcModificationSession.$$$reportNull$$$0(23);
        }
        if (text2 == null) {
            DbSrcModificationSession.$$$reportNull$$$0(24);
        }
        if (this.myContextProject == null || this.myContextProject.isDisposed()) {
            PersistentMarkup persistentMarkup2 = PersistentMarkup.asPersistent(text2);
            if (persistentMarkup2 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(25);
            }
            return persistentMarkup2;
        }
        try {
            SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(dbms);
            persistentMarkup = DbSrcUtilsCore.formatCompositeText(this.myContextProject, dialect, srcPath.getDisplayName(), text2, null);
        }
        catch (Throwable e2) {
            LOG.warn("Formatting for " + srcPath + " failed, passing unformatted", e2);
            PersistentMarkup persistentMarkup3 = PersistentMarkup.asPersistent(text2);
            if (persistentMarkup3 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(27);
            }
            return persistentMarkup3;
        }
        if (persistentMarkup == null) {
            DbSrcModificationSession.$$$reportNull$$$0(26);
        }
        return persistentMarkup;
    }

    private void synchronizeFs(boolean async2) {
        this.submitTransaction(() -> this.myStorage.flushToFs(async2));
    }

    private void processSave(@NotNull ObjectPath srcPath, @NotNull Dbms dbms, @NotNull CompositeText text2, int introVersion, int genVersion) {
        FileDocumentManager manager;
        Document document;
        VirtualFile dbFile;
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(28);
        }
        if (dbms == null) {
            DbSrcModificationSession.$$$reportNull$$$0(29);
        }
        if (text2 == null) {
            DbSrcModificationSession.$$$reportNull$$$0(30);
        }
        PersistentMarkup sql = this.myFormatOnSync ? this.format(srcPath, dbms, text2) : PersistentMarkup.asPersistent(text2);
        if (this.myContextProject != null) {
            sql = DbSrcModificationSession.markCompactDefinition(this.myContextProject, dbms, srcPath, sql);
        }
        DbSrcStorageDsMetadata.MetaData data = this.myStorage.getMetaData(srcPath);
        DbSrcStorageDsMetadata.MetaData expected = sql.getExpectedMetaData(data, introVersion, genVersion);
        Project objProject = this.getObjectProject();
        VirtualFile virtualFile = dbFile = objProject != null && objProject.isDisposed() ? null : DbSrcFileSystem.getInstance().findFileByPathIfCached(DbSrcFileSystem.getPathFromNormalized(objProject, this.myStorage.getDataSourceId(), srcPath, (DbSrcFileSystemCore.ItemTypeOrFolder)DbSrcFileSystemCore.ItemType.SRC));
        if (dbFile != null && (document = (manager = FileDocumentManager.getInstance()).getCachedDocument(dbFile)) != null && manager.isDocumentUnsaved(document)) {
            manager.saveDocument(document);
        }
        try {
            this.myStorage.putOriginalContent(srcPath, sql.getText().toString().getBytes(StandardCharsets.UTF_8), expected);
        }
        catch (Exception e2) {
            LOG.warn((Throwable)e2);
        }
        if (data == null || data.introContentVersion != expected.introContentVersion || data.genContentVersion != expected.genContentVersion) {
            this.invalidateSchema(srcPath);
        }
    }

    public static PersistentMarkup markCompactDefinition(@NotNull Project project, Dbms dbms, ObjectPath path, PersistentMarkup sql) {
        TextRange rg;
        if (project == null) {
            DbSrcModificationSession.$$$reportNull$$$0(31);
        }
        if ((rg = DbSrcMigrationUtils.findCompactDefinitionRange(project, dbms, path, sql, (Function<CompositeText, CompositeText>)Functions.id())) == null) {
            return sql;
        }
        List<CompositeText.Fragment> fragments = sql.getFragments();
        int sz = fragments.size() + 2;
        int[] offsets = new int[sz];
        char[] kinds = new char[sz];
        Int2ObjectOpenHashMap errors = new Int2ObjectOpenHashMap();
        int i2 = 0;
        int rgs = rg.getStartOffset();
        int rge = rg.getEndOffset();
        for (CompositeText.Fragment fragment : fragments) {
            int end = fragment.getEnd();
            char kind = fragment.getKind().getCode();
            String error2 = fragment.getError();
            if (fragment.getBegin() <= rgs && end >= rge) {
                offsets[i2] = rgs;
                kinds[i2] = kind;
                if (error2 != null) {
                    errors.put(i2, (Object)error2);
                }
                offsets[++i2] = rge;
                kinds[i2] = CompositeText.Kind.COMPACT_DEFINITION.getCode();
                if (error2 != null) {
                    errors.put(i2, (Object)error2);
                }
                ++i2;
            }
            offsets[i2] = end;
            kinds[i2] = kind;
            if (error2 != null) {
                errors.put(i2, (Object)error2);
            }
            ++i2;
        }
        return new PersistentMarkup(sql.getText(), offsets, kinds, (Int2ObjectMap<String>)errors);
    }

    @Nullable
    private Project getObjectProject() {
        return this.myGlobal ? null : this.myContextProject;
    }

    private void runWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbSrcModificationSession.$$$reportNull$$$0(32);
        }
        this.submitTransaction(() -> {
            Application app = ApplicationManager.getApplication();
            if (!((ComponentManager)Objects.requireNonNull(this.myGlobal ? app : this.myContextProject)).isDisposed()) {
                app.runWriteAction(runnable);
            }
        });
    }

    private void submitTransaction(@NotNull Runnable runnable) {
        Application app;
        if (runnable == null) {
            DbSrcModificationSession.$$$reportNull$$$0(33);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable.run();
        } else {
            app.invokeAndWait(() -> {
                if (!((ComponentManager)Objects.requireNonNull(this.myGlobal ? app : this.myContextProject)).isDisposed()) {
                    runnable.run();
                }
            }, this.myModality);
        }
    }

    public void waitForWriteFinished(boolean asyncRefresh) {
        this.waitExecutionFinished();
        this.synchronizeFs(asyncRefresh);
    }

    public void waitExecutionFinished() {
        CountDownLatch latch = new CountDownLatch(1);
        ourStorageWriter.execute(latch::countDown);
        try {
            latch.await();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
    }

    public void invalidateSchema(@NotNull ObjectPath path) {
        ObjectPath schema2;
        if (path == null) {
            DbSrcModificationSession.$$$reportNull$$$0(34);
        }
        if ((schema2 = path.findParent(ObjectKind.SCHEMA, false)) != null && !this.myInvalidatedSchemas.contains(schema2)) {
            this.myInvalidatedSchemas.add(schema2);
            DbSrcValidator.invalidate(this.myStorage, schema2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12, 13, 14, 17, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 11: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "queueRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "queueDelete";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "regenSources";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "regenSourcesImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "regenSource";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTmpSource";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processDelete";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processDrop";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processSave";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "markCompactDefinition";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runWriteAction";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "submitTransaction";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "invalidateSchema";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12, 13, 14, 17, 25, 26, 27 -> new IllegalStateException(string);
        };
    }

    private class MyRenameProcessor
    extends MergingRenameQueue.RenameProcessor<ObjectPath> {
        private MyRenameProcessor() {
        }

        @Override
        public boolean exists(@NotNull ObjectPath path) {
            if (path == null) {
                MyRenameProcessor.$$$reportNull$$$0(0);
            }
            return DbSrcModificationSession.this.myStorage.getMetaData(path) != null;
        }

        @Override
        @Nullable
        public ObjectPath getParent(@NotNull ObjectPath path) {
            if (path == null) {
                MyRenameProcessor.$$$reportNull$$$0(1);
            }
            return path.parent;
        }

        @Override
        @NotNull
        public ObjectPath createTempName(@NotNull ObjectPath path) {
            if (path == null) {
                MyRenameProcessor.$$$reportNull$$$0(2);
            }
            ObjectPath objectPath = ObjectPath.create(path.name, path.kind, path.isQuoted(), "cycle-rename-temporary", path.parent);
            if (objectPath == null) {
                MyRenameProcessor.$$$reportNull$$$0(3);
            }
            return objectPath;
        }

        @Override
        public void processRename(@NotNull ObjectPath from, @NotNull ObjectPath to) {
            if (from == null) {
                MyRenameProcessor.$$$reportNull$$$0(4);
            }
            if (to == null) {
                MyRenameProcessor.$$$reportNull$$$0(5);
            }
            try {
                DbSrcModificationSession.this.myStorage.moveAll(from, to);
                DbSrcModificationSession.this.myDirtySrc.add(to);
            }
            catch (Throwable e2) {
                LOG.warn(e2);
            }
        }

        @Override
        public void performRenamesBlock(@NotNull Runnable r) {
            if (r == null) {
                MyRenameProcessor.$$$reportNull$$$0(6);
            }
            DbSrcModificationSession.this.runWriteAction(r);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession$MyRenameProcessor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession$MyRenameProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTempName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "exists";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createTempName";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processRename";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "performRenamesBlock";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CountedThreadExecutor
    implements Executor {
        private final Logger LOG = Logger.getInstance(CountedThreadExecutor.class);
        private final BlockingQueue<Runnable> myQueue = new LinkedBlockingQueue<Runnable>(100);
        private final int myTimeoutSec;
        private volatile int myRefCount = 0;
        private volatile boolean myRunning = false;

        private CountedThreadExecutor(int timeoutSec) {
            this.myTimeoutSec = timeoutSec;
        }

        public boolean isRunning() {
            return this.myRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                ++this.myRefCount;
                if (!this.myRunning) {
                    this.myRunning = true;
                    ApplicationManager.getApplication().executeOnPooledThread(this::processQueue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                assert (this.myRefCount > 0);
                assert (this.myRunning);
                --this.myRefCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Runnable command2) {
            boolean acquire;
            if (command2 == null) {
                CountedThreadExecutor.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            boolean bl = acquire = this.myRefCount == 0;
            if (acquire) {
                this.acquire();
            }
            assert (this.myRunning);
            try {
                this.myQueue.put(command2);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (acquire) {
                    this.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue() {
            block25: {
                boolean running = true;
                block19: while (true) {
                    try {
                        while (true) {
                            Runnable task;
                            if ((task = this.myQueue.poll(this.myTimeoutSec, TimeUnit.SECONDS)) == null) {
                                BlockingQueue<Runnable> blockingQueue = this.myQueue;
                                synchronized (blockingQueue) {
                                    if (this.myQueue.isEmpty() && this.myRefCount == 0) {
                                        running = false;
                                        this.myRunning = false;
                                        break block25;
                                    }
                                    continue block19;
                                }
                            }
                            try {
                                task.run();
                                continue block19;
                            }
                            catch (Throwable e2) {
                                this.LOG.warn(e2);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e3) {
                        BlockingQueue<Runnable> e2 = this.myQueue;
                        synchronized (e2) {
                            running = false;
                            this.myRunning = false;
                        }
                        Thread.currentThread().interrupt();
                        break block25;
                    }
                }
                finally {
                    if (running) {
                        BlockingQueue<Runnable> blockingQueue = this.myQueue;
                        synchronized (blockingQueue) {
                            Application app = ApplicationManager.getApplication();
                            if (this.myRunning) {
                                this.LOG.warn("DbSrcWriter accidentally stopped, rescheduling...");
                                app.invokeLater(() -> app.executeOnPooledThread(this::processQueue), app.getDisposed());
                            }
                        }
                    }
                    this.LOG.info("DbSrcWriter stopped");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession$CountedThreadExecutor", "execute"));
        }
    }
}

