/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSrcFileStatusProvider
implements FileStatusProvider,
VcsBaseContentProvider {
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DbSrcFileStatusProvider.$$$reportNull$$$0(0);
        }
        return !virtualFile.isDirectory() && DbSrcUtilsCore.isDbSrcFile(virtualFile) ? (FileStatus)ObjectUtils.chooseNotNull((Object)DbSrcChangesTracker.getFileStatuses().getStatus(virtualFile).getStatus(), (Object)FileStatus.NOT_CHANGED) : null;
    }

    @Nullable
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file) {
        VirtualFile baseFile;
        VirtualFile base;
        if (file == null) {
            DbSrcFileStatusProvider.$$$reportNull$$$0(1);
        }
        if ((base = DbSrcFileSystem.getInstance().getSatelliteFile(file, DbSrcFileSystemCore.ItemType.USER_BASE, false)) == null) {
            base = DbSrcFileSystem.getInstance().getSatelliteFile(file, DbSrcFileSystemCore.ItemType.ORIG, false);
        }
        if (base == null) {
            base = DbSrcFileSystem.getInstance().getSatelliteFile(file, DbSrcFileSystemCore.ItemType.SRC, false);
        }
        if ((baseFile = base) == null) {
            return null;
        }
        return new VcsBaseContentProvider.BaseContent(){
            private final VcsRevisionNumber myRevisionNumber;
            {
                this.myRevisionNumber = new TextRevisionNumber("remote " + baseFile.getModificationStamp());
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                VcsRevisionNumber vcsRevisionNumber = this.myRevisionNumber;
                if (vcsRevisionNumber == null) {
                    1.$$$reportNull$$$0(0);
                }
                return vcsRevisionNumber;
            }

            @Nullable
            public String loadContent() {
                return DbSrcFileStatus.Companion.getContent(baseFile, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider$1", "getRevisionNumber"));
            }
        };
    }

    public boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileStatusProvider.$$$reportNull$$$0(2);
        }
        return DbSrcUtilsCore.isDbSrcFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileStatusProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileStatus";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseRevision";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

