/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbContentRevision;
import com.intellij.database.dataSource.srcStorage.DbSrcChangeList;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DbSrcChangesTrackerBase
extends DbSrcChangesTracker {
    public static final VcsRevisionNumber LOCAL = VcsRevisionNumber.NULL;
    public static final VcsRevisionNumber REMOTE = new TextRevisionNumber("Remote");
    public static final VcsRevisionNumber BEFORE = new TextRevisionNumber("Before");
    protected final Map<String, DbSrcChangeList> myChangeLists = new HashMap<String, DbSrcChangeList>();

    public DbSrcChangesTrackerBase(@Nullable Project project) {
        super(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DbSrcChangeList> getChangeLists() {
        ArrayList<DbSrcChangeList> changeLists;
        Map<String, DbSrcChangeList> map2 = this.myChangeLists;
        synchronized (map2) {
            changeLists = new ArrayList<DbSrcChangeList>(this.myChangeLists.values());
        }
        if (this.myProject != null) {
            changeLists.addAll(DbSrcChangesTrackerBase.getInstanceBase(null).getChangeLists());
        }
        ArrayList<DbSrcChangeList> arrayList = changeLists;
        if (arrayList == null) {
            DbSrcChangesTrackerBase.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DbSrcChangeList getChangeList(@NotNull String dataSource2) {
        if (dataSource2 == null) {
            DbSrcChangesTrackerBase.$$$reportNull$$$0(1);
        }
        Map<String, DbSrcChangeList> map2 = this.myChangeLists;
        synchronized (map2) {
            return this.myChangeLists.get(dataSource2);
        }
    }

    @Nullable
    public static Change getChange(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcChangesTrackerBase.$$$reportNull$$$0(2);
        }
        if (!DbSrcUtilsCore.isDbSrcFile(file)) {
            return null;
        }
        DbSrcChangeList list = DbSrcFileSystemCore.processPath(file, new DbSrcFileSystemCore.ItemProcessor<DbSrcChangeList>(){

            @Override
            public DbSrcChangeList processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                return type != DbSrcFileSystemCore.ItemType.SRC ? null : DbSrcChangesTrackerBase.getInstanceBase(project).getChangeList(dataSourceId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerBase$1";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (list == null) {
            return null;
        }
        for (Change change : list.getChanges()) {
            DbContentRevision rev = (DbContentRevision)((Object)ObjectUtils.tryCast((Object)change.getAfterRevision(), DbContentRevision.class));
            if (rev == null || !file.equals(rev.getVirtualFile())) continue;
            return change;
        }
        return null;
    }

    @TestOnly
    public static boolean isChanged(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcChangesTrackerBase.$$$reportNull$$$0(3);
        }
        ((DbSrcChangesTracker)ApplicationManager.getApplication().getService(DbSrcChangesTracker.class)).distributeUpdates(Collections.singletonList(file));
        return DbSrcChangesTrackerBase.getChange(file) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFiles(@NotNull Collection<VirtualFile> files2) {
        FileStatusManager fsm;
        if (files2 == null) {
            DbSrcChangesTrackerBase.$$$reportNull$$$0(4);
        }
        if (!files2.isEmpty()) {
            HashMap<String, DbSrcChangeList> changeLists;
            MultiMap byDataSource = MultiMap.createLinkedSet();
            Map<String, DbSrcChangeList> map2 = this.myChangeLists;
            synchronized (map2) {
                changeLists = new HashMap<String, DbSrcChangeList>(this.myChangeLists);
            }
            DbSrcFileSystem dbFs = DbSrcFileSystem.getInstance();
            for (VirtualFile file : files2) {
                if (DbSrcChangesTrackerBase.addByDataSource((MultiMap<String, VirtualFile>)byDataSource, dbFs, file)) continue;
                for (VirtualFile child : file.getChildren()) {
                    DbSrcChangesTrackerBase.addByDataSource((MultiMap<String, VirtualFile>)byDataSource, dbFs, child);
                }
            }
            for (Map.Entry entry : byDataSource.entrySet()) {
                DbSrcChangeList list = (DbSrcChangeList)changeLists.get(entry.getKey());
                if (list == null) continue;
                list.updateChanges((Iterable)entry.getValue());
            }
        }
        if ((fsm = (FileStatusManager)ReadAction.compute(() -> this.myProject != null && this.myProject.isOpen() ? FileStatusManager.getInstance((Project)this.myProject) : null)) != null) {
            fsm.fileStatusesChanged();
        }
        ((ModificationTrackerListener)this.myDispatcher.getMulticaster()).modificationCountChanged((Object)this);
    }

    private static boolean addByDataSource(MultiMap<String, VirtualFile> byDataSource, DbSrcFileSystem dbFs, VirtualFile file) {
        String ds = DbSrcUtilsCore.getDataSource(file);
        if (ds != null) {
            VirtualFile base = dbFs.getBaseFile(file, true, false, true);
            byDataSource.putValue((Object)ds, (Object)(base == null ? file : base));
            return true;
        }
        return false;
    }

    @NotNull
    public static DbSrcChangesTrackerBase getInstanceBase(@Nullable Project project) {
        DbSrcChangesTrackerBase dbSrcChangesTrackerBase = (DbSrcChangesTrackerBase)DbSrcChangesTrackerBase.getInstance(project);
        if (dbSrcChangesTrackerBase == null) {
            DbSrcChangesTrackerBase.$$$reportNull$$$0(5);
        }
        return dbSrcChangesTrackerBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChangeList";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public static class DbSrcDataSourceListener
    implements DataSourceStorage.Listener {
        private final DbSrcChangesTrackerBase myTracker;

        public DbSrcDataSourceListener(@NotNull DbSrcChangesTrackerBase tracker) {
            if (tracker == null) {
                DbSrcDataSourceListener.$$$reportNull$$$0(0);
            }
            this.myTracker = tracker;
            for (LocalDataSource localDataSource : this.getDataSources()) {
                this.dataSourceAdded(localDataSource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                DbSrcDataSourceListener.$$$reportNull$$$0(1);
            }
            if (!this.isGlobalAccepted() && dataSource2.isGlobal() || this.myTracker.isDisposed()) {
                return;
            }
            Map<String, DbSrcChangeList> map2 = this.myTracker.myChangeLists;
            synchronized (map2) {
                String id = dataSource2.getUniqueId();
                if (!this.myTracker.myChangeLists.containsKey(id)) {
                    this.myTracker.myChangeLists.put(id, new DbSrcChangeList(this.myTracker.getProject(), id));
                }
            }
        }

        private boolean isGlobalAccepted() {
            return this.myTracker.getProject() == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                DbSrcDataSourceListener.$$$reportNull$$$0(2);
            }
            if (!this.isGlobalAccepted() && dataSource2.isGlobal() || this.myTracker.isDisposed()) {
                return;
            }
            Map<String, DbSrcChangeList> map2 = this.myTracker.myChangeLists;
            synchronized (map2) {
                String id = dataSource2.getUniqueId();
                this.myTracker.myChangeLists.remove(id);
            }
        }

        @NotNull
        private List<? extends LocalDataSource> getDataSources() {
            if (this.myTracker.getProject() != null) {
                @NotNull Project project = this.myTracker.getProject();
                List<LocalDataSource> list = DataSourceStorage.getProjectStorage(project).getDataSources();
                if (list == null) {
                    DbSrcDataSourceListener.$$$reportNull$$$0(3);
                }
                return list;
            }
            List<LocalDataSource> list = DataSourceStorage.getStorage().getDataSources();
            if (list == null) {
                DbSrcDataSourceListener.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerBase$DbSrcDataSourceListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerBase$DbSrcDataSourceListener";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "dataSourceAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "dataSourceRemoved";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

