/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTrackerBase;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.ide.impl.ProjectUtilCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSrcChangesTrackerApplication
extends DbSrcChangesTrackerBase {
    private final DbSrcFileStatus myFileStatus = new DbSrcFileStatus();
    private final Set<VirtualFile> myDirtyFiles = new HashSet<VirtualFile>();
    private final Alarm myAlarm = new Alarm((Disposable)this);
    private final AtomicReference<Disposable> myAdded = new AtomicReference();
    private final DocumentListener myListener = new DocumentListener(){
        private final FileDocumentManager documentManager = FileDocumentManager.getInstance();

        public void documentChanged(@NotNull DocumentEvent event) {
            VirtualFile file;
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            if (DbSrcUtilsCore.isDbSrcFile(file = this.documentManager.getFile(event.getDocument()))) {
                DbSrcChangesTrackerApplication.this.fileDirty(file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication$1", "documentChanged"));
        }
    };

    public DbSrcChangesTrackerApplication() {
        super(null);
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        appConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent.getFileSystem() instanceof DbSrcFileSystem)) continue;
                    DbSrcChangesTrackerApplication.this.fileDirty(vFileEvent.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication$2", "after"));
            }
        });
        appConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                DbSrcChangesTrackerApplication.this.ensureListenerAdded();
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (ProjectManager.getInstance().getOpenProjects().length == 0) {
                    DbSrcChangesTrackerApplication.this.ensureListenerRemoved();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (ProjectUtilCore.getOpenProjects().length > 0) {
            this.ensureListenerAdded();
        }
        appConnection.subscribe(DataSourceStorage.TOPIC, (Object)new DbSrcChangesTrackerBase.DbSrcDataSourceListener(this));
        this.validate(null);
    }

    public void validate(@Nullable Project project) {
        VirtualFile root2 = DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(project, null, null, null, null));
        this.fileDirty(root2);
    }

    public void ensureListenerAdded() {
        Disposable disposable;
        if (this.myAdded.get() == null && this.myAdded.compareAndSet(null, disposable = Disposer.newDisposable())) {
            Disposer.register((Disposable)this, (Disposable)disposable);
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myListener, disposable);
        }
    }

    public void ensureListenerRemoved() {
        Disposable disposable = this.myAdded.getAndSet(null);
        if (disposable != null) {
            Disposer.dispose((Disposable)disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileDirty(@Nullable VirtualFile file) {
        if (!DbSrcUtilsCore.isDbSrcFile(file)) {
            return;
        }
        Set<VirtualFile> set = this.myDirtyFiles;
        synchronized (set) {
            this.myDirtyFiles.add(file);
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(this::update, 1000, ModalityState.defaultModalityState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        ArrayList<VirtualFile> files2;
        Set<VirtualFile> set = this.myDirtyFiles;
        synchronized (set) {
            files2 = new ArrayList<VirtualFile>(this.myDirtyFiles);
            this.myDirtyFiles.clear();
        }
        AppJavaExecutorUtil.executeOnPooledIoThread(() -> this.distributeUpdates(files2));
    }

    @Override
    public void distributeUpdates(List<VirtualFile> files2) {
        MultiMap byProject = MultiMap.create();
        for (VirtualFile file : files2) {
            Ref<Project> p2 = DbSrcUtils.getProject(file.getPath());
            if (p2 == null) continue;
            byProject.putValue((Object)((Project)p2.get()), (Object)file);
        }
        if (byProject.containsKey(null)) {
            this.updateFiles(byProject.get(null));
            for (Iterator<Object> iterator : ProjectManager.getInstance().getOpenProjects()) {
                DbSrcChangesTrackerApplication.updateFiles(iterator, byProject.get(iterator));
            }
        } else {
            for (Map.Entry entry : byProject.entrySet()) {
                DbSrcChangesTrackerApplication.updateFiles((Project)entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    private static void updateFiles(@NotNull Project project, Collection<VirtualFile> pFiles) {
        DbSrcChangesTrackerBase tracker;
        if (project == null) {
            DbSrcChangesTrackerApplication.$$$reportNull$$$0(0);
        }
        if ((tracker = (DbSrcChangesTrackerBase)ReadAction.compute(() -> !project.isDisposed() && project.isOpen() ? DbSrcChangesTrackerBase.getInstanceBase(project) : null)) != null) {
            tracker.updateFiles(pFiles);
        }
    }

    @Override
    @NotNull
    public DbSrcFileStatus getFileStatus() {
        DbSrcFileStatus dbSrcFileStatus = this.myFileStatus;
        if (dbSrcFileStatus == null) {
            DbSrcChangesTrackerApplication.$$$reportNull$$$0(1);
        }
        return dbSrcFileStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateFiles";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

