/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SyncQueue {
    private static final Logger LOG = Logger.getInstance(SyncQueue.class);
    private static Consumer<? super SyncProcessor<?>> ourSyncProcessorInterceptor = null;
    private final MultiMap<Object, SyncProcessor<?>> myActive = MultiMap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAbleToPerform(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            SyncQueue.$$$reportNull$$$0(0);
        }
        MultiMap<Object, SyncProcessor<?>> multiMap = this.myActive;
        synchronized (multiMap) {
            return !this.myActive.containsKey(SyncQueue.getKey(dataSource2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @Nullable
    public Throwable getAsyncTrace(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            SyncQueue.$$$reportNull$$$0(1);
        }
        MultiMap<Object, SyncProcessor<?>> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key2 = SyncQueue.getKey(dataSource2);
            Collection queue = this.myActive.get(key2);
            SyncProcessor item = (SyncProcessor)ContainerUtil.getFirstItem((Collection)queue);
            return item == null ? null : item.getAsyncTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SyncTask getActive(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            SyncQueue.$$$reportNull$$$0(2);
        }
        MultiMap<Object, SyncProcessor<?>> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key2 = SyncQueue.getKey(dataSource2);
            Collection queue = this.myActive.get(key2);
            SyncProcessor processor2 = (SyncProcessor)ContainerUtil.getFirstItem((Collection)queue);
            return processor2 == null ? null : (SyncTask)processor2.myTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public int getActiveTaskCount(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            SyncQueue.$$$reportNull$$$0(3);
        }
        MultiMap<Object, SyncProcessor<?>> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key2 = SyncQueue.getKey(dataSource2);
            Collection queue = this.myActive.get(key2);
            return queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <Task extends SyncTask> AsyncTask<SyncResult> tryPerform(@NotNull Task task, boolean stopRunning, boolean merge2, @NotNull Function<Task, ? extends SyncProcessor<Task>> processorFac) {
        if (task == null) {
            SyncQueue.$$$reportNull$$$0(4);
        }
        if (processorFac == null) {
            SyncQueue.$$$reportNull$$$0(5);
        }
        DasDataSource dataSource2 = task.getKey();
        Object totalTask = task;
        MultiMap<Object, SyncProcessor<?>> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key2 = SyncQueue.getKey(dataSource2);
            Collection queue = this.myActive.getModifiable(key2);
            SmartList dropped = new SmartList();
            SyncProcessor<?> current = SyncQueue.shrinkQueueRunning(queue, arg_0 -> SyncQueue.lambda$tryPerform$0((List)dropped, arg_0));
            if (merge2) {
                if (current != null && stopRunning) {
                    totalTask = ((SyncTask)totalTask).merge((SyncTask)current.myTask);
                }
                for (SyncTask droppedTask : dropped) {
                    totalTask = ((SyncTask)totalTask).merge(droppedTask);
                }
            }
            SyncProcessor processor2 = (SyncProcessor)processorFac.fun(totalTask);
            if (ourSyncProcessorInterceptor != null) {
                ourSyncProcessorInterceptor.consume((Object)processor2);
            }
            queue.add(processor2);
            return current == null ? this.startProcessor(key2, processor2) : SyncQueue.queuedProcessor(current, processor2, stopRunning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public AsyncTask<SyncResult> stopSynchronization(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            SyncQueue.$$$reportNull$$$0(6);
        }
        MultiMap<Object, SyncProcessor<?>> multiMap = this.myActive;
        // MONITORENTER : multiMap
        Object key2 = SyncQueue.getKey(dataSource2);
        Collection queue = this.myActive.getModifiable(key2);
        SyncProcessor<?> current = SyncQueue.shrinkQueueRunning(queue, null);
        if (current == null) {
            AsyncTask<Object> asyncTask = AsyncTask.completed(null);
            // MONITOREXIT : multiMap
            if (asyncTask != null) return asyncTask;
            SyncQueue.$$$reportNull$$$0(7);
            return asyncTask;
        }
        current.cancel();
        AsyncTask<SyncResult> asyncTask = current.myResult.getTask();
        // MONITOREXIT : multiMap
        if (asyncTask != null) return asyncTask;
        SyncQueue.$$$reportNull$$$0(8);
        return asyncTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncTask<SyncResult> whenFinished(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            SyncQueue.$$$reportNull$$$0(9);
        }
        MultiMap<Object, SyncProcessor<?>> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key2 = SyncQueue.getKey(dataSource2);
            Collection queue = this.myActive.get(key2);
            SyncProcessor last2 = (SyncProcessor)ContainerUtil.iterateAndGetLastItem((Iterable)queue);
            return last2 == null ? AsyncTask.completed(null) : last2.myResult.getTask();
        }
    }

    @NotNull
    private static Object getKey(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            SyncQueue.$$$reportNull$$$0(10);
        }
        String string = dataSource2.getUniqueId();
        if (string == null) {
            SyncQueue.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private static SyncProcessor<?> shrinkQueueRunning(@NotNull Collection<SyncProcessor<?>> queue, @Nullable Consumer<SyncProcessor<?>> droppedConsumer) {
        if (queue == null) {
            SyncQueue.$$$reportNull$$$0(12);
        }
        SyncProcessor<?> first2 = null;
        if (queue.size() < 2) {
            return (SyncProcessor)ContainerUtil.getFirstItem(queue);
        }
        ArrayList toStop = new ArrayList();
        Iterator<SyncProcessor<?>> it2 = queue.iterator();
        while (it2.hasNext()) {
            SyncProcessor<?> cur = it2.next();
            if (first2 == null) {
                first2 = cur;
                continue;
            }
            toStop.add(cur);
            if (droppedConsumer != null) {
                droppedConsumer.consume(cur);
            }
            it2.remove();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (SyncProcessor processor2 : toStop) {
                try {
                    processor2.cancel();
                }
                catch (Throwable e2) {
                    LOG.warn(e2);
                }
            }
        });
        return first2;
    }

    @NotNull
    private static AsyncTask<SyncResult> queuedProcessor(@NotNull SyncProcessor<?> current, @NotNull SyncProcessor<?> processor2, boolean stopExisting) {
        ProgressIndicator indicator;
        if (current == null) {
            SyncQueue.$$$reportNull$$$0(13);
        }
        if (processor2 == null) {
            SyncQueue.$$$reportNull$$$0(14);
        }
        if ((indicator = AsyncUtil.getAsyncFriendlyIndicator()) != null) {
            indicator.setText(DatabaseBundle.message("waiting.for.previous.introspection.to.finish", new Object[0]));
        }
        if (stopExisting) {
            current.cancel();
        }
        AsyncTask<SyncResult> asyncTask = processor2.myResult.getTask();
        if (asyncTask == null) {
            SyncQueue.$$$reportNull$$$0(15);
        }
        return asyncTask;
    }

    @NotNull
    private AsyncTask<SyncResult> startProcessor(@NotNull Object key2, @NotNull SyncProcessor<?> processor2) {
        if (key2 == null) {
            SyncQueue.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            SyncQueue.$$$reportNull$$$0(17);
        }
        AsyncTask<SyncResult> asyncTask = processor2.run().whenComplete(null, (r, e2) -> {
            MultiMap<Object, SyncProcessor<?>> multiMap = this.myActive;
            synchronized (multiMap) {
                Collection queue = this.myActive.getModifiable(key2);
                if (ContainerUtil.getFirstItem((Collection)queue) != processor2) {
                    LOG.warn("Unexpected sync queue corruption");
                }
                queue.remove(processor2);
                if (queue.isEmpty()) {
                    this.myActive.remove(key2);
                } else {
                    SyncProcessor first2 = (SyncProcessor)queue.iterator().next();
                    ApplicationManager.getApplication().executeOnPooledThread(() -> this.startProcessor(key2, first2));
                }
            }
        });
        if (asyncTask == null) {
            SyncQueue.$$$reportNull$$$0(18);
        }
        return asyncTask;
    }

    public static void withSyncProcessorInterceptor(@NotNull Disposable disposableParent, @NotNull Consumer<? super SyncProcessor<?>> consumer2) {
        if (disposableParent == null) {
            SyncQueue.$$$reportNull$$$0(19);
        }
        if (consumer2 == null) {
            SyncQueue.$$$reportNull$$$0(20);
        }
        if (ourSyncProcessorInterceptor != null) {
            throw new IllegalStateException("The interceptor is already in use");
        }
        ourSyncProcessorInterceptor = consumer2;
        Disposer.register((Disposable)disposableParent, () -> {
            ourSyncProcessorInterceptor = null;
        });
    }

    private static /* synthetic */ void lambda$tryPerform$0(List dropped, SyncProcessor p2) {
        dropped.add(p2.myTask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 11, 15, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processorFac";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/SyncQueue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/SyncQueue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "stopSynchronization";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "queuedProcessor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAbleToPerform";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncTrace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActive";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActiveTaskCount";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryPerform";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stopSynchronization";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "whenFinished";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shrinkQueueRunning";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "queuedProcessor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startProcessor";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withSyncProcessorInterceptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 11, 15, 18 -> new IllegalStateException(string);
        };
    }

    public static abstract class SyncProcessor<Task extends SyncTask> {
        protected final Task myTask;
        protected final AsyncTask.DelayedTask<SyncResult> myResult;
        protected final long myStartTime;
        protected final MyProgress myProgress;
        protected final ModalityState myModality;

        SyncProcessor(@NotNull Task task) {
            if (task == null) {
                SyncProcessor.$$$reportNull$$$0(0);
            }
            this.myProgress = new MyProgress();
            this.myTask = task;
            this.myResult = new AsyncTask.DelayedTask(AsyncTask.currentFrame());
            this.myStartTime = System.currentTimeMillis();
            this.myModality = ModalityState.defaultModalityState();
        }

        public void cancel() {
            this.myProgress.cancel();
            this.myResult.cancelIfNotStarted();
        }

        @Nullable
        public Throwable getAsyncTrace() {
            return this.myProgress.getAsyncTrace();
        }

        @NotNull
        public abstract AsyncTask<SyncResult> run();

        protected abstract ProgressIndicator createIndicator();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/database/dataSource/SyncQueue$SyncProcessor", "<init>"));
        }

        public class MyProgress {
            private volatile boolean myCanceled = false;
            private volatile boolean myCreated = false;
            private volatile ProgressIndicator myIndicator = AsyncUtil.getAsyncFriendlyIndicator();

            public synchronized void cancel() {
                if (this.myIndicator != null) {
                    this.myIndicator.cancel();
                }
                this.myCanceled = true;
            }

            @Nullable
            public synchronized ProgressIndicator start() {
                if (this.myCanceled) {
                    return null;
                }
                if (this.myIndicator == null) {
                    this.myIndicator = AsyncUtil.getAsyncFriendlyIndicator();
                }
                boolean bl = this.myCreated = this.myIndicator == null;
                if (this.myCreated) {
                    this.myIndicator = SyncProcessor.this.createIndicator();
                    this.myIndicator.start();
                }
                this.myIndicator.setText(DatabaseBundle.message("message.starting", new Object[0]));
                return this.myIndicator;
            }

            public synchronized void stop() {
                if (this.myIndicator == null || !this.myCreated) {
                    return;
                }
                this.myIndicator.stop();
                if (this.myIndicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)this.myIndicator).processFinish();
                }
            }

            @Nullable
            public synchronized Throwable getAsyncTrace() {
                return AsyncUtil.getAsyncCallTrace(this.myIndicator);
            }
        }
    }

    public static abstract class SyncTask {
        public abstract DasDataSource getKey();

        @NotNull
        public abstract SyncTask merge(@NotNull SyncTask var1);
    }

    public static class SyncResult {
        public final long elapsedTime;
        public final SyncTask task;

        public SyncResult(SyncTask task, long elapsedTime) {
            this.task = task;
            this.elapsedTime = elapsedTime;
        }
    }
}

