/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.DataSourceSshSslPanel;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SslConnectionInterceptor;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.run.ConsoleConfigurationParamProvider;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathsList;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0010J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001dH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/database/dataSource/SslConnectionInterceptor;", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor;", "Lcom/intellij/database/run/ConsoleConfigurationParamProvider;", "Lcom/intellij/database/run/ConsoleRunContextParametersTuner;", "()V", "handleConnectionFailure", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "e", "", "silent", "attempt", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Throwable;ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "interceptConnection", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "populate", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/ParametersList;", "env", "", "", "tuneParams", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "Companion", "UserKeyPasswordErrorInfo", "intellij.database.impl"})
public final class SslConnectionInterceptor
implements DatabaseConnectionInterceptor,
ConsoleConfigurationParamProvider,
ConsoleRunContextParametersTuner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String clientCertApplied = "CLIENT_CERT_APPLIED";

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection var1_1, boolean var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof interceptConnection.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SslConnectionInterceptor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.interceptConnection(null, false, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = proto.getConnectionPoint().getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDataSource(...)");
                dataSource = v0;
                ssl = dataSource.getSslCfg();
                if (ssl == null || !ssl.myEnabled) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = proto;
                $continuation.L$1 = ssl;
                $continuation.label = 1;
                v1 = com.intellij.database.dataSource.SslConnectionInterceptor$Companion.access$initDriverSsl(SslConnectionInterceptor.Companion, proto, silent != false, ssl, (Continuation)$continuation);
                if (v1 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                ssl = (DataSourceSslConfiguration)$continuation.L$1;
                proto = (DatabaseConnectionInterceptor.ProtoConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl30:
                // 2 sources

                JdbcSettings.SSL_MODE.put(proto.getExtraProperties(), (Object)ssl.myMode);
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void populate(@NotNull LocalDataSource dataSource2, @NotNull ParametersList params2, @NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        DataSourceSslConfiguration ssl = dataSource2.getSslCfg();
        if (ssl != null && ssl.myEnabled) {
            if (Registry.is((String)"database.ssl.use.socket.factory", (boolean)false)) {
                SslConnectionInterceptor.Companion.addNotEmpty(params2, ssl.myCaCertPath, "sslCaCertPath");
                SslConnectionInterceptor.Companion.addNotEmpty(params2, ssl.myClientCertPath, "sslClientCertPath");
                SslConnectionInterceptor.Companion.addNotEmpty(params2, ssl.myClientKeyPath, "sslClientKeyPath");
                SslConnectionInterceptor.Companion.addNotEmpty(params2, "true", "sslUseFactory");
            } else {
                if (StringUtil.isNotEmpty((String)ssl.myCaCertPath) || ssl.myUseIdeStore || ssl.myUseJavaStore || ssl.myUseSystemStore) {
                    SslConnectionInterceptor.Companion.addNotEmpty(params2, "true", "sslDeferredCaLoading");
                }
                if (StringUtil.isNotEmpty((String)ssl.myClientKeyPath)) {
                    SslConnectionInterceptor.Companion.addNotEmpty(params2, "true", "sslDeferredKeyLoading");
                }
            }
            if (ssl.myUseSystemStore && JdbcConsoleRunContext.shouldPassJnaPath(dataSource2)) {
                JdbcConsoleRunContext.passJnaPath(params2);
            }
        }
    }

    @Override
    public void tuneParams(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull SimpleJavaParameters params2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        PathsList cp = params2.getClassPath();
        DataSourceSslConfiguration ssl = dataSource2.getSslCfg();
        if (ssl != null && ssl.myEnabled && ssl.myUseSystemStore) {
            JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "org.jetbrains.nativecerts.NativeTrustedCertificates");
            JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "org.bouncycastle.jce.provider.BouncyCastleProvider");
            JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.sun.jna.Library");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection var1_1, @NotNull Throwable var2_2, boolean var3_3, int var4_4, @NotNull Continuation<? super Boolean> var5_5) {
        if (!(var5_5 instanceof handleConnectionFailure.1)) ** GOTO lbl-1000
        var8_6 = var5_5;
        if ((var8_6.label & -2147483648) != 0) {
            var8_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SslConnectionInterceptor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handleConnectionFailure(null, null, false, 0, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (silent != false || !(e instanceof KnownDatabaseException) || !(((KnownDatabaseException)e).info instanceof UserKeyPasswordErrorInfo)) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = proto;
                $continuation.label = 1;
                v0 = SslConnectionInterceptor.Companion.askCredentialsWhenFailed(proto, e.getMessage(), true, (Continuation<? super OneTimeString>)$continuation);
                if (v0 == var9_8) {
                    return var9_8;
                }
                ** GOTO lbl24
            }
            case 1: {
                proto = (DatabaseConnectionInterceptor.ProtoConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                p = (OneTimeString)v0;
                com.intellij.database.dataSource.SslConnectionInterceptor$Companion.access$initClientCertImpl(SslConnectionInterceptor.Companion, proto, p);
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J/\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\r\u0010\u000f\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0019\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\fH\u0002J&\u0010\u001e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/dataSource/SslConnectionInterceptor$Companion;", "", "()V", "clientCertApplied", "", "addNotEmpty", "", "props", "Lcom/intellij/execution/configurations/ParametersList;", "value", "key", "askCredentialsWhenFailed", "Lcom/intellij/credentialStore/OneTimeString;", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "message", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "error", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "askNoCredentials", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initCaCert", "ssl", "Lcom/intellij/database/dataSource/DataSourceSslConfiguration;", "initClientCert", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLcom/intellij/database/dataSource/DataSourceSslConfiguration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initClientCertImpl", "password", "initDriverSsl", "initIdeStore", "initJavaStore", "initSystemStore", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Object initDriverSsl(DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, DataSourceSslConfiguration ssl, Continuation<? super Unit> $completion) {
            if (!proto2.shouldInitDriver() || proto2.getDriver() == null) {
                return Unit.INSTANCE;
            }
            this.initCaCert(proto2, ssl);
            this.initIdeStore(proto2, ssl);
            this.initJavaStore(proto2, ssl);
            this.initSystemStore(proto2, ssl);
            Object object = this.initClientCert(proto2, silent, ssl, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private final Object initClientCert(DatabaseConnectionInterceptor.ProtoConnection var1_1, boolean var2_2, DataSourceSslConfiguration var3_3, Continuation<? super Unit> var4_4) {
            if (!(var4_4 instanceof initClientCert.1)) ** GOTO lbl-1000
            var8_5 = var4_4;
            if ((var8_5.label & -2147483648) != 0) {
                var8_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.database.dataSource.SslConnectionInterceptor$Companion.access$initClientCert(this.this$0, null, false, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)proto.getInterceptorProperties().get("CLIENT_CERT_APPLIED"))) {
                        return Unit.INSTANCE;
                    }
                    if (StringUtil.isEmpty((String)ssl.myClientKeyPath)) {
                        return Unit.INSTANCE;
                    }
                    var6_8 = ssl.myPasswordStorage;
                    Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"myPasswordStorage");
                    $continuation.L$0 = this;
                    $continuation.L$1 = proto;
                    $continuation.label = 1;
                    v0 = DatabaseCredentials.Companion.getInitialCredentials(var6_8, silent == false, (Function1)new Function1<Continuation<? super OneTimeString>, Object>(proto, null){
                        int label;
                        final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                        {
                            this.$proto = $proto;
                            super(1, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OneTimeString>, Object>(this.$proto, null){
                                        int label;
                                        final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                                        {
                                            this.$proto = $proto;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    DatabaseCredentials databaseCredentials = this.$proto.getCredentials();
                                                    LocalDataSource localDataSource = this.$proto.getConnectionPoint().getDataSource();
                                                    Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                                                    return databaseCredentials.getSslPassphrase(localDataSource);
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super OneTimeString> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    if (object3 != object2) return object3;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return object3;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@Nullable Continuation<? super OneTimeString> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, (Function2)new Function2<Throwable, Continuation<? super OneTimeString>, Object>(proto, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ DatabaseConnectionInterceptor.ProtoConnection $proto;
                        {
                            this.$proto = $proto;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    th = (Throwable)this.L$0;
                                    if (th != null) break;
                                    this.label = 1;
                                    v0 = com.intellij.database.dataSource.SslConnectionInterceptor$Companion.access$askNoCredentials(SslConnectionInterceptor.Companion, this.$proto, (Continuation)this);
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl15
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl15:
                                    // 2 sources

                                    v1 = (OneTimeString)v0;
                                    ** GOTO lbl26
                                }
                            }
                            this.label = 2;
                            v2 = SslConnectionInterceptor.Companion.askCredentialsWhenFailed(this.$proto, th.getMessage(), true, (Continuation<? super OneTimeString>)((Continuation)this));
                            if (v2 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl25
                            {
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl25:
                                    // 2 sources

                                    v1 = (OneTimeString)v2;
lbl26:
                                    // 2 sources

                                    return v1;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@Nullable Throwable p1, @Nullable Continuation<? super OneTimeString> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, initClientCert.p.3.INSTANCE, $continuation);
                    if (v0 == var9_7) {
                        return var9_7;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    proto = (DatabaseConnectionInterceptor.ProtoConnection)$continuation.L$1;
                    this = (Companion)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    p = (OneTimeString)v0;
                    this.initClientCertImpl(proto, p);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final void initClientCertImpl(DatabaseConnectionInterceptor.ProtoConnection proto2, OneTimeString password) {
            if (Intrinsics.areEqual((Object)true, (Object)proto2.getInterceptorProperties().get(SslConnectionInterceptor.clientCertApplied))) {
                return;
            }
            DataSourceSslConfiguration ssl = proto2.getConnectionPoint().getDataSource().getSslCfg();
            Object object = ssl;
            String keyPath = object != null && (object = ((DataSourceSslConfiguration)object).myClientKeyPath) != null ? StringKt.nullize$default((String)object, (boolean)false, (int)1, null) : null;
            RemoteDriver driver2 = proto2.getDriver();
            if (keyPath == null || driver2 == null) {
                return;
            }
            try {
                String certPath = StringUtil.nullize((String)ssl.myClientCertPath);
                if (StringsKt.endsWith$default((String)keyPath, (String)".jks", (boolean)false, (int)2, null) && certPath == null) {
                    OneTimeString oneTimeString = password;
                    driver2.loadUserCertificates(keyPath, oneTimeString != null ? OneTimeString.toCharArray$default((OneTimeString)oneTimeString, (boolean)false, (int)1, null) : null);
                } else {
                    OneTimeString oneTimeString = password;
                    driver2.loadUserCertificate("user-provided-key", keyPath, certPath, oneTimeString != null ? OneTimeString.toCharArray$default((OneTimeString)oneTimeString, (boolean)false, (int)1, null) : null);
                }
                proto2.getInterceptorProperties().put(SslConnectionInterceptor.clientCertApplied, true);
            }
            catch (Exception e2) {
                String msg;
                String string = e2.getMessage();
                if (string == null) {
                    string = "";
                }
                if (StringsKt.contains$default((CharSequence)(msg = string), (CharSequence)"JCE error: Password is not ASCII", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)msg, (CharSequence)"JCE error: Cannot retrieve the PKCS8EncodedKeySpec", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)msg, (CharSequence)"Password verification failed", (boolean)false, (int)2, null)) {
                    LocalDataSource localDataSource = proto2.getConnectionPoint().getDataSource();
                    Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                    throw new KnownDatabaseException(new UserKeyPasswordErrorInfo(localDataSource, e2));
                }
                throw e2;
            }
        }

        public final void initCaCert(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull DataSourceSslConfiguration ssl) {
            Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
            Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
            String caCertApplied = "CA_CERT_APPLIED";
            if (Intrinsics.areEqual((Object)true, (Object)proto2.getInterceptorProperties().get(caCertApplied))) {
                return;
            }
            RemoteDriver driver2 = proto2.getDriver();
            String caPath = StringUtil.nullize((String)ssl.myCaCertPath);
            if (caPath != null && driver2 != null) {
                try {
                    if (StringsKt.endsWith$default((String)caPath, (String)".jks", (boolean)false, (int)2, null)) {
                        driver2.loadTrustedCertificates(caPath, null);
                    } else {
                        driver2.loadTrustedCertificate("user-provided-ca", caPath);
                    }
                    proto2.getInterceptorProperties().put(caCertApplied, true);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Failed to load CA certificate", e2);
                }
            }
        }

        private final void initIdeStore(DatabaseConnectionInterceptor.ProtoConnection proto2, DataSourceSslConfiguration ssl) {
            String storePath = CertificateManager.DEFAULT_PATH;
            String storeApplied = "IDE_STORE_APPLIED";
            char[] cArray = "changeit".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] storePassword = cArray;
            boolean enabled = ssl.myUseIdeStore;
            if (Intrinsics.areEqual((Object)true, (Object)proto2.getInterceptorProperties().get(storeApplied))) {
                return;
            }
            RemoteDriver driver2 = proto2.getDriver();
            if (driver2 == null || !enabled || !new File(storePath).exists()) {
                return;
            }
            try {
                driver2.loadTrustedCertificates(storePath, storePassword);
                proto2.getInterceptorProperties().put(storeApplied, true);
            }
            catch (Exception e2) {
                throw new RuntimeException("Failed to load IDE store", e2);
            }
        }

        private final void initJavaStore(DatabaseConnectionInterceptor.ProtoConnection proto2, DataSourceSslConfiguration ssl) {
            String storeApplied = "JAVA_STORE_APPLIED";
            boolean enabled = ssl.myUseJavaStore;
            if (Intrinsics.areEqual((Object)true, (Object)proto2.getInterceptorProperties().get(storeApplied))) {
                return;
            }
            RemoteDriver driver2 = proto2.getDriver();
            if (driver2 == null || !enabled) {
                return;
            }
            try {
                driver2.loadJavaTrustedCertificates();
                proto2.getInterceptorProperties().put(storeApplied, true);
            }
            catch (Exception e2) {
                throw new RuntimeException("Failed to load java store", e2);
            }
        }

        private final void initSystemStore(DatabaseConnectionInterceptor.ProtoConnection proto2, DataSourceSslConfiguration ssl) {
            String storeApplied = "SYSTEM_STORE_APPLIED";
            boolean enabled = ssl.myUseSystemStore;
            if (Intrinsics.areEqual((Object)true, (Object)proto2.getInterceptorProperties().get(storeApplied))) {
                return;
            }
            RemoteDriver driver2 = proto2.getDriver();
            if (driver2 == null || !enabled) {
                return;
            }
            try {
                driver2.loadSystemTrustedCertificates();
                proto2.getInterceptorProperties().put(storeApplied, true);
            }
            catch (Exception e2) {
                throw new RuntimeException("Failed to load system store", e2);
            }
        }

        private final void addNotEmpty(ParametersList props, String value2, String key2) {
            CharSequence charSequence = value2;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                props.addProperty(key2, value2);
            }
        }

        private final Object askNoCredentials(DatabaseConnectionInterceptor.ProtoConnection proto2, Continuation<? super OneTimeString> $completion) {
            return this.askCredentialsWhenFailed(proto2, DatabaseBundle.message("dialog.message.html.please.provide.ssl.private.key.passphrase.html", new Object[0]), false, $completion);
        }

        @Nullable
        public final Object askCredentialsWhenFailed(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable String message2, boolean error2, @NotNull Continuation<? super OneTimeString> $completion) {
            LocalDataSource localDataSource = proto2.getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource2 = localDataSource;
            Project project = proto2.getProject();
            DatabaseCredentials dc = proto2.getCredentials();
            if (project.isDefault()) {
                throw new CancellationException("default project");
            }
            OneTimeString c1 = dc.getSslPassphrase(dataSource2);
            CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
            String string = DatabaseBundle.message("progress.title.re.ask.credentials", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return BuildersKt.withContext((CoroutineContext)coroutineContext.plus((CoroutineContext)new CoroutineName(string)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OneTimeString>, Object>(dc, dataSource2, c1, project, error2, message2, null){
                int label;
                final /* synthetic */ DatabaseCredentials $dc;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ OneTimeString $c1;
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $error;
                final /* synthetic */ String $message;
                {
                    this.$dc = $dc;
                    this.$dataSource = $dataSource;
                    this.$c1 = $c1;
                    this.$project = $project;
                    this.$error = $error;
                    this.$message = $message;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            c2 = this.$dc.getSslPassphrase(this.$dataSource);
                            if (Intrinsics.areEqual((Object)this.$c1, (Object)c2)) {
                                this.label = 1;
                                v0 = com.intellij.openapi.progress.CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Unit>(this.$dc, this.$dataSource, c2, this.$project, this.$error, this.$message){
                                    final /* synthetic */ DatabaseCredentials $dc;
                                    final /* synthetic */ LocalDataSource $dataSource;
                                    final /* synthetic */ OneTimeString $c2;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ boolean $error;
                                    final /* synthetic */ String $message;
                                    {
                                        this.$dc = $dc;
                                        this.$dataSource = $dataSource;
                                        this.$c2 = $c2;
                                        this.$project = $project;
                                        this.$error = $error;
                                        this.$message = $message;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        boolean ok2;
                                        DataSourceSshSslPanel.SslPassphraseComponent component2 = new DataSourceSshSslPanel.SslPassphraseComponent(this.$dc, this.$dataSource);
                                        component2.reset(this.$dataSource.getSslCfg(), this.$c2 == null);
                                        Icon icon = (this.$error ? MessageType.ERROR : MessageType.WARNING).getDefaultIcon();
                                        JComponent jComponent = component2;
                                        Object[] objectArray = new Object[]{this.$dataSource.getName()};
                                        String string = DatabaseBundle.message("dialog.title.connecting.to", objectArray);
                                        String string2 = this.$message;
                                        if (string2 == null) {
                                            string2 = "";
                                        }
                                        DialogBuilder dialogBuilder = DatabaseCredentialsUi.prepareDialog(this.$project, icon, jComponent, string, string2);
                                        Intrinsics.checkNotNullExpressionValue((Object)dialogBuilder, (String)"prepareDialog(...)");
                                        DialogBuilder builder = dialogBuilder;
                                        builder.setPreferredFocusComponent(component2.getPreferredFocusedComponent());
                                        boolean bl = ok2 = builder.show() == 0;
                                        if (!ok2) {
                                            throw new ProcessCanceledException();
                                        }
                                        DataSourceSslConfiguration cfg = this.$dataSource.getSslCfg();
                                        if (cfg != null) {
                                            component2.save(this.$dataSource, cfg, true);
                                        }
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OneTimeString>, Object>(this.$dc, this.$dataSource, null){
                                int label;
                                final /* synthetic */ DatabaseCredentials $dc;
                                final /* synthetic */ LocalDataSource $dataSource;
                                {
                                    this.$dc = $dc;
                                    this.$dataSource = $dataSource;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            return this.$dc.getSslPassphrase(this.$dataSource);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super OneTimeString> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v1 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl23
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super OneTimeString> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        public static final /* synthetic */ Object access$initDriverSsl(Companion $this, DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, DataSourceSslConfiguration ssl, Continuation $completion) {
            return $this.initDriverSsl(proto2, silent, ssl, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ void access$initClientCertImpl(Companion $this, DatabaseConnectionInterceptor.ProtoConnection proto2, OneTimeString password) {
            $this.initClientCertImpl(proto2, password);
        }

        public static final /* synthetic */ Object access$initClientCert(Companion $this, DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, DataSourceSslConfiguration ssl, Continuation $completion) {
            return $this.initClientCert(proto2, silent, ssl, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$askNoCredentials(Companion $this, DatabaseConnectionInterceptor.ProtoConnection proto2, Continuation $completion) {
            return $this.askNoCredentials(proto2, (Continuation<? super OneTimeString>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J,\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u00100\u000bj\u0007`\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/SslConnectionInterceptor$UserKeyPasswordErrorInfo;", "Lcom/intellij/database/dialects/BaseDatabaseErrorHandler$DatabaseErrorInfo;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/Exception;)V", "fillInfoData", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lorg/jetbrains/annotations/Nls;", "fixes", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "intellij.database.impl"})
    public static final class UserKeyPasswordErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        public UserKeyPasswordErrorInfo(@NotNull LocalDataSource dataSource2, @NotNull Exception e2) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            super(dataSource2, e2, e2);
        }

        protected void fillInfoData(@NotNull StringBuilder sb, @NotNull List<? extends ErrorInfo.Fix> fixes) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            String string = this.getOriginalThrowable().getMessage();
            if (string == null) {
                string = "";
            }
            String msg = string;
            Object[] objectArray = new Object[]{msg};
            sb.append(DatabaseBundle.message("dialog.message.wrong.ssl.key.password", objectArray));
        }
    }
}

