/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J8\u0010\u0007\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0082@\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;)V", "createSshSessionWithRetries", "Lkotlin/Triple;", "Lcom/intellij/database/dataSource/DataSourceSshTunnelConfiguration;", "Lcom/intellij/ssh/SshSession;", "Lcom/intellij/ssh/ui/unified/SshUiData;", "ssh", "sshUiData", "(Lcom/intellij/database/dataSource/DataSourceSshTunnelConfiguration;Lcom/intellij/ssh/ui/unified/SshUiData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createTunnels", "Lkotlin/Pair;", "", "Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshTunnel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "SshForcedPortErrorInfo", "SshForcedPortNotApplicableErrorInfo", "SshForcedPortOccupiedErrorInfo", "SshTunnel", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseSshTunnelEstablisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSshTunnelEstablisher.kt\ncom/intellij/database/dataSource/DatabaseSshTunnelEstablisher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
public final class DatabaseSshTunnelEstablisher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final LocalDataSource myDataSource;
    @NotNull
    private static final Logger LOG;
    public static final int DEF_PORT = 22;
    @NotNull
    public static final String DEF_KEY_FILE = "~/.ssh/id_rsa";

    private DatabaseSshTunnelEstablisher(Project myProject, LocalDataSource myDataSource) {
        this.myProject = myProject;
        this.myDataSource = myDataSource;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object createTunnels(@NotNull Continuation<? super Pair<? extends SshSession, ? extends List<SshTunnel>>> var1_1) {
        if (!(var1_1 instanceof createTunnels.1)) ** GOTO lbl-1000
        var15_2 = var1_1;
        if ((var15_2.label & -2147483648) != 0) {
            var15_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseSshTunnelEstablisher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createTunnels((Continuation<? super Pair<? extends SshSession, ? extends List<SshTunnel>>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ssh = DataSourceSshTunnelConfiguration.getEnabledSshConfiguration(this.myDataSource);
                if (ssh == null) {
                    return null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = ssh;
                $continuation.label = 1;
                v0 = com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$extractHostsPorts(DatabaseSshTunnelEstablisher.Companion, this.myProject, this.myDataSource, (Continuation)$continuation);
                if (v0 == var16_4) {
                    return var16_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                ssh = (DataSourceSshTunnelConfiguration)$continuation.L$1;
                this = (DatabaseSshTunnelEstablisher)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if ((hostsPorts = (List)v0).isEmpty()) {
                    throw new UnsupportedOperationException(DatabaseBundle.message("DataSourceSshPanel.unable.to.find.host.port", new Object[0]));
                }
                v1 = forcedLocalPort = ssh.getLocalPort() == -1 ? null : String.valueOf(ssh.getLocalPort());
                if (hostsPorts.size() > 1 && forcedLocalPort != null) {
                    throw new KnownDatabaseException(new SshForcedPortNotApplicableErrorInfo(forcedLocalPort));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = hostsPorts;
                $continuation.L$2 = forcedLocalPort;
                $continuation.label = 2;
                v2 = DatabaseSshTunnelEstablisher.Companion.getInitialSshCredentials(this.myProject, this.myDataSource, true, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>)$continuation);
                if (v2 == var16_4) {
                    return var16_4;
                }
                ** GOTO lbl46
            }
            case 2: {
                forcedLocalPort = (String)$continuation.L$2;
                hostsPorts = (List)$continuation.L$1;
                this = (DatabaseSshTunnelEstablisher)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl46:
                // 2 sources

                config = (Pair)v2;
                v3 = this;
                v4 /* !! */  = config;
                if (v4 /* !! */  != null && (v4 /* !! */  = (DataSourceSshTunnelConfiguration)v4 /* !! */ .getFirst()) != null) {
                    var8_9 /* !! */  = v4 /* !! */ ;
                    it = var8_9 /* !! */ ;
                    var12_12 = v3;
                    $i$a$-takeIf-DatabaseSshTunnelEstablisher$createTunnels$sessionInfo$1 = false;
                    var13_16 = it.isEnabled();
                    v3 = var12_12;
                    v5 /* !! */  = var13_16 ? var8_9 /* !! */  : null;
                } else {
                    v5 /* !! */  = null;
                }
                v6 = config;
                $continuation.L$0 = hostsPorts;
                $continuation.L$1 = forcedLocalPort;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v7 = v3.createSshSessionWithRetries((DataSourceSshTunnelConfiguration)v5 /* !! */ , (SshUiData)(v6 != null ? (SshUiData)v6.getSecond() : null), (Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, ? extends SshUiData>>)$continuation);
                if (v7 == var16_4) {
                    return var16_4;
                }
                ** GOTO lbl73
            }
            case 3: {
                forcedLocalPort = (String)$continuation.L$1;
                hostsPorts = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl73:
                // 2 sources

                if ((sessionInfo = (Triple)v7) == null) {
                    return null;
                }
                session = (SshSession)sessionInfo.getSecond();
                tunnels = new ArrayList<E>();
                try {
                    for (HostPort hostPort : hostsPorts) {
                        localPort = com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$getAddLocalPortTunnel(DatabaseSshTunnelEstablisher.Companion, hostPort, ((SshUiData)sessionInfo.getThird()).getAuthType() == AuthType.OPEN_SSH, forcedLocalPort, session);
                        tunnels.add(new SshTunnel(localPort, hostPort));
                    }
                    return new Pair((Object)session, (Object)tunnels);
                }
                catch (Throwable th) {
                    for (SshTunnel tunnel : tunnels) {
                        JdbcNativeUtil.performSafe((ThrowableRunnable)(ThrowableRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, createTunnels$lambda$1(com.intellij.ssh.SshSession com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$SshTunnel ), ()V)((SshSession)session, (SshTunnel)tunnel));
                    }
                    throw th;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object createSshSessionWithRetries(DataSourceSshTunnelConfiguration ssh, SshUiData sshUiData, Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, ? extends SshUiData>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, ? extends SshUiData>>, Object>(ssh, sshUiData, this, null){
            int label;
            final /* synthetic */ DataSourceSshTunnelConfiguration $ssh;
            final /* synthetic */ SshUiData $sshUiData;
            final /* synthetic */ DatabaseSshTunnelEstablisher this$0;
            {
                this.$ssh = $ssh;
                this.$sshUiData = $sshUiData;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (this.$ssh == null || this.$sshUiData == null) {
                            return null;
                        }
                        try {
                            var2_3 = new Triple((Object)this.$ssh, (Object)com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$createSshSession(DatabaseSshTunnelEstablisher.Companion, this.$sshUiData), (Object)this.$sshUiData);
                            ** GOTO lbl33
                        }
                        catch (Throwable e) {
                            if (!com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$isAuthFailure(DatabaseSshTunnelEstablisher.Companion, e)) {
                                throw e;
                            }
                            this.label = 1;
                            v0 = DatabaseSshTunnelEstablisher.Companion.askSshCredentialsWhenFailed(DatabaseSshTunnelEstablisher.access$getMyProject$p(this.this$0), DatabaseSshTunnelEstablisher.access$getMyDataSource$p(this.this$0), "<html>" + e.getMessage() + "</html>", true, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>)((Continuation)this));
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl22
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        v1 = config = (Pair)v0;
                        v2 = config;
                        this.label = 2;
                        v3 = DatabaseSshTunnelEstablisher.access$createSshSessionWithRetries(this.this$0, v1 != null ? (DataSourceSshTunnelConfiguration)v1.getFirst() : null, (SshUiData)(v2 != null ? (SshUiData)v2.getSecond() : null), (Continuation)this);
                        if (v3 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl32:
                        // 2 sources

                        var2_3 = (Triple)v3;
lbl33:
                        // 2 sources

                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, ? extends SshUiData>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final void createTunnels$lambda$1(SshSession $session, SshTunnel $tunnel) {
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        Intrinsics.checkNotNullParameter((Object)$tunnel, (String)"$tunnel");
        $session.removeLocalTunnel($tunnel.localPort);
    }

    @JvmStatic
    @Nullable
    public static final Pair<SshSession, List<SshTunnel>> createTunnelsSync(@NotNull Project project, @NotNull LocalDataSource dataSource2) throws SshException {
        return Companion.createTunnelsSync(project, dataSource2);
    }

    @JvmStatic
    @NotNull
    public static final String tildeExpandFilename(@NotNull String path) {
        return Companion.tildeExpandFilename(path);
    }

    public static final /* synthetic */ Object access$createSshSessionWithRetries(DatabaseSshTunnelEstablisher $this, DataSourceSshTunnelConfiguration ssh, SshUiData sshUiData, Continuation $completion) {
        return $this.createSshSessionWithRetries(ssh, sshUiData, (Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, ? extends SshUiData>>)$completion);
    }

    public static final /* synthetic */ Project access$getMyProject$p(DatabaseSshTunnelEstablisher $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ LocalDataSource access$getMyDataSource$p(DatabaseSshTunnelEstablisher $this) {
        return $this.myDataSource;
    }

    public /* synthetic */ DatabaseSshTunnelEstablisher(Project myProject, LocalDataSource myDataSource, DefaultConstructorMarker $constructor_marker) {
        this(myProject, myDataSource);
    }

    static {
        Logger logger2 = Logger.getInstance(DatabaseSshTunnelEstablisher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012JC\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0014\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0002J2\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J,\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J$\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u0012J$\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u001aH\u0002J\"\u0010&\u001a\u00020\u00062\u0006\u0010#\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0012\u0010'\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010(\u001a\u00020\u00062\u0006\u0010#\u001a\u00020!2\u0006\u0010)\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u001aH\u0002J6\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010,J\"\u0010-\u001a\u00020\u00062\u0006\u0010#\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u001aH\u0002J(\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J.\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u000b2\u0006\u00100\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0007J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010>\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$Companion;", "", "()V", "DEF_KEY_FILE", "", "DEF_PORT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "askNoSshCredentials", "Lkotlin/Pair;", "Lcom/intellij/database/dataSource/DataSourceSshTunnelConfiguration;", "Lcom/intellij/ssh/ui/unified/SshUiData;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "askSshCredentialsWhenFailed", "message", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "error", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSshSession", "Lcom/intellij/ssh/SshSession;", "sshUiData", "createTunnels", "", "Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshTunnel;", "createTunnelsSync", "extractHostsPorts", "Lcom/intellij/database/dataSource/url/HostPort;", "findExistingForwarding", "hostPort", "requiredLocal", "session", "findExistingPort", "findLocalPort", "getAddLocalPortTunnel", "reuseExisting", "getInitialSshCredentials", "askPassword", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getNewTunnelPort", "getSshAuth", "getSshAuthAsync", "info", "Lcom/intellij/database/model/DasDataSource;", "(Lcom/intellij/database/model/DasDataSource;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAuthFailure", "e", "", "tildeExpandFilename", "path", "usePortFromOpenSSHConfig", "", "holder", "Lcom/intellij/remote/RemoteCredentialsHolder;", "hostConfig", "Lcom/intellij/ssh/config/ConfigRepository$Config;", "useUserFromOpenSSHConfig", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseSshTunnelEstablisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSshTunnelEstablisher.kt\ncom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,338:1\n107#2:339\n79#2,22:340\n*S KotlinDebug\n*F\n+ 1 DatabaseSshTunnelEstablisher.kt\ncom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$Companion\n*L\n270#1:339\n270#1:340,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Pair<SshSession, List<SshTunnel>> createTunnelsSync(@NotNull Project project, @NotNull LocalDataSource dataSource2) throws SshException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            return (Pair)com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends SshSession, ? extends List<? extends SshTunnel>>>, Object>(project, dataSource2, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ LocalDataSource $dataSource;
                {
                    this.$project = $project;
                    this.$dataSource = $dataSource;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DatabaseSshTunnelEstablisher.Companion.createTunnels(this.$project, this.$dataSource, (Continuation<? super Pair<? extends SshSession, ? extends List<SshTunnel>>>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Pair<? extends SshSession, ? extends List<SshTunnel>>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Nullable
        public final Object createTunnels(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull Continuation<? super Pair<? extends SshSession, ? extends List<SshTunnel>>> $completion) {
            return new DatabaseSshTunnelEstablisher(project, dataSource2, null).createTunnels($completion);
        }

        /*
         * Unable to fully structure code
         */
        private final Object extractHostsPorts(Project var1_1, LocalDataSource var2_2, Continuation<? super List<? extends HostPort>> var3_3) {
            if (!(var3_3 instanceof extractHostsPorts.1)) ** GOTO lbl-1000
            var8_4 = var3_3;
            if ((var8_4.label & -2147483648) != 0) {
                var8_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$extractHostsPorts(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = DatabaseConnectionEstablisher.Companion.getProtoConnection((Project)project, (LocalDataSource)dataSource, (Continuation<? super DatabaseConnectionInterceptor.ProtoConnection>)$continuation);
                    if (v0 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    proto = (DatabaseConnectionInterceptor.ProtoConnection)v0;
                    connectionUrl = proto.getUrl();
                    driver = proto.getConnectionPoint().getDatabaseDriver();
                    if (driver == null) {
                        return CollectionsKt.emptyList();
                    }
                    v1 = JdbcUrlParserUtil.extractHostsPorts((Collection<StatelessJdbcUrlParser>)driver.getJDBCUrlParsers(), connectionUrl, null);
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"extractHostsPorts(...)");
                    return v1;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final int getAddLocalPortTunnel(HostPort hostPort, boolean reuseExisting, String requiredLocal, SshSession session2) {
            int existingPort = reuseExisting || requiredLocal != null ? this.findExistingPort(hostPort, requiredLocal, session2) : -1;
            return existingPort != -1 ? existingPort : this.getNewTunnelPort(hostPort, requiredLocal, session2);
        }

        private final int getNewTunnelPort(HostPort hostPort, String requiredLocal, SshSession session2) {
            int localPort = this.findLocalPort(requiredLocal);
            String string = hostPort.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            session2.addLocalTunnel(localPort, string, StringUtil.parseInt((String)hostPort.getPort(), (int)-1));
            LOG.info("SSH tunnel created: " + localPort + ":" + hostPort);
            return localPort;
        }

        private final int findLocalPort(String requiredLocal) {
            if (requiredLocal != null) {
                int localPort = StringUtil.parseInt((String)requiredLocal, (int)-1);
                if (localPort != -1) {
                    return localPort;
                }
                throw new SshException("Requested local port is not an integer: " + requiredLocal, new Attachment[0]);
            }
            try {
                return NetUtils.findAvailableSocketPort();
            }
            catch (IOException e2) {
                throw new SshException("Free port not found", (Throwable)e2, new Attachment[0]);
            }
        }

        private final int findExistingPort(HostPort hostPort, String requiredLocal, SshSession session2) {
            String existing = this.findExistingForwarding(hostPort, requiredLocal, session2);
            if (existing != null) {
                String string = existing.substring(0, StringsKt.indexOf$default((CharSequence)existing, (char)':', (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int localPort = StringUtil.parseInt((String)string, (int)-1);
                if (localPort == -1) {
                    throw new RuntimeException("Failed to parse forwarding: " + existing);
                }
                LOG.info("SSH tunnel reused: " + existing);
                return localPort;
            }
            return -1;
        }

        private final String findExistingForwarding(HostPort hostPort, String requiredLocal, SshSession session2) {
            String prefix;
            session2.applyPortForwardings();
            List existing = session2.getPortForwardingList();
            String term = StringUtil.notNullize((String)requiredLocal) + ":" + hostPort;
            String found = (String)ContainerUtil.find((Iterable)existing, (Condition)(requiredLocal == null ? arg_0 -> Companion.findExistingForwarding$lambda$0(term, arg_0) : arg_0 -> Companion.findExistingForwarding$lambda$1(term, arg_0)));
            if (found != null) {
                return found;
            }
            if (requiredLocal != null && (found = (String)ContainerUtil.find((Iterable)existing, arg_0 -> Companion.findExistingForwarding$lambda$2((Function1)new Function1<String, Boolean>(prefix = requiredLocal + ":"){
                final /* synthetic */ String $prefix;
                {
                    this.$prefix = $prefix;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String o2) {
                    Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                    return StringsKt.startsWith$default((String)o2, (String)this.$prefix, (boolean)false, (int)2, null);
                }
            }, arg_0))) != null) {
                String string = hostPort.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = StringUtil.trimStart((String)found, (String)prefix);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimStart(...)");
                throw new KnownDatabaseException(new SshForcedPortOccupiedErrorInfo(requiredLocal, string, string2));
            }
            return found;
        }

        private final boolean isAuthFailure(Throwable e2) {
            if (e2 instanceof SshException) {
                if (e2 instanceof AuthFailSshTransportException) {
                    return true;
                }
                String message2 = e2.getMessage();
                if (message2 == null) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)"Auth cancel", (Object)message2)) {
                    return true;
                }
                if (StringsKt.contains$default((CharSequence)message2, (CharSequence)"Too many authentication failures", (boolean)false, (int)2, null)) {
                    return true;
                }
            }
            return false;
        }

        private final SshSession createSshSession(SshUiData sshUiData) {
            RemoteCredentialsHolder holder = new RemoteCredentialsHolder();
            holder.copyFrom((RemoteCredentials)sshUiData);
            holder.setPort(StringUtil.parseInt((String)holder.getLiteralPort(), (int)22));
            switch (WhenMappings.$EnumSwitchMapping$0[holder.getAuthType().ordinal()]) {
                case 1: {
                    String string = StringUtil.notNullize((String)StringUtil.nullize((String)holder.getPrivateKeyFile()), (String)DatabaseSshTunnelEstablisher.DEF_KEY_FILE);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notNullize(...)");
                    holder.setPrivateKeyFile(this.tildeExpandFilename(string));
                    break;
                }
                case 2: {
                    OpenSSHClientConfig openSSHConfig = OpenSSHConfigService.Companion.getInstance().getConfig();
                    if (openSSHConfig == null) break;
                    ConfigRepository.Config hostConfig = (ConfigRepository.Config)openSSHConfig.getConfig(holder.getHost());
                    if (StringUtil.isEmptyOrSpaces((String)holder.getHost())) {
                        this.usePortFromOpenSSHConfig(holder, hostConfig);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)holder.getUserName())) break;
                    this.useUserFromOpenSSHConfig(holder, hostConfig);
                }
            }
            ConnectionBuilder builder = RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)((RemoteCredentials)holder), null, null, (boolean)false, null, (int)15, null);
            return builder.connect();
        }

        private final void usePortFromOpenSSHConfig(RemoteCredentialsHolder holder, ConfigRepository.Config hostConfig) {
            int port = hostConfig.getPort();
            if (port != -1) {
                LOG.info("Use " + port + " port from OpenSSH configuration file");
                holder.setPort(port);
            }
        }

        private final void useUserFromOpenSSHConfig(RemoteCredentialsHolder holder, ConfigRepository.Config hostConfig) {
            String user = hostConfig.getUser();
            if (StringUtil.isNotEmpty((String)user)) {
                LOG.info("Use \"" + user + "\" user from OpenSSH configuration file");
                holder.setUserName(user);
            }
        }

        @JvmStatic
        @NotNull
        public final String tildeExpandFilename(@NotNull String path) {
            Object object;
            String path2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String $this$trim$iv = path2 = path;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default((String)(path2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"~", (boolean)false, (int)2, null)) {
                String string = SystemProperties.getUserHome();
                String string2 = path2.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                object = string + string2;
            } else {
                object = path2;
            }
            return object;
        }

        @Nullable
        public final Object askSshCredentialsWhenFailed(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull String message2, boolean error2, @NotNull Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>> $completion) {
            if (project.isDefault()) {
                throw new CancellationException("Default project");
            }
            if (!DataSourceSshTunnelConfiguration.hasTunnel(dataSource2)) {
                throw new CancellationException("No SSH");
            }
            Pair<DataSourceSshTunnelConfiguration, SshUiData> p1 = this.getSshAuth(dataSource2, project);
            return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>, Object>(dataSource2, project, p1, message2, error2, null){
                int label;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ Project $project;
                final /* synthetic */ Pair<DataSourceSshTunnelConfiguration, SshUiData> $p1;
                final /* synthetic */ String $message;
                final /* synthetic */ boolean $error;
                {
                    this.$dataSource = $dataSource;
                    this.$project = $project;
                    this.$p1 = $p1;
                    this.$message = $message;
                    this.$error = $error;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Pair p2 = com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$getSshAuth(DatabaseSshTunnelEstablisher.Companion, this.$dataSource, this.$project);
                            if (!(Intrinsics.areEqual(this.$p1, (Object)p2) || this.$p1 != null && p2 != null && Intrinsics.areEqual((Object)this.$p1.getFirst(), (Object)p2.getFirst()) && this.$p1.getSecond() != null && p2.getSecond() != null && Intrinsics.areEqual((Object)this.$p1.getSecond(), (Object)p2.getSecond()))) {
                                return p2;
                            }
                            return DatabaseUiService.getInstance().askSshCredentials(this.$project, this.$dataSource, this.$message, this.$error);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Nullable
        public final Object askNoSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>> $completion) {
            String string = DatabaseBundle.message("ssh.tunnel.html.please.provide.ssh.credentials.html", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.askSshCredentialsWhenFailed(project, dataSource2, string, false, $completion);
        }

        @Nullable
        public final Object getInitialSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource2, boolean askPassword, @NotNull Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>> $completion) {
            return DatabaseCredentials.Companion.getInitialCredentials(LocalDataSource.Storage.MEMORY, askPassword, (Function1)new Function1<Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>, Object>(dataSource2, project, null){
                int label;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ Project $project;
                {
                    this.$dataSource = $dataSource;
                    this.$project = $project;
                    super(1, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DatabaseSshTunnelEstablisher.Companion.getSshAuthAsync(this.$dataSource, this.$project, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }, (Function2)new Function2<Throwable, Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>, Object>(project, dataSource2, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ LocalDataSource $dataSource;
                {
                    this.$project = $project;
                    this.$dataSource = $dataSource;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            th = (Throwable)this.L$0;
                            if (th != null) break;
                            this.label = 1;
                            v0 = DatabaseSshTunnelEstablisher.Companion.askNoSshCredentials(this.$project, this.$dataSource, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            v1 = (Pair)v0;
                            ** GOTO lbl28
                        }
                    }
                    v2 = th.getMessage();
                    Intrinsics.checkNotNull((Object)v2);
                    this.label = 2;
                    v3 = DatabaseSshTunnelEstablisher.Companion.askSshCredentialsWhenFailed(this.$project, this.$dataSource, v2, true, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>)((Continuation)this));
                    if (v3 == var3_2) {
                        return var3_2;
                    }
                    ** GOTO lbl27
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl27:
                            // 2 sources

                            v1 = (Pair)v3;
lbl28:
                            // 2 sources

                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@Nullable Throwable p1, @Nullable Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, getInitialSshCredentials.4.INSTANCE, $completion);
        }

        private final Pair<DataSourceSshTunnelConfiguration, SshUiData> getSshAuth(LocalDataSource dataSource2, Project project) {
            DataSourceSshTunnelConfiguration ssh = DataSourceSshTunnelConfiguration.getEnabledSshConfiguration(dataSource2);
            if (ssh == null) {
                return null;
            }
            SshConfig config = ssh.getSshConfig(project);
            if (config == null) {
                return null;
            }
            return new Pair((Object)ssh, (Object)new SshUiData(config));
        }

        @Nullable
        public final Object getSshAuthAsync(@NotNull DasDataSource info2, @NotNull Project project, @NotNull Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>> $completion) {
            DataSourceSshTunnelConfiguration ssh;
            LocalDataSource dataSource2;
            LocalDataSource localDataSource = dataSource2 = info2 instanceof LocalDataSource ? (LocalDataSource)info2 : null;
            DataSourceSshTunnelConfiguration dataSourceSshTunnelConfiguration = ssh = localDataSource != null ? localDataSource.getSshConfiguration() : null;
            if (ssh == null) {
                return null;
            }
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>, Object>(dataSource2, project, null){
                int label;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ Project $project;
                {
                    this.$dataSource = $dataSource;
                    this.$project = $project;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$getSshAuth(DatabaseSshTunnelEstablisher.Companion, this.$dataSource, this.$project);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private static final boolean findExistingForwarding$lambda$0(String $term, String o2) {
            Intrinsics.checkNotNullParameter((Object)$term, (String)"$term");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            return StringsKt.endsWith$default((String)o2, (String)$term, (boolean)false, (int)2, null);
        }

        private static final boolean findExistingForwarding$lambda$1(String $term, String o2) {
            Intrinsics.checkNotNullParameter((Object)$term, (String)"$term");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            return Intrinsics.areEqual((Object)o2, (Object)$term);
        }

        private static final boolean findExistingForwarding$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ Object access$extractHostsPorts(Companion $this, Project project, LocalDataSource dataSource2, Continuation $completion) {
            return $this.extractHostsPorts(project, dataSource2, (Continuation<? super List<? extends HostPort>>)$completion);
        }

        public static final /* synthetic */ int access$getAddLocalPortTunnel(Companion $this, HostPort hostPort, boolean reuseExisting, String requiredLocal, SshSession session2) {
            return $this.getAddLocalPortTunnel(hostPort, reuseExisting, requiredLocal, session2);
        }

        public static final /* synthetic */ SshSession access$createSshSession(Companion $this, SshUiData sshUiData) {
            return $this.createSshSession(sshUiData);
        }

        public static final /* synthetic */ boolean access$isAuthFailure(Companion $this, Throwable e2) {
            return $this.isAuthFailure(e2);
        }

        public static final /* synthetic */ Pair access$getSshAuth(Companion $this, LocalDataSource dataSource2, Project project) {
            return $this.getSshAuth(dataSource2, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AuthType.values().length];
                try {
                    nArray[AuthType.KEY_PAIR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AuthType.OPEN_SSH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortErrorInfo;", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "localPort", "", "(Ljava/lang/String;)V", "getLocalPort", "()Ljava/lang/String;", "getFixes", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "getOriginalThrowable", "", "intellij.database.connectivity"})
    public static abstract class SshForcedPortErrorInfo
    implements ErrorInfo {
        @NotNull
        private final String localPort;

        public SshForcedPortErrorInfo(@NotNull String localPort) {
            Intrinsics.checkNotNullParameter((Object)localPort, (String)"localPort");
            this.localPort = localPort;
        }

        @NotNull
        public final String getLocalPort() {
            return this.localPort;
        }

        @NotNull
        public List<ErrorInfo.Fix> getFixes() {
            return CollectionsKt.emptyList();
        }

        @Nullable
        public Throwable getOriginalThrowable() {
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortNotApplicableErrorInfo;", "Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortErrorInfo;", "localPort", "", "(Ljava/lang/String;)V", "getMessage", "intellij.database.connectivity"})
    public static final class SshForcedPortNotApplicableErrorInfo
    extends SshForcedPortErrorInfo {
        public SshForcedPortNotApplicableErrorInfo(@NotNull String localPort) {
            Intrinsics.checkNotNullParameter((Object)localPort, (String)"localPort");
            super(localPort);
        }

        @NotNull
        public String getMessage() {
            Object[] objectArray = new Object[]{this.getLocalPort()};
            String string = DatabaseBundle.message("notification.content.unable.to.create.multiple.ssh.tunnels", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortOccupiedErrorInfo;", "Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortErrorInfo;", "localPort", "", "desiredMapping", "existingMapping", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDesiredMapping", "()Ljava/lang/String;", "getExistingMapping", "getMessage", "intellij.database.connectivity"})
    public static final class SshForcedPortOccupiedErrorInfo
    extends SshForcedPortErrorInfo {
        @NotNull
        private final String desiredMapping;
        @NotNull
        private final String existingMapping;

        public SshForcedPortOccupiedErrorInfo(@NotNull String localPort, @NotNull String desiredMapping, @NotNull String existingMapping) {
            Intrinsics.checkNotNullParameter((Object)localPort, (String)"localPort");
            Intrinsics.checkNotNullParameter((Object)desiredMapping, (String)"desiredMapping");
            Intrinsics.checkNotNullParameter((Object)existingMapping, (String)"existingMapping");
            super(localPort);
            this.desiredMapping = desiredMapping;
            this.existingMapping = existingMapping;
        }

        @NotNull
        public final String getDesiredMapping() {
            return this.desiredMapping;
        }

        @NotNull
        public final String getExistingMapping() {
            return this.existingMapping;
        }

        @NotNull
        public String getMessage() {
            Object[] objectArray = new Object[]{this.getLocalPort(), this.existingMapping, this.desiredMapping};
            String string = DatabaseBundle.message("notification.content.forced.local.port.already.occupied.by.ssh.tunnel.to.expected", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshTunnel;", "", "localPort", "", "remoteHostPort", "Lcom/intellij/database/dataSource/url/HostPort;", "(ILcom/intellij/database/dataSource/url/HostPort;)V", "Companion", "intellij.database.connectivity"})
    public static final class SshTunnel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        public final int localPort;
        @JvmField
        @NotNull
        public final HostPort remoteHostPort;
        @NotNull
        public static final String LOCAL_HOST = "localhost";

        public SshTunnel(int localPort, @NotNull HostPort remoteHostPort) {
            Intrinsics.checkNotNullParameter((Object)remoteHostPort, (String)"remoteHostPort");
            this.localPort = localPort;
            this.remoteHostPort = remoteHostPort;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshTunnel$Companion;", "", "()V", "LOCAL_HOST", "", "intellij.database.connectivity"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

