/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessTemplateJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import icons.DatabaseIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DatabaseDriverImpl
extends UserDataHolderBase
implements DatabaseDriver {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverImpl.class);
    public static final String FIXED_CHANNEL = "fixed";
    private final boolean myPredefined;
    private final String myId;
    private String myBaseId;
    private String myGroupWithId;
    private boolean myAbstract;
    private String myName;
    private String myComment;
    private String myDriverClass;
    private String myDefaultDriverClass;
    private String mySqlDialect;
    private Icon myIcon;
    private String myIconName;
    private String myVmOptions;
    private Dbms myForcedDbms;
    private final Map<String, String> myVmEnv = new LinkedHashMap<String, String>();
    private final List<UrlTemplate> myUrlTemplates = new CopyOnWriteArrayList<UrlTemplate>();
    private final Map<String, String> myDriverProperties = new LinkedHashMap<String, String>();
    private final Map<DatabaseDriver.Option<?>, String> myOptions = new LinkedHashMap();
    private String myJrePath;
    private String myInitScript;
    private String myKeepAliveQuery;
    private final List<DatabaseDriver.ArtifactRef> myArtifacts = new ArrayList<DatabaseDriver.ArtifactRef>();
    private DatabaseDriver.Bounds myBounds;
    private final Set<DatabaseDriver.Constraint> myConstraints = new LinkedHashSet<DatabaseDriver.Constraint>();
    private final List<SimpleClasspathElement> myAdditionalClasspathElements = new ArrayList<SimpleClasspathElement>();
    private final List<SimpleClasspathElement> myNativeLibraryPaths = new ArrayList<SimpleClasspathElement>();
    private final Ref<Parsers> myParsers = Ref.create();
    private final Map<String, String> myAdditionalProperties = new HashMap<String, String>();

    public DatabaseDriverImpl(@Nullable String id, boolean predefined) {
        this.myId = StringUtil.isEmpty((String)id) ? UUID.randomUUID().toString() : id;
        this.myPredefined = predefined;
    }

    public DatabaseDriverImpl(@Nullable String id, @Nullable String name2, @Nullable String driverClass, @Nullable UrlTemplate urlTemplate) {
        this(id, name2, driverClass, urlTemplate, false);
    }

    public DatabaseDriverImpl(@Nullable String id, @Nullable String name2, @Nullable String driverClass, @Nullable UrlTemplate urlTemplate, boolean predefined) {
        this(id, predefined);
        this.myName = name2;
        this.myDriverClass = driverClass;
        if (urlTemplate != null) {
            this.setURLTemplates(Collections.singletonList(urlTemplate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Parsers getParsers() {
        Ref<Parsers> ref2 = this.myParsers;
        // MONITORENTER : ref2
        if (this.myParsers.isNull()) {
            this.myParsers.set((Object)new Parsers(this.myUrlTemplates));
        }
        Parsers parsers = (Parsers)this.myParsers.get();
        // MONITOREXIT : ref2
        if (parsers != null) return parsers;
        DatabaseDriverImpl.$$$reportNull$$$0(0);
        return parsers;
    }

    @NotNull
    public List<Pair<UrlTemplate, String>> getTemplatesErrors() {
        List<Pair<UrlTemplate, String>> list = this.getParsers().templatesErrors;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean isPredefined() {
        return this.myPredefined;
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public String getName() {
        return StringUtil.isNotEmpty((String)this.myName) ? this.myName : (StringUtil.isNotEmpty((String)this.myId) ? this.myId : "???");
    }

    @Override
    @Nullable
    public String getComment() {
        return this.myComment;
    }

    @NotNull
    public String getFullName() {
        String string = this.getName();
        if (string == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setName(@NotNull String name2) {
        if (name2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(3);
        }
        this.myName = name2;
    }

    public void setComment(@Nullable String comment) {
        this.myComment = comment;
    }

    @Override
    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers() {
        List<StatelessJdbcUrlParser> list = this.getParsers().jdbcUrlParsers;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @Nullable
    public DatabaseDriver.Bounds getConnectionBounds() {
        return this.myBounds;
    }

    @Nullable
    public String getJrePath() {
        return this.myJrePath;
    }

    public void setJrePath(@Nullable String jrePath) {
        this.myJrePath = jrePath;
    }

    @Override
    @Nullable
    public String getAdditionalProperty(@NotNull String name2) {
        if (name2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(5);
        }
        return this.myAdditionalProperties.get(name2);
    }

    @Override
    public void setAdditionalProperty(@NotNull String name2, @Nullable String value2) {
        if (name2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(6);
        }
        DbImplUtilCore.putOrRemove(this.myAdditionalProperties, name2, value2);
    }

    @Override
    @NotNull
    public Set<String> getAdditionalPropertiesNames() {
        Set<String> set = this.myAdditionalProperties.keySet();
        if (set == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Override
    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations() {
        EnumSet<StatelessJdbcUrlParser.LocationType> enumSet = this.getParsers().supportedLocations;
        if (enumSet == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(8);
        }
        return enumSet;
    }

    @Override
    public LocalDataSource createDataSource(@Nullable String newName) {
        LocalDataSource result2 = LocalDataSource.fromDriver(this, this.getSampleUrl(), false);
        this.setDefaultProperties(result2, true);
        result2.setName(StringUtil.notNullize((String)newName));
        return result2;
    }

    public void setDefaultProperties(@NotNull LocalDataSource result2, boolean override) {
        if (result2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(9);
        }
        if (override) {
            result2.setInitScript(this.myInitScript);
        } else {
            result2.setInitScript(StringUtil.join(Arrays.asList(this.myInitScript, result2.getInitScript()), (String)"\n"));
        }
        result2.setDriverClass(this.myDriverClass);
        result2.setAutoSynchronize(DatabaseDriver.OPTION_AUTO_SYNC.get(this));
        result2.setAutoCommit(DatabaseDriver.OPTION_AUTO_COMMIT.get(this));
        result2.setSchemaControl(DatabaseDriver.OPTION_SCHEMA_CONTROL.get(this));
        result2.setSourceLoading(DatabaseDriver.OPTION_SOURCE_LOADING.get(this));
        DatabaseAuthProvider provider = DatabaseAuthProvider.getPreferred(result2);
        if (provider == null) {
            provider = DatabaseAuthProvider.getDefault(result2);
        }
        result2.setAuthProviderId(provider.getId());
    }

    @Override
    public String getDriverClass() {
        String driverClass = this.getStoredDriverClass();
        if (driverClass == null) {
            driverClass = this.getDriverClassFromArtifacts();
        }
        if (driverClass == null) {
            driverClass = this.myDefaultDriverClass;
        }
        return driverClass;
    }

    @Nullable
    public String getStoredDriverClass() {
        return this.myDriverClass;
    }

    @Nullable
    private String getDriverClassFromArtifacts() {
        return DatabaseDriverImpl.getArtifactsProperty(this.myArtifacts, "driver.class");
    }

    @Nullable
    public static String getArtifactsProperty(List<DatabaseDriver.ArtifactRef> artifacts, String prop) {
        for (DatabaseDriver.ArtifactRef ref2 : artifacts) {
            String driverClass = ((ArtifactRefImpl)ref2).getProperty(prop);
            if (driverClass == null) continue;
            return driverClass;
        }
        return null;
    }

    public void setDriverClass(String driverClass) {
        this.myDriverClass = StringUtil.nullize((String)driverClass);
    }

    @NotNull
    public Collection<UrlTemplate> getUrlTemplates() {
        List<UrlTemplate> list = this.myUrlTemplates;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURLTemplates(@NotNull Collection<UrlTemplate> templates) {
        if (templates == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(11);
        }
        this.myUrlTemplates.clear();
        this.myUrlTemplates.addAll(templates);
        Ref<Parsers> ref2 = this.myParsers;
        synchronized (ref2) {
            this.myParsers.set(null);
        }
    }

    @Override
    public boolean matchesUrl(@NotNull String url) {
        if (url == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(12);
        }
        return JdbcUrlParserUtil.select(this.getJDBCUrlParsers(), url) != null;
    }

    @Override
    @NotNull
    public String getSampleUrl() {
        StatelessJdbcUrlParser sparser = null;
        for (StatelessJdbcUrlParser parser2 : this.getJDBCUrlParsers()) {
            if (!parser2.getName().equals("default")) continue;
            sparser = parser2;
            break;
        }
        if (sparser == null) {
            sparser = (StatelessJdbcUrlParser)ContainerUtil.getFirstItem(this.getJDBCUrlParsers());
        }
        if (sparser == null) {
            return "";
        }
        JdbcUrlParser parser3 = sparser.createStateful();
        for (String p2 : parser3.getParameterNames()) {
            String def = parser3.getParameterDefValue(p2);
            parser3.setParameter(p2, StringUtil.notNullize((String)def));
        }
        String string = parser3.getUrlText();
        if (string == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public String getSqlDialect() {
        return this.mySqlDialect;
    }

    public void setSqlDialect(String dialect) {
        if (Objects.equals(dialect, this.getSqlDialect())) {
            return;
        }
        this.mySqlDialect = dialect;
    }

    @NotNull
    public Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.myIcon != null ? this.myIcon : DatabaseIcons.UserDriver;
        if (icon == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(14);
        }
        return icon;
    }

    public void setIcon(@Nullable Icon icon) {
        if (this.myIcon == icon || this.myIcon == null && icon == DatabaseIcons.UserDriver) {
            return;
        }
        this.myIcon = icon;
        Dbms dbms = DbImplUtilCore.getDbms(this);
        if (dbms == Dbms.UNKNOWN && this.myIcon != DatabaseIcons.UserDriver || dbms != Dbms.UNKNOWN && this.myIcon != dbms.getIcon()) {
            Icon icon2 = icon = icon instanceof RetrievableIcon ? ((RetrievableIcon)icon).retrieveIcon() : icon;
            if (icon != null && !(icon instanceof CachedImageIcon)) {
                throw new AssertionError((Object)icon.getClass().getName());
            }
            this.myIconName = icon == null ? null : ((CachedImageIcon)icon).getOriginalPath();
        }
    }

    @Override
    public Map<String, String> getDriverProperties() {
        return this.myDriverProperties;
    }

    @Override
    public <T> T getOption(@NotNull DatabaseDriver.Option<T> option) {
        if (option == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(15);
        }
        String value2 = this.myOptions.get(option);
        return option.fromString(value2);
    }

    @Override
    public <T> void setOption(@NotNull DatabaseDriver.Option<T> option, T value2) {
        if (option == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(16);
        }
        if (value2 == null) {
            this.myOptions.remove(option);
        } else {
            this.myOptions.put(option, String.valueOf(value2));
        }
    }

    @Override
    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    @Override
    @Nullable
    public Dbms getForcedDbms() {
        return this.myForcedDbms;
    }

    public void setForcedDbms(@Nullable Dbms dbms) {
        this.myForcedDbms = dbms;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @Override
    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map2 = this.myVmEnv;
        if (map2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(17);
        }
        return map2;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(18);
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    @Nullable
    public String getInitScript() {
        return this.myInitScript;
    }

    public void setInitScript(@Nullable String initScript) {
        this.myInitScript = initScript;
    }

    @Nullable
    public String getKeepAliveQuery() {
        return this.myKeepAliveQuery;
    }

    public void setKeepAliveQuery(@Nullable String keepAliveQuery) {
        this.myKeepAliveQuery = keepAliveQuery;
    }

    @Override
    @NotNull
    public List<DatabaseDriver.ArtifactRef> getArtifacts() {
        List<DatabaseDriver.ArtifactRef> list = this.myArtifacts;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    public void setArtifacts(@NotNull List<DatabaseDriver.ArtifactRef> artifacts) {
        if (artifacts == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(20);
        }
        this.myArtifacts.clear();
        this.myArtifacts.addAll(artifacts);
    }

    @Override
    public List<SimpleClasspathElement> getNativeLibraryPaths() {
        return this.myNativeLibraryPaths;
    }

    public void setNativeLibraryPaths(@NotNull List<SimpleClasspathElement> paths2) {
        if (paths2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(21);
        }
        this.myNativeLibraryPaths.clear();
        this.myNativeLibraryPaths.addAll(paths2);
    }

    @Override
    public List<SimpleClasspathElement> getClasspathElements() {
        return JBIterable.from(this.myArtifacts).flatten(a -> ((ArtifactRefImpl)a).getElements()).append(this.myAdditionalClasspathElements).toList();
    }

    @Override
    public boolean hasDriverFiles() {
        return !this.myAdditionalClasspathElements.isEmpty() || ContainerUtil.or(this.myArtifacts, a -> ((ArtifactRefImpl)a).hasElements());
    }

    @Nullable
    public static String getDriverBaseId(@NotNull Element state) {
        if (state == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(22);
        }
        return StringUtil.nullize((String)state.getAttributeValue("based-on"));
    }

    void setAbstract(boolean a) {
        this.myAbstract = a;
    }

    public boolean isAbstract() {
        return this.myAbstract;
    }

    public void loadState(@NotNull Element config, boolean merge2, boolean overrideName, int format2) {
        if (config == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(23);
        }
        this.loadState(config, merge2, overrideName, format2, null);
    }

    public void loadState(@NotNull Element config, boolean merge2, boolean overrideName, int format2, @Nullable PluginDescriptor descriptor2) {
        Element keepAliveQueryElement;
        String optionName;
        ArrayList<DatabaseDriver.ArtifactRef> prev;
        Element vmOptionsElement;
        Element env;
        Element constraints;
        String name2;
        if (config == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(24);
        }
        PathMacroManager substitutor = DatabaseDriverImpl.getPathSubstitutor();
        if (overrideName || this.myName == null) {
            this.myName = DatabaseDriverImpl.getOverride(config.getAttributeValue("name"), this.myName, merge2);
        }
        this.myBaseId = DatabaseDriverImpl.getOverride(DatabaseDriverImpl.getDriverBaseId(config), this.myBaseId, merge2);
        this.myGroupWithId = DatabaseDriverImpl.getOverride(config.getAttributeValue("group-with"), this.myGroupWithId, merge2);
        this.myAbstract = "true".equals(config.getAttributeValue("abstract")) || this.myAbstract;
        this.myDriverClass = StringUtil.nullize((String)DatabaseDriverImpl.getOverride(config.getAttributeValue("driver-class"), this.myDriverClass, merge2));
        this.myDefaultDriverClass = StringUtil.nullize((String)DatabaseDriverImpl.getOverride(config.getAttributeValue("default-driver-class"), this.myDefaultDriverClass, merge2));
        this.myJrePath = DatabaseDriverImpl.getOverride(config.getAttributeValue("jre-path"), this.myJrePath, merge2);
        Element bounds = config.getChild("connection-bounds");
        if (!merge2) {
            this.myBounds = null;
        }
        if (bounds != null) {
            String readOnly = bounds.getAttributeValue("in-read-only");
            String boundTo = bounds.getAttributeValue("bound-to");
            LinkedHashSet<Object> rewriteParameters = new LinkedHashSet<Object>();
            for (Element param : bounds.getChildren("rewrite-parameter")) {
                name2 = param.getAttributeValue("name");
                boolean inUrl = "true".equals(param.getAttributeValue("in-url"));
                if (!StringUtil.isNotEmpty((String)name2)) continue;
                rewriteParameters.add(Pair.create((Object)name2, (Object)inUrl));
            }
            String defaultValue = bounds.getAttributeValue("default-value");
            if (!merge2 || this.myBounds == null) {
                if (this.myBounds == null) {
                    this.myBounds = new DatabaseDriver.Bounds();
                }
                this.myBounds.inReadOnlyMode = "true".equals(readOnly);
                this.myBounds.boundTo = "schema".equals(boundTo) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                this.myBounds.rewriteParameters = new ArrayList<Pair<String, Boolean>>(rewriteParameters);
                this.myBounds.defaultValue = defaultValue;
            } else {
                if (readOnly != null) {
                    this.myBounds.inReadOnlyMode = "true".equals(readOnly);
                }
                if (boundTo != null) {
                    ObjectKind objectKind = this.myBounds.boundTo = "schema".equals(boundTo) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                }
                if (!rewriteParameters.isEmpty()) {
                    rewriteParameters.addAll(this.myBounds.rewriteParameters);
                    this.myBounds.rewriteParameters = new ArrayList<Pair<String, Boolean>>(rewriteParameters);
                }
                if (defaultValue != null) {
                    this.myBounds.defaultValue = defaultValue;
                }
            }
        }
        if (!merge2) {
            this.myConstraints.clear();
        }
        if ((constraints = config.getChild("constraints")) != null) {
            this.myConstraints.clear();
            for (Element constraint : constraints.getChildren("constraint")) {
                Dbms dbms;
                String dbmsName = constraint.getAttributeValue("dbms");
                Dbms dbms2 = dbms = dbmsName == null ? null : Dbms.byName(dbmsName);
                if (dbms == null && dbmsName != null) continue;
                this.myConstraints.add(new DatabaseDriver.Constraint(dbms, Version.of(constraint.getAttributeValue("from")), Version.of(constraint.getAttributeValue("to"))));
            }
        }
        this.mySqlDialect = DatabaseDriverImpl.getOverride(config.getAttributeValue("dialect"), this.mySqlDialect, merge2);
        this.myForcedDbms = DatabaseDriverImpl.getOverride(Dbms.byName(config.getAttributeValue("forced-dbms")), this.myForcedDbms, merge2);
        this.myIconName = DatabaseDriverImpl.getOverride(config.getAttributeValue("icon"), this.myIconName, merge2);
        if (!Strings.isEmpty((String)this.myIconName)) {
            ClassLoader loader = descriptor2 == null ? null : descriptor2.getPluginClassLoader();
            this.myIcon = IconLoader.findIcon((String)this.myIconName, (ClassLoader)(loader == null ? DatabaseDriverImpl.class.getClassLoader() : loader));
        } else {
            Dbms dbms = DbImplUtilCore.getDbms(this);
            this.myIcon = dbms != Dbms.UNKNOWN ? dbms.getIcon() : null;
        }
        Element remarks = config.getChild("remarks");
        if (remarks != null) {
            this.myComment = remarks.getTextTrim();
        }
        LinkedHashSet<UrlTemplate> templates = new LinkedHashSet<UrlTemplate>();
        if (merge2) {
            templates.addAll(this.myUrlTemplates);
        }
        for (Object element2 : config.getChildren("url-template")) {
            name2 = DatabaseDriverImpl.getIfNotNull(element2.getAttributeValue("name"), "default");
            String template = DatabaseDriverImpl.getIfNotNull(element2.getAttributeValue("template"), element2.getValue());
            if (!StringUtil.isEmpty((String)template)) {
                Iterator t = new UrlTemplate(name2, template);
                if ("true".equals(element2.getAttributeValue("disable"))) {
                    templates.remove(t);
                    continue;
                }
                templates.add((UrlTemplate)((Object)t));
                continue;
            }
            templates.clear();
        }
        this.setURLTemplates(templates);
        if (!merge2) {
            this.myVmEnv.clear();
        }
        if ((env = config.getChild("vm-env")) != null) {
            for (Element property : env.getChildren("property")) {
                this.myVmEnv.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
            }
        }
        if ((vmOptionsElement = config.getChild("vm-options")) != null) {
            Element element3 = vmOptionsElement;
            this.myVmOptions = DatabaseDriverImpl.getOverride(element3.getTextTrim(), this.myVmOptions, merge2);
        }
        List artifacts = config.getChildren("artifact");
        ArrayList<DatabaseDriver.ArtifactRef> arrayList = prev = this.myArtifacts.isEmpty() ? Collections.emptyList() : new ArrayList<DatabaseDriver.ArtifactRef>(this.myArtifacts);
        if (!merge2) {
            this.myArtifacts.clear();
        }
        for (Element element4 : artifacts) {
            ArtifactRefImpl ref2;
            String rolling;
            String channel;
            if (element4.getAttributes().isEmpty()) {
                this.myArtifacts.clear();
                continue;
            }
            String use = element4.getAttributeValue("use");
            if ((use != null || format2 < 201) && !"true".equals(use)) continue;
            String id = (String)ObjectUtils.chooseNotNull((Object)element4.getAttributeValue("id"), (Object)element4.getAttributeValue("name"));
            if (id == null && prev.size() == 1) {
                id = ((DatabaseDriver.ArtifactRef)prev.get(0)).getId();
            }
            DatabaseDriver.ArtifactRef prevArtifact = null;
            Iterator it2 = prev.iterator();
            while (it2.hasNext()) {
                DatabaseDriver.ArtifactRef prevA = (DatabaseDriver.ArtifactRef)it2.next();
                if (!prevA.getId().equals(id)) continue;
                prevArtifact = prevA;
                it2.remove();
                this.myArtifacts.remove(prevA);
            }
            Version version = Version.of(element4.getAttributeValue("version"));
            if (version == null && merge2 && prevArtifact != null) {
                version = prevArtifact.getArtifactVersion();
            }
            if ((channel = element4.getAttributeValue("channel")) == null && (rolling = element4.getAttributeValue("rolling")) != null) {
                String string = channel = !Boolean.FALSE.toString().equals(rolling) ? "stable" : FIXED_CHANNEL;
            }
            if (FIXED_CHANNEL.equals(channel)) {
                channel = null;
            } else if (channel == null) {
                String string = channel = merge2 && prevArtifact != null ? prevArtifact.getChannel() : "stable";
            }
            if ((ref2 = (ArtifactRefImpl)DatabaseDriverImpl.createArtifactRef(id, version, channel)) == null) continue;
            for (Element lib : element4.getChildren("library")) {
                if (substitutor != null) {
                    substitutor.expandPaths(lib);
                }
                ref2.appendLegacy(SimpleClasspathElementFactory.createElements(null, (Element)lib));
            }
            this.myArtifacts.add(ref2);
        }
        if (!merge2) {
            this.myOptions.clear();
        }
        for (Element element4 : config.getChildren("option")) {
            optionName = element4.getAttributeValue("name");
            String value2 = element4.getAttributeValue("value");
            DatabaseDriver.Option option = DatabaseDriver.Option.byName(optionName);
            if (option == null || value2 == null || value2.equals(option.getDefault().toString())) continue;
            this.myOptions.put(option, value2);
        }
        if (!merge2) {
            this.myDriverProperties.clear();
        }
        for (Element element4 : config.getChildren("property")) {
            optionName = element4.getAttributeValue("name");
            if (StringUtil.isEmpty((String)optionName)) continue;
            this.myDriverProperties.put(optionName, element4.getAttributeValue("value"));
        }
        if (!merge2) {
            this.myAdditionalClasspathElements.clear();
            this.myNativeLibraryPaths.clear();
        }
        for (Element element4 : config.getChildren("library")) {
            ArrayList additional = new ArrayList();
            ArrayList<SimpleClasspathElement> natives = new ArrayList<SimpleClasspathElement>();
            if (substitutor != null) {
                substitutor.expandPaths(element4);
            }
            for (SimpleClasspathElement e2 : SimpleClasspathElementFactory.createElements(null, (Element)element4)) {
                boolean nativeLib = "true".equals(element4.getAttributeValue("native"));
                if (format2 < 201 && !nativeLib) {
                    nativeLib = ContainerUtil.exists((Iterable)e2.getClassesRootUrls(), r -> (r.startsWith("sqlserver") || r.startsWith("jtds")) && r.endsWith("-win-auth.jar"));
                }
                (nativeLib ? natives : additional).add(e2);
            }
            this.myAdditionalClasspathElements.addAll(additional);
            this.myNativeLibraryPaths.addAll(natives);
        }
        Element initScriptElement = config.getChild("init-script");
        if (initScriptElement != null) {
            this.myInitScript = DatabaseDriverImpl.getOverride(initScriptElement.getTextTrim(), this.myInitScript, merge2);
        }
        if ((keepAliveQueryElement = config.getChild("keep-alive-query")) != null) {
            this.myKeepAliveQuery = DatabaseDriverImpl.getOverride(keepAliveQueryElement.getTextTrim(), this.myKeepAliveQuery, merge2);
        }
        this.myAdditionalProperties.clear();
        Element additionalPropertiesElement = config.getChild("jdbc-additional-properties");
        if (additionalPropertiesElement != null) {
            DatabaseDriverImpl.loadProperties(additionalPropertiesElement, this.myAdditionalProperties);
        }
    }

    @Nullable
    private static PathMacroManager getPathSubstitutor() {
        Application app = ApplicationManager.getApplication();
        return app == null ? null : PathMacroManager.getInstance((ComponentManager)app);
    }

    @Nullable
    public String getBaseId() {
        return this.myBaseId;
    }

    @Nullable
    public String getGroupWithId() {
        return StringUtil.nullize((String)this.myGroupWithId);
    }

    public Element getState(@Nullable DatabaseDriverImpl base) {
        Set<DatabaseDriver.Constraint> preConstraints;
        DatabaseDriver.Bounds preBounds;
        Object tplElement;
        String defaultDriverClass;
        String driverClass;
        Element result2 = new Element("driver");
        result2.setAttribute("id", this.myId);
        if (this.myBaseId != null && (base == null || base.getId().equals(this.myBaseId))) {
            result2.setAttribute("based-on", this.myBaseId);
        }
        if (base == null && this.myAbstract) {
            result2.setAttribute("abstract", "true");
        }
        if (base == null || !Objects.equals(StringUtil.nullize((String)base.getName()), StringUtil.nullize((String)this.myName))) {
            result2.setAttribute("name", StringUtil.notNullize((String)this.myName));
        }
        if (base == null ? this.myGroupWithId != null : !Objects.equals(base.getGroupWithId(), this.getGroupWithId())) {
            result2.setAttribute("group-with", StringUtil.notNullize((String)this.myGroupWithId));
        }
        if (!(this.mySqlDialect == null || base != null && Objects.equals(base.getSqlDialect(), this.mySqlDialect))) {
            result2.setAttribute("dialect", this.mySqlDialect);
        }
        if (this.myForcedDbms != null) {
            result2.setAttribute("forced-dbms", this.myForcedDbms.getName());
        }
        String string = driverClass = base == null ? null : StringUtil.nullize((String)base.myDriverClass);
        if (!StringUtil.isEmpty((String)this.myDriverClass) && !Objects.equals(StringUtil.nullize((String)this.myDriverClass), driverClass)) {
            result2.setAttribute("driver-class", this.myDriverClass);
        }
        String string2 = defaultDriverClass = base == null ? null : StringUtil.nullize((String)base.myDefaultDriverClass);
        if (!StringUtil.isEmpty((String)this.myDefaultDriverClass) && !Objects.equals(StringUtil.nullize((String)this.myDefaultDriverClass), defaultDriverClass)) {
            result2.setAttribute("default-driver-class", this.myDefaultDriverClass);
        }
        if (StringUtil.isNotEmpty((String)this.myJrePath)) {
            result2.setAttribute("jre-path", this.myJrePath);
        }
        if (base == null && StringUtil.isNotEmpty((String)this.myIconName) || base != null && !Objects.equals(base.myIconName, this.myIconName)) {
            result2.setAttribute("icon", this.myIconName);
        }
        if (base == null && !StringUtil.isEmpty((String)this.myComment) || base != null && !Objects.equals(base.myComment, this.myComment)) {
            result2.addContent(new Element("remarks").addContent(this.myComment));
        }
        HashSet<UrlTemplate> predefTemplates = base == null ? Collections.emptySet() : new HashSet<UrlTemplate>(base.myUrlTemplates);
        for (UrlTemplate template : predefTemplates) {
            if (StringUtil.isEmpty((String)template.getTemplate()) || this.myUrlTemplates.contains(template)) continue;
            tplElement = new Element("url-template");
            tplElement.setAttribute("name", template.getName());
            tplElement.setAttribute("template", template.getTemplate());
            tplElement.setAttribute("disable", "true");
            result2.addContent((Element)tplElement);
        }
        for (UrlTemplate template : this.myUrlTemplates) {
            if (StringUtil.isEmpty((String)template.getTemplate()) || predefTemplates.contains(template)) continue;
            tplElement = new Element("url-template");
            tplElement.setAttribute("name", template.getName());
            tplElement.setAttribute("template", template.getTemplate());
            result2.addContent((Element)tplElement);
        }
        DatabaseDriver.Bounds bounds = preBounds = base == null ? null : base.getConnectionBounds();
        if (this.myBounds != null && !Comparing.equal((Object)this.myBounds, (Object)preBounds)) {
            Element bounds2 = new Element("connection-bounds");
            if (preBounds == null) {
                preBounds = new DatabaseDriver.Bounds();
            }
            if (!Comparing.equal((Object)this.myBounds.inReadOnlyMode, (Object)preBounds.inReadOnlyMode)) {
                bounds2.setAttribute("in-read-only", Boolean.toString(this.myBounds.inReadOnlyMode));
            }
            if (!Comparing.equal((Object)this.myBounds.boundTo, (Object)preBounds.boundTo)) {
                bounds2.setAttribute("bound-to", this.myBounds.boundTo.code());
            }
            if (!Comparing.equal(this.myBounds.rewriteParameters, preBounds.rewriteParameters)) {
                for (Pair pair : this.myBounds.rewriteParameters) {
                    Element element2 = new Element("rewrite-parameter");
                    element2.setAttribute("name", (String)pair.first);
                    if (((Boolean)pair.second).booleanValue()) {
                        element2.setAttribute("in-url", "true");
                    }
                    bounds2.addContent(element2);
                }
            }
            if (!Objects.equals(this.myBounds.defaultValue, preBounds.defaultValue)) {
                bounds2.setAttribute("default-value", StringUtil.notNullize((String)this.myBounds.defaultValue));
            }
            result2.addContent(bounds2);
        }
        Set<DatabaseDriver.Constraint> set = preConstraints = base == null ? null : base.getConstraints();
        if (!Comparing.equal(this.myConstraints, preConstraints) && !this.myConstraints.isEmpty()) {
            Element constraints = new Element("constraints");
            for (DatabaseDriver.Constraint constraint : this.myConstraints) {
                Element c2 = new Element("constraint");
                if (constraint.dbms != null) {
                    c2.setAttribute("dbms", constraint.dbms.getName());
                }
                if (constraint.from != null) {
                    c2.setAttribute("from", constraint.from.toString());
                }
                if (constraint.to != null) {
                    c2.setAttribute("to", constraint.to.toString());
                }
                constraints.addContent(c2);
            }
            result2.addContent(constraints);
        }
        if (base == null || !this.myArtifacts.equals(base.getArtifacts())) {
            Collection<DatabaseDriver.ArtifactRef> artifacts;
            if (base == null) {
                artifacts = this.myArtifacts;
            } else {
                LinkedHashMap<String, DatabaseDriver.ArtifactRef> linkedHashMap = new LinkedHashMap<String, DatabaseDriver.ArtifactRef>();
                for (DatabaseDriver.ArtifactRef artifact : this.myArtifacts) {
                    linkedHashMap.put(artifact.getId(), artifact);
                }
                if (ContainerUtil.find(base.myArtifacts, ba -> !extra.containsKey(ba.getId())) != null) {
                    artifacts = this.myArtifacts;
                    result2.addContent(new Element("artifact"));
                } else {
                    for (DatabaseDriver.ArtifactRef ba2 : base.myArtifacts) {
                        if (!ba2.equals(linkedHashMap.get(ba2.getId()))) continue;
                        linkedHashMap.remove(ba2.getId());
                    }
                    artifacts = linkedHashMap.values();
                }
            }
            for (DatabaseDriver.ArtifactRef artifactRef : artifacts) {
                Element artifactElement = new Element("artifact");
                artifactElement.setAttribute("id", artifactRef.getId());
                artifactElement.setAttribute("name", artifactRef.getId());
                String channel = artifactRef.getChannel();
                if (!"stable".equals(channel)) {
                    artifactElement.setAttribute("channel", StringUtil.notNullize((String)channel, (String)FIXED_CHANNEL));
                    artifactElement.setAttribute("rolling", Boolean.toString(channel != null));
                }
                artifactElement.setAttribute("use", Boolean.TRUE.toString());
                if (artifactRef.getArtifactVersion() != null) {
                    artifactElement.setAttribute("version", artifactRef.getArtifactVersion().toString());
                } else {
                    DatabaseDriverImpl.serializeClassPathElements(artifactElement, ((ArtifactRefImpl)artifactRef).getElements(), null);
                }
                result2.addContent(artifactElement);
            }
        }
        for (DatabaseDriver.Option option : this.myOptions.keySet()) {
            Object object = ObjectUtils.notNull(base == null ? null : base.getOption(option), option.getDefault());
            String strValue = this.myOptions.get(option);
            Object value2 = option.fromString(strValue);
            if (Objects.equals(value2, object)) continue;
            Element e3 = new Element("option");
            e3.setAttribute("name", option.getName());
            e3.setAttribute("value", strValue);
            result2.addContent(e3);
        }
        if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
            Element e4 = new Element("vm-options");
            e4.setText(this.myVmOptions);
            result2.addContent(e4);
        }
        if (!this.myVmEnv.isEmpty()) {
            Element env = new Element("vm-env");
            for (String string3 : this.myVmEnv.keySet()) {
                Element prop = new Element("property");
                prop.setAttribute("name", string3);
                prop.setAttribute("value", this.myVmEnv.get(string3));
                env.addContent(prop);
            }
            result2.addContent(env);
        }
        Map<Object, Object> predefProps = base == null ? Collections.emptyMap() : base.getDriverProperties();
        for (Map.Entry<String, String> entry : this.myDriverProperties.entrySet()) {
            if (Objects.equals(predefProps.get(entry.getKey()), entry.getValue())) continue;
            Element optionElement = new Element("property");
            optionElement.setAttribute("name", entry.getKey());
            optionElement.setAttribute("value", entry.getValue());
            result2.addContent(optionElement);
        }
        DatabaseDriverImpl.serializeClassPathElements(result2, this.myAdditionalClasspathElements, null);
        DatabaseDriverImpl.serializeClassPathElements(result2, this.myNativeLibraryPaths, "native");
        if (StringUtil.isNotEmpty((String)this.myInitScript)) {
            Element element3 = new Element("init-script");
            element3.setText(this.myInitScript);
            result2.addContent(element3);
        }
        if (StringUtil.isNotEmpty((String)this.myKeepAliveQuery)) {
            Element element4 = new Element("keep-alive-query");
            element4.setText(this.myKeepAliveQuery);
            result2.addContent(element4);
        }
        if (!this.myAdditionalProperties.isEmpty()) {
            Element element5 = new Element("jdbc-additional-properties");
            DatabaseDriverImpl.serializeProperties(element5, this.myAdditionalProperties);
            result2.addContent(element5);
        }
        return result2;
    }

    private static void serializeProperties(@NotNull Element element2, @NotNull Map<String, String> properties2) {
        if (element2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(25);
        }
        if (properties2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(26);
        }
        PathMacroManager ps = DatabaseDriverImpl.getPathSubstitutor();
        for (Map.Entry<String, String> e2 : properties2.entrySet()) {
            String name2 = e2.getKey();
            String value2 = e2.getValue();
            if (ps != null) {
                value2 = ps.collapsePathsRecursively(value2);
            }
            Element row = new Element("property");
            row.setAttribute("name", name2);
            row.setAttribute("value", value2);
            element2.addContent(row);
        }
    }

    private static void loadProperties(@NotNull Element propertiesElement, @NotNull Map<String, String> properties2) {
        if (propertiesElement == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(27);
        }
        if (properties2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(28);
        }
        PathMacroManager ps = DatabaseDriverImpl.getPathSubstitutor();
        List propertyRows = propertiesElement.getChildren("property");
        for (Element pr : propertyRows) {
            String name2 = pr.getAttributeValue("name");
            String value2 = pr.getAttributeValue("value");
            if (name2 == null || value2 == null) continue;
            name2 = name2.trim();
            value2 = value2.trim();
            if (name2.isEmpty() || value2.isEmpty()) continue;
            if (ps != null) {
                value2 = ps.expandPath(value2);
            }
            properties2.put(name2, value2);
        }
    }

    private static void serializeClassPathElements(Element result2, List<SimpleClasspathElement> classpathElements, String extra) {
        PathMacroManager substitutor = DatabaseDriverImpl.getPathSubstitutor();
        for (SimpleClasspathElement cpe : classpathElements) {
            Element libraryElement = new Element("library");
            try {
                cpe.serialize(libraryElement);
                if (substitutor != null) {
                    substitutor.collapsePaths(libraryElement);
                }
            }
            catch (IOException e2) {
                LOG.warn((Throwable)e2);
            }
            if (extra != null) {
                libraryElement.setAttribute(extra, "true");
            }
            result2.addContent(libraryElement);
        }
    }

    private static <T> T getIfNotNull(T value2, T defaultValue) {
        return value2 == null || value2 instanceof String && StringUtil.isEmpty((String)((String)value2)) ? defaultValue : value2;
    }

    private static <T> T getOverride(T value2, T oldValue, boolean merge2) {
        return merge2 ? DatabaseDriverImpl.getIfNotNull(value2, oldValue) : value2;
    }

    @Override
    public void setAdditionalClasspathElements(List<SimpleClasspathElement> classpathElements) {
        this.myAdditionalClasspathElements.clear();
        this.myAdditionalClasspathElements.addAll(classpathElements);
    }

    @Override
    @NotNull
    public List<SimpleClasspathElement> getAdditionalClasspathElements() {
        List<SimpleClasspathElement> list = this.myAdditionalClasspathElements;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Override
    @NotNull
    public DatabaseDriverImpl copy(@Nullable String newName, boolean withId) {
        DatabaseDriverImpl result2 = new DatabaseDriverImpl(withId ? this.myId : null, (String)ObjectUtils.chooseNotNull((Object)newName, (Object)this.myName), null, null, withId && this.isPredefined());
        result2.loadState(this.getState(null), false, false, Integer.MAX_VALUE);
        DatabaseDriverImpl databaseDriverImpl = result2;
        if (databaseDriverImpl == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(30);
        }
        return databaseDriverImpl;
    }

    public boolean equalConfiguration(DatabaseDriverImpl o2, boolean ignoreClassPath) {
        if (!Objects.equals(StringUtil.nullize((String)this.myName), StringUtil.nullize((String)o2.myName))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o2.getComment())) {
            return false;
        }
        if (!this.myArtifacts.equals(o2.myArtifacts)) {
            return false;
        }
        if (!ignoreClassPath && !this.myAdditionalClasspathElements.equals(o2.myAdditionalClasspathElements)) {
            return false;
        }
        if (!ignoreClassPath && !this.myNativeLibraryPaths.equals(o2.myNativeLibraryPaths)) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.mySqlDialect), StringUtil.nullize((String)o2.mySqlDialect))) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.myDriverClass), StringUtil.nullize((String)o2.myDriverClass))) {
            return false;
        }
        if (!Comparing.equal((Object)this.myBounds, (Object)o2.myBounds)) {
            return false;
        }
        if (!Objects.equals(this.myJrePath, o2.myJrePath)) {
            return false;
        }
        if (!Objects.equals(this.myForcedDbms, o2.myForcedDbms)) {
            return false;
        }
        if (!this.myDriverProperties.equals(o2.myDriverProperties)) {
            return false;
        }
        if (!this.myAdditionalProperties.equals(o2.myAdditionalProperties)) {
            return false;
        }
        for (DatabaseDriver.Option<?> option : DatabaseDriver.Option.enumerate()) {
            if (Comparing.equal(this.getOption(option), o2.getOption(option))) continue;
            return false;
        }
        if (!this.myUrlTemplates.equals(o2.myUrlTemplates)) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.myVmOptions), StringUtil.nullize((String)o2.myVmOptions))) {
            return false;
        }
        if (!ContainerUtil.diff(this.myVmEnv, o2.myVmEnv).isEmpty()) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.myInitScript), StringUtil.nullize((String)o2.myInitScript))) {
            return false;
        }
        if (!Objects.equals(StringUtil.nullize((String)this.myKeepAliveQuery), StringUtil.nullize((String)o2.myKeepAliveQuery))) {
            return false;
        }
        return Comparing.equal((Object)this.myIcon, (Object)o2.myIcon);
    }

    public boolean equalConfiguration(DatabaseDriverImpl o2) {
        return this.equalConfiguration(o2, false);
    }

    public String toString() {
        return DatabaseDriverImpl.class.getSimpleName() + "{myId='" + this.myId + "', myName='" + this.myName + "'}";
    }

    @TestOnly
    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(31);
        }
        sb.append("Id - ").append(this.getId()).append("\n");
        sb.append("Name - ").append(this.getName()).append("\n");
        sb.append("DriverClass - ").append(this.myDriverClass).append("\n");
        sb.append("Dialect - ").append(this.getSqlDialect()).append("\n");
        sb.append("IconName - ").append(this.myIconName).append("\n");
        sb.append("VmOptions - ").append(this.getVmOptions()).append("\n");
        sb.append("Predefined - ").append(this.isPredefined()).append("\n");
        sb.append("UrlTemplates").append("\n");
        for (UrlTemplate urlTemplate : this.getUrlTemplates()) {
            sb.append(" * ").append(urlTemplate.getName()).append(" - ").append(urlTemplate.getTemplate()).append("\n");
        }
        DatabaseDriverImpl.dumpProperties(sb, "DriverProperties", this.getDriverProperties(), true);
        sb.append("Option").append("\n");
        for (Map.Entry entry : this.myOptions.entrySet()) {
            sb.append(" * ").append(entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        DatabaseDriverImpl.dumpProperties(sb, "AdditionalProperties", this.myAdditionalProperties, false);
        if (this.myArtifacts.isEmpty()) {
            sb.append("ArtifactName - null\n");
        }
        for (DatabaseDriver.ArtifactRef artifactRef : this.myArtifacts) {
            sb.append("ArtifactName - ").append(artifactRef.getId()).append("\n");
            for (SimpleClasspathElement element2 : ((ArtifactRefImpl)artifactRef).getElements()) {
                sb.append(" * ").append(element2.getPresentableName()).append("\n");
            }
        }
        sb.append("Bounds - ");
        if (this.myBounds != null) {
            sb.append("boundTo: ").append(this.myBounds.boundTo);
            sb.append("defaultValue: ").append(this.myBounds.defaultValue);
            sb.append("inReadOnlyMode: ").append(this.myBounds.inReadOnlyMode);
            sb.append("rewriteParameters:");
            for (Pair pair : this.myBounds.rewriteParameters) {
                sb.append(" ").append((String)pair.first);
                if (!((Boolean)pair.second).booleanValue()) continue;
                sb.append(":in-url");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n");
        sb.append("ClasspathElements").append("\n");
        for (SimpleClasspathElement simpleClasspathElement : this.getAdditionalClasspathElements()) {
            sb.append(" * ").append(simpleClasspathElement.getPresentableName()).append("\n");
        }
        if (StringUtil.isNotEmpty((String)this.myInitScript)) {
            sb.append("initScript: ").append(this.myInitScript).append("\n");
        }
    }

    private static void dumpProperties(@NotNull StringBuilder b2, String sectionName, Map<String, String> properties2, boolean dumpEmpty) {
        if (b2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(32);
        }
        if (properties2.isEmpty() && !dumpEmpty) {
            return;
        }
        b2.append(sectionName).append("\n");
        for (Map.Entry<String, String> prop : properties2.entrySet()) {
            b2.append(" * ").append(prop.getKey()).append(" - ").append(prop.getValue()).append("\n");
        }
    }

    @Override
    @NotNull
    public Set<DatabaseDriver.Constraint> getConstraints() {
        Set<DatabaseDriver.Constraint> set = this.myConstraints;
        if (set == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(33);
        }
        return set;
    }

    @NotNull
    public List<SimpleClasspathElement> getArtifactClasspathElements() {
        List list = JBIterable.from(this.myArtifacts).flatten(a -> ((ArtifactRefImpl)a).getElements()).toList();
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    public static DatabaseDriver.ArtifactRef createArtifactRef(@Nullable String id, @Nullable Version version, String channel) {
        return StringUtil.isEmpty((String)id) ? null : new ArtifactRefImpl(id, version, channel);
    }

    public static boolean matches(@NotNull DatabaseDriver.ArtifactRef ref2, @NotNull DatabaseArtifactList.ArtifactVersion v2) {
        if (ref2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(35);
        }
        if (v2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(36);
        }
        return DatabaseDriverImpl.matches(ref2, v2.artifact) && Objects.equals(ref2.getArtifactVersion(), v2.version);
    }

    public static boolean matches(@NotNull DatabaseDriver.ArtifactRef ref2, @NotNull DatabaseArtifactList.Artifact a) {
        if (ref2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(37);
        }
        if (a == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(38);
        }
        return a.isId(ref2.getId());
    }

    @NotNull
    public static List<SimpleClasspathElement> getLegacyElements(@NotNull DatabaseDriver.ArtifactRef ref2) {
        if (ref2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(39);
        }
        List<SimpleClasspathElement> list = ((ArtifactRefImpl)ref2).myLegacyElements;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5, 6, 9, 11, 12, 15, 16, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31, 32, 35, 36, 37, 38, 39 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverImpl";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmEnv";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParsers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatesErrors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJDBCUrlParsers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPropertiesNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLocations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlTemplates";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSampleUrl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmEnv";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalClasspathElements";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraints";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactClasspathElements";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalProperty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultProperties";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setURLTemplates";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchesUrl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setArtifacts";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setNativeLibraryPaths";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDriverBaseId";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "serializeProperties";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadProperties";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "dumpProperties";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5, 6, 9, 11, 12, 15, 16, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31, 32, 35, 36, 37, 38, 39 -> new IllegalArgumentException(string);
        };
    }

    private static class Parsers {
        final List<StatelessJdbcUrlParser> jdbcUrlParsers = new ArrayList<StatelessJdbcUrlParser>();
        final EnumSet<StatelessJdbcUrlParser.LocationType> supportedLocations = EnumSet.noneOf(StatelessJdbcUrlParser.LocationType.class);
        final List<Pair<UrlTemplate, String>> templatesErrors = new ArrayList<Pair<UrlTemplate, String>>();

        Parsers(List<UrlTemplate> templates) {
            for (UrlTemplate template : templates) {
                try {
                    StatelessTextDecomposition decomposition = StatelessTextDecomposition.build(template.getTemplate(), TypesRegistry.getInstance());
                    this.jdbcUrlParsers.add(new StatelessTemplateJdbcUrlParser(template.getName(), decomposition));
                }
                catch (StatelessTextDecomposition.InvalidTemplateException e2) {
                    Application application = ApplicationManager.getApplication();
                    if (application == null || application.isUnitTestMode()) {
                        throw new RuntimeException(e2);
                    }
                    this.templatesErrors.add((Pair<UrlTemplate, String>)Pair.create((Object)template, (Object)e2.getMessage()));
                }
            }
            for (StatelessJdbcUrlParser p2 : this.jdbcUrlParsers) {
                this.supportedLocations.addAll(p2.getPossibleLocations());
            }
        }
    }

    private static final class ArtifactRefImpl
    implements DatabaseDriver.ArtifactRef {
        private final String myChannel;
        private final String myId;
        private final Version myVersion;
        private final List<SimpleClasspathElement> myLegacyElements;

        private ArtifactRefImpl(@NotNull String id, @Nullable Version version, String channel) {
            if (id == null) {
                ArtifactRefImpl.$$$reportNull$$$0(0);
            }
            this.myLegacyElements = new ArrayList<SimpleClasspathElement>();
            this.myId = id;
            this.myVersion = version;
            this.myChannel = channel;
        }

        public void appendLegacy(@NotNull List<SimpleClasspathElement> items2) {
            if (items2 == null) {
                ArtifactRefImpl.$$$reportNull$$$0(1);
            }
            if (items2.isEmpty()) {
                return;
            }
            this.myLegacyElements.addAll(items2);
        }

        @NotNull
        public List<SimpleClasspathElement> getElements() {
            if (this.myVersion == null) {
                List<SimpleClasspathElement> list = this.myLegacyElements;
                if (list == null) {
                    ArtifactRefImpl.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<SimpleClasspathElement> list = DatabaseArtifactManager.getClasspathElements(this.myId, this.myVersion);
            if (list == null) {
                ArtifactRefImpl.$$$reportNull$$$0(3);
            }
            return list;
        }

        public boolean hasElements() {
            if (this.myVersion == null) {
                return !this.myLegacyElements.isEmpty();
            }
            return DatabaseArtifactManager.hasClasspathElementsFast(this.myId, this.myVersion);
        }

        @Nullable
        public String getProperty(@NotNull String prop) {
            DatabaseArtifactList.ArtifactVersion resolved;
            if (prop == null) {
                ArtifactRefImpl.$$$reportNull$$$0(4);
            }
            return (resolved = DatabaseArtifactManager.getArtifacts().resolveVersion(this.myId, this.myVersion)) == null ? null : resolved.getProperty(prop);
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                ArtifactRefImpl.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            ArtifactRefImpl ref2 = (ArtifactRefImpl)o2;
            if (!Objects.equals(this.myChannel, ref2.myChannel)) {
                return false;
            }
            if (!this.myId.equals(ref2.myId)) {
                return false;
            }
            if (!Objects.equals(this.myVersion, ref2.myVersion)) {
                return false;
            }
            return Objects.equals(this.myLegacyElements, ref2.myLegacyElements);
        }

        public int hashCode() {
            int result2 = Objects.hashCode(this.myChannel);
            result2 = 31 * result2 + this.myId.hashCode();
            result2 = 31 * result2 + Objects.hashCode(this.myVersion);
            result2 = 31 * result2 + Objects.hashCode(this.myLegacyElements);
            return result2;
        }

        @Override
        @Nullable
        public Version getArtifactVersion() {
            return this.myVersion;
        }

        @Override
        public String getChannel() {
            return this.myChannel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prop";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "appendLegacy";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getProperty";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

