/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.InterruptibleDatabaseConnectionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.DatabaseIntrospectionSession;
import com.intellij.database.introspection.DbmsMismatchException;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
public final class DataSourceSyncManager {
    private static final DatabaseExecutor NEW_CONNECTION_EXECUTOR;
    private static DatabaseExecutor ourDefaultExecutor;
    private final SyncQueue myQueue = new SyncQueue();

    public static DataSourceSyncManager getInstance() {
        return (DataSourceSyncManager)ApplicationManager.getApplication().getService(DataSourceSyncManager.class);
    }

    private static void executeDatabaseOperation(@NotNull DbSyncTask syncTask, @Nullable ObjectPath path, boolean silent, @NotNull ThrowableConsumer<DatabaseConnection, Exception> op) {
        if (syncTask == null) {
            DataSourceSyncManager.$$$reportNull$$$0(0);
        }
        if (op == null) {
            DataSourceSyncManager.$$$reportNull$$$0(1);
        }
        LoaderContext loaderContext = syncTask.context;
        Project project = loaderContext.getProject();
        LocalDataSource ds = loaderContext.getDataSource();
        SearchPath searchPath = SearchPath.of(path);
        DatabaseConnectionConfig session2 = (DatabaseConnectionConfig)ObjectUtils.notNull((Object)ds.getIntrospectorSessionTemplate(), (Object)ds);
        DatabaseSessionManager.Facade dbSessionManagerFacade = DatabaseSessionManager.getFacade(project, session2, loaderContext.getCredentialsStore(), searchPath, silent, loaderContext.getErrorHandler(), DGDepartment.INTROSPECTION);
        dbSessionManagerFacade.runSync(connection2 -> {
            ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
            if (indicator == null) {
                throw new AssertionError((Object)"Indicator not found");
            }
            InterruptibleDatabaseConnectionKt.withCancelling(connection2, indicator, (Function0<Unit>)((Function0)() -> (Unit)SessionsUtil.consumer(op).invoke(connection2)));
            return null;
        });
    }

    private static boolean isSyncAble(@NotNull Project project, @NotNull RawDataSource dataSource2) {
        DataSourceManager<RawDataSource> manager;
        if (project == null) {
            DataSourceSyncManager.$$$reportNull$$$0(2);
        }
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(3);
        }
        return (manager = DataSourceManager.byDataSource(project, dataSource2)) == null || !manager.isLoading(dataSource2);
    }

    @TestOnly
    public static void withDefaultExecutor(@NotNull Disposable disposableParent, @Nullable DatabaseExecutor e2) {
        if (disposableParent == null) {
            DataSourceSyncManager.$$$reportNull$$$0(4);
        }
        DatabaseExecutor prev = ourDefaultExecutor;
        Disposer.register((Disposable)disposableParent, () -> {
            ourDefaultExecutor = prev;
        });
        ourDefaultExecutor = e2;
    }

    public boolean isAbleToPerform(@NotNull Project project, @NotNull RawDataSource dataSource2) {
        if (project == null) {
            DataSourceSyncManager.$$$reportNull$$$0(5);
        }
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(6);
        }
        if (!DataSourceSyncManager.isSyncAble(project, dataSource2)) {
            return false;
        }
        return this.myQueue.isAbleToPerform(dataSource2);
    }

    @TestOnly
    @Nullable
    public Throwable getAsyncTrace(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(7);
        }
        return this.myQueue.getAsyncTrace(dataSource2);
    }

    public boolean isActive(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(8);
        }
        return this.myQueue.getActive(dataSource2) != null;
    }

    @TestOnly
    public int getActiveTaskCount(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(9);
        }
        return this.myQueue.getActiveTaskCount(dataSource2);
    }

    public @Nullable AsyncTask<@NotNull SyncQueue.SyncResult> tryPerform(@NotNull LoaderContext context, boolean stopRunning, boolean merge2, @Nullable DatabaseExecutor executor) {
        if (context == null) {
            DataSourceSyncManager.$$$reportNull$$$0(10);
        }
        DbSyncTask syncTask = new DbSyncTask(context);
        return this.tryPerform(syncTask, stopRunning, merge2, executor);
    }

    public @Nullable AsyncTask<@NotNull SyncQueue.SyncResult> tryPerform(@NotNull LoaderContext context, boolean stopRunning, boolean merge2) {
        if (context == null) {
            DataSourceSyncManager.$$$reportNull$$$0(11);
        }
        return this.tryPerform(context, stopRunning, merge2, null);
    }

    private @Nullable AsyncTask<@NotNull SyncQueue.SyncResult> tryPerform(@NotNull DbSyncTask task, boolean stopRunning, boolean merge2, @Nullable DatabaseExecutor executor) {
        if (task == null) {
            DataSourceSyncManager.$$$reportNull$$$0(12);
        }
        if (!DataSourceSyncManager.isSyncAble(task.context.getProject(), task.getKey())) {
            return null;
        }
        return this.myQueue.tryPerform(task, stopRunning, merge2, t -> new DbSyncProcessor((DbSyncTask)t, executor));
    }

    public @Nullable AsyncTask<@NotNull SyncQueue.SyncResult> tryPerform(@NotNull SqlDataSource dataSource2, boolean stopRunning, boolean merge2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(13);
        }
        return this.myQueue.tryPerform(new SqlSyncTask(dataSource2), stopRunning, merge2, SqlSyncProcessor::new);
    }

    public @Nullable AsyncTask<@NotNull SyncQueue.SyncResult> applyMappings(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceSyncManager.$$$reportNull$$$0(14);
        }
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(15);
        }
        if (!DataSourceSyncManager.isSyncAble(project, dataSource2)) {
            return null;
        }
        LoaderContext ctx = LoaderContext.selectSkip(project, dataSource2);
        DbSyncTask syncTask = new DbSyncTask(ctx);
        return this.myQueue.tryPerform(syncTask, false, true, task -> new DbSyncProcessor((DbSyncTask)task, null));
    }

    @NotNull
    public @NotNull AsyncTask<@NotNull SyncQueue.SyncResult> whenFinished(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(16);
        }
        AsyncTask<SyncQueue.SyncResult> asyncTask = this.myQueue.whenFinished(dataSource2);
        if (asyncTask == null) {
            DataSourceSyncManager.$$$reportNull$$$0(17);
        }
        return asyncTask;
    }

    @NotNull
    public @NotNull AsyncTask<@NotNull SyncQueue.SyncResult> stopSynchronization(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(18);
        }
        AsyncTask<SyncQueue.SyncResult> asyncTask = this.myQueue.stopSynchronization(dataSource2);
        if (asyncTask == null) {
            DataSourceSyncManager.$$$reportNull$$$0(19);
        }
        return asyncTask;
    }

    static {
        ourDefaultExecutor = NEW_CONNECTION_EXECUTOR = DataSourceSyncManager::executeDatabaseOperation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncTask";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 2: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "whenFinished";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "stopSynchronization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeDatabaseOperation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSyncAble";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withDefaultExecutor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAbleToPerform";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncTrace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActiveTaskCount";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryPerform";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyMappings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "whenFinished";
                break;
            }
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "stopSynchronization";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 19 -> new IllegalStateException(string);
        };
    }

    public static final class DbSyncTask
    extends SyncQueue.SyncTask {
        public final LoaderContext context;

        private DbSyncTask(@NotNull LoaderContext context) {
            if (context == null) {
                DbSyncTask.$$$reportNull$$$0(0);
            }
            this.context = context;
        }

        @Override
        public RawDataSource getKey() {
            return this.context.getDataSource();
        }

        @Override
        @NotNull
        public SyncQueue.SyncTask merge(@NotNull SyncQueue.SyncTask task2) {
            if (task2 == null) {
                DbSyncTask.$$$reportNull$$$0(1);
            }
            DbSyncTask dbSyncTask = task2 instanceof DbSyncTask ? DbSyncTask.merge(this, (DbSyncTask)task2) : this;
            if (dbSyncTask == null) {
                DbSyncTask.$$$reportNull$$$0(2);
            }
            return dbSyncTask;
        }

        @NotNull
        public static DbSyncTask merge(@NotNull DbSyncTask task1, @NotNull DbSyncTask task2) {
            if (task1 == null) {
                DbSyncTask.$$$reportNull$$$0(3);
            }
            if (task2 == null) {
                DbSyncTask.$$$reportNull$$$0(4);
            }
            LoaderContext context = task1.context.merge(task2.context);
            context.setErrorHandler(task1.context.getErrorHandler());
            return new DbSyncTask(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager$DbSyncTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static interface DatabaseExecutor {
        public void perform(@NotNull DbSyncTask var1, @Nullable ObjectPath var2, boolean var3, @NotNull ThrowableConsumer<DatabaseConnection, Exception> var4);
    }

    public static final class SqlSyncTask
    extends SyncQueue.SyncTask {
        private final SqlDataSource myDataSource;

        private SqlSyncTask(@NotNull SqlDataSource dataSource2) {
            if (dataSource2 == null) {
                SqlSyncTask.$$$reportNull$$$0(0);
            }
            this.myDataSource = dataSource2;
        }

        @Override
        public DasDataSource getKey() {
            return this.myDataSource;
        }

        @Override
        @NotNull
        public SyncQueue.SyncTask merge(@NotNull SyncQueue.SyncTask task2) {
            if (task2 == null) {
                SqlSyncTask.$$$reportNull$$$0(1);
            }
            SqlSyncTask sqlSyncTask = this;
            if (sqlSyncTask == null) {
                SqlSyncTask.$$$reportNull$$$0(2);
            }
            return sqlSyncTask;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager$SqlSyncTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager$SqlSyncTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class DbSyncProcessor
    extends SyncQueue.SyncProcessor<DbSyncTask> {
        private final DatabaseExecutor myDbExecutor;

        DbSyncProcessor(@NotNull DbSyncTask task, @Nullable DatabaseExecutor executor) {
            if (task == null) {
                DbSyncProcessor.$$$reportNull$$$0(0);
            }
            super(task);
            this.myDbExecutor = executor != null ? executor : ourDefaultExecutor;
        }

        @Override
        @NotNull
        public AsyncTask<SyncQueue.SyncResult> run() {
            AsyncTask<SyncQueue.SyncResult> asyncTask = this.myResult.start(AsyncUtil.transactionExecutor((Disposable)((DbSyncTask)this.myTask).context.getProject(), this.myModality, true), () -> this.prepareAndRefresh());
            if (asyncTask == null) {
                DbSyncProcessor.$$$reportNull$$$0(1);
            }
            return asyncTask;
        }

        private AsyncTask<SyncQueue.SyncResult> prepareAndRefresh() {
            ProgressIndicator indicator;
            if (((DbSyncTask)this.myTask).context.getProject().isOpen() && (indicator = this.myProgress.start()) != null) {
                try {
                    AsyncTask.Frame frame = AsyncTask.frame(AnalysisBundle.message((String)"progress.title.refresh", (Object[])new Object[0]));
                    AsyncTask.storeIndicator(frame, indicator);
                    return ((AsyncTask)frame.sync(this::saveDocumentsAndRefresh)).whenComplete(null, (r, e2) -> this.myProgress.stop());
                }
                catch (Throwable e3) {
                    this.myProgress.stop();
                    return AsyncTask.exceptional(e3);
                }
            }
            return AsyncTask.cancelled();
        }

        private AsyncTask<SyncQueue.SyncResult> saveDocumentsAndRefresh() {
            WriteAction.runAndWait(() -> ((FileDocumentManager)FileDocumentManager.getInstance()).saveAllDocuments());
            return AsyncTask.currentFrame().compute(AsyncUtil.getPoolExecutor(), this::performSync);
        }

        @NotNull
        private SyncQueue.SyncResult performSync() {
            LocalDataSource dataSource2;
            LoaderContext loaderContext;
            block11: {
                loaderContext = ((DbSyncTask)this.myTask).context;
                dataSource2 = loaderContext.getDataSource();
                if (!loaderContext.loadNothing()) {
                    ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                    if (indicator == null) {
                        indicator = new EmptyProgressIndicator();
                    }
                    if (dataSource2.getInfo().getExactVersion().isOrLess(0) && loaderContext.countTasks() > 0) {
                        this.myDbExecutor.perform((DbSyncTask)this.myTask, null, true, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection2 -> connection2.getVersion()));
                    }
                    try {
                        try {
                            this.runSession(indicator);
                        }
                        catch (DbmsMismatchException dme) {
                            Dbms updatedDbms = ((DbSyncTask)this.myTask).context.getDbms();
                            if (dme.connectionDbms == updatedDbms) {
                                this.runSession(indicator);
                                break block11;
                            }
                            throw dme;
                        }
                    }
                    catch (SQLException e2) {
                        AsyncUtil.addUnhandledError(loaderContext.getErrorHandler(), e2, dataSource2);
                        throw new ProcessCanceledException();
                    }
                    finally {
                        DbSrcUtils.refresh();
                    }
                }
            }
            DataSourceSnapshotManager.getInstance().apply(loaderContext.getProject(), dataSource2);
            return new SyncQueue.SyncResult(this.myTask, System.currentTimeMillis() - this.myStartTime);
        }

        private void runSession(ProgressIndicator indicator) throws SQLException {
            SyncIntrospectionSession session2 = new SyncIntrospectionSession(this.myDbExecutor, ((DbSyncTask)this.myTask).context, this.myModality, indicator);
            session2.run();
        }

        @Override
        protected ProgressIndicator createIndicator() {
            LoaderContext loaderContext = ((DbSyncTask)this.myTask).context;
            if (loaderContext.loadNothing()) {
                return AsyncUtil.markAsyncFriendly(new EmptyProgressIndicator(), true);
            }
            String title = DatabaseBundle.message("action.DatabaseView.RefreshAction.progress", loaderContext.getDataSource().getName());
            return AsyncUtil.createBackgroundIndicator(loaderContext.getProject(), title);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager$DbSyncProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager$DbSyncProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "run";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        private class SyncIntrospectionSession
        extends DatabaseIntrospectionSession {
            private final DatabaseExecutor myExecutor;

            SyncIntrospectionSession(@NotNull DatabaseExecutor executor, @NotNull LoaderContext context, @NotNull ModalityState modality, ProgressIndicator indicator) {
                if (executor == null) {
                    SyncIntrospectionSession.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    SyncIntrospectionSession.$$$reportNull$$$0(1);
                }
                if (modality == null) {
                    SyncIntrospectionSession.$$$reportNull$$$0(2);
                }
                if (indicator == null) {
                    SyncIntrospectionSession.$$$reportNull$$$0(3);
                }
                super(context, indicator, modality);
                this.myExecutor = executor;
            }

            @Override
            protected void performDbSpecificOperation(@Nullable ObjectPath dbPath, boolean silent, @NotNull ThrowableConsumer<DatabaseConnection, Exception> operation2) {
                if (operation2 == null) {
                    SyncIntrospectionSession.$$$reportNull$$$0(4);
                }
                this.myExecutor.perform((DbSyncTask)DbSyncProcessor.this.myTask, dbPath, silent, operation2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modality";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operation";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager$DbSyncProcessor$SyncIntrospectionSession";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performDbSpecificOperation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class SqlSyncProcessor
    extends SyncQueue.SyncProcessor<SqlSyncTask> {
        SqlSyncProcessor(@NotNull SqlSyncTask task) {
            if (task == null) {
                SqlSyncProcessor.$$$reportNull$$$0(0);
            }
            super(task);
        }

        @Override
        @NotNull
        public AsyncTask<SyncQueue.SyncResult> run() {
            AsyncTask<SyncQueue.SyncResult> asyncTask = this.myResult.start(AsyncUtil.getEdtExecutor(), this::performSync);
            if (asyncTask == null) {
                SqlSyncProcessor.$$$reportNull$$$0(1);
            }
            return asyncTask;
        }

        @NotNull
        private AsyncTask<SyncQueue.SyncResult> performSync() {
            ProgressIndicator indicator = this.myProgress.start();
            if (indicator != null) {
                AsyncTask<SyncQueue.SyncResult> asyncTask;
                AsyncTask.Frame frame = AsyncTask.frame(DatabaseBundle.message("action.DatabaseView.RefreshAction.progress", ((SqlSyncTask)this.myTask).myDataSource.getName()));
                AsyncTask.storeIndicator(frame, indicator);
                try {
                    asyncTask = frame.computeAsync(AsyncUtil.getPoolExecutor(), () -> {
                        ((SqlSyncTask)this.myTask).myDataSource.sync();
                        return AsyncTask.completed(new SyncQueue.SyncResult(this.myTask, System.currentTimeMillis() - this.myStartTime));
                    }).whenComplete(AsyncUtil.getEdtExecutor(), (r, th) -> this.myProgress.stop());
                }
                catch (Throwable e2) {
                    this.myProgress.stop();
                    AsyncTask<SyncQueue.SyncResult> asyncTask2 = AsyncTask.exceptional(e2);
                    if (asyncTask2 == null) {
                        SqlSyncProcessor.$$$reportNull$$$0(3);
                    }
                    return asyncTask2;
                }
                if (asyncTask == null) {
                    SqlSyncProcessor.$$$reportNull$$$0(2);
                }
                return asyncTask;
            }
            AsyncTask<SyncQueue.SyncResult> asyncTask = AsyncTask.cancelled();
            if (asyncTask == null) {
                SqlSyncProcessor.$$$reportNull$$$0(4);
            }
            return asyncTask;
        }

        @Override
        protected ProgressIndicator createIndicator() {
            String title = DatabaseBundle.message("action.DatabaseView.RefreshAction.progress", ((SqlSyncTask)this.myTask).myDataSource.getName());
            return AsyncUtil.createBackgroundIndicator(((SqlSyncTask)this.myTask).myDataSource.getProject(), title);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager$SqlSyncProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager$SqlSyncProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "run";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performSync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

