/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceModelStorage;
import com.intellij.database.dataSource.DataSourceModelStorageImpl;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LoadingState;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageService;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.TreePattern;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.PreemptiveSafeFileOutputStream;
import com.intellij.util.io.SafeFileOutputStream;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.xmlpull.v1.XmlPullParser;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0012\b6\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0003:;<B\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J \u0010\u001c\u001a\u00020\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J(\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0!H\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010$\u001a\u00020\u0019H\u0016J,\u0010%\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0!2\u0006\u0010&\u001a\u00020'H\u0002J\f\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0016J\u0014\u0010*\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010+\u001a\u00020\rH\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010+\u001a\u00020\rH\u0002J\u0016\u0010-\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0016J2\u0010-\u001a\u00020.2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010&\u001a\u00020'2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020100H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\rH\u0002J\u001c\u00105\u001a\u0010\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020.\u0018\u0001062\u0006\u0010+\u001a\u00020\rJ$\u00107\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0!H\u0002J\u0016\u00108\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J\u000e\u00109\u001a\u00020.2\u0006\u0010+\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\u000e\u001aJ\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012 \u0011*#\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u00120\u0013\u00a2\u0006\u0002\b\n0\u000f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u0082\u0001\u0002=>\u00a8\u0006?"}, d2={"Lcom/intellij/database/dataSource/DataSourceModelStorageImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/database/dataSource/DataSourceModelStorage;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/components/ComponentManager;Lkotlinx/coroutines/CoroutineScope;)V", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "Lorg/jetbrains/annotations/NotNull;", "myLoadingState", "Lcom/intellij/database/dataSource/LoadingState$Holder;", "Lcom/intellij/database/dataSource/LocalDataSource;", "myLocks", "", "", "kotlin.jvm.PlatformType", "com/intellij/database/dataSource/DataSourceModelStorageImpl$myLocks$1$1", "", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyMappings", "", "dataSources", "", "cleanupOldFiles", "newDataSources", "continueLoadingWhenInitialized", "Lcom/intellij/database/util/AsyncTask;", "currentState", "Lcom/intellij/database/dataSource/LoadingState;", "createSavingListener", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "dispose", "finishModelLoading", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "getLoadedPromise", "Lorg/jetbrains/concurrency/Promise;", "getLoadingPromise", "dataSource", "getModelPath", "loadModels", "", "consumer", "Lcom/intellij/util/PairConsumer;", "Lcom/intellij/database/model/DasModel;", "lock", "", "ds", "readModel", "Lkotlin/Pair;", "readStateHeavy", "validateDataSources", "writeModel", "App", "Companion", "Prj", "Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$App;", "Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$Prj;", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDataSourceModelStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceModelStorageImpl.kt\ncom/intellij/database/dataSource/DataSourceModelStorageImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,608:1\n1#2:609\n37#3,2:610\n11#4:612\n*S KotlinDebug\n*F\n+ 1 DataSourceModelStorageImpl.kt\ncom/intellij/database/dataSource/DataSourceModelStorageImpl\n*L\n245#1:610,2\n482#1:612\n*E\n"})
public abstract class DataSourceModelStorageImpl
implements Disposable,
DataSourceModelStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final LoadingState.Holder<LocalDataSource> myLoadingState;
    @NotNull
    private final Map<String, myLocks.1> myLocks;
    @NotNull
    private final MessageBus messageBus;
    @NotNull
    private static final Logger LOG;

    private DataSourceModelStorageImpl(ComponentManager componentManager, CoroutineScope coroutineScope) {
        this.coroutineScope = coroutineScope;
        this.myLoadingState = new LoadingState.Holder();
        Map map2 = FactoryMap.create(arg_0 -> DataSourceModelStorageImpl.myLocks$lambda$0(myLocks.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"create(...)");
        this.myLocks = map2;
        MessageBus messageBus = componentManager.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        this.messageBus = messageBus;
        Project project = componentManager instanceof Project ? (Project)componentManager : null;
        DataSourceStorage.Listener listener2 = this.createSavingListener(project);
        if (listener2 != null) {
            MessageBusConnection messageBusConnection = this.messageBus.connect((Disposable)this);
            Topic<DataSourceStorage.Listener> topic = DataSourceStorage.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)listener2);
        }
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    @Override
    @NotNull
    public Promise<?> getLoadedPromise() {
        LoadingState<LocalDataSource> loadingState = this.myLoadingState.get();
        Object object = loadingState != null ? loadingState.getLoadingPromise() : null;
        if (object == null) {
            object = Promises.resolvedPromise();
        }
        return object;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Promise<?> getLoadingPromise(@NotNull LocalDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        LoadingState<LocalDataSource> loadingState = this.myLoadingState.get();
        Promise promise = loadingState != null ? loadingState.getLoadingPromise((LocalDataSource)((RawDataSource)dataSource2)) : null;
        if (promise == null) {
            promise = Promises.resolvedPromise();
        }
        return promise;
    }

    public void loadModels(@NotNull List<? extends LocalDataSource> dataSources2) {
        Intrinsics.checkNotNullParameter(dataSources2, (String)"dataSources");
        String string = DatabaseBundle.message("progress.title.loading.models", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myLoadingState.run(AsyncTask.Companion.frame(string), arg_0 -> DataSourceModelStorageImpl.loadModels$lambda$1(dataSources2, this, arg_0));
    }

    private final AsyncTask<?> continueLoadingWhenInitialized(List<? extends LocalDataSource> dataSources2, LoadingState<LocalDataSource> currentState) {
        Project project = this.getProject();
        Project project2 = project;
        if (project2 == null) {
            project2 = DbImplUtilCore.getAnyProject();
        }
        Project anyProject = project2;
        return AsyncTask.Companion.currentFrame().computeAsync(anyProject == null ? AsyncUtil.getEdtExecutor() : arg_0 -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$2(anyProject, arg_0), () -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$7(anyProject, this, dataSources2, currentState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readStateHeavy(List<? extends LocalDataSource> dataSources2, LoadingState<LocalDataSource> currentState) {
        Project project;
        Application application = ApplicationManager.getApplication();
        Project project2 = project = this.getProject();
        ComponentManager disposable = project2 != null ? (ComponentManager)project2 : (ComponentManager)application;
        ErrorHandler errorHandler = new ErrorHandler();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic<DataSourceModelStorage.Listener> topic = DataSourceModelStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        DataSourceModelStorage.Listener publisher = (DataSourceModelStorage.Listener)messageBus.syncPublisher(topic);
        try {
            ProgressManager.checkCanceled();
            publisher.started(project);
            this.loadModels(dataSources2, errorHandler, (PairConsumer<LocalDataSource, DasModel>)((PairConsumer)(arg_0, arg_1) -> DataSourceModelStorageImpl.readStateHeavy$lambda$8(currentState, arg_0, arg_1)));
        }
        catch (Throwable th) {
            if (AsyncUtil.isCancellation(th)) {
                throw new ProcessCanceledException(th);
            }
            errorHandler.addError(null, th);
        }
        finally {
            publisher.finished(project);
        }
        this.validateDataSources(dataSources2);
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)((Disposable)disposable), () -> DataSourceModelStorageImpl.readStateHeavy$lambda$9(this, dataSources2, currentState, errorHandler));
    }

    private final void validateDataSources(List<? extends LocalDataSource> dataSources2) {
        if (DbSrcValidator.isEnabled()) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, dataSources2, null){
                int label;
                final /* synthetic */ DataSourceModelStorageImpl this$0;
                final /* synthetic */ List<LocalDataSource> $dataSources;
                {
                    this.this$0 = $receiver;
                    this.$dataSources = $dataSources;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Project p2;
                            ResultKt.throwOnFailure((Object)object);
                            Project project = this.this$0.getProject();
                            Project project2 = project;
                            if (project2 == null) {
                                project2 = p2 = DbImplUtilCore.getAnyProject();
                            }
                            if (project != null) {
                                Project project3 = p2;
                                Intrinsics.checkNotNull((Object)project3);
                                com.intellij.database.dataSource.DataSourceModelStorageImpl$Companion.access$validateModels(DataSourceModelStorageImpl.Companion, project3, this.$dataSources);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void finishModelLoading(List<? extends LocalDataSource> dataSources2, LoadingState<LocalDataSource> currentState, ErrorHandler errorHandler) {
        List unsuccessful = new ArrayList();
        for (LocalDataSource localDataSource : dataSources2) {
            if (!currentState.isLoading((LocalDataSource)((RawDataSource)localDataSource))) continue;
            localDataSource.setModel(DasUtil.emptyModel());
            currentState.markLoaded((LocalDataSource)((RawDataSource)localDataSource));
            unsuccessful.add(localDataSource);
        }
        AppExecutorUtil.getAppExecutorService().execute(() -> DataSourceModelStorageImpl.finishModelLoading$lambda$10(this, dataSources2));
        ApplicationManager.getApplication().invokeLater(() -> DataSourceModelStorageImpl.finishModelLoading$lambda$11(this, errorHandler, unsuccessful));
    }

    private final void applyMappings(List<? extends LocalDataSource> dataSources2) {
        if (this.messageBus.isDisposed()) {
            return;
        }
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)((Disposable)this.messageBus), () -> DataSourceModelStorageImpl.applyMappings$lambda$15(this, dataSources2));
    }

    private final boolean loadModels(List<? extends LocalDataSource> dataSources2, ErrorHandler errorHandler, PairConsumer<LocalDataSource, DasModel> consumer2) {
        ProgressManager.checkCanceled();
        List newDataSources = new ArrayList(dataSources2);
        boolean hasNoModelDs = false;
        boolean failed = false;
        for (LocalDataSource source : newDataSources) {
            try {
                Pair pair = this.readModel(source);
                if (pair == null) {
                    pair = new Pair(null, (Object)false);
                }
                Pair pair2 = pair;
                DasModel model2 = (DasModel)pair2.component1();
                boolean modelMigrated = (Boolean)pair2.component2();
                if (model2 != null) {
                    consumer2.consume((Object)source, (Object)model2);
                    if (!modelMigrated) continue;
                    failed |= !this.writeModel(source);
                    continue;
                }
                consumer2.consume((Object)source, (Object)DasUtil.emptyModel());
                hasNoModelDs = true;
            }
            catch (ProcessCanceledException e2) {
                return false;
            }
            catch (Exception e3) {
                failed = true;
                String file = this.getModelPath(source);
                if (file != null) {
                    DataSourceStorage.processCorruption(this.getProject(), Paths.get(file, new String[0]), e3);
                }
                errorHandler.addError(e3.getMessage(), (Throwable)e3);
            }
        }
        if (hasNoModelDs) {
            JBIterable jBIterable = JBIterable.from((Iterable)newDataSources).filter(arg_0 -> DataSourceModelStorageImpl.loadModels$lambda$16(loadModels.empty.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable empty2 = jBIterable;
            LOG.info("No model loaded for: " + StringUtil.join((Iterable)((Iterable)empty2), arg_0 -> DataSourceModelStorageImpl.loadModels$lambda$17(loadModels.2.INSTANCE, arg_0), (String)", "));
        }
        if (failed) {
            return false;
        }
        Project project = this.getProject();
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.nonModal();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, (List<? extends LocalDataSource>)newDataSources, null){
            int label;
            final /* synthetic */ DataSourceModelStorageImpl this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List<LocalDataSource> $newDataSources;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$newDataSources = $newDataSources;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DataSourceModelStorageImpl.access$cleanupOldFiles(this.this$0, this.$project, this.$newDataSources);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DbSrcValidator.checkOutdatedFiles(this.$project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanupOldFiles(Project project, List<? extends LocalDataSource> newDataSources) {
        block10: {
            Path path;
            String dir;
            String string = dir = DataSourceStorage.getStorageDir(project);
            if (string != null) {
                String it2 = string;
                boolean bl = false;
                path = Paths.get(FileUtil.toSystemDependentName((String)it2), new String[0]);
            } else {
                path = null;
            }
            Path root2 = path;
            Set toKeep = new HashSet();
            Set uids = new HashSet();
            for (LocalDataSource localDataSource : newDataSources) {
                String string2 = localDataSource.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUniqueId(...)");
                uids.add(string2);
                if (localDataSource.getModel() == DasUtil.emptyModel()) continue;
                String path2 = this.getModelPath(localDataSource);
                String string3 = path2;
                ContainerUtil.addIfNotNull((Collection)toKeep, string3 == null ? null : Paths.get(FileUtil.toSystemDependentName((String)string3), new String[0]));
            }
            Pattern filePattern = Pattern.compile("\\p{XDigit}{8}(?:-\\p{XDigit}{4}){3}-\\p{XDigit}{12}(?:\\.xml)?");
            Function1 function1 = (Function1)new Function1<Path, Boolean>((Set<Path>)toKeep, (Set<String>)uids){
                final /* synthetic */ Set<Path> $toKeep;
                final /* synthetic */ Set<String> $uids;
                {
                    this.$toKeep = $toKeep;
                    this.$uids = $uids;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull Path f) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                    if (!this.$toKeep.contains(f)) {
                        boolean bl2;
                        block5: {
                            Iterable $this$any$iv = this.$uids;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    String it2 = (String)element$iv;
                                    boolean bl3 = false;
                                    if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)f), (String)it2, (boolean)false, (int)2, null)) continue;
                                    bl2 = true;
                                    break block5;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            };
            try {
                Path path2;
                Object object = root2;
                if (object == null) break block10;
                Path it3 = path2 = object;
                boolean bl = false;
                object = Files.isDirectory(root2, new LinkOption[0]) ? path2 : null;
                if (object == null) break block10;
                Path it4 = object;
                boolean bl2 = false;
                Stream<Path> stream = Files.list(root2);
                object = stream;
                if (stream == null) break block10;
                AutoCloseable autoCloseable = (AutoCloseable)object;
                Throwable throwable = null;
                try {
                    Stream files2 = (Stream)autoCloseable;
                    boolean bl3 = false;
                    files2.forEach(arg_0 -> DataSourceModelStorageImpl.cleanupOldFiles$lambda$22$lambda$21((Function1)new Function1<Path, Unit>(filePattern, (Function1<? super Path, Boolean>)function1){
                        final /* synthetic */ Pattern $filePattern;
                        final /* synthetic */ Function1<Path, Boolean> $keep;
                        {
                            this.$filePattern = $filePattern;
                            this.$keep = $keep;
                            super(1);
                        }

                        public final void invoke(Path file) {
                            Intrinsics.checkNotNull((Object)file);
                            if (this.$filePattern.matcher(PathsKt.getName((Path)file)).matches() && !((Boolean)this.$keep.invoke((Object)file)).booleanValue()) {
                                try {
                                    FileUtil.delete((Path)file);
                                }
                                catch (IOException e2) {
                                    DataSourceModelStorageImpl.access$getLOG$cp().warn((Throwable)e2);
                                }
                            }
                        }
                    }, arg_0));
                    Unit throwable2 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (IOException e2) {
                LOG.warn((Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeModel(@NotNull LocalDataSource dataSource2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Project project = this.getProject();
        ProgressManager.checkCanceled();
        if (project != null && project.isDefault()) {
            return false;
        }
        String string = this.getModelPath(dataSource2);
        if (string == null) {
            return false;
        }
        String path = string;
        if (DataSourceModelStorageImpl.Companion.isReadonly(project, path)) {
            LOG.warn("Unable to save model. File is readonly: " + path);
            return false;
        }
        if (project != null && project.isDisposed()) {
            return false;
        }
        File file = new File(path);
        FileUtil.createParentDirs((File)file);
        DasModel dasModel = dataSource2.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
        DasModel model2 = dasModel;
        if (model2.getModelRoots().isEmpty()) {
            FileUtil.delete((File)file);
            return false;
        }
        Object object = this.lock(dataSource2);
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = DataSourceModelStorageImpl.Companion.writeModel(file, dataSource2);
            return bl2;
        }
    }

    @Nullable
    public final Pair<DasModel, Boolean> readModel(@NotNull LocalDataSource dataSource2) throws IOException {
        File file;
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        ProgressManager.checkCanceled();
        Project project = this.getProject();
        if (project != null && project.isDefault()) {
            return null;
        }
        String path = this.getModelPath(dataSource2);
        File file2 = file = path == null ? null : new File(path);
        if (file == null || !file.exists()) {
            return null;
        }
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic<DataSourceModelStorage.Listener> topic = DataSourceModelStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        DataSourceModelStorage.Listener publisher = (DataSourceModelStorage.Listener)messageBus.syncPublisher(topic);
        publisher.started(project, dataSource2);
        try {
            Pair pair;
            ModelFactory modelFactory = DbSrcModelStorageService.getInstance().createFactory(project, dataSource2);
            Intrinsics.checkNotNullExpressionValue((Object)modelFactory, (String)"createFactory(...)");
            ModelFactory factory = modelFactory;
            Pair pair2 = Companion.readModel(factory, file, dataSource2.getName());
            if (pair2 == null) {
                pair2 = new Pair(null, null);
            }
            Pair pair3 = pair2;
            DasModel model2 = (DasModel)pair3.component1();
            ModelImporter importer = (ModelImporter)pair3.component2();
            if (model2 != null && importer != null) {
                publisher.finished(project, dataSource2, model2, importer);
            } else {
                publisher.failed(project, dataSource2, null);
            }
            DasModel dasModel = model2;
            if (dasModel != null) {
                DasModel it2 = dasModel;
                boolean bl = false;
                ModelImporter modelImporter = importer;
                pair = new Pair((Object)it2, (Object)(modelImporter != null ? modelImporter.wasMigrated : false));
            } else {
                pair = null;
            }
            return pair;
        }
        catch (Throwable th) {
            publisher.failed(project, dataSource2, th);
            throw th;
        }
    }

    private final String getModelPath(LocalDataSource dataSource2) {
        String dir;
        String string = dir = DataSourceStorage.getStorageDir(this.getProject());
        return string == null ? null : string + "/" + dataSource2.getUniqueId() + ".xml";
    }

    private final DataSourceStorage.Listener createSavingListener(Project project) {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            return null;
        }
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"com/intellij/database/dataSource/DataSourceModelStorageImpl$createSavingListener$SavingListener", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "(Lcom/intellij/database/dataSource/DataSourceModelStorageImpl;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/application/Application;)V", "myQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "dataSourceAdded", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "dataSourceChanged", "dataSourceRemoved", "isMy", "", "remove", "save", "saveDataSource", "intellij.database.connectivity"})
        @SourceDebugExtension(value={"SMAP\nDataSourceModelStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceModelStorageImpl.kt\ncom/intellij/database/dataSource/DataSourceModelStorageImpl$createSavingListener$SavingListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,608:1\n1#2:609\n*E\n"})
        public final class SavingListener
        implements DataSourceStorage.Listener {
            @NotNull
            private final MergingUpdateQueue myQueue;
            final /* synthetic */ DataSourceModelStorageImpl this$0;
            final /* synthetic */ Project $project;

            public SavingListener(@NotNull DataSourceModelStorageImpl $receiver, @Nullable Project $project, Application $app) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"this$0");
                this.this$0 = $receiver;
                this.$project = $project;
                this.myQueue = new MergingUpdateQueue("DataSourceStorage xml writer queue", 30000, true, null, (Disposable)$receiver, null, Alarm.ThreadToUse.POOLED_THREAD);
                if ($project != null) {
                    $app.getMessageBus().connect((Disposable)$receiver).subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener($project, this){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ SavingListener this$0;
                        {
                            this.$project = $project;
                            this.this$0 = $receiver;
                        }

                        public void projectClosing(@NotNull Project p2) {
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
                            if (p2 == this.$project) {
                                SavingListener.access$getMyQueue$p(this.this$0).sendFlush();
                            }
                        }
                    });
                } else {
                    $app.addApplicationListener(new ApplicationListener(this){
                        final /* synthetic */ SavingListener this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void applicationExiting() {
                            SavingListener.access$getMyQueue$p(this.this$0).sendFlush();
                        }
                    }, (Disposable)$receiver);
                }
            }

            public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
                Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
                String string = dataSource2.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
                String uuid = string;
                String string2 = uuid + "_purger";
                this.myQueue.queue(new Update(this, dataSource2, uuid, string2){
                    private boolean wasQueued;
                    final /* synthetic */ SavingListener this$0;
                    final /* synthetic */ LocalDataSource $dataSource;
                    final /* synthetic */ String $uuid;
                    {
                        this.this$0 = $receiver;
                        this.$dataSource = $dataSource;
                        this.$uuid = $uuid;
                        super((Object)$super_call_param$1, 10);
                    }

                    public final boolean getWasQueued() {
                        return this.wasQueued;
                    }

                    public final void setWasQueued(boolean bl) {
                        this.wasQueued = bl;
                    }

                    public void run() {
                        if (this.wasQueued) {
                            SavingListener.access$save(this.this$0, this.$dataSource);
                        }
                        SavingListener.access$remove(this.this$0, this.$dataSource);
                    }

                    public boolean canEat(@NotNull Update update2) {
                        boolean isQueued;
                        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
                        Object[] objectArray = update2.getEqualityObjects();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getEqualityObjects(...)");
                        Object[] objects2 = objectArray;
                        boolean bl = isQueued = objects2.length == 1 && Intrinsics.areEqual((Object)this.$uuid, (Object)objects2[0]);
                        if (isQueued) {
                            this.wasQueued = true;
                        }
                        return isQueued;
                    }
                });
                this.myQueue.sendFlush();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void remove(LocalDataSource dataSource2) {
                Map map2 = DataSourceModelStorageImpl.access$getMyLocks$p(this.this$0);
                DataSourceModelStorageImpl dataSourceModelStorageImpl = this.this$0;
                Map map3 = map2;
                synchronized (map3) {
                    boolean bl = false;
                    myLocks.1 var5_6 = DataSourceModelStorageImpl.access$getMyLocks$p(dataSourceModelStorageImpl).remove(dataSource2.getUniqueId());
                }
            }

            public void dataSourceChanged(@Nullable LocalDataSource dataSource2) {
                if (dataSource2 == null) {
                    return;
                }
                this.saveDataSource(dataSource2);
            }

            public void dataSourceAdded(@NotNull LocalDataSource dataSource2) {
                Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
                this.saveDataSource(dataSource2);
            }

            private final void saveDataSource(LocalDataSource dataSource2) {
                if (!this.isMy(dataSource2)) {
                    return;
                }
                if (dataSource2.isInBatch() || this.this$0.isLoading(dataSource2)) {
                    return;
                }
                DataSourceModelStorageImpl.access$getLOG$cp().debug("Scheduling save " + dataSource2.getName());
                this.myQueue.queue(Update.create((Object)dataSource2.getUniqueId(), () -> SavingListener.saveDataSource$lambda$1(this, dataSource2)));
            }

            private final boolean isMy(LocalDataSource dataSource2) {
                return this.$project == null == dataSource2.isGlobal();
            }

            private final void save(LocalDataSource dataSource2) {
                Project project = this.$project;
                if ((project != null ? (ComponentManager)project : (ComponentManager)ApplicationManager.getApplication()).isDisposed()) {
                    return;
                }
                try {
                    this.this$0.writeModel(dataSource2);
                }
                catch (IOException e2) {
                    DataSourceModelStorageImpl.access$getLOG$cp().error("Failed to save model for: " + dataSource2.getName(), (Throwable)e2);
                }
            }

            private static final void saveDataSource$lambda$1(SavingListener this$0, LocalDataSource $dataSource) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
                this$0.save($dataSource);
            }

            public static final /* synthetic */ void access$save(SavingListener $this, LocalDataSource dataSource2) {
                $this.save(dataSource2);
            }

            public static final /* synthetic */ void access$remove(SavingListener $this, LocalDataSource dataSource2) {
                $this.remove(dataSource2);
            }

            public static final /* synthetic */ MergingUpdateQueue access$getMyQueue$p(SavingListener $this) {
                return $this.myQueue;
            }
        }
        return new SavingListener(this, project, app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object lock(LocalDataSource ds) {
        Map<String, myLocks.1> map2 = this.myLocks;
        synchronized (map2) {
            boolean bl = false;
            myLocks.1 v0 = this.myLocks.get(ds.getUniqueId());
            Intrinsics.checkNotNull((Object)v0);
            myLocks.1 var4_5 = v0;
            return var4_5;
        }
    }

    private static final myLocks.1 myLocks$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final AsyncTask loadModels$lambda$1(List $dataSources, DataSourceModelStorageImpl this$0, LoadingState currentState) {
        Intrinsics.checkNotNullParameter((Object)$dataSources, (String)"$dataSources");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (LocalDataSource dataSource2 : $dataSources) {
            currentState.markLoading((RawDataSource)dataSource2);
            dataSource2.resolveDriver();
            if (dataSource2.getDatabaseDriver() != null && dataSource2.getOwnClasspath().isEmpty()) continue;
            dataSource2.ensureDriverConfigured();
        }
        List list = Collections.unmodifiableList($dataSources);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        Intrinsics.checkNotNull((Object)currentState);
        return this$0.continueLoadingWhenInitialized(list, currentState);
    }

    private static final void continueLoadingWhenInitialized$lambda$2(Project $anyProject, Runnable r) {
        StartupManager.getInstance((Project)$anyProject).runAfterOpened(r);
    }

    private static final void continueLoadingWhenInitialized$lambda$7$lambda$6$lambda$3(DataSourceModelStorageImpl this$0, Runnable it2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it2, null){
            int label;
            final /* synthetic */ Runnable $it;
            {
                this.$it = $it;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$it.run();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void continueLoadingWhenInitialized$lambda$7$lambda$6$lambda$5$lambda$4(DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dataSources, (String)"$dataSources");
        Intrinsics.checkNotNullParameter((Object)$currentState, (String)"$currentState");
        this$0.readStateHeavy($dataSources, $currentState);
    }

    private static final Object continueLoadingWhenInitialized$lambda$7$lambda$6$lambda$5(DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dataSources, (String)"$dataSources");
        Intrinsics.checkNotNullParameter((Object)$currentState, (String)"$currentState");
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this$0, () -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$7$lambda$6$lambda$5$lambda$4(this$0, $dataSources, $currentState));
        return null;
    }

    private static final AsyncTask continueLoadingWhenInitialized$lambda$7$lambda$6(AsyncTask.Frame $frame, Project $anyProject, DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState) {
        Intrinsics.checkNotNullParameter((Object)((Object)$frame), (String)"$frame");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dataSources, (String)"$dataSources");
        Intrinsics.checkNotNullParameter((Object)$currentState, (String)"$currentState");
        return AsyncTask.Companion.withBgIndicator($frame, $anyProject, null, false).compute(arg_0 -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$7$lambda$6$lambda$3(this$0, arg_0), () -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$7$lambda$6$lambda$5(this$0, $dataSources, $currentState));
    }

    private static final AsyncTask continueLoadingWhenInitialized$lambda$7(Project $anyProject, DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dataSources, (String)"$dataSources");
        Intrinsics.checkNotNullParameter((Object)$currentState, (String)"$currentState");
        String string = DatabaseBundle.message("loading.data.sources", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        AsyncTask.Frame frame = AsyncTask.Companion.frame(string);
        return frame.computeAsync(AsyncUtil.getEdtExecutor(), () -> DataSourceModelStorageImpl.continueLoadingWhenInitialized$lambda$7$lambda$6(frame, $anyProject, this$0, $dataSources, $currentState));
    }

    private static final void readStateHeavy$lambda$8(LoadingState $currentState, LocalDataSource dataSource2, DasModel model2) {
        Intrinsics.checkNotNullParameter((Object)$currentState, (String)"$currentState");
        dataSource2.setModel(model2);
        $currentState.markLoaded((RawDataSource)dataSource2);
    }

    private static final void readStateHeavy$lambda$9(DataSourceModelStorageImpl this$0, List $dataSources, LoadingState $currentState, ErrorHandler $errorHandler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dataSources, (String)"$dataSources");
        Intrinsics.checkNotNullParameter((Object)$currentState, (String)"$currentState");
        Intrinsics.checkNotNullParameter((Object)$errorHandler, (String)"$errorHandler");
        this$0.finishModelLoading($dataSources, $currentState, $errorHandler);
    }

    private static final void finishModelLoading$lambda$10(DataSourceModelStorageImpl this$0, List $dataSources) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$dataSources, (String)"$dataSources");
            try {
                this$0.applyMappings($dataSources);
            }
            catch (Throwable th) {
                if (AsyncUtil.isCancellation(th)) break block2;
                LOG.error(th);
            }
        }
    }

    private static final void finishModelLoading$lambda$11(DataSourceModelStorageImpl this$0, ErrorHandler $errorHandler, List $unsuccessful) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$errorHandler, (String)"$errorHandler");
        Intrinsics.checkNotNullParameter((Object)$unsuccessful, (String)"$unsuccessful");
        DataSourceModelStorageImpl.Companion.notifyErrors(this$0.getProject(), $errorHandler, $unsuccessful);
    }

    private static final void applyMappings$lambda$15$lambda$12(List $dataSources, Project $anyProject, List $incomplete) {
        Intrinsics.checkNotNullParameter((Object)$dataSources, (String)"$dataSources");
        Intrinsics.checkNotNullParameter((Object)$anyProject, (String)"$anyProject");
        Intrinsics.checkNotNullParameter((Object)$incomplete, (String)"$incomplete");
        for (LocalDataSource dataSource2 : $dataSources) {
            AsyncTask<SyncQueue.SyncResult> task = DataSourceUtil.applyMappings($anyProject, dataSource2);
            if (task == null) continue;
            try {
                task.handle().toFuture().get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e2) {
                $incomplete.add(task.toFuture());
            }
            catch (Throwable throwable) {}
        }
    }

    private static final boolean applyMappings$lambda$15$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void applyMappings$lambda$15$lambda$14(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void applyMappings$lambda$15(DataSourceModelStorageImpl this$0, List $dataSources) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dataSources, (String)"$dataSources");
        Project project = this$0.getProject();
        Project project2 = project;
        if (project2 == null && (project2 = DbImplUtilCore.getAnyProject()) == null) {
            return;
        }
        Project anyProject = project2;
        List incomplete = new ArrayList();
        ProgressManager.getInstance().executeProcessUnderProgress(() -> DataSourceModelStorageImpl.applyMappings$lambda$15$lambda$12($dataSources, anyProject, incomplete), (ProgressIndicator)new EmptyProgressIndicator());
        incomplete.removeIf(arg_0 -> DataSourceModelStorageImpl.applyMappings$lambda$15$lambda$13(applyMappings.1.2.INSTANCE, arg_0));
        ProgressManager.checkCanceled();
        MessageBus messageBus = this$0.messageBus;
        Topic<DataSourceStorage.Listener> topic = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((DataSourceStorage.Listener)messageBus.syncPublisher(topic)).dataSourceChanged(null);
        if (!incomplete.isEmpty()) {
            Collection $this$toTypedArray$iv = incomplete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
            CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).whenComplete((arg_0, arg_1) -> DataSourceModelStorageImpl.applyMappings$lambda$15$lambda$14((Function2)new Function2<Void, Throwable, Unit>(this$0){
                final /* synthetic */ DataSourceModelStorageImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(Void void_, Throwable throwable) {
                    MessageBus messageBus = DataSourceModelStorageImpl.access$getMessageBus$p(this.this$0);
                    Topic<DataSourceStorage.Listener> topic = DataSourceStorage.TOPIC;
                    Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                    ((DataSourceStorage.Listener)messageBus.syncPublisher(topic)).dataSourceChanged(null);
                }
            }, arg_0, arg_1));
        }
    }

    private static final boolean loadModels$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence loadModels$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CharSequence)$tmp0.invoke(p0);
    }

    private static final void cleanupOldFiles$lambda$22$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public /* synthetic */ DataSourceModelStorageImpl(ComponentManager componentManager, CoroutineScope coroutineScope, DefaultConstructorMarker $constructor_marker) {
        this(componentManager, coroutineScope);
    }

    public static final /* synthetic */ void access$cleanupOldFiles(DataSourceModelStorageImpl $this, Project project, List newDataSources) {
        $this.cleanupOldFiles(project, newDataSources);
    }

    public static final /* synthetic */ Map access$getMyLocks$p(DataSourceModelStorageImpl $this) {
        return $this.myLocks;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ MessageBus access$getMessageBus$p(DataSourceModelStorageImpl $this) {
        return $this.messageBus;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(DataSourceModelStorageImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Service
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$App;", "Lcom/intellij/database/dataSource/DataSourceModelStorageImpl;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "intellij.database.connectivity"})
    private static final class App
    extends DataSourceModelStorageImpl {
        public App(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            super((ComponentManager)application, coroutineScope, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J.\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\nJ0\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J$\u0010 \u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"H\u0002J\u0018\u0010%\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0011H\u0002J,\u0010%\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010'\u001a\u0004\u0018\u00010\u00142\b\u0010(\u001a\u0004\u0018\u00010\n2\b\u0010)\u001a\u0004\u0018\u00010*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isReadonly", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "", "notifyErrors", "", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "unsuccessful", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "readModel", "Lkotlin/Pair;", "Lcom/intellij/database/model/DasModel;", "Lcom/intellij/database/model/serialization/ModelImporter;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "file", "Ljava/io/File;", "dataSourceName", "Lcom/intellij/database/model/basic/BasicModModel;", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "validateModels", "dataSources", "writeHugeFileSafe", "consumer", "Lcom/intellij/util/ThrowableConsumer;", "Ljava/io/OutputStream;", "Ljava/io/IOException;", "writeModel", "dataSource", "model", "name", "scope", "Lcom/intellij/database/util/TreePattern;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        private final void notifyErrors(Project project, ErrorHandler errorHandler, List<? extends LocalDataSource> unsuccessful) {
            String summary = errorHandler.getSummary();
            if (StringUtil.isNotEmpty((String)summary)) {
                Object[] objectArray = new Object[]{project == null ? "Global" : "Project"};
                String string = DatabaseBundle.message("notification.title.data.sources.href.sync.refresh.required", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String title = string;
                new Notification("Database configuration", title, summary, NotificationType.ERROR).setListener((NotificationListener)new NotificationListener.Adapter(project, unsuccessful){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List<LocalDataSource> $unsuccessful;
                    {
                        this.$project = $project;
                        this.$unsuccessful = $unsuccessful;
                    }

                    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e2) {
                        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                        Project project = this.$project;
                        if (project == null && (project = DbImplUtilCore.getAnyProject()) == null) {
                            return;
                        }
                        Project anyProject = project;
                        for (LocalDataSource dataSource2 : this.$unsuccessful) {
                            DataSourceUtil.performAutoSyncTask(LoaderContext.selectGeneralTask(anyProject, dataSource2));
                        }
                    }
                }).notify(project);
            }
        }

        private final void validateModels(Project project, List<? extends LocalDataSource> dataSources2) {
            if (project.isDisposed()) {
                return;
            }
            Couple<List<LocalDataSource>> couple = new DbSrcValidator().collect(project, (Iterable<LocalDataSource>)dataSources2);
            Intrinsics.checkNotNullExpressionValue(couple, (String)"collect(...)");
            Couple<List<LocalDataSource>> result2 = couple;
            if (project.isDisposed() || ((List)result2.first).isEmpty() && ((List)result2.second).isEmpty()) {
                return;
            }
            if (!((List)result2.second).isEmpty()) {
                DbSrcValidator.suggestIntrospecting(project, (List)result2.second);
            }
            if (!((List)result2.first).isEmpty()) {
                DbSrcValidator.regenerateSources(project, (List)result2.first);
            }
        }

        private final boolean writeModel(File file, LocalDataSource dataSource2) throws IOException {
            String string = dataSource2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name2 = string;
            DasModel dasModel = dataSource2.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
            DasModel model2 = dasModel;
            TreePattern treePattern = dataSource2.getIntrospectionScope();
            Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"getIntrospectionScope(...)");
            TreePattern scope = treePattern;
            this.writeModel(file, model2, name2, scope);
            return true;
        }

        public final void writeModel(@NotNull File file, @Nullable DasModel model2, @Nullable String name2, @Nullable TreePattern scope) throws IOException {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.writeHugeFileSafe(file, (ThrowableConsumer<OutputStream, IOException>)((ThrowableConsumer)arg_0 -> Companion.writeModel$lambda$0(name2, model2, scope, arg_0)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeHugeFileSafe(File file, ThrowableConsumer<OutputStream, IOException> consumer2) throws IOException {
            int bufferSize = Registry.intValue((String)"database.storage.output.buffer");
            OutputStream safe2 = bufferSize < 0 ? (OutputStream)new SafeFileOutputStream(file) : (OutputStream)new PreemptiveSafeFileOutputStream(file.toPath());
            Closeable closeable = bufferSize < 0 ? safe2 : (OutputStream)new BufferedOutputStream(safe2, bufferSize);
            Throwable throwable = null;
            try {
                OutputStream out = (OutputStream)closeable;
                boolean bl = false;
                try {
                    consumer2.consume((Object)out);
                }
                catch (Throwable t) {
                    if (safe2 instanceof PreemptiveSafeFileOutputStream) {
                        ((PreemptiveSafeFileOutputStream)safe2).abort();
                    } else {
                        ((SafeFileOutputStream)safe2).abort();
                    }
                    throw t;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final boolean isReadonly(Project project, String path) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = project == null ? null : VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
            if (virtualFile == null) {
                return false;
            }
            boolean[] readOnly = new boolean[1];
            try {
                EdtInvocationManager.invokeAndWaitIfNeeded(() -> Companion.isReadonly$lambda$3(readOnly, project, virtualFile));
            }
            catch (Throwable th) {
                ExceptionUtil.rethrow((Throwable)th);
            }
            return readOnly[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Pair<DasModel, ModelImporter> readModel(@NotNull ModelFactory modelFactory, @NotNull File file, @Nullable String dataSourceName) throws IOException {
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            try (HierarchicalStreamReader reader = (HierarchicalStreamReader)new XppReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), (XmlPullParser)new MXParser());){
                Pair<BasicModModel, ModelImporter> pair = this.readModel(modelFactory, dataSourceName, reader);
                if (pair != null) {
                    Pair<BasicModModel, ModelImporter> it2 = pair;
                    boolean bl = false;
                    Pair<BasicModModel, ModelImporter> pair2 = it2;
                    return pair2;
                }
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    pair = this.readModel(modelFactory, dataSourceName, reader);
                    if (pair != null) {
                        Pair<BasicModModel, ModelImporter> it3 = pair;
                        boolean bl = false;
                        Pair<BasicModModel, ModelImporter> pair3 = it3;
                        return pair3;
                    }
                    reader.moveUp();
                }
                pair = null;
                return pair;
            }
        }

        private final Pair<BasicModModel, ModelImporter> readModel(ModelFactory modelFactory, String dataSourceName, HierarchicalStreamReader reader) {
            Pair pair;
            if (Intrinsics.areEqual((Object)"database-model", (Object)reader.getNodeName())) {
                ModelImporter importer = new ModelImporter(modelFactory);
                BasicModModel model2 = importer.deserialize(reader, dataSourceName);
                pair = new Pair((Object)model2, (Object)importer);
            } else {
                pair = null;
            }
            return pair;
        }

        private static final void writeModel$lambda$0(String $name, DasModel $model, TreePattern $scope, OutputStream out) {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            HierarchicalStreamWriter writer = (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)printWriter);
            writer.startNode("dataSource");
            writer.addAttribute("name", $name);
            DasModel dasModel = $model;
            Intrinsics.checkNotNull((Object)dasModel);
            ModelSerializerKt.serialize(dasModel, writer, $scope);
            writer.endNode();
            writer.close();
        }

        /*
         * Unable to fully structure code
         */
        private static final void isReadonly$lambda$3$lambda$2(boolean[] $readOnly, Project $project, VirtualFile $virtualFile) {
            Intrinsics.checkNotNullParameter((Object)$readOnly, (String)"$readOnly");
            v0 = $project;
            Intrinsics.checkNotNull((Object)v0);
            if (v0.isDisposed()) ** GOTO lbl-1000
            var3_3 = new VirtualFile[]{$virtualFile};
            if (!ReadonlyStatusHandler.ensureFilesWritable((Project)$project, (VirtualFile[])var3_3)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            $readOnly[0] = v1;
        }

        private static final void isReadonly$lambda$3(boolean[] $readOnly, Project $project, VirtualFile $virtualFile) {
            Intrinsics.checkNotNullParameter((Object)$readOnly, (String)"$readOnly");
            NonProjectFileWritingAccessProvider.disableChecksDuring(() -> Companion.isReadonly$lambda$3$lambda$2($readOnly, $project, $virtualFile));
        }

        public static final /* synthetic */ void access$validateModels(Companion $this, Project project, List dataSources2) {
            $this.validateModels(project, dataSources2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dataSource/DataSourceModelStorageImpl$Prj;", "Lcom/intellij/database/dataSource/DataSourceModelStorageImpl;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.database.connectivity"})
    private static final class Prj
    extends DataSourceModelStorageImpl {
        @NotNull
        private final Project project;

        public Prj(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            super((ComponentManager)project, coroutineScope, null);
            this.project = project;
        }

        @Override
        @NotNull
        protected Project getProject() {
            return this.project;
        }
    }
}

