/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u001bH\u0007\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0005*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013\"\u0017\u0010\u0014\u001a\u0004\u0018\u00010\b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"basicModel", "Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/DasDataSource;", "getBasicModel", "(Lcom/intellij/database/model/DasDataSource;)Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/RawDataSource;", "(Lcom/intellij/database/model/RawDataSource;)Lcom/intellij/database/model/basic/BasicModel;", "basicModelRoot", "Lcom/intellij/database/model/basic/BasicRoot;", "getBasicModelRoot", "(Lcom/intellij/database/model/DasDataSource;)Lcom/intellij/database/model/basic/BasicRoot;", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getLocalDataSource", "(Lcom/intellij/database/model/DasDataSource;)Lcom/intellij/database/dataSource/LocalDataSource;", "rawDataSource", "getRawDataSource", "(Lcom/intellij/database/model/DasDataSource;)Lcom/intellij/database/model/RawDataSource;", "Lcom/intellij/database/psi/DbDataSource;", "(Lcom/intellij/database/psi/DbDataSource;)Lcom/intellij/database/model/RawDataSource;", "realModelRoot", "getRealModelRoot", "(Lcom/intellij/database/model/RawDataSource;)Lcom/intellij/database/model/basic/BasicRoot;", "isLoading", "", "inProject", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/view/DataSourceNode;", "intellij.database.core.impl"})
@JvmName(name="DataSourceFun")
public final class DataSourceFun {
    @Nullable
    public static final RawDataSource getRawDataSource(@NotNull DasDataSource $this$rawDataSource) {
        Intrinsics.checkNotNullParameter((Object)$this$rawDataSource, (String)"<this>");
        DasDataSource dasDataSource = $this$rawDataSource;
        return dasDataSource instanceof RawDataSource ? (RawDataSource)$this$rawDataSource : (dasDataSource instanceof DbDataSource ? DataSourceFun.getRawDataSource((DbDataSource)$this$rawDataSource) : null);
    }

    @Nullable
    public static final RawDataSource getRawDataSource(@NotNull DbDataSource $this$rawDataSource) {
        Intrinsics.checkNotNullParameter((Object)$this$rawDataSource, (String)"<this>");
        return $this$rawDataSource.getDelegate();
    }

    @Nullable
    public static final BasicModel getBasicModel(@NotNull DasDataSource $this$basicModel) {
        Intrinsics.checkNotNullParameter((Object)$this$basicModel, (String)"<this>");
        RawDataSource rawDataSource = DataSourceFun.getRawDataSource($this$basicModel);
        return rawDataSource != null ? DataSourceFun.getBasicModel(rawDataSource) : null;
    }

    @Nullable
    public static final BasicModel getBasicModel(@NotNull RawDataSource $this$basicModel) {
        Intrinsics.checkNotNullParameter((Object)$this$basicModel, (String)"<this>");
        DasModel dasModel = $this$basicModel.getModel();
        return dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
    }

    @Nullable
    public static final BasicRoot getBasicModelRoot(@NotNull DasDataSource $this$basicModelRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$basicModelRoot, (String)"<this>");
        BasicModel basicModel = DataSourceFun.getBasicModel($this$basicModelRoot);
        return basicModel != null ? basicModel.getRoot() : null;
    }

    @Nullable
    public static final BasicRoot getRealModelRoot(@NotNull RawDataSource $this$realModelRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$realModelRoot, (String)"<this>");
        BasicModel basicModel = DataSourceFun.getBasicModel($this$realModelRoot);
        return basicModel != null ? basicModel.getRoot() : null;
    }

    @Nullable
    public static final LocalDataSource getLocalDataSource(@NotNull DasDataSource $this$localDataSource) {
        Intrinsics.checkNotNullParameter((Object)$this$localDataSource, (String)"<this>");
        RawDataSource rawDataSource = DataSourceFun.getRawDataSource($this$localDataSource);
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    public static final boolean isLoading(@NotNull RawDataSource $this$isLoading, @NotNull Project inProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isLoading, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inProject, (String)"inProject");
        DataSourceManager<RawDataSource> dataSourceManager = DataSourceManager.byDataSource(inProject, $this$isLoading);
        if (dataSourceManager == null) {
            return false;
        }
        DataSourceManager<RawDataSource> manager = dataSourceManager;
        return manager.isLoading($this$isLoading);
    }

    @ApiStatus.Experimental
    public static final boolean isLoading(@NotNull DataSourceNode $this$isLoading) {
        Intrinsics.checkNotNullParameter((Object)$this$isLoading, (String)"<this>");
        return DataSourceFun.isLoading($this$isLoading.rawDataSource, $this$isLoading.getProject());
    }
}

