/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.DbmsExtension;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTWriter;

public class GeoHelper {
    protected static final Logger LOG = Logger.getInstance(GeoHelper.class);
    public static final DbmsExtension<GeoHelper> EP = new DbmsExtension("com.intellij.database.geoHelper");

    public boolean isGeoType(@NotNull String type) {
        if (type == null) {
            GeoHelper.$$$reportNull$$$0(0);
        }
        return type.equalsIgnoreCase("geometry") || type.equalsIgnoreCase("geography");
    }

    public String extractGeometryAsWkt(Object data, @Nullable GridColumn column2) {
        return (String)ObjectUtils.tryCast((Object)data, String.class);
    }

    public static String hexWkb2Wkt(@NotNull String data) {
        if (data == null) {
            GeoHelper.$$$reportNull$$$0(1);
        }
        try {
            return GeoHelper.wkb2Wkt(WKBReader.hexToBytes(data));
        }
        catch (RuntimeException e2) {
            return null;
        }
    }

    public static String wkb2Wkt(byte @NotNull [] data) {
        if (data == null) {
            GeoHelper.$$$reportNull$$$0(2);
        }
        return GeoHelper.wkb2WktInner(new ByteArrayInStream(data));
    }

    @Nullable
    protected static String wkb2WktInner(ByteArrayInStream stream) {
        Geometry geometry = GeoHelper.wkb2Geom(stream);
        return geometry == null ? null : new WKTWriter().write(geometry);
    }

    @Nullable
    protected static Geometry wkb2Geom(ByteArrayInStream stream) {
        try {
            return new WKBReader().read(stream);
        }
        catch (IOException | ParseException e2) {
            LOG.warn((Throwable)e2);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/data/types/GeoHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isGeoType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hexWkb2Wkt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "wkb2Wkt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

