/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.DatabaseEngine;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.console.session.MessageBusSession;
import com.intellij.database.console.session.SessionAuditService;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.audit.AuditorChain;
import com.intellij.database.run.audit.CancelProgressAuditor;
import com.intellij.database.run.audit.TxIsolationAuditor;
import com.intellij.database.run.audit.TxMarkerAuditor;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.MessageBusSessionState;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.StateWatcher;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\b\u0016\u0018\u0000 [2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0005[\\]^_B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0014H\u0016J\b\u0010D\u001a\u00020BH\u0016J\u0010\u0010E\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0014H\u0016J\b\u0010F\u001a\u00020BH\u0016J\u0018\u0010G\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00142\u0006\u0010H\u001a\u00020\u0002H\u0016J\b\u0010I\u001a\u00020JH\u0016J\u0012\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020\fH\u0016J\b\u0010N\u001a\u00020\fH\u0016J\b\u0010O\u001a\u00020,H\u0016J\b\u0010P\u001a\u00020\bH\u0016J\b\u0010Q\u001a\u00020RH\u0016J\b\u0010S\u001a\u00020\"H\u0016J\b\u0010T\u001a\u00020\"H\u0016J\u0010\u0010U\u001a\u00020B2\u0006\u0010V\u001a\u00020\"H\u0016J\u0010\u0010W\u001a\u00020B2\u0006\u0010X\u001a\u00020JH\u0016J\u0010\u0010Y\u001a\u00020B2\u0006\u0010Z\u001a\u00020RH\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R$\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010$R\u0014\u0010(\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R$\u00100\u001a\u00020/2\u0006\u0010!\u001a\u00020/@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R(\u00105\u001a\u00020\f2\b\b\u0001\u0010!\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/intellij/database/console/session/MessageBusSession;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/database/console/session/DatabaseSession;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable$Parent;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "kernel", "Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;Ljava/lang/String;)V", "auditService", "Lcom/intellij/database/dataSource/connection/audit/AuditService;", "getAuditService", "()Lcom/intellij/database/dataSource/connection/audit/AuditService;", "clients", "", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "getClients", "()[Lcom/intellij/database/console/client/DatabaseSessionClient;", "clientsWithFile", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "getClientsWithFile", "()[Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConfiguration", "()Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConnectionPoint", "()Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "value", "", "isConnected", "()Z", "setConnected", "(Z)V", "isInternal", "isService", "getKernel", "()Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "messageBus", "Lcom/intellij/database/DataBus$Consuming;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/run/session/MessageBusSessionState;", "state", "getState", "()Lcom/intellij/database/run/session/MessageBusSessionState;", "setState", "(Lcom/intellij/database/run/session/MessageBusSessionState;)V", "title", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "view", "Lcom/intellij/database/run/session/LogView;", "getView", "()Lcom/intellij/database/run/session/LogView;", "wallet", "Lcom/intellij/database/console/session/MessageBusSession$Wallet;", "wasPublicClient", "attach", "", "client", "beforeTreeDispose", "detach", "dispose", "exchange", "to", "getCurrentTx", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getData", "", "dataId", "getDisplayName", "getMessageBus", "getTarget", "getTxIsolation", "", "isIdle", "isValid", "setAutoCommit", "autoCommit", "setCurrentTx", "marker", "setTxIsolation", "isolation", "Companion", "MessageBusSessionChangeEvent", "NaturalKernel", "SessionKernel", "Wallet", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nMessageBusSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageBusSession.kt\ncom/intellij/database/console/session/MessageBusSession\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,297:1\n37#2,2:298\n37#2,2:300\n*S KotlinDebug\n*F\n+ 1 MessageBusSession.kt\ncom/intellij/database/console/session/MessageBusSession\n*L\n77#1:298,2\n80#1:300,2\n*E\n"})
public class MessageBusSession
extends UserDataHolderBase
implements DatabaseSession,
DataProvider,
Disposable.Parent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseConnectionPoint connectionPoint;
    @NotNull
    private final SessionKernel kernel;
    @NotNull
    private String title;
    @NotNull
    private final AuditService auditService;
    private final boolean isService;
    private volatile boolean isConnected;
    @NotNull
    private MessageBusSessionState state;
    @NotNull
    private final DataBus.Consuming messageBus;
    @NotNull
    private final Wallet wallet;
    private boolean wasPublicClient;
    @NlsSafe
    @NotNull
    public static final String DEFAULT_SESSION_NAME = "default";
    @NotNull
    public static final String DATABASE_CONSOLE_HELP_ID = "reference.runToolWindow.jdbcTab";

    public MessageBusSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull SessionKernel kernel, @Nls @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)kernel, (String)"kernel");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.project = project;
        this.connectionPoint = connectionPoint;
        this.kernel = kernel;
        this.title = name2;
        this.auditService = new SessionAuditService(this);
        this.isService = ((CharSequence)name2).length() == 0;
        this.state = new MessageBusSessionState();
        DataBus.Consuming consuming = this.kernel.getConsuming().filterFor(this);
        Intrinsics.checkNotNullExpressionValue((Object)consuming, (String)"filterFor(...)");
        this.messageBus = consuming;
        this.wallet = new Wallet(this);
        this.kernel.init(this.getProject(), this);
        Disposer.register((Disposable)((Disposable)this.getProject()), (Disposable)this);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public DatabaseConnectionPoint getConnectionPoint() {
        return this.connectionPoint;
    }

    @NotNull
    protected final SessionKernel getKernel() {
        return this.kernel;
    }

    @Override
    @NotNull
    public String getTitle() {
        return ((CharSequence)this.title).length() == 0 ? DEFAULT_SESSION_NAME : this.title;
    }

    @Override
    public void setTitle(@Nls @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (((CharSequence)this.title).length() == 0) {
            return;
        }
        this.title = value2;
        MessageBusSession.Companion.syncPublisher().renamed(this);
    }

    @Override
    @Nullable
    public ConsoleRunConfiguration getConfiguration() {
        return this.kernel.getConfiguration();
    }

    @Override
    @NotNull
    public AuditService getAuditService() {
        return this.auditService;
    }

    @Override
    public boolean isService() {
        return this.isService;
    }

    @Override
    public boolean isInternal() {
        return !this.isService() && !this.wasPublicClient;
    }

    @NotNull
    public final LogView<DatabaseSession> getView() {
        return DatabaseSessionViewService.Companion.getInstance().getView(this);
    }

    @Override
    @NotNull
    public DatabaseSessionClient[] getClients() {
        Collection $this$toTypedArray$iv = this.wallet.getAttached();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DatabaseSessionClient[0]);
    }

    @Override
    @NotNull
    public DatabaseSessionClientWithFile[] getClientsWithFile() {
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this.wallet.getAttached()), DatabaseSessionClientWithFile.class), (Function1)clientsWithFile.1.INSTANCE));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DatabaseSessionClientWithFile[0]);
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean value2) {
        this.isConnected = value2;
        DatabaseSessionStateListener listener2 = MessageBusSession.Companion.syncPublisher();
        if (value2) {
            listener2.connected(this);
        } else {
            listener2.disconnected(this);
        }
    }

    @Override
    @NotNull
    public MessageBusSessionState getState() {
        return this.state;
    }

    public void setState(@NotNull MessageBusSessionState value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ThreadingAssertions.assertEventDispatchThread();
        DatabaseSessionStateListener.ChangeEvent.EventType eventType = this.state.isIdle() == value2.isIdle() ? DatabaseSessionStateListener.ChangeEvent.EventType.CHANGED : (this.state.isIdle() ? DatabaseSessionStateListener.ChangeEvent.EventType.STARTED : DatabaseSessionStateListener.ChangeEvent.EventType.STOPPED);
        this.state = value2;
        MessageBusSession.Companion.syncPublisher().stateChanged(new MessageBusSessionChangeEvent(this, eventType));
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        return this.kernel.getTxMarker();
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        this.kernel.setTxMarker(marker);
    }

    @Override
    public int getTxIsolation() {
        return this.kernel.getIsolation();
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.kernel.setIsolation(isolation);
    }

    @Override
    public boolean isIdle() {
        return this.kernel.getIdle();
    }

    @Override
    @NotNull
    public DatabaseConnectionPoint getTarget() {
        return this.getConnectionPoint();
    }

    @Override
    public boolean isValid() {
        LogView<DatabaseSession> view2 = DatabaseSessionViewService.Companion.getInstance().getViewIfAny(this);
        return (view2 == null || view2.isValid()) && !this.wallet.getDisposed() && DataSourceUtil.isDataSourceValid(DbPsiFacade.getInstance(this.getProject()), this.getTarget().getDataSource());
    }

    @NotNull
    public String getDisplayName() {
        return this.getTitle();
    }

    @Override
    @NotNull
    public DataBus.Consuming getMessageBus() {
        return this.messageBus;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        DataRequest.TxMarker txMarker;
        if (autoCommit) {
            DataRequest.TxMarker txMarker2 = DataRequest.AUTO_COMMIT;
            txMarker = txMarker2;
            Intrinsics.checkNotNullExpressionValue((Object)txMarker2, (String)"AUTO_COMMIT");
        } else {
            DataRequest.TxMarker txMarker3 = DataRequest.START_NEW;
            txMarker = txMarker3;
            Intrinsics.checkNotNullExpressionValue((Object)txMarker3, (String)"START_NEW");
        }
        this.setCurrentTx(txMarker);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return PlatformCoreDataKeys.HELP_ID.is(dataId) ? (Serializable)((Object)DATABASE_CONSOLE_HELP_ID) : (Session.SESSION_KEY.is(dataId) ? (Serializable)((Object)this) : null);
    }

    public void dispose() {
    }

    public void beforeTreeDispose() {
        this.wallet.setDisposed(true);
    }

    @Override
    public void attach(@NotNull DatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (this.wallet.contains(client)) {
            return;
        }
        boolean wasInternal = this.isInternal();
        boolean bl = this.wasPublicClient = this.wasPublicClient || !client.getDepartment().isInternal();
        if (!this.isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeLaterIfNeeded(() -> MessageBusSession.attach$lambda$0(this));
        }
        if (wasInternal && !this.isInternal()) {
            UIUtil.invokeLaterIfNeeded(() -> MessageBusSession.attach$lambda$1(this));
        }
        this.wallet.attach(client);
    }

    @Override
    public void detach(@NotNull DatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.wallet.detach(client, DatabaseSessionClient.DetachTrigger.USER_REQUEST);
    }

    @Override
    public void exchange(@NotNull DatabaseSessionClient client, @NotNull DatabaseSession to) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            if (this.wallet.contains(client)) {
                this.wallet.detach(client, DatabaseSessionClient.DetachTrigger.SESSION_SWITCH);
            }
            to.attach(client);
            VisibleDatabaseSessionClient visibleDatabaseSessionClient = client instanceof VisibleDatabaseSessionClient ? (VisibleDatabaseSessionClient)client : null;
            if (visibleDatabaseSessionClient == null) break block1;
            VisibleDatabaseSessionClient it2 = visibleDatabaseSessionClient;
            boolean bl = false;
            MessageBusSession.Companion.syncPublisher().clientReattached(it2, this, to);
        }
    }

    private static final void attach$lambda$0(MessageBusSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseSessionViewService.Companion.getInstance().initView(this$0);
    }

    private static final void attach$lambda$1(MessageBusSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MessageBusSessionChangeEvent event = new MessageBusSessionChangeEvent(this$0, DatabaseSessionStateListener.ChangeEvent.EventType.PUBLISHED);
        MessageBusSession.Companion.syncPublisher().stateChanged(event);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$Companion;", "", "()V", "DATABASE_CONSOLE_HELP_ID", "", "DEFAULT_SESSION_NAME", "syncPublisher", "Lcom/intellij/database/console/session/DatabaseSessionStateListener;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        private final DatabaseSessionStateListener syncPublisher() {
            return (DatabaseSessionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DatabaseSession.Companion.getTopic());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$MessageBusSessionChangeEvent;", "Lcom/intellij/database/console/session/DatabaseSessionStateListener$ChangeEvent;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "eventType", "Lcom/intellij/database/console/session/DatabaseSessionStateListener$ChangeEvent$EventType;", "(Lcom/intellij/database/console/session/DatabaseSession;Lcom/intellij/database/console/session/DatabaseSessionStateListener$ChangeEvent$EventType;)V", "getSession", "getType", "intellij.database.connectivity"})
    private static final class MessageBusSessionChangeEvent
    implements DatabaseSessionStateListener.ChangeEvent {
        @NotNull
        private final DatabaseSession session;
        @NotNull
        private final DatabaseSessionStateListener.ChangeEvent.EventType eventType;

        public MessageBusSessionChangeEvent(@NotNull DatabaseSession session2, @NotNull DatabaseSessionStateListener.ChangeEvent.EventType eventType) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            this.session = session2;
            this.eventType = eventType;
        }

        @Override
        @NotNull
        public DatabaseSessionStateListener.ChangeEvent.EventType getType() {
            return this.eventType;
        }

        @Override
        @NotNull
        public DatabaseSession getSession() {
            return this.session;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ2\u00100\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00101\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u00103\u001a\u00020/H\u0014J\u0018\u00104\u001a\u0002052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00103\u001a\u000206H\u0016R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$NaturalKernel;", "Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/access/DatabaseCredentials;Z)V", "broker", "Lcom/intellij/database/SimpleRequestBroker;", "kotlin.jvm.PlatformType", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConfiguration", "()Lcom/intellij/database/run/ConsoleRunConfiguration;", "consuming", "Lcom/intellij/database/DataBus$Consuming;", "getConsuming", "()Lcom/intellij/database/DataBus$Consuming;", "engine", "Lcom/intellij/database/console/DatabaseEngine;", "getEngine", "()Lcom/intellij/database/console/DatabaseEngine;", "setEngine", "(Lcom/intellij/database/console/DatabaseEngine;)V", "idle", "getIdle", "()Z", "isolation", "", "getIsolation", "()I", "setIsolation", "(I)V", "txMarker", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getTxMarker", "()Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setTxMarker", "(Lcom/intellij/database/datagrid/DataRequest$TxMarker;)V", "watcher", "Lcom/intellij/database/run/session/StateWatcher;", "Lcom/intellij/database/console/session/DatabaseSession;", "createEngine", "bus", "Lcom/intellij/database/DataBus$Producing;", "session", "init", "", "Lcom/intellij/database/console/session/MessageBusSession;", "intellij.database.connectivity"})
    public static class NaturalKernel
    implements SessionKernel {
        @NotNull
        private final DatabaseConnectionPoint connectionPoint;
        @Nullable
        private final DatabaseCredentials credentialsStore;
        private final boolean silent;
        private final SimpleRequestBroker broker;
        private StateWatcher<DatabaseSession> watcher;
        private volatile int isolation;
        @NotNull
        private volatile DataRequest.TxMarker txMarker;
        public DatabaseEngine engine;

        public NaturalKernel(@NotNull Project project, @NotNull String title, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, boolean silent) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            this.connectionPoint = connectionPoint;
            this.credentialsStore = credentialsStore;
            this.silent = silent;
            this.broker = SimpleRequestBroker.newInstance(project, title);
            this.isolation = this.connectionPoint.getTxIsolation();
            DataRequest.TxMarker txMarker = DataRequest.getInitialTxMarker(this.connectionPoint.isAutoCommit());
            Intrinsics.checkNotNullExpressionValue((Object)txMarker, (String)"getInitialTxMarker(...)");
            this.txMarker = txMarker;
        }

        @Override
        public int getIsolation() {
            return this.isolation;
        }

        @Override
        public void setIsolation(int n) {
            this.isolation = n;
        }

        @Override
        @NotNull
        public DataRequest.TxMarker getTxMarker() {
            return this.txMarker;
        }

        @Override
        public void setTxMarker(@NotNull DataRequest.TxMarker txMarker) {
            Intrinsics.checkNotNullParameter((Object)txMarker, (String)"<set-?>");
            this.txMarker = txMarker;
        }

        @Override
        @NotNull
        public DataBus.Consuming getConsuming() {
            SimpleRequestBroker simpleRequestBroker = this.broker;
            Intrinsics.checkNotNullExpressionValue((Object)simpleRequestBroker, (String)"broker");
            return simpleRequestBroker;
        }

        @Override
        public boolean getIdle() {
            StateWatcher<DatabaseSession> stateWatcher = this.watcher;
            if (stateWatcher == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watcher");
                stateWatcher = null;
            }
            return stateWatcher.isIdle();
        }

        @NotNull
        public final DatabaseEngine getEngine() {
            DatabaseEngine databaseEngine = this.engine;
            if (databaseEngine != null) {
                return databaseEngine;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            return null;
        }

        public final void setEngine(@NotNull DatabaseEngine databaseEngine) {
            Intrinsics.checkNotNullParameter((Object)databaseEngine, (String)"<set-?>");
            this.engine = databaseEngine;
        }

        @Override
        @Nullable
        public ConsoleRunConfiguration getConfiguration() {
            return this.getEngine().getConfiguration();
        }

        @Override
        public void init(@NotNull Project project, @NotNull MessageBusSession session2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            SimpleRequestBroker simpleRequestBroker = this.broker;
            Intrinsics.checkNotNullExpressionValue((Object)simpleRequestBroker, (String)"broker");
            this.setEngine(this.createEngine(project, simpleRequestBroker, this.connectionPoint, this.credentialsStore, session2));
            DataAuditor[] dataAuditorArray = new DataAuditor[]{new TxIsolationAuditor(session2), new TxMarkerAuditor(session2), new CancelProgressAuditor(session2)};
            session2.messageBus.addAuditor(new AuditorChain(dataAuditorArray));
            Disposer.register((Disposable)session2, (Disposable)this.getEngine());
            this.watcher = new StateWatcher.DatabaseSessionWatcher(session2);
        }

        @NotNull
        protected DatabaseEngine createEngine(@NotNull Project project, @NotNull DataBus.Producing bus, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, @NotNull DatabaseSession session2) {
            JdbcEngine jdbcEngine;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            JdbcEngine $this$createEngine_u24lambda_u240 = jdbcEngine = new JdbcEngine(project, bus, connectionPoint, credentialsStore, session2);
            boolean bl = false;
            $this$createEngine_u24lambda_u240.setAskPassword(!this.silent);
            return jdbcEngine;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0015X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006 \u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$SessionKernel;", "", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConfiguration", "()Lcom/intellij/database/run/ConsoleRunConfiguration;", "consuming", "Lcom/intellij/database/DataBus$Consuming;", "getConsuming", "()Lcom/intellij/database/DataBus$Consuming;", "idle", "", "getIdle", "()Z", "isolation", "", "getIsolation", "()I", "setIsolation", "(I)V", "txMarker", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getTxMarker", "()Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "setTxMarker", "(Lcom/intellij/database/datagrid/DataRequest$TxMarker;)V", "init", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/database/console/session/MessageBusSession;", "intellij.database.connectivity"})
    public static interface SessionKernel {
        @NotNull
        public DataBus.Consuming getConsuming();

        @NotNull
        public DataRequest.TxMarker getTxMarker();

        public void setTxMarker(@NotNull DataRequest.TxMarker var1);

        public int getIsolation();

        public void setIsolation(int var1);

        public boolean getIdle();

        @Nullable
        public ConsoleRunConfiguration getConfiguration();

        public void init(@NotNull Project var1, @NotNull MessageBusSession var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0011\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0086\u0002J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/console/session/MessageBusSession$Wallet;", "", "session", "Lcom/intellij/database/console/session/MessageBusSession;", "(Lcom/intellij/database/console/session/MessageBusSession;)V", "attached", "", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "getAttached", "()Ljava/util/List;", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "attach", "", "client", "canClose", "contains", "detach", "trigger", "Lcom/intellij/database/console/client/DatabaseSessionClient$DetachTrigger;", "disposeIfPossible", "intellij.database.connectivity"})
    private static final class Wallet {
        @NotNull
        private final MessageBusSession session;
        @NotNull
        private final List<DatabaseSessionClient> attached;
        private volatile boolean disposed;

        public Wallet(@NotNull MessageBusSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            this.session = session2;
            ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
            this.attached = (List)concurrentList;
        }

        @NotNull
        public final List<DatabaseSessionClient> getAttached() {
            return this.attached;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        public final void setDisposed(boolean bl) {
            this.disposed = bl;
        }

        public final boolean contains(@NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            return this.attached.contains(client);
        }

        public final void attach(@NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            UIUtil.invokeLaterIfNeeded(() -> Wallet.attach$lambda$0(this, client));
            Disposer.register((Disposable)client, () -> Wallet.attach$lambda$1(this, client));
        }

        public final void detach(@NotNull DatabaseSessionClient client, @NotNull DatabaseSessionClient.DetachTrigger trigger2) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)((Object)trigger2), (String)"trigger");
            this.disposeIfPossible(client);
            client.detached(trigger2);
        }

        private final void disposeIfPossible(DatabaseSessionClient client) {
            UIUtil.invokeLaterIfNeeded(() -> Wallet.disposeIfPossible$lambda$2(this, client));
        }

        private final boolean canClose(DatabaseSessionClient client) {
            return !this.session.isService() && (this.session.isInternal() || ApplicationManager.getApplication().isUnitTestMode() || !this.session.getCurrentTx().isTransactionInProgress() && client instanceof DatabaseSessionClientWithFile && ((DatabaseSessionClientWithFile)client).getAutoClose());
        }

        private static final void attach$lambda$0(Wallet this$0, DatabaseSessionClient $client) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
            ((Collection)this$0.attached).add($client);
            if ($client instanceof VisibleDatabaseSessionClient) {
                Companion.syncPublisher().clientAttached((VisibleDatabaseSessionClient)$client);
            }
        }

        private static final void attach$lambda$1(Wallet this$0, DatabaseSessionClient $client) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
            this$0.disposeIfPossible($client);
        }

        private static final void disposeIfPossible$lambda$2(Wallet this$0, DatabaseSessionClient $client) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
            ((Collection)this$0.attached).remove($client);
            if ($client instanceof VisibleDatabaseSessionClient) {
                Companion.syncPublisher().clientDetached((VisibleDatabaseSessionClient)$client);
            }
            if (this$0.attached.isEmpty() && this$0.canClose($client)) {
                Disposer.dispose((Disposable)this$0.session);
            }
        }
    }
}

