/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationProducer;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ0\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000fJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J>\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000fH\u0002J\u0018\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\tH\u0002J&\u0010(\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120*H\u0014\u00a8\u0006,"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration;", "()V", "asTarget", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions$Target;", "e", "Lcom/intellij/database/psi/DbElement;", "canCreate", "", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiElements", "Lcom/intellij/psi/PsiElement;", "createConfigurationFromContext", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "findExistingConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getPsiElements", "getSelectedFiles", "", "source", "sourceFile", "Lcom/intellij/psi/PsiFile;", "getSelectedTargets", "Lcom/intellij/util/containers/JBIterable;", "psi", "getVirtualFilesFromContext", "isConfigurationFromContext", "configuration", "isIgnoredConsoleScriptFile", "file", "isConsoleOrEmptySource", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseScriptRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseScriptRunConfigurationProducer.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1#2:132\n1#2:143\n1603#3,9:133\n1855#3:142\n1856#3:144\n1612#3:145\n*S KotlinDebug\n*F\n+ 1 DatabaseScriptRunConfigurationProducer.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationProducer\n*L\n86#1:143\n86#1:133,9\n86#1:142\n86#1:144\n86#1:145\n*E\n"})
public final class DatabaseScriptRunConfigurationProducer
extends LazyRunConfigurationProducer<DatabaseScriptRunConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return DatabaseScriptRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0];
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(@NotNull ConfigurationContext context) {
        ConfigurationFromContext configurationFromContext;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConfigurationFromContext configurationFromContext2 = super.createConfigurationFromContext(context);
        if (configurationFromContext2 != null) {
            ConfigurationFromContext configurationFromContext3;
            ConfigurationFromContext $this$createConfigurationFromContext_u24lambda_u240 = configurationFromContext3 = configurationFromContext2;
            boolean bl = false;
            $this$createConfigurationFromContext_u24lambda_u240.getConfigurationSettings().setEditBeforeRun(true);
            configurationFromContext = configurationFromContext3;
        } else {
            configurationFromContext = null;
        }
        return configurationFromContext;
    }

    protected boolean setupConfigurationFromContext(@NotNull DatabaseScriptRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        block1: {
            DatabaseScriptRunConfigurationOptions databaseScriptRunConfigurationOptions;
            PsiElement source;
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
            PsiElement psiElement = source = (PsiElement)sourceElement.get();
            PsiFile sourceFile = psiElement != null ? psiElement.getContainingFile() : null;
            List<String> list = this.getSelectedFiles(context.getProject(), this.getVirtualFilesFromContext(context), source, sourceFile);
            if (list == null) {
                return false;
            }
            List<String> selectedFiles = list;
            JBIterable<DatabaseScriptRunConfigurationOptions.Target> selectedTargets = this.getSelectedTargets(this.getPsiElements(context));
            DatabaseScriptRunConfigurationOptions $this$setupConfigurationFromContext_u24lambda_u241 = databaseScriptRunConfigurationOptions = configuration.getOptions();
            boolean bl = false;
            $this$setupConfigurationFromContext_u24lambda_u241.setMode(DatabaseScriptRunConfigurationOptions.Mode.FILE);
            $this$setupConfigurationFromContext_u24lambda_u241.setFiles(CollectionsKt.toMutableList((Collection)selectedFiles));
            $this$setupConfigurationFromContext_u24lambda_u241.setTargets(CollectionsKt.toMutableList((Iterable)((Iterable)selectedTargets)));
            configuration.setGeneratedName();
            PsiFile psiFile = sourceFile;
            if (psiFile == null) break block1;
            PsiFile it2 = psiFile;
            boolean bl2 = false;
            sourceElement.set((Object)it2);
        }
        return true;
    }

    public final boolean canCreate(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.canCreate(context.getProject(), this.getVirtualFilesFromContext(context), this.getPsiElements(context));
    }

    public final boolean canCreate(@Nullable Project project, @Nullable List<? extends VirtualFile> virtualFiles, @Nullable List<? extends PsiElement> psiElements) {
        List<String> list = this.getSelectedFiles(project, virtualFiles, null, null);
        return (list != null ? !((Collection)list).isEmpty() : false) && this.getSelectedTargets(psiElements).isNotEmpty();
    }

    private final List<VirtualFile> getVirtualFilesFromContext(ConfigurationContext context) {
        Object object = (VirtualFile[])LangDataKeys.VIRTUAL_FILE_ARRAY.getData(context.getDataContext());
        if (object == null || (object = ArraysKt.asList((Object[])object)) == null) {
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context.getDataContext());
            if (virtualFile != null) {
                VirtualFile it2 = virtualFile;
                boolean bl = false;
                object = CollectionsKt.listOf((Object)it2);
            } else {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getSelectedFiles(Project project, List<? extends VirtualFile> virtualFiles, PsiElement source, PsiFile sourceFile) {
        List files2;
        List list;
        void $this$mapNotNullTo$iv$iv;
        if (virtualFiles == null) {
            return null;
        }
        boolean isConsoleOrEmptySource = source != null && sourceFile != null && (!Intrinsics.areEqual((Object)source, (Object)sourceFile) || !(source instanceof PsiCompiledFile) && source.getTextLength() == 0);
        Iterable $this$mapNotNull$iv = virtualFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            VirtualFile it2 = virtualFile = file;
            boolean bl3 = false;
            Object object = DbImplUtil.isScriptFile(project, it2) && !this.isIgnoredConsoleScriptFile(file, isConsoleOrEmptySource) ? virtualFile : null;
            if ((object != null ? object.getPath() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it3 = list = (files2 = (List)destination$iv$iv);
        boolean bl = false;
        return !((Collection)it3).isEmpty() ? list : null;
    }

    private final List<PsiElement> getPsiElements(ConfigurationContext context) {
        Object object = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context.getDataContext());
        if (object == null || (object = ArraysKt.asList((Object[])object)) == null) {
            PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context.getDataContext());
            if (psiElement != null) {
                PsiElement it2 = psiElement;
                boolean bl = false;
                object = CollectionsKt.listOf((Object)it2);
            } else {
                object = null;
            }
        }
        return object;
    }

    private final JBIterable<DatabaseScriptRunConfigurationOptions.Target> getSelectedTargets(List<? extends PsiElement> psi) {
        JBIterable jBIterable = JBIterable.from((Iterable)psi).filter(DbElement.class).filterMap(arg_0 -> DatabaseScriptRunConfigurationProducer.getSelectedTargets$lambda$8(getSelectedTargets.1.INSTANCE, arg_0)).map(arg_0 -> DatabaseScriptRunConfigurationProducer.getSelectedTargets$lambda$9((Function1)new Function1<DbElement, DatabaseScriptRunConfigurationOptions.Target>(this){
            final /* synthetic */ DatabaseScriptRunConfigurationProducer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final DatabaseScriptRunConfigurationOptions.Target invoke(DbElement it2) {
                Intrinsics.checkNotNull((Object)it2);
                return DatabaseScriptRunConfigurationProducer.access$asTarget(this.this$0, it2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return jBIterable;
    }

    private final DatabaseScriptRunConfigurationOptions.Target asTarget(DbElement e2) {
        DbElement dbElement;
        DbDataSource dbDataSource = e2.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        DbDataSource dataSource2 = dbDataSource;
        DbElement it2 = dbElement = e2;
        boolean bl = false;
        ObjectPath path = ObjectPaths.of(!Intrinsics.areEqual((Object)it2, (Object)dataSource2) ? dbElement : null);
        ObjectPath objectPath = path;
        return new DatabaseScriptRunConfigurationOptions.Target(dataSource2.getUniqueId(), objectPath != null ? objectPath.serialize() : null);
    }

    private final boolean isIgnoredConsoleScriptFile(VirtualFile file, boolean isConsoleOrEmptySource) {
        return DbVFSUtils.isConsoleFile(file) && isConsoleOrEmptySource;
    }

    public boolean isConfigurationFromContext(@NotNull DatabaseScriptRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DatabaseScriptRunConfigurationOptions options2 = configuration.getOptions();
        List<String> list = this.getSelectedFiles(context.getProject(), this.getVirtualFilesFromContext(context), null, null);
        if (list == null) {
            return false;
        }
        List<String> selectedFiles = list;
        List list2 = this.getSelectedTargets(this.getPsiElements(context)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        List targets2 = list2;
        return options2.getMode() == DatabaseScriptRunConfigurationOptions.Mode.FILE && selectedFiles.size() == options2.getFiles().size() && selectedFiles.containsAll((Collection)options2.getFiles()) && (targets2.isEmpty() || targets2.size() == options2.getTargets().size() && targets2.containsAll((Collection)options2.getTargets()));
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project).getSelectedConfiguration();
        if (runnerAndConfigurationSettings != null) {
            DatabaseScriptRunConfiguration rc;
            RunnerAndConfigurationSettings cur = runnerAndConfigurationSettings;
            boolean bl = false;
            RunConfiguration runConfiguration = cur.getConfiguration();
            DatabaseScriptRunConfiguration databaseScriptRunConfiguration = rc = runConfiguration instanceof DatabaseScriptRunConfiguration ? (DatabaseScriptRunConfiguration)runConfiguration : null;
            if (rc != null && this.isConfigurationFromContext(rc, context)) {
                return cur;
            }
        }
        return super.findExistingConfiguration(context);
    }

    private static final DbElement getSelectedTargets$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DbElement)$tmp0.invoke(p0);
    }

    private static final DatabaseScriptRunConfigurationOptions.Target getSelectedTargets$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DatabaseScriptRunConfigurationOptions.Target)((Object)$tmp0.invoke(p0));
    }

    public static final /* synthetic */ DatabaseScriptRunConfigurationOptions.Target access$asTarget(DatabaseScriptRunConfigurationProducer $this, DbElement e2) {
        return $this.asTarget(e2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationProducer$Companion;", "", "()V", "setUpConfigurationFromFiles", "", "configuration", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration;", "selectedFiles", "", "", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void setUpConfigurationFromFiles(@NotNull DatabaseScriptRunConfiguration configuration, @NotNull List<String> selectedFiles) {
            DatabaseScriptRunConfigurationOptions databaseScriptRunConfigurationOptions;
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter(selectedFiles, (String)"selectedFiles");
            DatabaseScriptRunConfigurationOptions $this$setUpConfigurationFromFiles_u24lambda_u240 = databaseScriptRunConfigurationOptions = configuration.getOptions();
            boolean bl = false;
            $this$setUpConfigurationFromFiles_u24lambda_u240.setMode(DatabaseScriptRunConfigurationOptions.Mode.FILE);
            $this$setUpConfigurationFromFiles_u24lambda_u240.setFiles(CollectionsKt.toMutableList((Collection)selectedFiles));
            configuration.setGeneratedName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

