/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.console.runConfiguration.DatabaseScriptFilesRunProfileState;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationSettingsEditor;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunProfileState;
import com.intellij.database.console.runConfiguration.DatabaseScriptTextRunProfileState;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.lang.Language;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0000H\u0016J\u0010\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a\u0018\u00010\u0019H\u0002J\u0010\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0002J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "type", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationType;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "(Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationType;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "checkConfiguration", "", "clone", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getOptions", "getState", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getTargetPairs", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/util/ObjectPath;", "getVirtualFiles", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/vfs/VirtualFile;", "isGeneratedName", "", "suggestedName", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseScriptRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseScriptRunConfiguration.kt\ncom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class DatabaseScriptRunConfiguration
extends LocatableConfigurationBase<DatabaseScriptRunConfigurationOptions>
implements RunConfigurationWithSuppressedDefaultRunAction {
    public DatabaseScriptRunConfiguration(@NotNull DatabaseScriptRunConfigurationType type, @NotNull Project project, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, (ConfigurationFactory)type, name2);
    }

    public /* synthetic */ DatabaseScriptRunConfiguration(DatabaseScriptRunConfigurationType databaseScriptRunConfigurationType, Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(databaseScriptRunConfigurationType, project, string);
    }

    @NotNull
    public DatabaseScriptRunConfigurationOptions getOptions() {
        LocatableRunConfigurationOptions locatableRunConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)locatableRunConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions");
        return (DatabaseScriptRunConfigurationOptions)locatableRunConfigurationOptions;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new DatabaseScriptRunConfigurationSettingsEditor(project, (Function0<DatabaseScriptRunConfiguration>)((Function0)new Function0<DatabaseScriptRunConfiguration>(this){
            final /* synthetic */ DatabaseScriptRunConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DatabaseScriptRunConfiguration invoke() {
                ConfigurationFactory configurationFactory = this.this$0.getFactory();
                Intrinsics.checkNotNull((Object)configurationFactory, (String)"null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType");
                DatabaseScriptRunConfigurationType databaseScriptRunConfigurationType = (DatabaseScriptRunConfigurationType)configurationFactory;
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return new DatabaseScriptRunConfiguration(databaseScriptRunConfigurationType, project, null, 4, null);
            }
        }));
    }

    public void checkConfiguration() {
        Unit unit;
        super.checkConfiguration();
        DatabaseScriptRunConfigurationOptions options2 = this.getOptions();
        if (options2.getMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT) {
            CharSequence charSequence = options2.getText();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                throw new RuntimeConfigurationError(DatabaseBundle.message("dialog.message.missing.code.to.execute", new Object[0]));
            }
        } else if (this.getVirtualFiles() == null) {
            throw new RuntimeConfigurationError(DatabaseBundle.message("dialog.message.missing.files.to.execute", new Object[0]));
        }
        List<Pair<LocalDataSource, ObjectPath>> list = this.getTargetPairs();
        if (list != null) {
            List<Pair<LocalDataSource, ObjectPath>> it2 = list;
            boolean bl = false;
            if (it2.isEmpty()) {
                throw new RuntimeConfigurationError(DatabaseBundle.message("dialog.message.no.configured.target.data.sources", new Object[0]));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new RuntimeConfigurationError(DatabaseBundle.message("dialog.message.missing.target.data.sources", new Object[0]));
        }
    }

    @Nullable
    public DatabaseScriptRunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        DatabaseScriptRunProfileState databaseScriptRunProfileState;
        block7: {
            AsyncTask.Frame frame;
            DatabaseScriptRunProfileState databaseScriptRunProfileState2;
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            DatabaseScriptRunConfigurationOptions options2 = this.getOptions();
            List<Pair<LocalDataSource, ObjectPath>> list = this.getTargetPairs();
            if (list == null) {
                return null;
            }
            List<Pair<LocalDataSource, ObjectPath>> targets2 = list;
            if (targets2.isEmpty()) {
                return null;
            }
            Pair singleTarget = (Pair)CollectionsKt.singleOrNull(targets2);
            if (options2.getMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT && singleTarget != null) {
                String string = options2.getText();
                if (string == null) {
                    return null;
                }
                Object scriptText = string;
                if (!StringsKt.endsWith$default((CharSequence)((CharSequence)scriptText), (char)'\n', (boolean)false, (int)2, null)) {
                    scriptText = (String)scriptText + "\n";
                }
                String string2 = this.getName();
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Object object = singleTarget.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                databaseScriptRunProfileState2 = new DatabaseScriptTextRunProfileState(string2, project, (LocalDataSource)object, SearchPath.of((ObjectPath)singleTarget.second), (String)scriptText);
            } else {
                JBIterable<VirtualFile> jBIterable = this.getVirtualFiles();
                if (jBIterable == null) {
                    return null;
                }
                JBIterable<VirtualFile> virtualFiles = jBIterable;
                String string = this.getName();
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                List list2 = virtualFiles.toList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
                databaseScriptRunProfileState2 = new DatabaseScriptFilesRunProfileState(string, project, list2, targets2, environment);
            }
            DatabaseScriptRunProfileState $this$getState_u24lambda_u242 = databaseScriptRunProfileState = databaseScriptRunProfileState2;
            boolean bl = false;
            AsyncTask.Frame frame2 = frame = (AsyncTask.Frame)((Object)RemoteConsoleProcessSupport.BEFORE_RUN_CONTEXT.get((UserDataHolder)environment));
            if (frame2 == null) break block7;
            Intrinsics.checkNotNull((Object)((Object)frame2));
            AsyncTask.Frame it2 = frame;
            boolean bl2 = false;
            RemoteConsoleProcessSupport.BEFORE_RUN_CONTEXT.set((UserDataHolder)$this$getState_u24lambda_u242, (Object)it2);
        }
        return databaseScriptRunProfileState;
    }

    @NotNull
    public DatabaseScriptRunConfiguration clone() {
        RunConfiguration runConfiguration = super.clone();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration");
        return (DatabaseScriptRunConfiguration)runConfiguration;
    }

    private final List<Pair<LocalDataSource, ObjectPath>> getTargetPairs() {
        List list;
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(this.getProject());
        List it2 = list = JBIterable.from((Iterable)this.getOptions().getTargets()).map(arg_0 -> DatabaseScriptRunConfiguration.getTargetPairs$lambda$3((Function1)new Function1<DatabaseScriptRunConfigurationOptions.Target, Pair<LocalDataSource, ObjectPath>>(storage){
            final /* synthetic */ DataSourceStorage $storage;
            {
                this.$storage = $storage;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Pair<LocalDataSource, ObjectPath> invoke(DatabaseScriptRunConfigurationOptions.Target it2) {
                Pair pair;
                LocalDataSource localDataSource = this.$storage.getDataSourceById(it2.getDataSourceId());
                if (localDataSource != null) {
                    ObjectPath objectPath;
                    LocalDataSource ds = localDataSource;
                    boolean bl = false;
                    LocalDataSource localDataSource2 = ds;
                    String string = it2.getNamespace();
                    if (string != null) {
                        void n;
                        String string2 = string;
                        LocalDataSource localDataSource3 = localDataSource2;
                        boolean bl2 = false;
                        objectPath = ObjectPath.deserialize((String)n);
                        localDataSource2 = localDataSource3;
                    } else {
                        objectPath = null;
                    }
                    pair = Pair.create((Object)localDataSource2, objectPath);
                } else {
                    pair = null;
                }
                return pair;
            }
        }, arg_0)).toList();
        boolean bl = false;
        return !it2.contains(null) ? list : null;
    }

    private final JBIterable<VirtualFile> getVirtualFiles() {
        JBIterable jBIterable;
        DatabaseScriptRunConfigurationOptions options2 = this.getOptions();
        if (options2.getMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT) {
            String string = options2.getText();
            if (string == null) {
                return JBIterable.empty();
            }
            String statementText = string;
            DataSourceStorage projectStorage = DataSourceStorage.getProjectStorage(this.getProject());
            Object object = SequencesKt.first((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)options2.getTargets()), (Function1)((Function1)new Function1<DatabaseScriptRunConfigurationOptions.Target, LocalDataSource>(projectStorage){
                final /* synthetic */ DataSourceStorage $projectStorage;
                {
                    this.$projectStorage = $projectStorage;
                    super(1);
                }

                @Nullable
                public final LocalDataSource invoke(@NotNull DatabaseScriptRunConfigurationOptions.Target it2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
                    return this.$projectStorage.getDataSourceById(it2.getDataSourceId());
                }
            })));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            LocalDataSource dataSource2 = (LocalDataSource)object;
            LightVirtualFile virtualFile = new LightVirtualFile(this.getName(), (Language)DbSqlUtil.getSqlDialect(dataSource2), (CharSequence)statementText);
            return JBIterable.of((Object)virtualFile);
        }
        JBIterable it2 = jBIterable = JBIterable.from((Iterable)options2.getFiles()).map(arg_0 -> DatabaseScriptRunConfiguration.getVirtualFiles$lambda$5(getVirtualFiles.1.INSTANCE, arg_0)).collect();
        boolean bl = false;
        return !it2.contains(null) ? jBIterable : null;
    }

    public boolean isGeneratedName() {
        return Intrinsics.areEqual((Object)this.getName(), (Object)this.suggestedName());
    }

    @Nullable
    public String suggestedName() {
        String string;
        if (this.getOptions().getMode() != DatabaseScriptRunConfigurationOptions.Mode.FILE) {
            return null;
        }
        List<String> files2 = this.getOptions().getFiles();
        DatabaseScriptRunConfigurationOptions $this$suggestedName_u24lambda_u247 = (DatabaseScriptRunConfigurationOptions)((Object)this.getState());
        boolean bl = false;
        switch (files2.size()) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = PathUtil.getFileName((String)files2.get(0));
                break;
            }
            default: {
                Object[] objectArray = new Object[]{PathUtil.getFileName((String)files2.get(0)), files2.size() - 1};
                string = DatabaseBundle.message("sql.run.configuration.few.files.to.run.default.name", objectArray);
            }
        }
        return string;
    }

    private static final Pair getTargetPairs$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final VirtualFile getVirtualFiles$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VirtualFile)$tmp0.invoke(p0);
    }
}

