/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatementHighlightingPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final HighlightInfoType HIGH_PRIORITY_TYPE = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, DatabaseColors.CONSOLE_RANGE_TO_EXECUTE);
    private static final HighlightInfoType LOW_PRIORITY_TYPE = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, DatabaseColors.CONSOLE_RANGE_TO_EXECUTE);

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            StatementHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            StatementHighlightingPassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
    }

    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file, final @NotNull Editor editor2) {
        if (file == null) {
            StatementHighlightingPassFactory.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            StatementHighlightingPassFactory.$$$reportNull$$$0(3);
        }
        Project project = file.getProject();
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return null;
        }
        if (!(file instanceof SqlFile || file instanceof PsiPlainTextFile || ScriptModelUtilCore.isJSFile(file))) {
            return null;
        }
        if (editor2.isOneLineMode()) {
            return null;
        }
        final VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !FileEditorManager.getInstance((Project)project).isFileOpen(virtualFile)) {
            return null;
        }
        return new TextEditorHighlightingPass(project, editor2.getDocument(), false){
            private TextRange myStatementRange;

            public void doCollectInformation(@NotNull ProgressIndicator progress) {
                if (progress == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myStatementRange = null;
                DatabaseSettings.ExecOption execOption = DatabaseSettings.getDefaultExecOption();
                if (execOption.execInside == 6) {
                    return;
                }
                JdbcConsole console = JdbcConsoleProvider.getValidConsole(this.myProject, virtualFile);
                if (console == null) {
                    return;
                }
                PsiElement elementAt = JdbcConsoleProvider.elementAt(file, null, editor2);
                if (elementAt == null) {
                    return;
                }
                JdbcConsoleProvider.Info info2 = JdbcConsoleProvider.findScriptModel(file, elementAt, editor2, execOption);
                if (info2 == null) {
                    return;
                }
                JdbcConsoleProvider.chooseStatements(info2, null, false, model2 -> {
                    SqlFile sqlFile;
                    int start2 = -1;
                    int end = -1;
                    for (TextRange r : model2.statements().transform(ScriptModelUtilCore.TO_RANGE)) {
                        if (start2 < 0) {
                            start2 = r.getStartOffset();
                        }
                        end = r.getEndOffset();
                    }
                    if (start2 >= 0 && end >= 0) {
                        this.myStatementRange = TextRange.create((int)start2, (int)end);
                    }
                    if ((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)elementAt.getContainingFile(), SqlFile.class)) != null) {
                        this.myStatementRange = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost((PsiElement)sqlFile, this.myStatementRange);
                    }
                });
            }

            public void doApplyInformationToEditor() {
                List infos;
                Document document = editor2.getDocument();
                if (this.myStatementRange == null || this.myStatementRange.isEmpty()) {
                    infos = Collections.emptyList();
                } else {
                    TextAttributes rangeAttr = editor2.getColorsScheme().getAttributes(DatabaseColors.CONSOLE_RANGE_TO_EXECUTE);
                    Color bg = rangeAttr == null ? null : rangeAttr.getBackgroundColor();
                    infos = new ArrayList(3);
                    int start2 = this.myStatementRange.getStartOffset();
                    int end = this.myStatementRange.getEndOffset();
                    int firstLine = document.getLineNumber(start2);
                    int lastLine = document.getLineNumber(end);
                    infos.add(1.createInfo(firstLine == lastLine || bg == null ? HIGH_PRIORITY_TYPE : LOW_PRIORITY_TYPE, start2, end, null));
                    if (firstLine != lastLine && bg != null) {
                        infos.add(1.createInfo(HIGH_PRIORITY_TYPE, start2, document.getLineEndOffset(firstLine), bg));
                        infos.add(1.createInfo(HIGH_PRIORITY_TYPE, document.getLineStartOffset(lastLine), end, bg));
                    }
                }
                UpdateHighlightersUtil.setHighlightersToSingleEditor((Project)this.myProject, (Editor)editor2, (int)0, (int)file.getTextLength(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
            }

            @NotNull
            private static HighlightInfo createInfo(HighlightInfoType type, int start2, int end, @Nullable Color forcedBg) {
                HighlightInfo.Builder b2 = HighlightInfo.newHighlightInfo((HighlightInfoType)type).range(start2, end);
                if (forcedBg != null) {
                    HighlightInfo highlightInfo = b2.textAttributes(new TextAttributes(null, forcedBg, null, null, 0)).createUnconditionally();
                    if (highlightInfo == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return highlightInfo;
                }
                HighlightInfo highlightInfo = b2.createUnconditionally();
                if (highlightInfo == null) {
                    1.$$$reportNull$$$0(2);
                }
                return highlightInfo;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "progress";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/StatementHighlightingPassFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/StatementHighlightingPassFactory$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doCollectInformation";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/console/StatementHighlightingPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

