/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.IsolateClassPathOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.PassProxyOptionProvider;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.idea.AppMode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SingleRootClasspathElement;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class JdbcConsoleRunContext
implements ConsoleRunConfiguration.RunContext {
    private static final Logger LOG = Logger.getInstance(JdbcConsoleRunContext.class);
    private static final Collection<String> IGNORED_SUFFIXES = Arrays.asList(".txt", ".me", ".info", ".pom", ".xml");
    public static final String MAIN_CLASS = "com.intellij.database.remote.RemoteJdbcServer";
    private static final String ZONE_PROPERTY = "user.timezone";
    private static final String LIBRARY_PATH = "java.library.path";
    private final LocalDataSource myDataSource;

    JdbcConsoleRunContext(LocalDataSource dataSource2) {
        this.myDataSource = dataSource2;
    }

    public static void addUtilJars(@NotNull PathsList cp, boolean addGroovy) {
        if (cp == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(0);
        }
        cp.add(PathUtil.getJarPathForClass(StringUtilRt.class));
        cp.add(PathUtil.getJarPathForClass(Hash.Strategy.class));
        if (addGroovy) {
            JdbcConsoleRunContext.addClassJar(cp, JdbcConsoleRunContext.class, "groovy.lang.GroovyShell");
        }
    }

    public static void addJdbcConsoleJars(PathsList cp) {
        JdbcConsoleRunContext.addClassJar(cp, JdbcConsoleRunContext.class, MAIN_CLASS);
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFederatedProvider");
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.intellij.database.remote.jdbc.LobInfo");
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.intellij.desktop.DesktopActionsUtils");
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.jetbrains.JBR");
        JdbcConsoleRunContext.addJdbcHelpersJars(cp);
    }

    public static void addJdbcHelpersJars(PathsList cp) {
        for (DbmsExtension.Bean<JdbcHelper> b2 : DbImplUtilCore.JDBC_HELPER_EP.allExtensions()) {
            cp.add(PathUtil.getJarPathForClass(b2.getInstance().getClass()));
        }
    }

    public static void addClassJar(@NotNull PathsList cp, @NotNull Class<?> context, @NotNull String className) {
        String s2;
        if (cp == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(2);
        }
        if (className == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(3);
        }
        if ((s2 = PathManager.getResourceRoot(context, (String)("/" + className.replace('.', '/') + ".class"))) == null) {
            return;
        }
        cp.add(new File(s2).getAbsoluteFile().getAbsolutePath());
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    @Override
    public String getMainClassName() {
        return MAIN_CLASS;
    }

    @Override
    public void collectClassPath(PathsList cp) {
        JdbcConsoleRunContext.addUtilJars(cp, true);
        JdbcConsoleRunContext.addJdbcConsoleJars(cp);
        if (!this.shouldIsolateClassPath()) {
            JdbcConsoleRunContext.addIsolatedClassPath(cp, this.myDataSource);
        }
    }

    private static void addIsolatedClassPath(PathsList cp, LocalDataSource dataSource2) {
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.intellij.database.remote.jdbc.SqliteShim");
        JdbcConsoleRunContext.addJdbcDrivers(cp, dataSource2);
    }

    public static void addJdbcDrivers(PathsList cp, LocalDataSource dataSource2) {
        boolean sensitive = StandardFileSystems.local().isCaseSensitive();
        for (String url : JdbcConsoleRunContext.expandPackUrls(dataSource2.getClasspathElements())) {
            String path = PathUtil.toPresentableUrl((String)url);
            if (JdbcConsoleRunContext.isIgnored(sensitive, path)) continue;
            cp.add(path);
        }
    }

    private static boolean isIgnored(boolean sensitive, String path) {
        for (String suffix2 : IGNORED_SUFFIXES) {
            if (!(sensitive ? path.endsWith(suffix2) : StringUtil.endsWithIgnoreCase((String)path, (String)suffix2))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Sdk getSdk() {
        DatabaseDriver driver2 = this.myDataSource.getDatabaseDriver();
        String path = driver2 == null ? null : ((DatabaseDriverImpl)driver2).getJrePath();
        return path == null ? null : new SimpleJavaSdkType().createJdk("tmp-custom", path);
    }

    @Override
    public void tuneParams(@NotNull Project project, @NotNull SimpleJavaParameters params2) throws ExecutionException {
        String driverClass;
        if (project == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(4);
        }
        if (params2 == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(driverClass = this.myDataSource.getDriverClass()))) {
            throw new ExecutionException(DatabaseBundle.message("dialog.message.no.driver.class.for", this.myDataSource.getName()));
        }
        ParametersList vmParams = params2.getVMParametersList();
        if (!vmParams.hasProperty(ZONE_PROPERTY)) {
            vmParams.addProperty(ZONE_PROPERTY, "UTC");
        }
        Bitness bitness = this.detectBitness(params2);
        List<File> nativePaths = this.getNativeLibrariesPaths(bitness);
        this.setNativePaths(params2, nativePaths);
        JdbcConsoleRunContext.setDefaultMemoryOption(vmParams, "-Xmx");
        JdbcConsoleRunContext.setDefaultMemoryOption(vmParams, "-Xms");
        if (JdbcConsoleRunContext.shouldRunHeadless()) {
            vmParams.addProperty("java.awt.headless", "true");
        }
        if (this.shouldPassProxySettings()) {
            JdbcConsoleRunContext.passProxySettings(vmParams);
        }
        if (this.shouldIsolateClassPath()) {
            PathsList cp = new PathsList();
            JdbcConsoleRunContext.addIsolatedClassPath(cp, this.myDataSource);
            if (!cp.isEmpty()) {
                vmParams.addProperty("jdbc.classpath", cp.getPathsString());
            }
        }
        JdbcConsoleRunContext.addIllegalAccessOptions(vmParams);
        params2.getProgramParametersList().add(driverClass);
        String dir = this.myDataSource.getWorkingDir();
        if ("".equals(dir)) {
            String string = dir = this.myDataSource.isGlobal() ? null : project.getBasePath();
        }
        if (dir != null) {
            params2.setWorkingDirectory(JdbcConsoleRunContext.expand(project, dir));
        }
        for (ConsoleRunContextParametersTuner parametersTuner : (ConsoleRunContextParametersTuner[])PARAMETERS_TUNERS.getExtensions()) {
            parametersTuner.tuneParams(project, this.myDataSource, params2);
        }
    }

    public static void passJnaPath(ParametersList vmParams) {
        String jnaBootLibraryPath = System.getProperty("jna.boot.library.path");
        if (jnaBootLibraryPath != null) {
            vmParams.addProperty("jna.boot.library.path", jnaBootLibraryPath);
            vmParams.addProperty("jna.nosys", "true");
            vmParams.addProperty("jna.noclasspath", "true");
        }
    }

    public static boolean shouldPassJnaPath(@NotNull LocalDataSource dataSource2) {
        String options2;
        if (dataSource2 == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(6);
        }
        return (options2 = dataSource2.getVmOptions()) == null || !options2.contains("-Djna.boot.library.path") && !options2.contains("-Djna.nosys") && !options2.contains("-Djna.noclasspath");
    }

    private boolean shouldPassProxySettings() {
        return Boolean.TRUE.equals(DbOptionProvider.getOptionValue(this.myDataSource, PassProxyOptionProvider.class));
    }

    private boolean shouldIsolateClassPath() {
        return !RemoteObject.IN_PROCESS && Boolean.TRUE.equals(DbOptionProvider.getOptionValue(this.myDataSource, IsolateClassPathOptionProvider.class));
    }

    private static void passProxySettings(ParametersList vmParams) {
        List<String> nonProxy = List.of("localhost", "127.0.0.1");
        for (Pair<String, String> opt : DatabaseCoreUiService.getInstance().getProxyOptions(nonProxy)) {
            vmParams.addProperty((String)opt.first, (String)opt.second);
        }
    }

    private static boolean shouldRunHeadless() {
        return AppMode.isHeadless() || AppMode.isRemoteDevHost();
    }

    private static void addIllegalAccessOptions(@NotNull ParametersList params2) {
        ParamsGroup group2;
        if (params2 == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(7);
        }
        if ((group2 = params2.getParamsGroup("exports")) != null) {
            group2.addParameter("--add-opens=jdk.unsupported/sun.misc=ALL-UNNAMED");
            group2.addParameter("--add-opens=java.base/java.nio=ALL-UNNAMED");
            group2.addParameter("--add-opens=java.base/java.util=ALL-UNNAMED");
        }
    }

    public static String expand(@NotNull Project project, String dir) {
        String expanded;
        if (project == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(8);
        }
        if (dir == null) {
            return null;
        }
        DataContext context = SimpleDataContext.getProjectContext((Project)project);
        try {
            expanded = MacroManager.getInstance().expandSilentMacros(dir, true, context);
        }
        catch (Macro.ExecutionCancelledException e2) {
            expanded = dir;
        }
        return (String)ObjectUtils.notNull((Object)expanded, (Object)dir);
    }

    private static void setDefaultMemoryOption(ParametersList vmParams, String option) {
        String value2 = (String)ContainerUtil.find((Iterable)vmParams.getParameters(), p2 -> p2.startsWith(option));
        if (value2 != null) {
            return;
        }
        String current = (String)ContainerUtil.find(ManagementFactory.getRuntimeMXBean().getInputArguments(), p2 -> p2.startsWith(option));
        if (current == null) {
            return;
        }
        vmParams.add(current);
    }

    public void setNativePaths(@NotNull SimpleJavaParameters params2, List<File> nativePaths) {
        String ldPath;
        if (params2 == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(9);
        }
        if (nativePaths.isEmpty()) {
            return;
        }
        ParametersList vmParams = params2.getVMParametersList();
        String existing = StringUtil.nullize((String)vmParams.getPropertyValue(LIBRARY_PATH));
        String path = StringUtil.join((Iterable)JBIterable.from(nativePaths).map(File::getAbsolutePath), (String)File.pathSeparator);
        vmParams.addProperty(LIBRARY_PATH, (String)(existing == null ? path : existing + File.pathSeparator + path));
        String string = SystemInfo.isMac ? "DYLD_FALLBACK_LIBRARY_PATH" : (SystemInfo.isUnix ? "LD_LIBRARY_PATH" : (ldPath = SystemInfo.isWindows ? "PATH" : null));
        if (ldPath != null) {
            String prev = StringUtil.nullize((String)((String)params2.getEnv().get(path)));
            if (prev == null) {
                prev = StringUtil.nullize((String)((String)EnvironmentUtil.getEnvironmentMap().get(ldPath)));
            }
            String newPath = prev == null ? path : prev + File.pathSeparator + path;
            LOG.info("Extending " + ldPath + " " + prev + "\nto " + newPath);
            params2.addEnv(ldPath, newPath);
        }
    }

    @NotNull
    private List<File> getNativeLibrariesPaths(Bitness bitness) {
        DatabaseDriver driver2 = this.myDataSource.getDatabaseDriver();
        if (driver2 == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                JdbcConsoleRunContext.$$$reportNull$$$0(10);
            }
            return list;
        }
        DatabaseArtifactList.Item.Arch arch = switch (bitness) {
            default -> throw new IncompatibleClassChangeError();
            case Bitness.x32 -> DatabaseArtifactList.Item.Arch.X86;
            case Bitness.x64 -> DatabaseArtifactList.Item.Arch.X86_64;
        };
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        List<SimpleClasspathElement> libPaths = driver2.getNativeLibraryPaths();
        ArrayList<File> result2 = new ArrayList<File>();
        for (SimpleClasspathElement element2 : libPaths) {
            for (String url : element2.getClassesRootUrls()) {
                File file = new File(StringUtil.trimStart((String)url, (String)"file://"));
                if (StringUtil.endsWithIgnoreCase((String)url, (String)".jar") || JdbcConsoleRunContext.isZip(url)) {
                    ContainerUtil.addIfNotNull(result2, (Object)loader.getNativeLibrary(file, null, arch));
                    continue;
                }
                result2.add(file.isFile() ? file.getParentFile() : file);
            }
        }
        DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
        for (DatabaseDriver.ArtifactRef artifact : driver2.getArtifacts()) {
            DatabaseArtifactList.ArtifactVersion version;
            if (artifact.getArtifactVersion() == null || (version = artifacts.resolveVersion(artifact.getId(), artifact.getArtifactVersion())) == null) continue;
            List<File> fromArtifacts = loader.getNativeLibraries(version, arch);
            result2.addAll(fromArtifacts);
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static boolean isZip(String url) {
        return StringUtil.endsWithIgnoreCase((String)url, (String)".zip");
    }

    @NotNull
    protected Bitness detectBitness(@NotNull SimpleJavaParameters params2) {
        JdkVersionDetector.JdkVersionInfo info2;
        String homePath;
        Sdk jdk;
        if (params2 == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(12);
        }
        if ((jdk = params2.getJdk()) != null && (homePath = jdk.getHomePath()) != null && (info2 = JdkVersionDetector.getInstance().detectJdkVersionInfo(homePath)) != null && info2.arch.width == 32) {
            Bitness bitness = Bitness.x32;
            if (bitness == null) {
                JdbcConsoleRunContext.$$$reportNull$$$0(13);
            }
            return bitness;
        }
        Bitness bitness = Bitness.x64;
        if (bitness == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(14);
        }
        return bitness;
    }

    @NotNull
    public static JBIterable<SimpleClasspathElement> expandPacks(@NotNull List<SimpleClasspathElement> items2) {
        if (items2 == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(15);
        }
        JBIterable jBIterable = JdbcConsoleRunContext.expandPackUrls(items2).map(SingleRootClasspathElement::new);
        if (jBIterable == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<String> expandPackUrls(@NotNull List<SimpleClasspathElement> items2) {
        if (items2 == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(17);
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        JBIterable jBIterable = JBIterable.from(items2).flatten(item -> {
            List urls = item.getClassesRootUrls();
            if (ContainerUtil.find((Iterable)urls, u -> JdbcConsoleRunContext.isZip(u)) == null) {
                return item.getClassesRootUrls();
            }
            ArrayList<Object> unzipped = new ArrayList<Object>();
            for (String url : urls) {
                if (!JdbcConsoleRunContext.isZip(url)) {
                    unzipped.add(url);
                    continue;
                }
                File dir = loader.unpackZipIfNeeded(new File(StringUtil.trimStart((String)url, (String)"file://")));
                for (File file : ((JBTreeTraverser)FileUtil.fileTraverser((File)dir).filter(File::isFile)).traverse()) {
                    unzipped.add("file://" + file.getAbsolutePath());
                }
            }
            return unzipped;
        });
        if (jBIterable == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 13, 14, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsoleRunContext";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsoleRunContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeLibrariesPaths";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "detectBitness";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPacks";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPackUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addUtilJars";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addClassJar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tuneParams";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldPassJnaPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addIllegalAccessOptions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setNativePaths";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "detectBitness";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "expandPacks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "expandPackUrls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 13, 14, 16, 18 -> new IllegalStateException(string);
        };
    }
}

