/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.SessionProgressListener;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineProgressHelper {
    private final JdbcConsole myConsole;
    private final StatusRepaintListener myListener;

    InlineProgressHelper(@NotNull JdbcConsole console) {
        if (console == null) {
            InlineProgressHelper.$$$reportNull$$$0(0);
        }
        this.myConsole = console;
        this.myListener = new StatusRepaintListener(console);
        this.myConsole.getMessageBus().addAuditor(new InlineProgressAuditor(console));
        Disposer.register((Disposable)console, (Disposable)this.myListener);
        MessageBusConnection connect2 = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myListener);
        connect2.subscribe(DatabaseSession.getTopic(), (Object)this.myListener);
    }

    public void applyState(@NotNull Editor editor2) {
        if (editor2 == null) {
            InlineProgressHelper.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DatabaseSession session2 = this.myConsole.getSession();
        DatabaseSession.State state = session2.getState();
        if (state.isIdle() || !EditorUtil.isRealFileEditor((Editor)editor2)) {
            return;
        }
        List<DatabaseSession.State.Work> work = state.getWork();
        for (DatabaseSession.State.Work w : work) {
            if (w.getRequest().getOwner() != this.myConsole) continue;
            this.addProgress(editor2, w.getRequest(), w.getState() != DatabaseSession.State.WorkState.FINISHED);
        }
    }

    public void addProgress(@NotNull DataRequest.CoupledWithEditor coupled) {
        if (coupled == null) {
            InlineProgressHelper.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Editor editor2 = coupled.getEditor();
        if (editor2 != null) {
            this.addProgress(editor2, coupled.getRequest(), true);
        }
    }

    private void addProgress(@NotNull Editor editor2, @NotNull GridDataRequest request, boolean active) {
        if (editor2 == null) {
            InlineProgressHelper.$$$reportNull$$$0(3);
        }
        if (request == null) {
            InlineProgressHelper.$$$reportNull$$$0(4);
        }
        if (editor2.isDisposed()) {
            return;
        }
        DatabaseSession session2 = this.myConsole.getSession();
        Inlay<RequestStatusInlineRenderer> inlay = active ? this.addTimeSpent(editor2, this.myConsole.getSession(), request) : null;
        RangeHighlighter highlighter = this.addGutterProgress(editor2, session2, request, inlay, active);
        this.myListener.offerHighlighter(highlighter, active);
        if (inlay != null) {
            this.myListener.offerInlay(inlay);
        }
    }

    @Nullable
    private Inlay<RequestStatusInlineRenderer> addTimeSpent(@NotNull Editor editor2, @NotNull DatabaseSession session2, @NotNull GridDataRequest request) {
        DataRequest.CoupledWithEditor coupled;
        TextRange range;
        if (editor2 == null) {
            InlineProgressHelper.$$$reportNull$$$0(5);
        }
        if (session2 == null) {
            InlineProgressHelper.$$$reportNull$$$0(6);
        }
        if (request == null) {
            InlineProgressHelper.$$$reportNull$$$0(7);
        }
        TextRange textRange = range = (coupled = (DataRequest.CoupledWithEditor)ObjectUtils.tryCast((Object)request, DataRequest.CoupledWithEditor.class)) == null ? null : coupled.getRange();
        if (range == null) {
            return null;
        }
        if (!EditorUtil.isRealFileEditor((Editor)editor2) || this.myListener.mergeInlays(editor2, coupled)) {
            return null;
        }
        int offset = range.getStartOffset();
        RequestStatusInlineRenderer renderer2 = new RequestStatusInlineRenderer(coupled, session2, editor2);
        Inlay inlay = editor2.getInlayModel().addAfterLineEndElement(offset, true, (EditorCustomElementRenderer)renderer2);
        if (inlay != null) {
            EditorUtil.disposeWithEditor((Editor)editor2, (Disposable)inlay);
            Disposer.register((Disposable)inlay, () -> this.myListener.remove((Inlay<RequestStatusInlineRenderer>)inlay));
        }
        return inlay;
    }

    @Nullable
    private RangeHighlighter addGutterProgress(@NotNull Editor editor2, @NotNull DatabaseSession session2, @NotNull GridDataRequest request, final @Nullable Inlay<RequestStatusInlineRenderer> inlay, boolean active) {
        DataRequest.CoupledWithEditor coupled;
        TextRange range;
        if (editor2 == null) {
            InlineProgressHelper.$$$reportNull$$$0(8);
        }
        if (session2 == null) {
            InlineProgressHelper.$$$reportNull$$$0(9);
        }
        if (request == null) {
            InlineProgressHelper.$$$reportNull$$$0(10);
        }
        TextRange textRange = range = (coupled = (DataRequest.CoupledWithEditor)ObjectUtils.tryCast((Object)request, DataRequest.CoupledWithEditor.class)) == null ? null : coupled.getRange();
        if (range == null) {
            return null;
        }
        int s2 = range.getStartOffset();
        int e2 = range.getEndOffset();
        if (this.myListener.mergeHighlighters(editor2, coupled, active)) {
            return null;
        }
        MarkupModel mModel = editor2.getMarkupModel();
        final RangeHighlighter highlighter = mModel.addRangeHighlighter(null, s2, e2, 1000, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setGutterIconRenderer((GutterIconRenderer)new RequestStatusGutterRenderer(editor2, coupled, session2));
        EditorUtil.disposeWithEditor((Editor)editor2, () -> this.myListener.remove(highlighter));
        if (inlay != null && mModel instanceof MarkupModelEx) {
            ((MarkupModelEx)mModel).addMarkupModelListener(inlay, new MarkupModelListener(){

                public void afterRemoved(@NotNull RangeHighlighterEx removed) {
                    if (removed == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (removed == highlighter) {
                        Disposer.dispose((Disposable)inlay);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removed", "com/intellij/database/console/InlineProgressHelper$1", "afterRemoved"));
                }
            });
        }
        return highlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coupled";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/console/InlineProgressHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyState";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addProgress";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addTimeSpent";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addGutterProgress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StatusRepaintListener
    extends SessionProgressListener
    implements Disposable {
        private final Timer myTimer;
        private final List<RangeHighlighter> myPendingHighlighters;
        private final List<RangeHighlighter> myLastHighlighters;
        private final List<Inlay<RequestStatusInlineRenderer>> myInlays;
        private final JdbcConsole myConsole;
        private Disposable myMarkersParent;
        private long myLastChainStart;
        private boolean myDisposed;

        StatusRepaintListener(@NotNull JdbcConsole console) {
            if (console == null) {
                StatusRepaintListener.$$$reportNull$$$0(0);
            }
            this.myTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    this.requestRepaint(this.getSession());
                }
            });
            this.myConsole = console;
            this.myPendingHighlighters = new ArrayList<RangeHighlighter>();
            this.myLastHighlighters = new ArrayList<RangeHighlighter>();
            this.myInlays = new ArrayList<Inlay<RequestStatusInlineRenderer>>();
            this.clearHighlighters();
        }

        @Override
        public void updateProgress(@NotNull DatabaseSessionStateListener.ChangeEvent event) {
            if (event == null) {
                StatusRepaintListener.$$$reportNull$$$0(1);
            }
            if (this.myDisposed) {
                return;
            }
            DatabaseSession session2 = this.getSession();
            if (event.getSession() != session2) {
                return;
            }
            DatabaseSession.State state = event.getSession().getState();
            this.updateInlays();
            if (state.isIdle()) {
                if (state.isFinalized()) {
                    this.myTimer.stop();
                }
                this.requestRepaint(session2);
                return;
            }
            long startTime = state.getStartTime();
            if (startTime != 0L && startTime != this.myLastChainStart) {
                this.myLastChainStart = startTime;
                this.clearHighlighters();
                this.myTimer.start();
            }
        }

        void offerHighlighter(@Nullable RangeHighlighter highlighter, boolean active) {
            if (highlighter != null) {
                this.getHighlighters(active).add(highlighter);
            }
        }

        void offerInlay(@Nullable Inlay<RequestStatusInlineRenderer> info2) {
            if (info2 != null) {
                this.myInlays.add(info2);
            }
        }

        @NotNull
        private DatabaseSession getSession() {
            DatabaseSession databaseSession = this.myConsole.getSession();
            if (databaseSession == null) {
                StatusRepaintListener.$$$reportNull$$$0(2);
            }
            return databaseSession;
        }

        private void updateInlays() {
            DatabaseSession.State state = this.getSession().getState();
            for (int i2 = this.myInlays.size() - 1; i2 > -1; --i2) {
                Inlay<RequestStatusInlineRenderer> inlay = this.myInlays.get(i2);
                DatabaseSession.State.Work work = ((RequestStatusInlineRenderer)inlay.getRenderer()).myRequests.getMostRecentWork(state);
                if (work != null && work.getState() != DatabaseSession.State.WorkState.FINISHED) continue;
                Disposer.dispose(inlay);
                this.myInlays.remove(inlay);
            }
        }

        private void repaintInlays() {
            for (Inlay<RequestStatusInlineRenderer> inlay : this.myInlays) {
                inlay.update();
            }
        }

        private void clearHighlighters() {
            if (this.myMarkersParent != null) {
                Disposer.dispose((Disposable)this.myMarkersParent);
            }
            this.myMarkersParent = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)this.myMarkersParent);
            if (this.myPendingHighlighters.isEmpty() && this.myInlays.isEmpty()) {
                return;
            }
            this.myLastHighlighters.clear();
            this.myLastHighlighters.addAll(this.myPendingHighlighters);
            this.myPendingHighlighters.clear();
            Disposer.register((Disposable)this.myMarkersParent, () -> StatusRepaintListener.disposeHighlighters(this.myLastHighlighters));
        }

        public void dispose() {
            this.myDisposed = true;
            this.myTimer.stop();
            for (int i2 = this.myInlays.size() - 1; i2 > -1; --i2) {
                Disposer.dispose((Disposable)((Disposable)this.myInlays.get(i2)));
            }
            this.myInlays.clear();
            StatusRepaintListener.disposeHighlighters(this.myLastHighlighters);
            StatusRepaintListener.disposeHighlighters(this.myPendingHighlighters);
        }

        boolean mergeHighlighters(@NotNull Editor editor2, @NotNull DataRequest.CoupledWithEditor coupled, boolean active) {
            if (editor2 == null) {
                StatusRepaintListener.$$$reportNull$$$0(3);
            }
            if (coupled == null) {
                StatusRepaintListener.$$$reportNull$$$0(4);
            }
            for (RangeHighlighter highlighter : this.getHighlighters(active)) {
                RequestStatusGutterRenderer renderer2 = (RequestStatusGutterRenderer)highlighter.getGutterIconRenderer();
                if (renderer2 == null || renderer2.getEditor() != editor2 || !renderer2.myRequests.hasSame(coupled)) continue;
                renderer2.myRequests.add(coupled);
                return true;
            }
            return false;
        }

        boolean mergeInlays(@NotNull Editor editor2, @NotNull DataRequest.CoupledWithEditor coupled) {
            if (editor2 == null) {
                StatusRepaintListener.$$$reportNull$$$0(5);
            }
            if (coupled == null) {
                StatusRepaintListener.$$$reportNull$$$0(6);
            }
            for (Inlay<RequestStatusInlineRenderer> inlay : this.myInlays) {
                if (inlay.getEditor() != editor2) continue;
                RequestStatusInlineRenderer renderer2 = (RequestStatusInlineRenderer)inlay.getRenderer();
                if (!renderer2.myRequests.hasSame(coupled)) continue;
                renderer2.myRequests.add(coupled);
                return true;
            }
            return false;
        }

        void remove(@NotNull Inlay<RequestStatusInlineRenderer> inlay) {
            if (inlay == null) {
                StatusRepaintListener.$$$reportNull$$$0(7);
            }
            this.myInlays.remove(inlay);
        }

        void remove(@NotNull RangeHighlighter highlighter) {
            if (highlighter == null) {
                StatusRepaintListener.$$$reportNull$$$0(8);
            }
            this.myPendingHighlighters.remove(highlighter);
            this.myLastHighlighters.remove(highlighter);
        }

        private static void disposeHighlighters(List<RangeHighlighter> highlighters) {
            for (RangeHighlighter highlighter : highlighters) {
                highlighter.dispose();
            }
        }

        @NotNull
        private List<RangeHighlighter> getHighlighters(boolean active) {
            List<RangeHighlighter> list = !active || this.myTimer.isRunning() ? this.myLastHighlighters : this.myPendingHighlighters;
            if (list == null) {
                StatusRepaintListener.$$$reportNull$$$0(9);
            }
            return list;
        }

        private void requestRepaint(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                StatusRepaintListener.$$$reportNull$$$0(10);
            }
            this.repaintInlays();
            List<DatabaseSession.State.Work> work = session2.getState().getWork();
            for (DatabaseSession.State.Work w : work) {
                StatusRepaintListener.repaintLine(w);
            }
        }

        private static void repaintLine(@NotNull DatabaseSession.State.Work w) {
            Editor editor2;
            DataRequest.CoupledWithEditor coupled;
            if (w == null) {
                StatusRepaintListener.$$$reportNull$$$0(11);
            }
            TextRange range = (coupled = (DataRequest.CoupledWithEditor)ObjectUtils.tryCast((Object)((Object)w.getRequest()), DataRequest.CoupledWithEditor.class)) == null ? null : coupled.getRange();
            Editor editor3 = editor2 = coupled == null ? null : coupled.getEditor();
            if (range == null || editor2 == null || editor2.isDisposed()) {
                return;
            }
            int start2 = range.getStartOffset();
            int line = editor2.offsetToVisualPosition((int)start2).line;
            int y = editor2.visualLineToY(line);
            editor2.getContentComponent().repaint(new Rectangle(0, y, editor2.getContentComponent().getWidth(), editor2.getLineHeight()));
            EditorGutterComponentEx gutter = ((EditorEx)editor2).getGutterComponentEx();
            gutter.repaint(new Rectangle(0, y, gutter.getWidth(), editor2.getLineHeight()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/InlineProgressHelper$StatusRepaintListener";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coupled";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "w";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/InlineProgressHelper$StatusRepaintListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlighters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProgress";
                    break;
                }
                case 2: 
                case 9: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeHighlighters";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeInlays";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "requestRepaint";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "repaintLine";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static class InlineProgressAuditor
    implements DataAuditor {
        private final JdbcConsole myConsole;

        InlineProgressAuditor(@NotNull JdbcConsole console) {
            if (console == null) {
                InlineProgressAuditor.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                InlineProgressAuditor.$$$reportNull$$$0(1);
            }
            if (producer == null) {
                InlineProgressAuditor.$$$reportNull$$$0(2);
            }
            if (!(request instanceof DataRequest.CoupledWithEditor)) {
                return;
            }
            DbUIUtil.invokeLaterIfNeeded(() -> this.myConsole.getProgressHelper().addProgress((DataRequest.CoupledWithEditor)((Object)request)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/InlineProgressHelper$InlineProgressAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobSubmitted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RequestStatusInlineRenderer
    implements EditorCustomElementRenderer {
        private final RequestContainer myRequests;
        private final DatabaseSession mySession;
        private final Editor myEditor;

        RequestStatusInlineRenderer(@NotNull DataRequest.CoupledWithEditor request, @NotNull DatabaseSession session2, @NotNull Editor editor2) {
            if (request == null) {
                RequestStatusInlineRenderer.$$$reportNull$$$0(0);
            }
            if (session2 == null) {
                RequestStatusInlineRenderer.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                RequestStatusInlineRenderer.$$$reportNull$$$0(2);
            }
            this.myRequests = new RequestContainer();
            this.myRequests.add(request);
            this.mySession = session2;
            this.myEditor = editor2;
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g2, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            String timeSpent;
            if (inlay == null) {
                RequestStatusInlineRenderer.$$$reportNull$$$0(3);
            }
            if (g2 == null) {
                RequestStatusInlineRenderer.$$$reportNull$$$0(4);
            }
            if (targetRegion == null) {
                RequestStatusInlineRenderer.$$$reportNull$$$0(5);
            }
            if (textAttributes == null) {
                RequestStatusInlineRenderer.$$$reportNull$$$0(6);
            }
            if ((timeSpent = this.getTimeSpent()) == null) {
                return;
            }
            Editor editor2 = inlay.getEditor();
            SelectionModel sModel = editor2.getSelectionModel();
            int start2 = sModel.getSelectionStart();
            int end = sModel.getSelectionEnd();
            int offset = inlay.getOffset();
            int selectionStartLine = editor2.offsetToVisualPosition((int)start2).line;
            int selectionEndLine = editor2.offsetToVisualPosition((int)end).line;
            int inlayLine = editor2.offsetToVisualPosition((int)offset).line;
            TextAttributes attributes2 = editor2.getColorsScheme().getAttributes(inlayLine >= selectionStartLine && inlayLine < selectionEndLine ? DebuggerColors.INLINED_VALUES_EXECUTION_LINE : DebuggerColors.INLINED_VALUES);
            TextAttributes resultAttributes = attributes2 == null ? textAttributes : attributes2;
            HintRenderer.paintHint((Graphics)g2, (EditorImpl)((EditorImpl)this.myEditor), (Rectangle)targetRegion, (String)timeSpent, (TextAttributes)resultAttributes, (TextAttributes)resultAttributes, null);
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                RequestStatusInlineRenderer.$$$reportNull$$$0(7);
            }
            return Math.max(HintRenderer.calcWidthInPixels((Editor)this.myEditor, (String)this.getTimeSpent(), null), 1);
        }

        public int calcHeightInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                RequestStatusInlineRenderer.$$$reportNull$$$0(8);
            }
            return this.myEditor.getLineHeight();
        }

        @Nullable
        private String getTimeSpent() {
            DatabaseSession.State.Work work = this.myRequests.getMostRecentWork(this.mySession.getState());
            return work == null ? null : SessionsUtil.getTimeSpent(work, this.mySession);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRegion";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/InlineProgressHelper$RequestStatusInlineRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcHeightInPixels";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RequestStatusGutterRenderer
    extends GutterIconRenderer {
        private final RequestContainer myRequests;
        private final DatabaseSession mySession;
        private final NavigateToErrorAction myAction;
        private final Editor myEditor;

        RequestStatusGutterRenderer(@NotNull Editor editor2, @NotNull DataRequest.CoupledWithEditor request, @NotNull DatabaseSession session2) {
            if (editor2 == null) {
                RequestStatusGutterRenderer.$$$reportNull$$$0(0);
            }
            if (request == null) {
                RequestStatusGutterRenderer.$$$reportNull$$$0(1);
            }
            if (session2 == null) {
                RequestStatusGutterRenderer.$$$reportNull$$$0(2);
            }
            this.myEditor = editor2;
            this.myRequests = new RequestContainer();
            this.myRequests.add(request);
            this.mySession = session2;
            this.myAction = new NavigateToErrorAction();
        }

        @NotNull
        public Icon getIcon() {
            DatabaseSession.State.Work work = this.myRequests.getMostRecentWork(this.mySession.getState());
            Icon progressIcon = work == null ? null : SessionsUtil.getProgressIcon(work, this.mySession, true);
            Icon icon = progressIcon == null ? RequestStatusGutterRenderer.getStatusIcon(work) : progressIcon;
            if (icon == null) {
                RequestStatusGutterRenderer.$$$reportNull$$$0(3);
            }
            return icon;
        }

        @Nullable
        public AnAction getClickAction() {
            return this.myAction;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.RIGHT;
            if (alignment == null) {
                RequestStatusGutterRenderer.$$$reportNull$$$0(4);
            }
            return alignment;
        }

        @Nullable
        public String getTooltipText() {
            DatabaseSession.State.Work work = this.getWork();
            if (work == null) {
                return null;
            }
            DatabaseSession.State.WorkStatus status = work.getStatus();
            return status.getType() == DatabaseSession.State.WorkStatusType.SUCCESS ? SessionsUtil.getTimeSpent(work, this.mySession) : status.getDescription();
        }

        public boolean isNavigateAction() {
            return this.myAction.isEnabled();
        }

        @Nullable
        private DatabaseSession.State.Work getWork() {
            return this.myRequests.getMostRecentWork(this.mySession.getState());
        }

        public boolean equals(Object obj2) {
            return this == obj2;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @NotNull
        public Editor getEditor() {
            Editor editor2 = this.myEditor;
            if (editor2 == null) {
                RequestStatusGutterRenderer.$$$reportNull$$$0(5);
            }
            return editor2;
        }

        @NotNull
        private static Icon getStatusIcon(@Nullable DatabaseSession.State.Work work) {
            DatabaseSession.State.WorkStatus status;
            if (work != null && work.getState() == DatabaseSession.State.WorkState.FINISHED && (status = work.getStatus()).getType().getIcon() != null) {
                Icon icon = status.getType().getIcon();
                if (icon == null) {
                    RequestStatusGutterRenderer.$$$reportNull$$$0(6);
                }
                return icon;
            }
            Icon icon = EmptyIcon.ICON_0;
            if (icon == null) {
                RequestStatusGutterRenderer.$$$reportNull$$$0(7);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/InlineProgressHelper$RequestStatusGutterRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/InlineProgressHelper$RequestStatusGutterRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatusIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }

        private class NavigateToErrorAction
        extends AnAction {
            private NavigateToErrorAction() {
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    NavigateToErrorAction.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    NavigateToErrorAction.$$$reportNull$$$0(1);
                }
                e2.getPresentation().setEnabledAndVisible(this.isEnabled());
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                DataRequest.CoupledWithEditor.ErrorNavigator navigator;
                if (e2 == null) {
                    NavigateToErrorAction.$$$reportNull$$$0(2);
                }
                if ((navigator = this.getNavigator()) != null) {
                    navigator.navigate();
                }
            }

            private boolean isEnabled() {
                DataRequest.CoupledWithEditor.ErrorNavigator navigator = this.getNavigator();
                return navigator != null && navigator.canNavigate();
            }

            @Nullable
            private DataRequest.CoupledWithEditor.ErrorNavigator getNavigator() {
                DatabaseSession.State.Work work = RequestStatusGutterRenderer.this.getWork();
                return work == null ? null : work.getStatus().getErrorNavigator();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/InlineProgressHelper$RequestStatusGutterRenderer$NavigateToErrorAction";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/InlineProgressHelper$RequestStatusGutterRenderer$NavigateToErrorAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }
    }

    private static class RequestContainer {
        private final List<DataRequest.CoupledWithEditor> myRequests = new ArrayList<DataRequest.CoupledWithEditor>();

        RequestContainer() {
        }

        void add(@NotNull DataRequest.CoupledWithEditor request) {
            if (request == null) {
                RequestContainer.$$$reportNull$$$0(0);
            }
            this.myRequests.add(request);
        }

        boolean hasSame(@NotNull DataRequest.CoupledWithEditor coupled) {
            TextRange range;
            if (coupled == null) {
                RequestContainer.$$$reportNull$$$0(1);
            }
            if ((range = coupled.getRange()) == null) {
                return false;
            }
            for (DataRequest.CoupledWithEditor request : this.myRequests) {
                TextRange r = request.getRange();
                if (r == null || !r.equals((Object)range)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        DatabaseSession.State.Work getMostRecentWork(@NotNull DatabaseSession.State state) {
            if (state == null) {
                RequestContainer.$$$reportNull$$$0(2);
            }
            return state.getMostRecentWork(ContainerUtil.map(this.myRequests, r -> r.getRequest()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coupled";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/InlineProgressHelper$RequestContainer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasSame";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getMostRecentWork";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

