/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.database.DataBus;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.connection.throwable.info.WarningInfo;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.Arrays;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEngine
extends DataRequest.Visitor
implements DataProducer,
Disposable {
    protected static final Logger LOG = Logger.getInstance(AbstractEngine.class);
    private final ThreadPoolExecutor myExecutorService;
    private final Project myProject;
    private final DataBus.Producing myMessageBus;
    private final EngineDataAuditor myDataAuditor;
    private final DataConsumer myDataConsumer;
    private final AtomicReference<DataRequest.Context> myRequestContext;
    private final AtomicReference<ProgressIndicator> myProgressIndicator;
    private final AtomicBoolean myCancelled;

    protected AbstractEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus) {
        if (project == null) {
            AbstractEngine.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            AbstractEngine.$$$reportNull$$$0(1);
        }
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)StringUtil.getShortName((String)this.getClass().getName()));
        this.myRequestContext = new AtomicReference();
        this.myProgressIndicator = new AtomicReference();
        this.myCancelled = new AtomicBoolean(false);
        this.myProject = project;
        this.myMessageBus = messageBus;
        Disposer.register((Disposable)project, (Disposable)this);
        this.myDataAuditor = this.wrapDataAuditor(messageBus.getDataAuditor());
        this.myDataConsumer = messageBus.getDataConsumer();
        messageBus.addProducer(this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractEngine.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    protected EngineDataAuditor getDataAuditor() {
        EngineDataAuditor engineDataAuditor = this.myDataAuditor;
        if (engineDataAuditor == null) {
            AbstractEngine.$$$reportNull$$$0(3);
        }
        return engineDataAuditor;
    }

    @NotNull
    protected DataConsumer getDataConsumer() {
        DataConsumer dataConsumer = this.myDataConsumer;
        if (dataConsumer == null) {
            AbstractEngine.$$$reportNull$$$0(4);
        }
        return dataConsumer;
    }

    @NotNull
    protected DataRequest.Context getRequestContext() {
        DataRequest.Context context = this.myRequestContext.get();
        if (context == null) {
            AbstractEngine.$$$reportNull$$$0(5);
        }
        return context;
    }

    @Nullable
    protected DataRequest.Context getRequestContextIfAny() {
        return this.myRequestContext.get();
    }

    public void processRequest(@NotNull GridDataRequest request) {
        if (request == null) {
            AbstractEngine.$$$reportNull$$$0(6);
        }
        ((DataRequest)request).accept(this);
    }

    @Override
    public void visitRequest(DataRequest r) {
        LOG.error("unknown request: " + r);
    }

    public final void dispose() {
        this.myMessageBus.beforeProducerRemove(this);
        this.submitRunnable(this::releaseConnection);
        this.submitRunnable(() -> this.myMessageBus.afterProducerRemove(this));
        this.cancelAndPassThroughRemainingRequests();
        this.myExecutorService.shutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutorService.awaitTermination(120L, TimeUnit.SECONDS);
                LOG.info("Engine execution service termination completed");
            }
            catch (InterruptedException e2) {
                LOG.warn("Engine execution service termination interrupted");
            }
        }
    }

    protected void releaseConnection() {
    }

    public boolean isDisposed() {
        return this.myExecutorService.isShutdown();
    }

    @Override
    public void visitDisconnect(DataRequest.Disconnect r) {
        this.performRequestDirect(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            this.disconnect();
            return true;
        }));
    }

    protected void disconnect() {
        this.cancelPendingRequests(null);
    }

    @Override
    public void visitCancel(DataRequest.Cancel r) {
        this.performRequestDirect(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> this.cancelPendingRequests(r)));
    }

    protected boolean cancelPendingRequests(@Nullable DataRequest.Cancel cancelRequest) {
        this.cancelAndPassThroughRemainingRequests();
        this.cancelProgressIndicator();
        return true;
    }

    private void cancelAndPassThroughRemainingRequests() {
        if (this.myCancelled.compareAndSet(false, true)) {
            this.submitRunnable(() -> this.myCancelled.compareAndSet(true, false));
        }
    }

    private void cancelProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator.get();
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
    }

    @NotNull
    protected abstract DataRequest.Context createRequestContext(@NotNull DataRequest var1);

    private void performRequestDirect(@NotNull DataRequest request, @NotNull ThrowableComputable<Boolean, Exception> computable) {
        if (request == null) {
            AbstractEngine.$$$reportNull$$$0(7);
        }
        if (computable == null) {
            AbstractEngine.$$$reportNull$$$0(8);
        }
        this.getDataAuditor().jobSubmitted(request, this);
        AsyncTask.currentFrame().compute(AsyncUtil.getPoolExecutor(), () -> {
            Boolean res2 = false;
            try {
                res2 = (Boolean)computable.compute();
            }
            catch (ProcessCanceledException processCanceledException) {
                try {
                    this.getDataAuditor().jobFinished(request, this);
                }
                finally {
                    DbImplUtil.setActionCallbackDone(request.getPromise(), res2, ModalityState.defaultModalityState());
                }
            }
            catch (Throwable e2) {
                LOG.error(e2);
            }
            finally {
                try {
                    this.getDataAuditor().jobFinished(request, this);
                }
                finally {
                    DbImplUtil.setActionCallbackDone(request.getPromise(), res2, ModalityState.defaultModalityState());
                }
            }
            return null;
        });
    }

    protected void submitRunnable(@NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractEngine.$$$reportNull$$$0(9);
        }
        AsyncTask.checkedFrame().compute(this.myExecutorService, () -> {
            runnable.run();
            return null;
        });
    }

    private void submitRunnable(@NotNull DataRequest request, @NotNull Supplier<Boolean> supplier2) {
        if (request == null) {
            AbstractEngine.$$$reportNull$$$0(10);
        }
        if (supplier2 == null) {
            AbstractEngine.$$$reportNull$$$0(11);
        }
        ModalityState modalityState = AsyncTask.getCurrentModality();
        this.getDataAuditor().jobSubmitted(request, this);
        this.submitRunnable(() -> {
            boolean result2 = false;
            try {
                Object indicator = AsyncTask.getIndicator(AsyncTask.currentFrame());
                if (indicator == null) {
                    indicator = new AsyncUtil.EmptyProgressIndicatorEx();
                }
                this.myProgressIndicator.set((ProgressIndicator)indicator);
                if (!this.myCancelled.get()) {
                    result2 = (Boolean)AsyncUtil.underProgress(supplier2, indicator);
                }
            }
            finally {
                this.myProgressIndicator.set(null);
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                try {
                    this.getDataAuditor().jobFinished(request, this);
                }
                finally {
                    DbImplUtil.setActionCallbackDone(request.getPromise(), result2, modalityState);
                }
            }
        });
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator(AsyncTask.Frame frame) {
        Object asyncIndicator;
        ProgressIndicator frameIndicator = AsyncTask.getIndicator(frame);
        if (frameIndicator == null) {
            asyncIndicator = new AsyncUtil.EmptyProgressIndicatorEx();
            AsyncTask.withIndicator(frame, asyncIndicator);
        } else {
            asyncIndicator = frameIndicator;
        }
        ProgressIndicator progressIndicator = asyncIndicator;
        if (progressIndicator == null) {
            AbstractEngine.$$$reportNull$$$0(12);
        }
        return progressIndicator;
    }

    protected void submitRequest(@NotNull DataRequest request, @NotNull ThrowableComputable<Boolean, Exception> computable) {
        if (request == null) {
            AbstractEngine.$$$reportNull$$$0(13);
        }
        if (computable == null) {
            AbstractEngine.$$$reportNull$$$0(14);
        }
        AsyncTask.Frame frame = AsyncTask.frame(AnalysisBundle.message((String)"progress.title.submit.request", (Object[])new Object[0]));
        this.submitRunnable(request, () -> {
            boolean result2 = false;
            DataRequest.Context context = null;
            try {
                context = this.createRequestContext(request);
                this.myRequestContext.set(context);
                try {
                    this.onRequestStarted(context);
                    result2 = (Boolean)frame.sync(computable);
                }
                finally {
                    this.onRequestFinished(context);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e2) {
                if (context == null) {
                    LOG.error(e2);
                } else if (!this.myCancelled.get()) {
                    try {
                        this.getDataAuditor().error(context, e2);
                    }
                    catch (Exception e1) {
                        LOG.error((Throwable)new CompoundRuntimeException(Arrays.asList(e2, e1)));
                    }
                }
            }
            finally {
                this.myRequestContext.compareAndSet(context, null);
            }
            return result2;
        });
    }

    protected void onRequestFinished(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            AbstractEngine.$$$reportNull$$$0(15);
        }
        this.getDataAuditor().requestFinished(context);
    }

    protected void onRequestStarted(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            AbstractEngine.$$$reportNull$$$0(16);
        }
        this.getDataAuditor().requestStarted(context);
    }

    @NotNull
    protected EngineDataAuditor wrapDataAuditor(@NotNull DataAuditor dataAuditor) {
        if (dataAuditor == null) {
            AbstractEngine.$$$reportNull$$$0(17);
        }
        return new EngineDataAuditor(dataAuditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/AbstractEngine";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataAuditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/AbstractEngine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataAuditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataConsumer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestContext";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performRequestDirect";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "submitRunnable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "submitRequest";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onRequestFinished";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStarted";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapDataAuditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 12 -> new IllegalStateException(string);
        };
    }

    protected static class EngineDataAuditor
    extends DataAuditor.Wrapper
    implements DataRequest.OutputHandler {
        public EngineDataAuditor(@NotNull DataAuditor delegate) {
            if (delegate == null) {
                EngineDataAuditor.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        public final void error(@NotNull DataRequest.Context context, @NotNull @NotNull Supplier<? extends @NotNull ErrorInfo> errorInfoSupplier) {
            if (context == null) {
                EngineDataAuditor.$$$reportNull$$$0(1);
            }
            if (errorInfoSupplier == null) {
                EngineDataAuditor.$$$reportNull$$$0(2);
            }
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.error(context, (ErrorInfo)errorInfoSupplier.get()));
        }

        @Override
        public final void error(@NotNull DataRequest.Context context, @NotNull Throwable th) {
            if (context == null) {
                EngineDataAuditor.$$$reportNull$$$0(3);
            }
            if (th == null) {
                EngineDataAuditor.$$$reportNull$$$0(4);
            }
            this.error(context, () -> this.createErrorInfo(th));
        }

        @NotNull
        protected ErrorInfo createErrorInfo(@NotNull Throwable th) {
            if (th == null) {
                EngineDataAuditor.$$$reportNull$$$0(5);
            }
            ErrorInfo errorInfo = SimpleErrorInfo.create((Throwable)th);
            if (errorInfo == null) {
                EngineDataAuditor.$$$reportNull$$$0(6);
            }
            return errorInfo;
        }

        @Override
        public final void error(@NotNull DataRequest.Context context, @Nls @NotNull String message2) {
            if (context == null) {
                EngineDataAuditor.$$$reportNull$$$0(7);
            }
            if (message2 == null) {
                EngineDataAuditor.$$$reportNull$$$0(8);
            }
            this.error(context, () -> this.createErrorInfo(message2));
        }

        @NotNull
        protected ErrorInfo createErrorInfo(@Nls @NotNull String message2) {
            if (message2 == null) {
                EngineDataAuditor.$$$reportNull$$$0(9);
            }
            ErrorInfo errorInfo = SimpleErrorInfo.create((String)message2);
            if (errorInfo == null) {
                EngineDataAuditor.$$$reportNull$$$0(10);
            }
            return errorInfo;
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
            if (context == null) {
                EngineDataAuditor.$$$reportNull$$$0(11);
            }
            if (errorInfo == null) {
                EngineDataAuditor.$$$reportNull$$$0(12);
            }
            assert (!(errorInfo.getOriginalThrowable() instanceof ProcessCanceledException)) : "ProcessCanceledException reporting is not allowed";
            this.delegate.error(context, errorInfo);
        }

        public final void warn(@NotNull DataRequest.Context context, @NotNull @NotNull Supplier<? extends @NotNull WarningInfo> warningInfoSupplier) {
            if (context == null) {
                EngineDataAuditor.$$$reportNull$$$0(13);
            }
            if (warningInfoSupplier == null) {
                EngineDataAuditor.$$$reportNull$$$0(14);
            }
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.warn(context, (WarningInfo)warningInfoSupplier.get()));
        }

        @Override
        public final void warn(@NotNull DataRequest.Context context, @NotNull Throwable th) {
            if (context == null) {
                EngineDataAuditor.$$$reportNull$$$0(15);
            }
            if (th == null) {
                EngineDataAuditor.$$$reportNull$$$0(16);
            }
            this.warn(context, () -> this.createWarningInfo(th));
        }

        @NotNull
        protected WarningInfo createWarningInfo(@NotNull Throwable th) {
            if (th == null) {
                EngineDataAuditor.$$$reportNull$$$0(17);
            }
            WarningInfo warningInfo = WarningInfo.create((Throwable)th);
            if (warningInfo == null) {
                EngineDataAuditor.$$$reportNull$$$0(18);
            }
            return warningInfo;
        }

        @Override
        public final void warn(@NotNull DataRequest.Context context, @Nls @NotNull String message2, boolean isUserOutput) {
            if (context == null) {
                EngineDataAuditor.$$$reportNull$$$0(19);
            }
            if (message2 == null) {
                EngineDataAuditor.$$$reportNull$$$0(20);
            }
            this.warn(context, () -> this.createWarningInfo(message2, isUserOutput));
        }

        @NotNull
        protected WarningInfo createWarningInfo(@Nls @NotNull String message2, boolean isUserOutput) {
            if (message2 == null) {
                EngineDataAuditor.$$$reportNull$$$0(21);
            }
            WarningInfo warningInfo = WarningInfo.create((String)message2, (boolean)isUserOutput);
            if (warningInfo == null) {
                EngineDataAuditor.$$$reportNull$$$0(22);
            }
            return warningInfo;
        }

        @Override
        public void warn(@NotNull DataRequest.Context context, @NotNull WarningInfo warningInfo) {
            if (context == null) {
                EngineDataAuditor.$$$reportNull$$$0(23);
            }
            if (warningInfo == null) {
                EngineDataAuditor.$$$reportNull$$$0(24);
            }
            this.delegate.warn(context, warningInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 10, 18, 22 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 3: 
                case 7: 
                case 11: 
                case 13: 
                case 15: 
                case 19: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfoSupplier";
                    break;
                }
                case 4: 
                case 5: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "th";
                    break;
                }
                case 6: 
                case 10: 
                case 18: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/AbstractEngine$EngineDataAuditor";
                    break;
                }
                case 8: 
                case 9: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "warningInfoSupplier";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "warningInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/AbstractEngine$EngineDataAuditor";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createErrorInfo";
                    break;
                }
                case 18: 
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createWarningInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createErrorInfo";
                    break;
                }
                case 6: 
                case 10: 
                case 18: 
                case 22: {
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "warn";
                    break;
                }
                case 17: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "createWarningInfo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 10, 18, 22 -> new IllegalStateException(string);
            };
        }
    }
}

