/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliModel;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.nio.file.Files;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0017J\b\u0010 \u001a\u00020\fH\u0016J\u0016\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0012\u0010(\u001a\u00020\"2\b\b\u0001\u0010)\u001a\u00020\"H\u0017J\u0010\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\"H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00060"}, d2={"Lcom/intellij/database/cli/CliRunTarget;", "Lcom/intellij/openapi/Disposable;", "()V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "supportsCommandLineValidation", "", "getSupportsCommandLineValidation", "()Z", "addRunTargetChangeListener", "", "runnable", "Ljava/lang/Runnable;", "adjustCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "commandLine", "checkFileStrict", "file", "Ljava/io/File;", "checkWslSymlink", "createExecutableFileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "createPathChooser", "Lcom/intellij/openapi/fileChooser/PathChooserDialog;", "descriptor", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "createPathChooserDescriptor", "dispose", "getPort", "", "defaultPort", "getPresentableUrl", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "patchFileChooserDescriptor", "patchPathLabel", "label", "validateFilePath", "path", "validateModel", "Lcom/intellij/openapi/ui/ValidationInfo;", "model", "Lcom/intellij/database/cli/CliModel;", "intellij.database.impl"})
public abstract class CliRunTarget
implements Disposable {
    @Nullable
    public JComponent getComponent() {
        return null;
    }

    public boolean getSupportsCommandLineValidation() {
        return true;
    }

    @Nullable
    public final FileChooserDescriptor createExecutableFileChooserDescriptor() {
        return this.patchFileChooserDescriptor(new FileChooserDescriptor(FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor()));
    }

    @Nullable
    public final FileChooserDescriptor createPathChooserDescriptor() {
        return this.patchFileChooserDescriptor(new FileChooserDescriptor(FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor()));
    }

    @Nullable
    public FileChooserDescriptor patchFileChooserDescriptor(@NotNull FileChooserDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return descriptor2;
    }

    public void addRunTargetChangeListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
    }

    @NotNull
    public PathChooserDialog createPathChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @NotNull Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        PathChooserDialog pathChooserDialog = FileChooserFactory.getInstance().createPathChooser(descriptor2, project, parentComponent);
        Intrinsics.checkNotNullExpressionValue((Object)pathChooserDialog, (String)"createPathChooser(...)");
        return pathChooserDialog;
    }

    @NotNull
    public String getPresentableUrl(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @Nullable
    public ValidationInfo validateModel(@NotNull CliModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return null;
    }

    public boolean validateFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        return this.checkFileStrict(file) || this.checkWslSymlink(file);
    }

    private final boolean checkFileStrict(File file) {
        return file.exists() && file.isFile() && Files.isExecutable(file.toPath());
    }

    private final boolean checkWslSymlink(File file) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!WslPath.Companion.isWslUncPath(string)) {
            return false;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return false;
        }
        File parent2 = file2;
        String fileName = file.getName();
        File[] files2 = parent2.listFiles((arg_0, arg_1) -> CliRunTarget.checkWslSymlink$lambda$0(fileName, arg_0, arg_1));
        return files2 != null && files2.length == 1;
    }

    @NlsSafe
    @NotNull
    public String patchPathLabel(@NlsSafe @NotNull String label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        return label2;
    }

    @Nullable
    public String getPort(@Nullable String defaultPort) {
        return defaultPort;
    }

    @NotNull
    public GeneralCommandLine adjustCommandLine(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return commandLine;
    }

    public void dispose() {
    }

    private static final boolean checkWslSymlink$lambda$0(String $fileName, File file, String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Intrinsics.areEqual((Object)name2, (Object)$fileName);
    }
}

