/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationPack;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliProperties
implements Disposable {
    private static final String PATH = "_PATH";
    private static final String COMMAND = "_COMMAND";
    private static final String EXPANDED = "_EXPANDED";
    private static final String VARIANTS = "_VARIANTS_";
    private static final String LAST_USED_CONFIGURATION = "_LAST_USED_CONFIGURATION";
    private final ThreadPoolExecutor myExecutor;
    private final CliConfiguration myConfiguration;
    private final CliModel myModel;

    CliProperties(@NotNull CliConfiguration configuration, @NotNull CliModel model2) {
        if (configuration == null) {
            CliProperties.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            CliProperties.$$$reportNull$$$0(1);
        }
        this.myConfiguration = configuration;
        this.myModel = model2;
        this.myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Cli database tool help parser");
    }

    public void store() {
        String key2 = this.myConfiguration.getPropertyKey();
        String dsKey = this.dsBoundKey(key2);
        PropertiesComponent component2 = PropertiesComponent.getInstance();
        component2.setValue(dsKey + PATH, this.myModel.getPathToExecutable());
        component2.setValue(dsKey + COMMAND, this.myModel.getCommand());
        component2.setValue(key2 + EXPANDED, String.valueOf(this.myModel.isExpanded()));
    }

    @NotNull
    private String dsBoundKey(@NotNull String key2) {
        LocalDataSource dataSource2;
        if (key2 == null) {
            CliProperties.$$$reportNull$$$0(2);
        }
        Object object = (dataSource2 = this.myModel.getDataSource()) != null ? key2 + "_" + dataSource2.getUniqueId() : key2;
        if (object == null) {
            CliProperties.$$$reportNull$$$0(3);
        }
        return object;
    }

    @Nullable
    private static String getWithFallback(@NotNull PropertiesComponent component2, @NotNull String key2, @NotNull String fallbackKey) {
        String path;
        if (component2 == null) {
            CliProperties.$$$reportNull$$$0(4);
        }
        if (key2 == null) {
            CliProperties.$$$reportNull$$$0(5);
        }
        if (fallbackKey == null) {
            CliProperties.$$$reportNull$$$0(6);
        }
        return (path = component2.getValue(key2)) != null ? path : component2.getValue(fallbackKey);
    }

    public void restore() {
        String key2 = this.myConfiguration.getPropertyKey();
        String dsKey = this.dsBoundKey(key2);
        PropertiesComponent component2 = PropertiesComponent.getInstance();
        String path = CliProperties.getWithFallback(component2, dsKey + PATH, key2 + PATH);
        String command2 = CliProperties.getWithFallback(component2, dsKey + COMMAND, key2 + COMMAND);
        String expanded = component2.getValue(key2 + EXPANDED);
        if (path != null) {
            this.myModel.setPathToExecutable(path);
        }
        if (command2 != null) {
            this.myModel.setCommand(command2);
        }
        this.myModel.setExpanded(expanded != null ? Boolean.parseBoolean(expanded) : true);
    }

    public void storeVariants() {
        CliConfiguration configuration = this.myModel.getConfiguration();
        String key2 = configuration.getPropertyKey();
        String path = this.myModel.getPathToExecutable();
        File file = new File(path);
        if (!(file.exists() && file.isFile() && Files.isExecutable(Paths.get(path, new String[0])))) {
            this.myModel.setVariants(new ArrayList<String>());
            return;
        }
        int hash = FileUtil.fileHashCode((File)file);
        PropertiesComponent component2 = PropertiesComponent.getInstance();
        String value2 = component2.getValue(key2 + VARIANTS + hash);
        if (value2 == null) {
            this.myExecutor.execute(new MyVariantsTask(this.myModel, path, configuration.getHelpCommand(), hash));
            return;
        }
        this.myModel.setVariants(StringUtil.split((String)value2, (String)" "));
    }

    public void dispose() {
        this.myExecutor.shutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutor.awaitTermination(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void storeLastUsedConfiguration(@NotNull CliConfigurationPack pack, @NotNull CliConfiguration configuration) {
        if (pack == null) {
            CliProperties.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            CliProperties.$$$reportNull$$$0(8);
        }
        PropertiesComponent component2 = PropertiesComponent.getInstance();
        component2.setValue(pack.getKey() + LAST_USED_CONFIGURATION, configuration.getPropertyKey());
    }

    @Nullable
    public static CliConfiguration getLastUsedConfigurationKey(@NotNull CliConfigurationPack pack) {
        if (pack == null) {
            CliProperties.$$$reportNull$$$0(9);
        }
        PropertiesComponent component2 = PropertiesComponent.getInstance();
        String configurationKey = component2.getValue(pack.getKey() + LAST_USED_CONFIGURATION);
        return (CliConfiguration)ContainerUtil.find(pack.getConfigurations(), c2 -> StringUtil.equals((CharSequence)c2.getPropertyKey(), (CharSequence)configurationKey));
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<String> getVariants(@NotNull String path, @NotNull String helpCommand) {
        String string;
        Process process2;
        if (path == null) {
            CliProperties.$$$reportNull$$$0(10);
        }
        if (helpCommand == null) {
            CliProperties.$$$reportNull$$$0(11);
        }
        if ((process2 = CliProperties.createProcess(path, helpCommand)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CliProperties.$$$reportNull$$$0(12);
            }
            return list;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(process2.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder builder = new StringBuilder();
        while ((string = reader.readLine()) != null) {
            builder.append(string);
        }
        List<String> list = CliProperties.getFromString(builder.toString());
        reader.close();
        List<String> list2 = list;
        if (list2 == null) {
            CliProperties.$$$reportNull$$$0(13);
        }
        return list2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    process2.destroyForcibly();
                    List list3 = ContainerUtil.emptyList();
                    if (list3 == null) {
                        CliProperties.$$$reportNull$$$0(14);
                    }
                    return list3;
                }
            }
        }
    }

    @Nullable
    private static Process createProcess(@NotNull String path, @NotNull String helpCommand) {
        if (path == null) {
            CliProperties.$$$reportNull$$$0(15);
        }
        if (helpCommand == null) {
            CliProperties.$$$reportNull$$$0(16);
        }
        try {
            GeneralCommandLine line = new GeneralCommandLine(new String[]{path, helpCommand});
            return line.createProcess();
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    @NotNull
    private static List<String> getFromString(@NotNull String current) {
        if (current == null) {
            CliProperties.$$$reportNull$$$0(17);
        }
        List<CliLexeme> result2 = DbCliUtil.extractArguments(current);
        List<String> list = result2.stream().map(CliLexeme::getText).distinct().collect(Collectors.toList());
        if (list == null) {
            CliProperties.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12, 13, 14, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliProperties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackKey";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpCommand";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dsBoundKey";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dsBoundKey";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getWithFallback";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "storeLastUsedConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLastUsedConfigurationKey";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFromString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12, 13, 14, 18 -> new IllegalStateException(string);
        };
    }

    private static final class MyVariantsTask
    implements Runnable {
        private final CliModel mySettings;
        private final String myPath;
        private final String myCommand;
        private final int myHash;

        private MyVariantsTask(@NotNull CliModel settings, @NotNull String path, @NotNull String command2, int hash) {
            if (settings == null) {
                MyVariantsTask.$$$reportNull$$$0(0);
            }
            if (path == null) {
                MyVariantsTask.$$$reportNull$$$0(1);
            }
            if (command2 == null) {
                MyVariantsTask.$$$reportNull$$$0(2);
            }
            this.mySettings = settings;
            this.myPath = path;
            this.myCommand = command2;
            this.myHash = hash;
        }

        @Override
        public void run() {
            PropertiesComponent properties2 = PropertiesComponent.getInstance();
            List<String> variants = CliProperties.getVariants(this.myPath, this.myCommand);
            DbUIUtil.invokeLater(() -> {
                properties2.setValue(this.mySettings.getConfiguration().getPropertyKey() + CliProperties.VARIANTS + this.myHash, StringUtil.join((Collection)variants, (String)" "));
                this.mySettings.setVariants(variants);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/cli/CliProperties$MyVariantsTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

