/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliLocalRunTarget;
import com.intellij.database.cli.CliLocalRunTargetProvider;
import com.intellij.database.cli.CliRunTarget;
import com.intellij.database.cli.CliRunTargetProvider;
import com.intellij.database.cli.component.CliPathTextField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CliPanelDecorator
implements Disposable {
    private static final int WIDTH = 2;
    private static final int GAP = 6;
    private final String myName;
    private final JPanel myPanel;
    List<Pair<JBRadioButton, CliRunTarget>> myRunTargets;
    private final List<Runnable> myRunTargetChangeListeners;
    private final Map<CliComponent, JBLabel> myMutableLabels;

    public CliPanelDecorator(@NotNull String name2, @NotNull HideableTitledPanel titledPanel, @NotNull JComponent pathComponent, @NotNull List<CliComponent> components, @NotNull Project project) {
        if (name2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(0);
        }
        if (titledPanel == null) {
            CliPanelDecorator.$$$reportNull$$$0(1);
        }
        if (pathComponent == null) {
            CliPanelDecorator.$$$reportNull$$$0(2);
        }
        if (components == null) {
            CliPanelDecorator.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CliPanelDecorator.$$$reportNull$$$0(4);
        }
        this.myRunTargets = new SmartList();
        this.myRunTargetChangeListeners = new SmartList();
        this.myMutableLabels = new HashMap<CliComponent, JBLabel>();
        this.myName = name2;
        JComponent hideable = this.getHideablePanel(pathComponent, components);
        JComponent visible = this.getAlwaysVisiblePanel(components);
        titledPanel.setContentComponent(hideable);
        this.myPanel = new JPanel((LayoutManager)new VerticalLayout(6));
        this.addRunTargetPanel(this.myPanel, project);
        this.myPanel.add((Component)titledPanel);
        this.myPanel.add(visible);
        this.addRunTargetChangeListener(() -> {
            CliRunTarget runTarget = this.getRunTarget();
            for (Map.Entry<CliComponent, JBLabel> entry : this.myMutableLabels.entrySet()) {
                String label2 = entry.getKey().getLabel();
                if (label2 == null) continue;
                String labelText = runTarget.patchPathLabel(label2);
                entry.getValue().setText(labelText);
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CliPanelDecorator.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    public CliRunTarget getRunTarget() {
        for (Pair<JBRadioButton, CliRunTarget> entry : this.myRunTargets) {
            if (!((JBRadioButton)entry.getFirst()).isSelected()) continue;
            CliRunTarget cliRunTarget = (CliRunTarget)entry.getSecond();
            if (cliRunTarget == null) {
                CliPanelDecorator.$$$reportNull$$$0(6);
            }
            return cliRunTarget;
        }
        CliLocalRunTarget cliLocalRunTarget = CliLocalRunTarget.INSTANCE;
        if (cliLocalRunTarget == null) {
            CliPanelDecorator.$$$reportNull$$$0(7);
        }
        return cliLocalRunTarget;
    }

    public void addRunTargetChangeListener(@NotNull Runnable consumer2) {
        if (consumer2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(8);
        }
        this.myRunTargetChangeListeners.add(consumer2);
        for (Pair<JBRadioButton, CliRunTarget> pair : this.myRunTargets) {
            ((CliRunTarget)pair.getSecond()).addRunTargetChangeListener(consumer2);
        }
    }

    public void dispose() {
    }

    private void addRunTargetPanel(@NotNull JPanel panel2, @NotNull Project project) {
        List<CliRunTargetProvider> providers;
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(9);
        }
        if (project == null) {
            CliPanelDecorator.$$$reportNull$$$0(10);
        }
        if ((providers = CliRunTargetProvider.getAllProviders()).size() <= 1) {
            return;
        }
        JPanel runTargetPanel = new JPanel((LayoutManager)new VerticalLayout(6));
        panel2.add(runTargetPanel);
        TitledSeparator separator = new TitledSeparator(DatabaseBundle.message("database.cli.integration.run.target.panel.title", new Object[0]), null);
        JPanel separatorPanel = new JPanel(new BorderLayout());
        separatorPanel.add((Component)separator, "Center");
        runTargetPanel.add(separatorPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        ActionListener listener2 = e2 -> {
            for (Pair<JBRadioButton, CliRunTarget> entry : this.myRunTargets) {
                JBRadioButton button = (JBRadioButton)entry.getFirst();
                CliRunTarget runTarget = (CliRunTarget)entry.getSecond();
                JComponent component2 = runTarget.getComponent();
                boolean selected = button.isSelected();
                if (component2 != null) {
                    UIUtil.setEnabled((Component)component2, (boolean)selected, (boolean)true, (boolean)true);
                }
                if (!selected) continue;
                for (Runnable consumer2 : this.myRunTargetChangeListeners) {
                    consumer2.run();
                }
            }
        };
        for (CliRunTargetProvider provider : providers) {
            JPanel providerPanel = new JPanel((LayoutManager)new VerticalLayout(6));
            runTargetPanel.add(providerPanel);
            JBRadioButton radioButton = new JBRadioButton(provider.getDisplayName());
            if (provider instanceof CliLocalRunTargetProvider) {
                radioButton.setSelected(true);
            }
            buttonGroup.add((AbstractButton)radioButton);
            providerPanel.add((Component)radioButton);
            radioButton.addActionListener(listener2);
            CliRunTarget runTarget = provider.createRunTarget(project);
            Disposer.register((Disposable)this, (Disposable)runTarget);
            this.myRunTargets.add((Pair<JBRadioButton, CliRunTarget>)Pair.create((Object)radioButton, (Object)runTarget));
            JComponent providerComponent = runTarget.getComponent();
            if (providerComponent == null) continue;
            providerPanel.add(providerComponent);
            UIUtil.setEnabled((Component)providerComponent, (boolean)false, (boolean)true, (boolean)true);
        }
    }

    @NotNull
    private JComponent getHideablePanel(@NotNull JComponent pathComponent, @NotNull List<CliComponent> components) {
        if (pathComponent == null) {
            CliPanelDecorator.$$$reportNull$$$0(11);
        }
        if (components == null) {
            CliPanelDecorator.$$$reportNull$$$0(12);
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        JBLabel pathLabel = new JBLabel(DatabaseBundle.message("database.cli.integration.path.to.executable.pattern", this.myName) + " ");
        GridBagConstraints gbc = CliPanelDecorator.createConstraints();
        CliPanelDecorator.add(panel2, (JComponent)pathLabel, gbc);
        CliPanelDecorator.span(gbc);
        CliPanelDecorator.add(panel2, pathComponent, gbc);
        this.addComponents(panel2, gbc, ContainerUtil.filter(components, CliComponent::isHideable));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            CliPanelDecorator.$$$reportNull$$$0(13);
        }
        return jPanel;
    }

    @NotNull
    private JComponent getAlwaysVisiblePanel(@NotNull List<CliComponent> components) {
        if (components == null) {
            CliPanelDecorator.$$$reportNull$$$0(14);
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = CliPanelDecorator.createConstraints();
        this.addComponents(panel2, gbc, ContainerUtil.filter(components, (Condition)Conditions.not(CliComponent::isHideable)));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            CliPanelDecorator.$$$reportNull$$$0(15);
        }
        return jPanel;
    }

    private void addComponents(@NotNull JPanel panel2, @NotNull GridBagConstraints gbc, @NotNull List<CliComponent> components) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(16);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(17);
        }
        if (components == null) {
            CliPanelDecorator.$$$reportNull$$$0(18);
        }
        for (CliComponent component2 : components) {
            this.addComponent(panel2, component2, gbc);
        }
    }

    private static GridBagConstraints createConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        CliPanelDecorator.reset(gbc);
        return gbc;
    }

    private static void reset(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(19);
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        CliPanelDecorator.noSpan(gbc);
    }

    private void addComponent(@NotNull JPanel panel2, @NotNull CliComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(20);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(21);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(22);
        }
        if (component2.getLabel() == null) {
            CliPanelDecorator.addSimple(panel2, component2, gbc);
            return;
        }
        this.addLabeled(panel2, component2, gbc);
    }

    private static void addSimple(@NotNull JPanel panel2, @NotNull CliComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(23);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(24);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(25);
        }
        CliPanelDecorator.noSpan(gbc);
        CliPanelDecorator.add(panel2, component2.getComponent(), gbc);
        CliPanelDecorator.addDescription(panel2, component2, gbc);
    }

    private void addLabeled(@NotNull JPanel panel2, @NotNull CliComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(26);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(27);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(28);
        }
        CliPanelDecorator.noSpan(gbc);
        CliPanelDecorator.nextLine(gbc);
        JBLabel jbLabel = new JBLabel(component2.getLabel() + ": ");
        CliPanelDecorator.add(panel2, (JComponent)jbLabel, gbc);
        if (component2 instanceof CliPathTextField) {
            this.myMutableLabels.put(component2, jbLabel);
        }
        CliPanelDecorator.span(gbc);
        CliPanelDecorator.add(panel2, component2.getComponent(), gbc);
        CliPanelDecorator.addDescription(panel2, component2, gbc);
    }

    private static void addDescription(@NotNull JPanel panel2, @NotNull CliComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(29);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(30);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(31);
        }
        if (component2.getDescription() == null) {
            return;
        }
        CliPanelDecorator.nextCell(gbc);
        CliPanelDecorator.add(panel2, ComponentPanelBuilder.createCommentComponent((String)component2.getDescription(), (boolean)true, (int)100, (boolean)true), gbc);
    }

    private static void nextLine(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(32);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
    }

    private static void noSpan(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(33);
        }
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }

    private static void span(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(34);
        }
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
    }

    private static void nextCell(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(35);
        }
        if (gbc.gridx == 1) {
            CliPanelDecorator.nextLine(gbc);
            return;
        }
        ++gbc.gridx;
    }

    private static void add(@NotNull JPanel panel2, @NotNull JComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(36);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(37);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(38);
        }
        panel2.add((Component)component2, gbc);
        CliPanelDecorator.nextCell(gbc);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titledPanel";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathComponent";
                break;
            }
            case 3: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliPanelDecorator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 16: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gbc";
                break;
            }
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliPanelDecorator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunTarget";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHideablePanel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlwaysVisiblePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRunTargetChangeListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRunTargetPanel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHideablePanel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAlwaysVisiblePanel";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addComponents";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addSimple";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addLabeled";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addDescription";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "nextLine";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "noSpan";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "span";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "nextCell";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 13, 15 -> new IllegalStateException(string);
        };
    }
}

