/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationPack;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.CliProperties;
import com.intellij.database.cli.CliRunner;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliDialog
extends DialogWrapper {
    private static final String DIMENSION_KEY = "DUMP_DIALOG_DIMENSION_KEY";
    private static final Dimension MIN_SIZE = JBUI.size((int)300, (int)100);
    private static final Dimension PREFERRED_SIZE = JBUI.size((int)600, (int)400);
    private final LocalDataSource myDataSource;
    private final Project myProject;
    private final CliConfigurationPack myPack;
    private final MyPanel myPanel;

    public CliDialog(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull Collection<DbElement> elements2, @NotNull CliConfigurationPack configurations, @NotNull @NlsContexts.DialogTitle String title) {
        if (project == null) {
            CliDialog.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            CliDialog.$$$reportNull$$$0(1);
        }
        if (elements2 == null) {
            CliDialog.$$$reportNull$$$0(2);
        }
        if (configurations == null) {
            CliDialog.$$$reportNull$$$0(3);
        }
        if (title == null) {
            CliDialog.$$$reportNull$$$0(4);
        }
        super(project);
        this.myDataSource = dataSource2;
        this.myProject = project;
        this.myPack = configurations;
        this.myPanel = configurations.isSingleConfiguration() ? new MySingleConfigurationPanel(project, elements2, configurations, dataSource2) : new MyMultiConfigurationPanel(project, elements2, configurations, dataSource2);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPanel);
        this.setTitle(title);
        this.initValidation();
        this.init();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.putValue("Name", DatabaseBundle.message("database.cli.integration.run.action", new Object[0]));
    }

    protected void doOKAction() {
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        CliProperties.storeLastUsedConfiguration(this.myPack, this.myPanel.configuration());
        CliModel model2 = this.myPanel.model();
        String executable = model2.getExecutableCommand();
        List<String> parameterizable = model2.getParameterizable();
        WSLDistribution wslDistribution = WslPath.getDistributionByWindowsUncPath((String)model2.getPathToExecutable());
        model2.store();
        super.doOKAction();
        new CliRunner(this.myProject, this.myDataSource, this.myPanel.configuration(), parameterizable, executable, model2.getRunTarget(), wslDistribution).run();
    }

    protected boolean shouldAddErrorNearButtons() {
        return !CliDialog.isMoveHelpButtonLeft();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.model().getPreferredFocusableComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myPanel.validator().createInfo(this.myPanel.model());
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JComponent component2 = this.myPanel.component();
        component2.setMinimumSize(MIN_SIZE);
        component2.setPreferredSize(PREFERRED_SIZE);
        return component2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "configurations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/cli/CliDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MySingleConfigurationPanel
    extends JPanel
    implements MyPanel {
        private final CliModel myModel;
        private final CliConfiguration myConfiguration;
        private final CliDialogValidator myValidator;

        MySingleConfigurationPanel(@NotNull Project project, @NotNull Collection<DbElement> elements2, @NotNull CliConfigurationPack configurations, @NotNull LocalDataSource dataSource2) {
            if (project == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(0);
            }
            if (elements2 == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(1);
            }
            if (configurations == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(2);
            }
            if (dataSource2 == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(3);
            }
            super(new BorderLayout());
            CliConfiguration first2 = configurations.first();
            this.myConfiguration = Objects.requireNonNull(first2);
            this.myModel = new CliModel(project, this.myConfiguration.getObjectsPreparer().prepare(elements2).get(), this.myConfiguration, dataSource2);
            this.myValidator = this.myConfiguration.getValidator();
            Disposer.register((Disposable)this, (Disposable)this.myModel);
            Disposer.register((Disposable)this.myModel, (Disposable)this.myValidator);
            this.add(this.myModel.getComponent());
        }

        @Override
        @NotNull
        public CliDialogValidator validator() {
            CliDialogValidator cliDialogValidator = this.myValidator;
            if (cliDialogValidator == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(4);
            }
            return cliDialogValidator;
        }

        @Override
        @NotNull
        public CliConfiguration configuration() {
            CliConfiguration cliConfiguration = this.myConfiguration;
            if (cliConfiguration == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(5);
            }
            return cliConfiguration;
        }

        @Override
        @NotNull
        public CliModel model() {
            CliModel cliModel = this.myModel;
            if (cliModel == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(6);
            }
            return cliModel;
        }

        @Override
        @NotNull
        public JComponent component() {
            MySingleConfigurationPanel mySingleConfigurationPanel = this;
            if (mySingleConfigurationPanel == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(7);
            }
            return mySingleConfigurationPanel;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "configuration";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "model";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyMultiConfigurationPanel
    extends JPanel
    implements MyPanel {
        private final CardLayout myLayout;
        private final Map<CliConfiguration, Data> myMap;
        private final JPanel myCardPanel;
        private final ActionToolbar myToolbar;
        private CliConfiguration mySelectedConfiguration;

        MyMultiConfigurationPanel(@NotNull Project project, @NotNull Collection<DbElement> elements2, @NotNull CliConfigurationPack configurations, @NotNull LocalDataSource dataSource2) {
            if (project == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(0);
            }
            if (elements2 == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(1);
            }
            if (configurations == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(2);
            }
            if (dataSource2 == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(3);
            }
            super(new BorderLayout());
            this.myLayout = new CardLayout();
            this.myMap = new HashMap<CliConfiguration, Data>();
            this.myCardPanel = new JPanel(this.myLayout);
            configurations.getConfigurations().forEach(c2 -> {
                CliDialogValidator validator = c2.getValidator();
                CliModel model2 = new CliModel(project, c2.getObjectsPreparer().prepare(elements2).get(), (CliConfiguration)c2, dataSource2);
                Disposer.register((Disposable)this, (Disposable)model2);
                Disposer.register((Disposable)model2, (Disposable)validator);
                this.myMap.put((CliConfiguration)c2, new Data(validator, model2));
                this.myCardPanel.add((Component)model2.getComponent(), c2.getName());
            });
            ArrayList<Object> actions = new ArrayList<Object>();
            boolean first2 = true;
            for (CliConfiguration configuration : configurations.getConfigurations()) {
                if (!first2) {
                    actions.add(new Separator());
                }
                first2 = false;
                actions.add((Object)new MyToggle(configuration));
            }
            this.myToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(actions), true);
            this.add((Component)this.myToolbar.getComponent(), "North");
            this.add((Component)this.myCardPanel, "Center");
            this.mySelectedConfiguration = (CliConfiguration)ObjectUtils.notNull((Object)CliProperties.getLastUsedConfigurationKey(configurations), (Object)configurations.first());
            this.myLayout.show(this.myCardPanel, Objects.requireNonNull(this.mySelectedConfiguration).getName());
        }

        @Override
        @NotNull
        public CliConfiguration configuration() {
            CliConfiguration cliConfiguration = this.mySelectedConfiguration;
            if (cliConfiguration == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(4);
            }
            return cliConfiguration;
        }

        @Override
        @NotNull
        public CliDialogValidator validator() {
            CliDialogValidator cliDialogValidator = this.myMap.get((Object)this.mySelectedConfiguration).validator;
            if (cliDialogValidator == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(5);
            }
            return cliDialogValidator;
        }

        @Override
        @NotNull
        public CliModel model() {
            CliModel cliModel = this.myMap.get((Object)this.mySelectedConfiguration).model;
            if (cliModel == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(6);
            }
            return cliModel;
        }

        @Override
        @NotNull
        public JComponent component() {
            MyMultiConfigurationPanel myMultiConfigurationPanel = this;
            if (myMultiConfigurationPanel == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(7);
            }
            return myMultiConfigurationPanel;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "configuration";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validator";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "model";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }

        private final class MyToggle
        extends ToggleAction
        implements DumbAware {
            private final CliConfiguration myConfiguration;

            private MyToggle(CliConfiguration configuration) {
                if (configuration == null) {
                    MyToggle.$$$reportNull$$$0(0);
                }
                super(StringUtil.escapeMnemonics((String)configuration.getName()));
                this.myConfiguration = configuration;
                this.getTemplatePresentation().setIcon(EmptyIcon.ICON_0);
                this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    MyToggle.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    MyToggle.$$$reportNull$$$0(2);
                }
                e2.getPresentation().setEnabledAndVisible(true);
                super.update(e2);
            }

            public boolean isSelected(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    MyToggle.$$$reportNull$$$0(3);
                }
                return MyMultiConfigurationPanel.this.mySelectedConfiguration == this.myConfiguration;
            }

            public void setSelected(@NotNull AnActionEvent e2, boolean state) {
                if (e2 == null) {
                    MyToggle.$$$reportNull$$$0(4);
                }
                if (!state) {
                    return;
                }
                boolean expanded = MyMultiConfigurationPanel.this.myMap.get((Object)MyMultiConfigurationPanel.this.mySelectedConfiguration).model.isExpanded();
                MyMultiConfigurationPanel.this.mySelectedConfiguration = this.myConfiguration;
                MyMultiConfigurationPanel.this.myToolbar.updateActionsImmediately();
                MyMultiConfigurationPanel.this.myMap.get((Object)MyMultiConfigurationPanel.this.mySelectedConfiguration).model.setExpanded(expanded);
                MyMultiConfigurationPanel.this.myLayout.show(MyMultiConfigurationPanel.this.myCardPanel, MyMultiConfigurationPanel.this.mySelectedConfiguration.getName());
            }

            public boolean displayTextInToolbar() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "configuration";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel$MyToggle";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel$MyToggle";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        private static final class Data {
            final CliDialogValidator validator;
            final CliModel model;

            private Data(@NotNull CliDialogValidator validator, @NotNull CliModel model2) {
                if (validator == null) {
                    Data.$$$reportNull$$$0(0);
                }
                if (model2 == null) {
                    Data.$$$reportNull$$$0(1);
                }
                this.validator = validator;
                this.model = model2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "validator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel$Data";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static interface MyPanel
    extends Disposable {
        @NotNull
        public CliDialogValidator validator();

        @NotNull
        public CliConfiguration configuration();

        @NotNull
        public CliModel model();

        @NotNull
        public JComponent component();
    }
}

