/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.diagnostic;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.diagnostic.JdbcLogAction;
import com.intellij.database.actions.diagnostic.JdbcLogSettings;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextAreaKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.util.text.StringKt;
import java.util.logging.Level;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0015\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/actions/diagnostic/JdbcLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPresetGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "configArea", "Lcom/intellij/ui/components/JBTextArea;", "editSettings", "Lcom/intellij/database/actions/diagnostic/JdbcLogSettings;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getLogLevels", "", "Ljava/util/logging/Level;", "()[Ljava/util/logging/Level;", "getTarget", "Lcom/intellij/database/dataSource/LocalDataSource;", "update", "intellij.database.impl"})
public final class JdbcLogAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        LocalDataSource ds = this.getTarget(e2);
        e2.getPresentation().setEnabledAndVisible(ds != null);
    }

    private final LocalDataSource getTarget(AnActionEvent e2) {
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return (LocalDataSource)DatabaseContextFun.getSelectedDataSources(dataContext).filterMap(arg_0 -> JdbcLogAction.getTarget$lambda$0(getTarget.1.INSTANCE, arg_0)).single();
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        block2: {
            JdbcLogSettings jdbcLogSettings;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Project project = e2.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            LocalDataSource localDataSource = this.getTarget(e2);
            if (localDataSource == null) {
                return;
            }
            LocalDataSource ds = localDataSource;
            JdbcLogSettings settings = new JdbcLogSettings(false, null, null, null, null, false, 63, null);
            settings.load(ds);
            JdbcLogSettings jdbcLogSettings2 = this.editSettings(project2, settings);
            if (jdbcLogSettings2 == null) break block2;
            JdbcLogSettings $this$actionPerformed_u24lambda_u241 = jdbcLogSettings = jdbcLogSettings2;
            boolean bl = false;
            $this$actionPerformed_u24lambda_u241.save(ds);
            DataSourceUtil.deactivate(project2, ds);
        }
    }

    private final JdbcLogSettings editSettings(Project project, JdbcLogSettings settings) {
        JdbcLogSettings newSettings = JdbcLogSettings.copy$default(settings, false, null, null, null, null, false, 63, null);
        JBTextArea configArea = new JBTextArea(settings.getConfig());
        DialogPanel panel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(newSettings, this, project, configArea){
            final /* synthetic */ JdbcLogSettings $newSettings;
            final /* synthetic */ JdbcLogAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ JBTextArea $configArea;
            {
                this.$newSettings = $newSettings;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$configArea = $configArea;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = DatabaseBundle.message("ssl.logging", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.$newSettings){
                    final /* synthetic */ JdbcLogSettings $newSettings;
                    {
                        this.$newSettings = $newSettings;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Row $this$row) {
                        void $this$invoke_u24lambda_u242_u24lambda_u241;
                        FixedComboBoxEditor fixedComboBoxEditor;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell cell = new Cell[]{"", "all", "ssl", "ssl:handshake"};
                        cell = ComboBoxKt.bindItem((Cell)$this$row.comboBox((ComboBoxModel)new DefaultComboBoxModel<String>((E[])cell), (ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> editSettings.panel.1.invoke$lambda$0(editSettings.panel.1.INSTANCE, arg_0, arg_1, arg_2))), (Function0)((Function0)new MutablePropertyReference0Impl(this.$newSettings){

                            @Nullable
                            public Object get() {
                                return ((JdbcLogSettings)this.receiver).getDebugSsl();
                            }

                            public void set(@Nullable Object value2) {
                                ((JdbcLogSettings)this.receiver).setDebugSsl((String)value2);
                            }
                        }), (Function1)((Function1)new Function1<String, Unit>(this.$newSettings){
                            final /* synthetic */ JdbcLogSettings $newSettings;
                            {
                                this.$newSettings = $newSettings;
                                super(1);
                            }

                            public final void invoke(@Nullable String it2) {
                                String string = it2;
                                if (string == null) {
                                    string = "";
                                }
                                this.$newSettings.setDebugSsl(string);
                            }
                        }));
                        JdbcLogSettings jdbcLogSettings = this.$newSettings;
                        Cell $this$invoke_u24lambda_u242 = cell;
                        boolean bl = false;
                        ((ComboBox)$this$invoke_u24lambda_u242.getComponent()).setEditable(true);
                        FixedComboBoxEditor fixedComboBoxEditor2 = fixedComboBoxEditor = new FixedComboBoxEditor();
                        ComboBox comboBox = (ComboBox)$this$invoke_u24lambda_u242.getComponent();
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u242_u24lambda_u241.getField().getEmptyText().setText(DatabaseBundle.message("label.disabled", new Object[0]));
                        comboBox.setEditor((ComboBoxEditor)fixedComboBoxEditor);
                        ((ComboBox)$this$invoke_u24lambda_u242.getComponent()).setSelectedItem((Object)jdbcLogSettings.getDebugSsl());
                    }

                    private static final void invoke$lambda$0(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        $tmp0.invoke((Object)p0, p1, (Object)p2);
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$newSettings){
                    final /* synthetic */ JdbcLogSettings $newSettings;
                    {
                        this.$newSettings = $newSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = DatabaseBundle.message("checkbox.enabled", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this.$newSettings){

                            @Nullable
                            public Object get() {
                                return ((JdbcLogSettings)this.receiver).getEnabled();
                            }

                            public void set(@Nullable Object value2) {
                                ((JdbcLogSettings)this.receiver).setEnabled((Boolean)value2);
                            }
                        }));
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$newSettings){
                    final /* synthetic */ JdbcLogSettings $newSettings;
                    {
                        this.$newSettings = $newSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = DatabaseBundle.message("checkbox.capture.output.to.log", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this.$newSettings){

                            @Nullable
                            public Object get() {
                                return ((JdbcLogSettings)this.receiver).getCaptureStdout();
                            }

                            public void set(@Nullable Object value2) {
                                ((JdbcLogSettings)this.receiver).setCaptureStdout((Boolean)value2);
                            }
                        }));
                    }
                }), (int)1, null);
                String string2 = DatabaseBundle.message("driver.log.level", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0, this.$newSettings){
                    final /* synthetic */ JdbcLogAction this$0;
                    final /* synthetic */ JdbcLogSettings $newSettings;
                    {
                        this.this$0 = $receiver;
                        this.$newSettings = $newSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        ComboBoxKt.bindItem((Cell)$this$row.comboBox((ComboBoxModel)new DefaultComboBoxModel<Level>(JdbcLogAction.access$getLogLevels(this.this$0)), (ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> editSettings.panel.4.invoke$lambda$0(editSettings.panel.1.INSTANCE, arg_0, arg_1, arg_2))), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this.$newSettings){

                            @Nullable
                            public Object get() {
                                return ((JdbcLogSettings)this.receiver).getJdbcLevel();
                            }

                            public void set(@Nullable Object value2) {
                                ((JdbcLogSettings)this.receiver).setJdbcLevel((Level)value2);
                            }
                        }));
                    }

                    private static final void invoke$lambda$0(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        $tmp0.invoke((Object)p0, p1, (Object)p2);
                    }
                });
                String string3 = DatabaseBundle.message("driver.log.extra.path", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                $this$panel.row(string3, (Function1)new Function1<Row, Unit>(this.$project, this.$newSettings){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ JdbcLogSettings $newSettings;
                    {
                        this.$project = $project;
                        this.$newSettings = $newSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = DatabaseBundle.message("dialog.title.log.files.location", new Object[0]);
                        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFolderDescriptor(...)");
                        TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (String)string, (Project)this.$project, (FileChooserDescriptor)fileChooserDescriptor, null, (int)8, null).align((Align)AlignX.FILL.INSTANCE), (Function0)((Function0)new Function0<String>(this.$newSettings){
                            final /* synthetic */ JdbcLogSettings $newSettings;
                            {
                                this.$newSettings = $newSettings;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                String string = this.$newSettings.getPath();
                                if (string == null) {
                                    string = "";
                                }
                                return string;
                            }
                        }), (Function1)((Function1)new Function1<String, Unit>(this.$newSettings){
                            final /* synthetic */ JdbcLogSettings $newSettings;
                            {
                                this.$newSettings = $newSettings;
                                super(1);
                            }

                            public final void invoke(@NotNull String it2) {
                                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                this.$newSettings.setPath(StringKt.nullize$default((String)it2, (boolean)false, (int)1, null));
                            }
                        }));
                    }
                });
                String string4 = DatabaseBundle.message("custom.configuration", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                $this$panel.row(string4, (Function1)new Function1<Row, Unit>(this.$configArea, this.this$0){
                    final /* synthetic */ JBTextArea $configArea;
                    final /* synthetic */ JdbcLogAction this$0;
                    {
                        this.$configArea = $configArea;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        AnAction[] anActionArray = new AnAction[]{JdbcLogAction.access$createPresetGroup(this.this$0, this.$configArea)};
                        $this$row.cell(ActionUtil.createToolbarComponent((JComponent)((JComponent)this.$configArea), (String)"toolbar", (ActionGroup)((ActionGroup)new DefaultActionGroup(anActionArray)), (boolean)true));
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$configArea){
                    final /* synthetic */ JBTextArea $configArea;
                    {
                        this.$configArea = $configArea;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        TextAreaKt.columns((Cell)TextAreaKt.rows((Cell)$this$row.scrollCell((JComponent)this.$configArea).align(Align.FILL), (int)8), (int)50);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
        DialogBuilder dialog = new DialogBuilder();
        dialog.setCenterPanel((JComponent)panel2);
        dialog.setTitle(DatabaseBundle.message("dialog.title.jdbc.log.settings", new Object[0]));
        if (!dialog.showAndGet()) {
            return null;
        }
        String string = configArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        newSettings.setConfig(((Object)StringsKt.trim((CharSequence)string)).toString());
        return newSettings;
    }

    private final DefaultActionGroup createPresetGroup(JBTextArea configArea) {
        DefaultActionGroup predef = new DefaultActionGroup(DatabaseBundle.message("action.log.presets.text", new Object[0]), null, AllIcons.Actions.AddFile);
        predef.setPopup(true);
        String string = DatabaseBundle.message("action.log.to.file.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        predef.add((AnAction)JdbcLogAction.createPresetGroup$createPresetAction(configArea, string, "handlers=java.util.logging.FileHandler\njava.util.logging.FileHandler.level=ALL\njava.util.logging.FileHandler.pattern=%t/jdbc-%u-%g.log\njava.util.logging.FileHandler.formatter=java.util.logging.SimpleFormatter"));
        String string2 = DatabaseBundle.message("action.log.to.idea.log.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        predef.add((AnAction)JdbcLogAction.createPresetGroup$createPresetAction(configArea, string2, "handlers=java.util.logging.ConsoleHandler\njava.util.logging.ConsoleHandler.level=ALL"));
        return predef;
    }

    private final Level[] getLogLevels() {
        Level[] levelArray = new Level[]{Level.ALL, Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, null};
        return levelArray;
    }

    private static final LocalDataSource getTarget$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LocalDataSource)$tmp0.invoke(p0);
    }

    private static final void createPresetGroup$createPresetAction$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final DumbAwareAction createPresetGroup$createPresetAction(JBTextArea $configArea, String name2, String text2) {
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)name2, arg_0 -> JdbcLogAction.createPresetGroup$createPresetAction$lambda$2((Function1)new Function1<AnActionEvent, Unit>($configArea, text2){
            final /* synthetic */ JBTextArea $configArea;
            final /* synthetic */ String $text;
            {
                this.$configArea = $configArea;
                this.$text = $text;
                super(1);
            }

            public final void invoke(AnActionEvent it2) {
                this.$configArea.setText(this.$text);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        return dumbAwareAction;
    }

    public static final /* synthetic */ Level[] access$getLogLevels(JdbcLogAction $this) {
        return $this.getLogLevels();
    }

    public static final /* synthetic */ DefaultActionGroup access$createPresetGroup(JdbcLogAction $this, JBTextArea configArea) {
        return $this.createPresetGroup(configArea);
    }
}

