/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.diagnostic;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.actions.DiagnosticRefreshAction;
import com.intellij.database.actions.RefreshActionsLogic;
import com.intellij.database.actions.diagnostic.DiagnosticFormatter;
import com.intellij.database.actions.diagnostic.DiagnosticRefresh;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u001c\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002\u001a&\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002\u001a,\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0007\u001a:\u0010\u001c\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u00012\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u001fH\u0000\u001a\u001c\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"DiagnosticLogDirPrefix", "", "DiagnosticLogFileNameTemplate", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "diagnosticRefresh", "Lcom/intellij/database/util/AsyncTask;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "elementsToRefresh", "", "Lcom/intellij/database/psi/DbElement;", "diagnosticRefreshSqlDS", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "dataSource", "onLogReady", "", "project", "Lcom/intellij/openapi/project/Project;", "logDir", "Ljava/nio/file/Path;", "templateText", "performDiagnosticRefresh", "selection", "Lcom/intellij/util/containers/JBIterable;", "progressTemplateText", "performDiagnosticRefreshOperation", "dataSourceId", "asyncOperation", "Lkotlin/Function0;", "rebuildDdlDataSource", "intellij.database.impl"})
@JvmName(name="DiagnosticRefresh")
@SourceDebugExtension(value={"SMAP\nDiagnosticRefresh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticRefresh.kt\ncom/intellij/database/actions/diagnostic/DiagnosticRefresh\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,145:1\n1549#2:146\n1620#2,3:147\n37#3,2:150\n*S KotlinDebug\n*F\n+ 1 DiagnosticRefresh.kt\ncom/intellij/database/actions/diagnostic/DiagnosticRefresh\n*L\n137#1:146\n137#1:147,3\n139#1:150,2\n*E\n"})
public final class DiagnosticRefresh {
    @NotNull
    private static final String DiagnosticLogDirPrefix = "introspection";
    @NotNull
    private static final String DiagnosticLogFileNameTemplate = "introspector.%u.%g.log";
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    public static final void performDiagnosticRefresh(@Nullable Project project, @NotNull JBIterable<DbElement> selection2, @Nls @Nullable String progressTemplateText) {
        Intrinsics.checkNotNullParameter(selection2, (String)"selection");
        DbDataSource dbDataSource = (DbDataSource)selection2.map(arg_0 -> DiagnosticRefresh.performDiagnosticRefresh$lambda$0(performDiagnosticRefresh.dataSource.1.INSTANCE, arg_0)).first();
        if (dbDataSource == null) {
            return;
        }
        DbDataSource dataSource2 = dbDataSource;
        Set set = selection2.filter(arg_0 -> DiagnosticRefresh.performDiagnosticRefresh$lambda$1((Function1)new Function1<DbElement, Boolean>(dataSource2){
            final /* synthetic */ DbDataSource $dataSource;
            {
                this.$dataSource = $dataSource;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DbElement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                return o2.getDataSource() == this.$dataSource;
            }
        }, arg_0)).toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        Set elementsToRefresh2 = set;
        String string = dataSource2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        DiagnosticRefresh.performDiagnosticRefreshOperation(project, string, progressTemplateText, (Function0)new Function0<AsyncTask<?>>(dataSource2, elementsToRefresh2){
            final /* synthetic */ DbDataSource $dataSource;
            final /* synthetic */ Set<DbElement> $elementsToRefresh;
            {
                this.$dataSource = $dataSource;
                this.$elementsToRefresh = $elementsToRefresh;
                super(0);
            }

            @Nullable
            public final AsyncTask<?> invoke() {
                return DiagnosticRefresh.access$diagnosticRefresh(this.$dataSource, this.$elementsToRefresh);
            }
        });
    }

    public static final void performDiagnosticRefreshOperation(@Nullable Project project, @NotNull String dataSourceId, @Nls @Nullable String progressTemplateText, @NotNull Function0<? extends AsyncTask<?>> asyncOperation) {
        Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
        Intrinsics.checkNotNullParameter(asyncOperation, (String)"asyncOperation");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        try {
            AsyncTask refreshAsyncTask;
            Path logDir = Files.createTempDirectory(DiagnosticLogDirPrefix, new FileAttribute[0]);
            String logFilePath = logDir + File.separatorChar + DiagnosticLogFileNameTemplate;
            FileHandler handler2 = new FileHandler(logFilePath, 0x200000, 10, false);
            handler2.setLevel(Level.ALL);
            handler2.setFormatter(DiagnosticFormatter.INSTANCE);
            handler2.setFilter(arg_0 -> DiagnosticRefresh.performDiagnosticRefreshOperation$lambda$2(dataSourceId, arg_0));
            DatabaseGlobalAuditService.Companion.attach(handler2, disposable2);
            Disposer.register((Disposable)disposable2, handler2::close);
            Level level = Level.ALL;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"ALL");
            DatabaseGlobalAuditService.Companion.setRootLevel(level, disposable2);
            AsyncTask asyncTask = refreshAsyncTask = (AsyncTask)asyncOperation.invoke();
            if (asyncTask != null) {
                asyncTask.whenComplete(AsyncUtil.getEdtExecutor(), (arg_0, arg_1) -> DiagnosticRefresh.performDiagnosticRefreshOperation$lambda$3((Function2)new Function2<Object, Throwable, Unit>(disposable2, project, logDir, progressTemplateText){
                    final /* synthetic */ Disposable $disposable;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Path $logDir;
                    final /* synthetic */ String $progressTemplateText;
                    {
                        this.$disposable = $disposable;
                        this.$project = $project;
                        this.$logDir = $logDir;
                        this.$progressTemplateText = $progressTemplateText;
                        super(2);
                    }

                    public final void invoke(@Nullable Object object, @Nullable Throwable throwable) {
                        Disposer.dispose((Disposable)this.$disposable);
                        AsyncUtil.underProgress(() -> performDiagnosticRefreshOperation.3.invoke$lambda$0(this.$project, this.$logDir, this.$progressTemplateText), (ProgressIndicator)new EmptyProgressIndicator());
                    }

                    private static final void invoke$lambda$0(Project $project, Path $logDir, String $progressTemplateText) {
                        Intrinsics.checkNotNull((Object)$logDir);
                        DiagnosticRefresh.access$onLogReady($project, $logDir, $progressTemplateText);
                    }
                }, arg_0, arg_1));
            }
        }
        catch (Throwable th) {
            LOG.error(th);
            Disposer.dispose((Disposable)disposable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onLogReady(Project project, Path logDir, @Nls String templateText) {
        Path path;
        AutoCloseable autoCloseable = Files.list(logDir);
        Throwable throwable = null;
        try {
            Stream it2 = (Stream)autoCloseable;
            boolean bl = false;
            Optional optional = it2.findAny();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"findAny(...)");
            Path path2 = (Path)UtilKt.orNull(optional);
            if (path2 == null) {
                path2 = logDir;
            }
            path = path2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Path existing = path;
        String path3 = ((Object)logDir).toString();
        String string = templateText;
        if (string == null) {
            string = "";
        }
        String string2 = HtmlChunk.link((String)"view", (String)path3).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, string2, NotificationType.INFORMATION).setListener((arg_0, arg_1) -> DiagnosticRefresh.onLogReady$lambda$5(existing, arg_0, arg_1)).setDisplayId("DiagnosticRefreshAction.finished").notify(project);
        RevealFileAction.openFile((Path)existing);
    }

    private static final AsyncTask<?> diagnosticRefresh(DbDataSource dbDataSource, Set<? extends DbElement> elementsToRefresh2) {
        SqlDataSource sqlDs2 = DbImplUtil.getMaybeSqlDataSource(dbDataSource);
        if (sqlDs2 != null) {
            return DiagnosticRefresh.diagnosticRefreshSqlDS(sqlDs2, dbDataSource);
        }
        if (elementsToRefresh2.isEmpty() || CollectionFun.containsOnly((Collection)elementsToRefresh2, dbDataSource)) {
            RawDataSource rawDataSource = DataSourceFun.getRawDataSource(dbDataSource);
            if (rawDataSource == null) {
                return null;
            }
            RawDataSource rds = rawDataSource;
            Project project = dbDataSource.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return RefreshActionsLogic.runDataSourceGeneralRefresh(project, rds);
        }
        Project project = dbDataSource.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return RefreshActionsLogic.runDbElementsRefresh(project, (JBIterable<DbElement>)UtilKt.asJBIterable((Iterable)elementsToRefresh2));
    }

    private static final AsyncTask<?> diagnosticRefreshSqlDS(SqlDataSource sqlDs2, DbDataSource dataSource2) {
        Object[] objectArray = new Object[]{sqlDs2.getName()};
        String string = DatabaseBundle.message("progress.title.diagnostic.refresh", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        AsyncTask.Frame frame = AsyncTask.Companion.frame(string);
        AsyncTask.Companion.withBgIndicator(frame, dataSource2.getProject(), null, true);
        return frame.computeAsync(null, () -> DiagnosticRefresh.diagnosticRefreshSqlDS$lambda$6(dataSource2, sqlDs2));
    }

    private static final AsyncTask<?> rebuildDdlDataSource(Project project, SqlDataSource sqlDs2) {
        Object object = WriteAction.compute(() -> DiagnosticRefresh.rebuildDdlDataSource$lambda$8(sqlDs2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (AsyncTask)object;
    }

    private static final DbDataSource performDiagnosticRefresh$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DbDataSource)$tmp0.invoke(p0);
    }

    private static final boolean performDiagnosticRefresh$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean performDiagnosticRefreshOperation$lambda$2(String $dataSourceId, LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)$dataSourceId, (String)"$dataSourceId");
        return record instanceof DatabaseGlobalAuditService.DatabaseLogRecord && Intrinsics.areEqual((Object)((DatabaseGlobalAuditService.DatabaseLogRecord)record).getDataSourceId(), (Object)$dataSourceId) && (!(record instanceof DatabaseGlobalAuditService.DatabaseLogBlockRecord) || !(((DatabaseGlobalAuditService.DatabaseLogBlockRecord)record).getBlocks().length == 0));
    }

    private static final void performDiagnosticRefreshOperation$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void onLogReady$lambda$5(Path $existing, Notification notification, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)$existing, (String)"$existing");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            RevealFileAction.openFile((Path)$existing);
        }
    }

    private static final AsyncTask diagnosticRefreshSqlDS$lambda$6(DbDataSource $dataSource, SqlDataSource $sqlDs) {
        Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
        Intrinsics.checkNotNullParameter((Object)$sqlDs, (String)"$sqlDs");
        Project project = $dataSource.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return DiagnosticRefresh.rebuildDdlDataSource(project, $sqlDs);
    }

    /*
     * WARNING - void declaration
     */
    private static final AsyncTask rebuildDdlDataSource$lambda$8(SqlDataSource $sqlDs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$sqlDs, (String)"$sqlDs");
        List list = $sqlDs.getSqlFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSqlFiles(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            SqlFile sqlFile = (SqlFile)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it2.getViewProvider().getVirtualFile());
        }
        List files2 = (List)destination$iv$iv;
        FileContentUtilCore.reparseFiles((Collection)files2);
        Collection $this$toTypedArray$iv = files2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        return DataSourceSyncManager.getInstance().tryPerform($sqlDs, true, false);
    }

    public static final /* synthetic */ AsyncTask access$diagnosticRefresh(DbDataSource dbDataSource, Set elementsToRefresh2) {
        return DiagnosticRefresh.diagnosticRefresh(dbDataSource, elementsToRefresh2);
    }

    public static final /* synthetic */ void access$onLogReady(Project project, Path logDir, String templateText) {
        DiagnosticRefresh.onLogReady(project, logDir, templateText);
    }

    static {
        Logger logger2 = Logger.getInstance(DiagnosticRefreshAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }
}

