/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.SynchronizeHandler;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.actions.RefreshActionsLogic;
import com.intellij.database.actions.diagnostic.DiagnosticRefresh;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.introspection.GeneralIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00a4\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a.\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u001a\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\u001a(\u0010\u001c\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a \u0010\u001c\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001c\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u001a \u0010\"\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0018\u0010#\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u001e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002\u001a\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u001bH\u0002\u001a\u0018\u0010*\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002\u001a$\u0010+\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010,\u001a\u00020\u00102\b\b\u0002\u0010-\u001a\u00020\u0010H\u0001\u001a,\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000e2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0002\u001a.\u00100\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0007\u001a\u001e\u00100\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000301H\u0007\u001a(\u00102\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u00103\u001a\u00020\u0003H\u0002\u001a*\u00104\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000e2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030 \u001a&\u00105\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0018\u00106\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u001a\u001e\u00107\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u000208\u001a(\u00109\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010;H\u0001\u001a\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002\u001a\u001e\u0010>\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002\u001a4\u0010?\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u0002082\u0006\u0010%\u001a\u00020@2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030 \u001a,\u0010?\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u0002082\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030 \u001a4\u0010A\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0002\u001a\f\u0010B\u001a\u00020\u0010*\u00020CH\u0002\u001a\u0015\u0010D\u001a\u00020\u0010*\u00020E2\u0006\u0010F\u001a\u00020!H\u0086\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "adjustNodeToElement", "Lcom/intellij/database/model/basic/BasicElement;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "asyncForgetModelAndRefreshForDataSource", "Lcom/intellij/database/util/AsyncTask;", "Lcom/intellij/database/dataSource/SyncQueue$SyncResult;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/database/dataSource/DataSourceStorage;", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "refresh", "", "sqlDataSource", "Lcom/intellij/sql/database/SqlDataSource;", "checkForgetModelIsPossible", "Lcom/intellij/database/actions/ActionStatus;", "ctx", "Lcom/intellij/openapi/actionSystem/DataContext;", "diagnosticRefreshCheck", "diagnosticRefreshPerform", "", "progressTemplateText", "", "doForgetModelAndRefreshForDataSource", "extendIntrospectionScopeIfNeeded", "dataSource", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "forgetModelAndRefresh", "forgetSchemas", "forgetSchemasInOneModel", "model", "Lcom/intellij/database/model/basic/BasicModel;", "logFailed", "", "message", "performPluginsExtensionOperations", "refreshCheck", "requireSingleDataSource", "requiresConnect", "refreshGivenElementsAutomatically", "elementsToRefresh", "refreshSpecificFragments", "", "refreshThisObject", "objectToRefresh", "refreshToComplete", "refreshWholeModelAutomatically", "regularRefreshPerform", "runDataSourceGeneralRefresh", "Lcom/intellij/database/model/RawDataSource;", "runDbElementsRefresh", "selection", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/psi/DbElement;", "runGeneralForLocalDataSource", "runInitialForLocalDataSourceWithEmptyModel", "runRegularRefresh", "Lcom/intellij/database/model/DasModel;", "runRegularRefreshForLocalDataSourceWithModel", "canBeConnectedRightNow", "Lcom/intellij/database/view/DataSourceNode;", "contains", "Lcom/intellij/database/util/TreePattern;", "namespace", "intellij.database.impl"})
@JvmName(name="RefreshActionsLogic")
@SourceDebugExtension(value={"SMAP\nRefreshActionsLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshActionsLogic.kt\ncom/intellij/database/actions/RefreshActionsLogic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 DatabaseContextFun.kt\ncom/intellij/database/view/DatabaseContextFun\n*L\n1#1,583:1\n1726#2,3:584\n1477#2:587\n1502#2,3:588\n1505#2,3:598\n800#2,11:601\n1477#2:628\n1502#2,3:629\n1505#2,3:639\n372#3,7:591\n372#3,7:617\n372#3,7:632\n26#4:612\n988#5:613\n1017#5,3:614\n1020#5,3:624\n318#6:627\n*S KotlinDebug\n*F\n+ 1 RefreshActionsLogic.kt\ncom/intellij/database/actions/RefreshActionsLogic\n*L\n55#1:584,3\n110#1:587\n110#1:588,3\n110#1:598,3\n115#1:601,11\n474#1:628\n474#1:629,3\n474#1:639,3\n110#1:591,7\n419#1:617,7\n474#1:632,7\n231#1:612\n419#1:613\n419#1:614,3\n419#1:624,3\n472#1:627\n*E\n"})
public final class RefreshActionsLogic {
    @NotNull
    private static final Logger logger;

    @ApiStatus.Internal
    @NotNull
    public static final ActionStatus refreshCheck(@NotNull DataContext ctx, boolean requireSingleDataSource, boolean requiresConnect) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(ctx);
        if (!((Collection)ranks).isEmpty()) {
            boolean bl;
            block8: {
                if (ranks.contains(DvTreeNodeRank.TL_FOLDER)) {
                    return ranks.size() == 1 ? ActionStatus.HIDDEN : ActionStatus.DISABLED;
                }
                List<DataSourceNode> dsns = DatabaseContextFun.getSelectionRelatedDataSources(ctx);
                if (dsns.isEmpty()) {
                    return ActionStatus.HIDDEN;
                }
                if (requireSingleDataSource && dsns.size() > 1) {
                    return ActionStatus.DISABLED;
                }
                Iterable $this$all$iv = dsns;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        DataSourceNode it2 = (DataSourceNode)element$iv;
                        boolean bl2 = false;
                        if (it2.isIntrospectable() && !DataSourceFun.isLoading(it2) && (!requiresConnect || RefreshActionsLogic.canBeConnectedRightNow(it2))) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            boolean allOk = bl;
            return allOk ? ActionStatus.ENABLED : ActionStatus.DISABLED;
        }
        if (!DatabaseContextFun.fromDatabaseTree(ctx)) {
            BasicElement editorObject;
            BasicElement basicElement = editorObject = DatabaseContextFun.getEditorObject(ctx);
            BasicModel model2 = basicElement != null ? basicElement.getModel() : null;
            return model2 != null ? ActionStatus.ENABLED : ActionStatus.HIDDEN;
        }
        return ActionStatus.HIDDEN;
    }

    public static /* synthetic */ ActionStatus refreshCheck$default(DataContext dataContext, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return RefreshActionsLogic.refreshCheck(dataContext, bl, bl2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final ActionStatus checkForgetModelIsPossible(@NotNull DataContext ctx) {
        boolean neg;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(ctx);
        boolean pos = ranks.contains(DvTreeNodeRank.TL_ROOT);
        boolean bl = neg = ranks.size() > 1;
        ActionStatus status = pos && !neg ? RefreshActionsLogic.refreshCheck(ctx, false, false) : (pos ? ActionStatus.DISABLED : ActionStatus.HIDDEN);
        return status;
    }

    private static final boolean canBeConnectedRightNow(DataSourceNode $this$canBeConnectedRightNow) {
        RawDataSource ds = $this$canBeConnectedRightNow.rawDataSource;
        return ds instanceof SqlDataSource ? true : (ds instanceof LocalDataSource ? DbImplUtilCore.canConnectTo((LocalDataSource)ds) : false);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final void regularRefreshPerform(@NotNull Project project, @NotNull DataContext ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(ctx);
        if (!((Collection)ranks).isEmpty()) {
            List<DataSourceNode> dsns = DatabaseContextFun.getSelectionRelatedDataSources(ctx);
            if (dsns.isEmpty()) {
                return;
            }
            if (ranks.contains(DvTreeNodeRank.TL_ROOT)) {
                for (DataSourceNode dsn : dsns) {
                    RefreshActionsLogic.runDataSourceGeneralRefresh(project, dsn.rawDataSource);
                }
            } else {
                Object element$iv$iv;
                Map.Entry $this$groupByTo$iv$iv2;
                void $this$groupBy$iv;
                JBIterable jBIterable = DatabaseContextFun.getSelectedNodes(ctx).filterMap(arg_0 -> RefreshActionsLogic.regularRefreshPerform$lambda$1(regularRefreshPerform.selection.1.INSTANCE, arg_0)).filter(arg_0 -> RefreshActionsLogic.regularRefreshPerform$lambda$2(regularRefreshPerform.selection.2.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable dsn = (Iterable)jBIterable;
                boolean $i$f$groupBy = false;
                void var7_14 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                Iterator iterator = $this$groupByTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    BasicModel key$iv$iv;
                    element$iv$iv = iterator.next();
                    BasicElement it2 = (BasicElement)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2.getModel());
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map selection2 = destination$iv$iv;
                BasicModelRegistry registry = BasicModelRegistry.Companion.instance();
                for (Map.Entry $this$groupByTo$iv$iv2 : selection2.entrySet()) {
                    RawDataSource ds;
                    BasicModel model2 = (BasicModel)$this$groupByTo$iv$iv2.getKey();
                    List elements2 = (List)$this$groupByTo$iv$iv2.getValue();
                    if (registry.getDataSource(model2) == null) continue;
                    if (ranks.contains(DvTreeNodeRank.TL_NAMESPACE) && ds instanceof LocalDataSource) {
                        void $this$filterIsInstanceTo$iv$iv;
                        void $this$filterIsInstance$iv;
                        element$iv$iv = elements2;
                        LocalDataSource localDataSource = (LocalDataSource)ds;
                        boolean $i$f$filterIsInstance = false;
                        void bl = $this$filterIsInstance$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv2 instanceof BasicNamespace)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        RefreshActionsLogic.extendIntrospectionScopeIfNeeded(localDataSource, (List)destination$iv$iv2);
                    }
                    RefreshActionsLogic.runRegularRefresh(project, ds, model2, elements2);
                }
            }
        } else if (!DatabaseContextFun.fromDatabaseTree(ctx)) {
            BasicElement editorObject = DatabaseContextFun.getEditorObject(ctx);
            if (editorObject != null) {
                BasicModel model3 = editorObject.getModel();
                if (model3 != null) {
                    BasicSchema schema2 = editorObject.getSchema();
                    if (schema2 != null) {
                        RefreshActionsLogic.refreshThisObject(project, model3, editorObject);
                    } else {
                        RawDataSource dataSource2;
                        BasicModelRegistry registry = BasicModelRegistry.Companion.instance();
                        RawDataSource rawDataSource = dataSource2 = registry.getDataSource(model3);
                        if (rawDataSource != null) {
                            RefreshActionsLogic.runRegularRefresh(project, rawDataSource, model3, SetsKt.setOf((Object)editorObject));
                        } else {
                            throw new IllegalStateException("Cannot refresh object " + editorObject + ": no data source");
                        }
                    }
                }
                return;
            }
            logger.warn("Cannot run refresh because unknown what to refresh.");
        } else {
            logger.warn("Cannot run refresh because unknown what to refresh and what is the source of the action.");
        }
    }

    private static final BasicElement adjustNodeToElement(BasicNode node2) {
        BasicNode basicNode = node2;
        return basicNode instanceof BasicElement ? (BasicElement)node2 : (basicNode instanceof HostFamily ? ((HostFamily)node2).getHost() : (basicNode instanceof DvHostNode ? ((DvHostNode)node2).host : (basicNode instanceof DataSourceNode ? (BasicElement)((DataSourceNode)node2).getModelRoot() : null)));
    }

    @NotNull
    public static final ActionStatus diagnosticRefreshCheck(@NotNull DataContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return RefreshActionsLogic.refreshCheck$default(ctx, true, false, 4, null);
    }

    public static final void diagnosticRefreshPerform(@NotNull Project project, @NotNull DataContext ctx, @Nls @Nullable String progressTemplateText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Ref.ObjectRef dataSource2 = new Ref.ObjectRef();
        BasicModel model2 = null;
        Ref.ObjectRef elementsToRefresh2 = new Ref.ObjectRef();
        elementsToRefresh2.element = SetsKt.emptySet();
        boolean fromTree = DatabaseContextFun.fromDatabaseTree(ctx);
        if (fromTree) {
            DataSourceNode dataSourceNode = DatabaseContextFun.getSelectionRelatedSingleDataSource(ctx);
            if (dataSourceNode == null) {
                logger.warn("Diagnostic Refresh: no single related data source");
                return;
            }
            DataSourceNode dsn = dataSourceNode;
            dataSource2.element = dsn.rawDataSource;
            model2 = dsn.getModel();
            List list = DatabaseContextFun.getSelectedElements(ctx).filter(arg_0 -> RefreshActionsLogic.diagnosticRefreshPerform$lambda$4((Function1)new Function1<BasicElement, Boolean>(model2){
                final /* synthetic */ BasicModel $model;
                {
                    this.$model = $model;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(BasicElement el) {
                    return el.getModel() == this.$model;
                }
            }, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            elementsToRefresh2.element = list;
        } else {
            BasicElement editorObject;
            BasicElement basicElement = editorObject = DatabaseContextFun.getEditorObject(ctx);
            BasicModel basicModel = model2 = basicElement != null ? basicElement.getModel() : null;
            if (editorObject != null && model2 != null) {
                RawDataSource ds;
                BasicModelRegistry modelRegistry2 = BasicModelRegistry.Companion.instance();
                RawDataSource rawDataSource = ds = modelRegistry2.getDataSource(model2);
                if (rawDataSource == null) {
                    logger.warn("Diagnostic Refresh: cannot get the data source of the editor object");
                    return;
                }
                dataSource2.element = rawDataSource;
                elementsToRefresh2.element = CollectionsKt.listOf((Object)editorObject);
            }
        }
        if ((RawDataSource)dataSource2.element == null) {
            logger.warn("Diagnostic Refresh: cannot find a data source");
            return;
        }
        if (model2 == null) {
            logger.warn("Diagnostic Refresh: cannot obtain a model (when the data source is: " + dataSource2.element + ")");
            return;
        }
        String string = ((RawDataSource)dataSource2.element).getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        DiagnosticRefresh.performDiagnosticRefreshOperation(project, string, progressTemplateText, (Function0)new Function0<AsyncTask<?>>(project, (Ref.ObjectRef<RawDataSource>)dataSource2, model2, (Ref.ObjectRef<Collection<BasicElement>>)elementsToRefresh2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef<RawDataSource> $dataSource;
            final /* synthetic */ BasicModel $model;
            final /* synthetic */ Ref.ObjectRef<Collection<BasicElement>> $elementsToRefresh;
            {
                this.$project = $project;
                this.$dataSource = $dataSource;
                this.$model = $model;
                this.$elementsToRefresh = $elementsToRefresh;
                super(0);
            }

            @Nullable
            public final AsyncTask<?> invoke() {
                return RefreshActionsLogic.runRegularRefresh(this.$project, (RawDataSource)this.$dataSource.element, this.$model, (Collection)this.$elementsToRefresh.element);
            }
        });
    }

    public static final void extendIntrospectionScopeIfNeeded(@NotNull LocalDataSource dataSource2, @NotNull Collection<? extends BasicNamespace> namespaces2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter(namespaces2, (String)"namespaces");
        if (namespaces2.isEmpty()) {
            return;
        }
        TreePattern treePattern = dataSource2.getIntrospectionScope();
        Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"getIntrospectionScope(...)");
        TreePattern oldScope = treePattern;
        JBIterable jBIterable = UtilKt.asJBIterable((Iterable)namespaces2).filter(arg_0 -> RefreshActionsLogic.extendIntrospectionScopeIfNeeded$lambda$5((Function1)new Function1<BasicNamespace, Boolean>(oldScope){
            final /* synthetic */ TreePattern $oldScope;
            {
                this.$oldScope = $oldScope;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicNamespace it2) {
                Intrinsics.checkNotNull((Object)it2);
                return !RefreshActionsLogic.contains(this.$oldScope, it2);
            }
        }, arg_0)).map(arg_0 -> RefreshActionsLogic.extendIntrospectionScopeIfNeeded$lambda$6(extendIntrospectionScopeIfNeeded.entriesToAdd.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        JBIterable entriesToAdd2 = jBIterable;
        if (entriesToAdd2.isEmpty()) {
            return;
        }
        boolean $i$f$emptyArray = false;
        Object[] objectArray = JBIterable.of((Object)oldScope).append((Iterable)entriesToAdd2).toArray((Object[])new TreePattern[0]);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
        TreePattern[] newScopePatterns = (TreePattern[])objectArray;
        TreePattern treePattern2 = TreePatternUtils.union(Arrays.copyOf(newScopePatterns, newScopePatterns.length));
        Intrinsics.checkNotNullExpressionValue((Object)treePattern2, (String)"union(...)");
        TreePattern newScope = treePattern2;
        dataSource2.setIntrospectionScope(newScope);
    }

    public static final boolean contains(@NotNull TreePattern $this$contains, @NotNull BasicNamespace namespace) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return DataSourceSchemaMapping.matches($this$contains, namespace);
    }

    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> runRegularRefresh(@NotNull Project project, @NotNull RawDataSource dataSource2, @NotNull Collection<? extends BasicElement> elementsToRefresh2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter(elementsToRefresh2, (String)"elementsToRefresh");
        DasModel dasModel = dataSource2.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
        DasModel model2 = dasModel;
        return RefreshActionsLogic.runRegularRefresh(project, dataSource2, model2, elementsToRefresh2);
    }

    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> runRegularRefresh(@NotNull Project project, @NotNull RawDataSource dataSource2, @NotNull DasModel model2, @NotNull Collection<? extends BasicElement> elementsToRefresh2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter(elementsToRefresh2, (String)"elementsToRefresh");
        RawDataSource rawDataSource = dataSource2;
        if (rawDataSource instanceof LocalDataSource) {
            return model2 instanceof BasicModel ? RefreshActionsLogic.runRegularRefreshForLocalDataSourceWithModel(project, (LocalDataSource)dataSource2, (BasicModel)model2, elementsToRefresh2) : (Intrinsics.areEqual((Object)model2.getMetaModel(), (Object)MetaModel.EMPTY) ? RefreshActionsLogic.runInitialForLocalDataSourceWithEmptyModel(project, (LocalDataSource)dataSource2) : (AsyncTask<SyncQueue.SyncResult>)((Object)RefreshActionsLogic.logFailed("Unknown how to refresh a LocalDataSource with a model of class " + model2.getClass().getName())));
        }
        if (rawDataSource instanceof SqlDataSource) {
            DataSourceSyncManager dataSourceSyncManager = DataSourceSyncManager.getInstance();
            return dataSourceSyncManager.tryPerform((SqlDataSource)dataSource2, true, true);
        }
        return null;
    }

    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> runDataSourceGeneralRefresh(@NotNull Project project, @NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        RawDataSource rawDataSource = dataSource2;
        if (rawDataSource instanceof LocalDataSource) {
            return RefreshActionsLogic.runGeneralForLocalDataSource(project, (LocalDataSource)dataSource2);
        }
        if (rawDataSource instanceof SqlDataSource) {
            DataSourceSyncManager dataSourceSyncManager = DataSourceSyncManager.getInstance();
            return dataSourceSyncManager.tryPerform((SqlDataSource)dataSource2, true, true);
        }
        return null;
    }

    private static final void performPluginsExtensionOperations(Project project, LocalDataSource dataSource2) {
        for (SynchronizeHandler extension : (SynchronizeHandler[])SynchronizeHandler.EP_NAME.getExtensions()) {
            try {
                extension.beforeSynchronize(project, dataSource2);
            }
            catch (Exception e2) {
                String string;
                String string2 = e2.getMessage();
                if (string2 != null) {
                    CharSequence charSequence = string2;
                    Regex regex = new Regex("\\r?\\n");
                    String string3 = "\n\t";
                    string = regex.replace(charSequence, string3);
                } else {
                    string = null;
                }
                String exceptionMessage = string;
                String message2 = "Extension error while refreshing data source: " + dataSource2 + "\nException class: " + e2.getClass() + "\nMessage: " + exceptionMessage;
                logger.error(message2, (Throwable)e2);
            }
        }
    }

    private static final AsyncTask<SyncQueue.SyncResult> runInitialForLocalDataSourceWithEmptyModel(Project project, LocalDataSource dataSource2) {
        GeneralIntrospectionTask task = new GeneralIntrospectionTask();
        LoaderContext loaderContext = LoaderContext.selectTasks(project, dataSource2, CollectionsKt.listOf((Object)task));
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(loaderContext);
        Intrinsics.checkNotNullExpressionValue(asyncTask, (String)"performManualSyncTask(...)");
        return asyncTask;
    }

    private static final AsyncTask<SyncQueue.SyncResult> runGeneralForLocalDataSource(Project project, LocalDataSource dataSource2) {
        GeneralIntrospectionTask task = new GeneralIntrospectionTask();
        LoaderContext loaderContext = LoaderContext.selectTasks(project, dataSource2, CollectionsKt.listOf((Object)task));
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(loaderContext);
        Intrinsics.checkNotNullExpressionValue(asyncTask, (String)"performManualSyncTask(...)");
        return asyncTask;
    }

    private static final AsyncTask<SyncQueue.SyncResult> runRegularRefreshForLocalDataSourceWithModel(Project project, LocalDataSource dataSource2, BasicModel model2, Collection<? extends BasicElement> elementsToRefresh2) {
        BasicRoot basicRoot = model2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        BasicRoot root2 = basicRoot;
        if (elementsToRefresh2.contains(root2)) {
            return RefreshActionsLogic.refreshWholeModelAutomatically(project, dataSource2, model2);
        }
        return RefreshActionsLogic.refreshGivenElementsAutomatically(project, dataSource2, elementsToRefresh2);
    }

    @NotNull
    public static final AsyncTask<SyncQueue.SyncResult> refreshToComplete(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull Collection<? extends BasicElement> elementsToRefresh2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter(elementsToRefresh2, (String)"elementsToRefresh");
        BasicModel basicModel = DataSourceFun.getBasicModel(dataSource2);
        if (basicModel == null) {
            throw new IllegalStateException("Cannot refresh to complete: the given data source has no model");
        }
        BasicModel model2 = basicModel;
        int alienElements = 0;
        for (BasicElement basicElement : elementsToRefresh2) {
            if (Intrinsics.areEqual((Object)basicElement.getModel(), (Object)model2)) continue;
            ++alienElements;
        }
        if (alienElements > 0) {
            throw new IllegalArgumentException("Cannot refresh to complete: " + alienElements + " of total " + elementsToRefresh2.size() + " don't belong to the given model");
        }
        return RefreshActionsLogic.refreshGivenElementsAutomatically(project, dataSource2, elementsToRefresh2);
    }

    private static final AsyncTask<SyncQueue.SyncResult> refreshWholeModelAutomatically(Project project, LocalDataSource dataSource2, BasicModel model2) {
        RefreshActionsLogic.performPluginsExtensionOperations(project, dataSource2);
        GeneralIntrospectionTask task = new GeneralIntrospectionTask();
        LoaderContext loaderContext = LoaderContext.selectTask(project, dataSource2, task);
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(loaderContext);
        Intrinsics.checkNotNullExpressionValue(asyncTask, (String)"performManualSyncTask(...)");
        return asyncTask;
    }

    private static final AsyncTask<SyncQueue.SyncResult> refreshGivenElementsAutomatically(Project project, LocalDataSource dataSource2, Collection<? extends BasicElement> elementsToRefresh2) {
        List<IntrospectionTask> tasks = IntrospectionTasks.prepareManyElementsRefreshTasks(elementsToRefresh2);
        RefreshActionsLogic.performPluginsExtensionOperations(project, dataSource2);
        LoaderContext loaderContext = LoaderContext.selectTasks(project, dataSource2, (Collection<? extends IntrospectionTask>)tasks);
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(loaderContext);
        Intrinsics.checkNotNullExpressionValue(asyncTask, (String)"performManualSyncTask(...)");
        return asyncTask;
    }

    private static final AsyncTask<SyncQueue.SyncResult> refreshThisObject(Project project, BasicModel model2, BasicElement objectToRefresh) {
        LocalDataSource ds;
        BasicModelRegistry basicModelRegistry = BasicModelRegistry.Companion.instance();
        RawDataSource dataSource2 = basicModelRegistry.getDataSource(model2);
        if (dataSource2 == null) {
            return (AsyncTask)((Object)RefreshActionsLogic.logFailed("Cannot refresh this object: no data source for model " + model2));
        }
        LocalDataSource localDataSource = ds = dataSource2 instanceof LocalDataSource ? (LocalDataSource)dataSource2 : null;
        if (ds == null) {
            return (AsyncTask)((Object)RefreshActionsLogic.logFailed("Cannot refresh this object: the data source class is " + dataSource2.getClass().getSimpleName()));
        }
        IntrospectionTask introspectionTask = IntrospectionTasks.prepareOneElementRefreshTask(objectToRefresh);
        if (introspectionTask == null) {
            throw new IllegalArgumentException("Unknown how to refresh this element: " + objectToRefresh + " (of class " + objectToRefresh.getClass().getName() + ")");
        }
        LoaderContext loaderContext = LoaderContext.selectTask(project, ds, introspectionTask);
        return DataSourceUtil.performManualSyncTask(loaderContext);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    public static final void refreshSpecificFragments(@NotNull Project project, @NotNull Iterable<? extends BasicElement> elementsToRefresh2) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(elementsToRefresh2, (String)"elementsToRefresh");
        Sequence $this$groupBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence(elementsToRefresh2), (Function1)refreshSpecificFragments.elementsGroupedByModel.1.INSTANCE);
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BasicModel key$iv$iv;
            BasicElement it2 = (BasicElement)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2.getModel());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map elementsGroupedByModel2 = destination$iv$iv;
        for (Map.Entry entry : elementsGroupedByModel2.entrySet()) {
            BasicModel model2 = (BasicModel)entry.getKey();
            Collection elements2 = (Collection)entry.getValue();
            RefreshActionsLogic.refreshSpecificFragments(project, model2, elements2);
        }
    }

    @ApiStatus.Experimental
    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> refreshSpecificFragments(@NotNull Project project, @NotNull BasicModel model2, @NotNull Collection<? extends BasicElement> elementsToRefresh2) {
        LocalDataSource ds;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter(elementsToRefresh2, (String)"elementsToRefresh");
        BasicModelRegistry basicModelRegistry = BasicModelRegistry.Companion.instance();
        RawDataSource dataSource2 = basicModelRegistry.getDataSource(model2);
        if (dataSource2 == null) {
            return (AsyncTask)((Object)RefreshActionsLogic.logFailed("Cannot refresh fragments: no data source for model " + model2));
        }
        LocalDataSource localDataSource = ds = dataSource2 instanceof LocalDataSource ? (LocalDataSource)dataSource2 : null;
        if (ds == null) {
            return (AsyncTask)((Object)RefreshActionsLogic.logFailed("Cannot refresh fragments: the data source class is " + dataSource2.getClass().getSimpleName()));
        }
        if (!DBIntrospectorFeatures.supportsFragmentIntrospection(ds)) {
            return (AsyncTask)((Object)RefreshActionsLogic.logFailed("This data source doesn't support fragment introspection: rdbms is " + ds.getDbms() + ", use jdbc is " + ds.useJdbcIntrospector()));
        }
        List<IntrospectionTask> introspectionTasks = IntrospectionTasks.prepareManyElementsRefreshTasks(elementsToRefresh2);
        LoaderContext loaderContext = LoaderContext.selectTasks(project, ds, (Collection<? extends IntrospectionTask>)introspectionTasks);
        return DataSourceUtil.performManualSyncTask(loaderContext);
    }

    @ApiStatus.Internal
    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> runDbElementsRefresh(@NotNull Project project, @Nullable JBIterable<DbElement> selection2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (selection2 == null || selection2.isEmpty()) {
            return null;
        }
        DatabaseNodeWrappingService wrappingService2 = (DatabaseNodeWrappingService)project.getService(DatabaseNodeWrappingService.class);
        JBIterable jBIterable = selection2.filterMap(arg_0 -> RefreshActionsLogic.runDbElementsRefresh$lambda$8((Function1)new Function1<DbElement, BasicNode>(wrappingService2){
            final /* synthetic */ DatabaseNodeWrappingService $wrappingService;
            {
                this.$wrappingService = $wrappingService;
                super(1);
            }

            @Nullable
            public final BasicNode invoke(DbElement o2) {
                Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
                return this.$wrappingService.unwrap(o2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        JBIterable selectedNodes2 = jBIterable;
        JBIterable jBIterable2 = selectedNodes2.filter(DataSourceNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        JBIterable selectedDataSources = jBIterable2;
        if (selectedDataSources.isNotEmpty()) {
            DataSourceNode dataSourceNode = (DataSourceNode)selectedDataSources.single();
            if (dataSourceNode == null) {
                return (AsyncTask)((Object)RefreshActionsLogic.logFailed("We cannot refresh elements from different models at the same time!"));
            }
            DataSourceNode theDSN = dataSourceNode;
            return RefreshActionsLogic.runDataSourceGeneralRefresh(project, theDSN.rawDataSource);
        }
        JBIterable jBIterable3 = selectedNodes2.filter(BasicElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
        JBIterable selectedElements = jBIterable3;
        if (selectedElements.isEmpty()) {
            return null;
        }
        BasicModel model2 = (BasicModel)selectedElements.filterMap(arg_0 -> RefreshActionsLogic.runDbElementsRefresh$lambda$9(runDbElementsRefresh.model.1.INSTANCE, arg_0)).unique().single();
        if (model2 == null) {
            return (AsyncTask)((Object)RefreshActionsLogic.logFailed("We cannot refresh elements from different models at the same time!"));
        }
        BasicModelRegistry modelRegistry2 = BasicModelRegistry.Companion.instance();
        RawDataSource rawDataSource = modelRegistry2.getDataSource(model2);
        if (rawDataSource == null) {
            return null;
        }
        RawDataSource dataSource2 = rawDataSource;
        DasModel dasModel = model2;
        List list = selectedElements.toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return RefreshActionsLogic.runRegularRefresh(project, dataSource2, dasModel, list);
    }

    /*
     * WARNING - void declaration
     */
    public static final void forgetSchemas(@NotNull Project project, @NotNull DataContext ctx) {
        void $this$groupByTo$iv$iv;
        void $this$filterBy$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        JBIterable<BasicElement> jBIterable = DatabaseContextFun.getSelectedElements(ctx);
        boolean $i$f$filterBy22 = false;
        JBIterable jBIterable2 = $this$filterBy$iv.filter(BasicNamespace.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        JBIterable jBIterable3 = jBIterable2.filter(arg_0 -> RefreshActionsLogic.forgetSchemas$lambda$10(forgetSchemas.namespaceGroups.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
        Iterable $this$groupBy$iv = (Iterable)jBIterable3;
        boolean $i$f$groupBy = false;
        Iterable $i$f$filterBy22 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BasicModel key$iv$iv;
            BasicNamespace it2 = (BasicNamespace)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2.getModel());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map namespaceGroups2 = destination$iv$iv;
        if (namespaceGroups2.isEmpty()) {
            return;
        }
        String string = DatabaseBundle.message("action.DatabaseView.ForgetSchemaAction.taskText", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String taskText = string;
        Application application = ApplicationManagerEx.getApplication();
        for (Map.Entry entry : namespaceGroups2.entrySet()) {
            BasicModel model2 = (BasicModel)entry.getKey();
            List namespaces2 = (List)entry.getValue();
            Task.Backgroundable bgTask2 = new Task.Backgroundable(project, taskText, model2, application, namespaces2){
                final /* synthetic */ Project $project;
                final /* synthetic */ BasicModel $model;
                final /* synthetic */ Application $application;
                final /* synthetic */ List<BasicNamespace> $namespaces;
                {
                    this.$project = $project;
                    this.$model = $model;
                    this.$application = $application;
                    this.$namespaces = $namespaces;
                    super($project, $taskText, false);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    DbImplUtilCore.performSrcOperation(null, this.$model, ModalityState.defaultModalityState(), false, () -> forgetSchemas.bgTask.1.run$lambda$0(this.$model, this.$namespaces));
                    this.$application.invokeLater(() -> forgetSchemas.bgTask.1.run$lambda$1(this.$project, this.$namespaces));
                }

                private static final void run$lambda$0(BasicModel $model, List $namespaces) {
                    Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
                    Intrinsics.checkNotNullParameter((Object)$namespaces, (String)"$namespaces");
                    RefreshActionsLogic.access$forgetSchemasInOneModel($model, $namespaces);
                }

                private static final void run$lambda$1(Project $project, List $namespaces) {
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    Intrinsics.checkNotNullParameter((Object)$namespaces, (String)"$namespaces");
                    DatabaseView.collapseNodes($project, $namespaces);
                }
            };
            bgTask2.queue();
        }
    }

    private static final void forgetSchemasInOneModel(BasicModel model2, Collection<? extends BasicNamespace> namespaces2) {
        if (model2 instanceof BasicModModel) {
            ((BasicModModel)model2).modify(BasicModRoot.class, new ModelModifier(namespaces2, model2){
                final /* synthetic */ Collection<BasicNamespace> $namespaces;
                final /* synthetic */ BasicModel $model;
                {
                    this.$namespaces = $namespaces;
                    this.$model = $model;
                }

                public final void perform(BasicModRoot it2) {
                    for (BasicNamespace namespace : this.$namespaces) {
                        boolean bl;
                        boolean bl2 = bl = namespace.getModel() == this.$model;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        BasicNamespace basicNamespace = namespace;
                        if (basicNamespace instanceof BasicModDatabase) {
                            NamingFamily namingFamily = ((BasicModDatabase)namespace).getSchemas();
                            Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                            Iterable $this$forEach$iv = namingFamily;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                BasicModSchema it3 = (BasicModSchema)element$iv;
                                boolean bl3 = false;
                                it3.forgetStuff();
                            }
                            continue;
                        }
                        if (!(basicNamespace instanceof BasicModSchema)) continue;
                        ((BasicModSchema)namespace).forgetStuff();
                    }
                }
            });
        }
    }

    public static final void forgetModelAndRefresh(@NotNull Project project, @NotNull DataContext ctx, boolean refresh2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        JBIterable<RawDataSource> dss2 = DatabaseContextFun.getSelectedDataSources(ctx);
        for (RawDataSource ds : dss2) {
            RawDataSource rawDataSource = ds;
            if (rawDataSource instanceof SqlDataSource) {
                Intrinsics.checkNotNull((Object)ds);
                RefreshActionsLogic.doForgetModelAndRefreshForDataSource(project, (SqlDataSource)ds, refresh2);
                continue;
            }
            if (!(rawDataSource instanceof LocalDataSource)) continue;
            Intrinsics.checkNotNull((Object)((Object)storage));
            Intrinsics.checkNotNull((Object)ds);
            RefreshActionsLogic.doForgetModelAndRefreshForDataSource(project, storage, (LocalDataSource)ds, refresh2);
        }
    }

    private static final void doForgetModelAndRefreshForDataSource(Project project, DataSourceStorage storage, LocalDataSource localDataSource, boolean refresh2) {
        String string;
        boolean bl = refresh2;
        if (bl) {
            Object[] objectArray = new Object[]{localDataSource.getName()};
            string = DatabaseBundle.message("action.DatabaseView.ForceRefreshAction.progress", objectArray);
        } else if (!bl) {
            string = DatabaseBundle.message("action.DatabaseView.ForgetModelAction.progress", new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String progressTitle = string2;
        AsyncTask.Frame frame = AsyncTask.Companion.frame(progressTitle);
        AsyncTask.Companion.withBgIndicatorIfNeeded(frame, project, null).computeAsync((Function0)new Function0<AsyncTask<SyncQueue.SyncResult>>(project, storage, localDataSource, refresh2){
            final /* synthetic */ Project $project;
            final /* synthetic */ DataSourceStorage $storage;
            final /* synthetic */ LocalDataSource $localDataSource;
            final /* synthetic */ boolean $refresh;
            {
                this.$project = $project;
                this.$storage = $storage;
                this.$localDataSource = $localDataSource;
                this.$refresh = $refresh;
                super(0);
            }

            @NotNull
            public final AsyncTask<SyncQueue.SyncResult> invoke() {
                return RefreshActionsLogic.access$asyncForgetModelAndRefreshForDataSource(this.$project, this.$storage, this.$localDataSource, this.$refresh);
            }
        });
    }

    private static final AsyncTask<SyncQueue.SyncResult> asyncForgetModelAndRefreshForDataSource(Project project, DataSourceStorage storage, LocalDataSource localDataSource, boolean refresh2) {
        AsyncTask<SyncQueue.SyncResult> asyncTask;
        AsyncTask<SyncQueue.SyncResult> stage2 = DataSourceSyncManager.getInstance().stopSynchronization(localDataSource).whenComplete(AsyncUtil.getPoolExecutor(), (Function0<Unit>)((Function0)new Function0<Unit>(localDataSource){
            final /* synthetic */ LocalDataSource $localDataSource;
            {
                this.$localDataSource = $localDataSource;
                super(0);
            }

            public final void invoke() {
                this.$localDataSource.clearModel();
            }
        })).whenComplete(AsyncUtil.getEdtExecutor(), (Function0<Unit>)((Function0)new Function0<Unit>(storage, localDataSource){
            final /* synthetic */ DataSourceStorage $storage;
            final /* synthetic */ LocalDataSource $localDataSource;
            {
                this.$storage = $storage;
                this.$localDataSource = $localDataSource;
                super(0);
            }

            public final void invoke() {
                this.$storage.updateDataSource(this.$localDataSource);
            }
        }));
        boolean bl = refresh2;
        if (bl) {
            asyncTask = stage2.whenComplete(null, (Function0<Unit>)((Function0)new Function0<Unit>(project, localDataSource){
                final /* synthetic */ Project $project;
                final /* synthetic */ LocalDataSource $localDataSource;
                {
                    this.$project = $project;
                    this.$localDataSource = $localDataSource;
                    super(0);
                }

                public final void invoke() {
                    RefreshActionsLogic.runDataSourceGeneralRefresh(this.$project, this.$localDataSource);
                }
            }));
        } else if (!bl) {
            asyncTask = stage2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return asyncTask;
    }

    private static final void doForgetModelAndRefreshForDataSource(Project project, SqlDataSource sqlDataSource, boolean refresh2) {
        String string;
        if (refresh2) {
            Object[] objectArray = new Object[]{sqlDataSource.getName()};
            string = DatabaseBundle.message("action.DatabaseView.ForceRefreshAction.progress", objectArray);
        } else {
            string = DatabaseBundle.message("action.DatabaseView.ForgetModelAction.progress", new Object[0]);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String progressTitle = string2;
        AsyncTask.Frame frame = AsyncTask.Companion.frame(progressTitle);
        AsyncTask.Companion.withBgIndicatorIfNeeded(frame, project, null).computeAsync((Function0)new Function0<AsyncTask<SyncQueue.SyncResult>>(project, sqlDataSource, refresh2){
            final /* synthetic */ Project $project;
            final /* synthetic */ SqlDataSource $sqlDataSource;
            final /* synthetic */ boolean $refresh;
            {
                this.$project = $project;
                this.$sqlDataSource = $sqlDataSource;
                this.$refresh = $refresh;
                super(0);
            }

            @NotNull
            public final AsyncTask<SyncQueue.SyncResult> invoke() {
                return RefreshActionsLogic.access$asyncForgetModelAndRefreshForDataSource(this.$project, this.$sqlDataSource, this.$refresh);
            }
        });
    }

    private static final AsyncTask<SyncQueue.SyncResult> asyncForgetModelAndRefreshForDataSource(Project project, SqlDataSource sqlDataSource, boolean refresh2) {
        AsyncTask<SyncQueue.SyncResult> asyncTask;
        AsyncTask<SyncQueue.SyncResult> stage2 = DataSourceSyncManager.getInstance().stopSynchronization((DasDataSource)sqlDataSource).whenComplete(AsyncUtil.getPoolExecutor(), (Function0<Unit>)((Function0)new Function0<Unit>(sqlDataSource){
            final /* synthetic */ SqlDataSource $sqlDataSource;
            {
                this.$sqlDataSource = $sqlDataSource;
                super(0);
            }

            public final void invoke() {
                this.$sqlDataSource.clearModel();
            }
        }));
        boolean bl = refresh2;
        if (bl) {
            asyncTask = stage2.whenComplete(null, (Function0<Unit>)((Function0)new Function0<Unit>(project, sqlDataSource){
                final /* synthetic */ Project $project;
                final /* synthetic */ SqlDataSource $sqlDataSource;
                {
                    this.$project = $project;
                    this.$sqlDataSource = $sqlDataSource;
                    super(0);
                }

                public final void invoke() {
                    RefreshActionsLogic.runDataSourceGeneralRefresh(this.$project, (RawDataSource)this.$sqlDataSource);
                }
            }));
        } else if (!bl) {
            asyncTask = stage2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return asyncTask;
    }

    private static final Void logFailed(String message2) {
        logger.warn(message2);
        return null;
    }

    private static final BasicElement regularRefreshPerform$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final boolean regularRefreshPerform$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean diagnosticRefreshPerform$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean extendIntrospectionScopeIfNeeded$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final TreePattern extendIntrospectionScopeIfNeeded$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TreePattern)$tmp0.invoke(p0);
    }

    private static final BasicNode runDbElementsRefresh$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicNode)$tmp0.invoke(p0);
    }

    private static final BasicModel runDbElementsRefresh$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicModel)$tmp0.invoke(p0);
    }

    private static final boolean forgetSchemas$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ BasicElement access$adjustNodeToElement(BasicNode node2) {
        return RefreshActionsLogic.adjustNodeToElement(node2);
    }

    public static final /* synthetic */ void access$forgetSchemasInOneModel(BasicModel model2, Collection namespaces2) {
        RefreshActionsLogic.forgetSchemasInOneModel(model2, namespaces2);
    }

    public static final /* synthetic */ AsyncTask access$asyncForgetModelAndRefreshForDataSource(Project project, DataSourceStorage storage, LocalDataSource localDataSource, boolean refresh2) {
        return RefreshActionsLogic.asyncForgetModelAndRefreshForDataSource(project, storage, localDataSource, refresh2);
    }

    public static final /* synthetic */ AsyncTask access$asyncForgetModelAndRefreshForDataSource(Project project, SqlDataSource sqlDataSource, boolean refresh2) {
        return RefreshActionsLogic.asyncForgetModelAndRefreshForDataSource(project, sqlDataSource, refresh2);
    }

    static {
        Logger logger2 = Logger.getInstance((String)"com.intellij.database.actions.Refresh");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }
}

