/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.PerformActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QueryActionBase
extends PerformActionBase
implements Toggleable {
    public void update(@NotNull AnActionEvent e2) {
        boolean enabled;
        if (e2 == null) {
            QueryActionBase.$$$reportNull$$$0(0);
        }
        Editor editor2 = (Editor)e2.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
        FileEditor fileEditor = (FileEditor)e2.getData(PlatformCoreDataKeys.FILE_EDITOR);
        JdbcConsole console = QueryActionBase.getConsole(e2);
        boolean applicable = QueryActionBase.isEditorOrStructurePopup(editor2, fileEditor) && (!this.isConsoleRequired() || console != null) && this.isApplicable(console, editor2, file);
        boolean bl = enabled = applicable && this.isEnabled(console, editor2, file);
        if (enabled && console != null && console.isValid()) {
            Editor resultEditor = editor2 == null ? ((TextEditor)fileEditor).getEditor() : editor2;
            TextRange range = ScriptModelUtil.getSelectedStatementsRange(console, resultEditor, this.getExecOption());
            e2.getPresentation().setEnabled(range.getLength() > 0);
            e2.getPresentation().setVisible(true);
        }
        e2.getPresentation().setEnabled(enabled);
        e2.getPresentation().setVisible(applicable || e2.isFromActionToolbar());
    }

    private static boolean isEditorOrStructurePopup(@Nullable Editor editor2, @Nullable FileEditor fileEditor) {
        return EditorUtil.isRealFileEditor((Editor)editor2) || editor2 == null && fileEditor instanceof TextEditor;
    }

    static boolean shouldBePromoted(@NotNull DataContext context) {
        if (context == null) {
            QueryActionBase.$$$reportNull$$$0(1);
        }
        FileEditor fileEditor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(context);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(context);
        return QueryActionBase.isEditorOrStructurePopup(editor2, fileEditor);
    }

    protected boolean isApplicable(@Nullable JdbcConsole console, @Nullable Editor editor2, @Nullable PsiFile file) {
        return JdbcConsoleProvider.isSqlAtPlace(file, editor2) || console != null && JdbcConsoleProvider.isJSAtPlace(file, editor2);
    }

    protected boolean isEnabled(@Nullable JdbcConsole console, Editor editor2, PsiFile file) {
        return true;
    }

    protected boolean isConsoleRequired() {
        return true;
    }

    @NotNull
    protected DatabaseSettings.ExecOption getExecOption() {
        DatabaseSettings.ExecOption execOption = DatabaseSettings.getDefaultExecOption();
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(2);
        }
        return execOption;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Project project;
        if (e2 == null) {
            QueryActionBase.$$$reportNull$$$0(3);
        }
        if ((project = e2.getProject()) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        DatabaseSettings.ExecOption option = this.getExecOption();
        JdbcConsoleProvider.Info info2 = (JdbcConsoleProvider.Info)ObjectUtils.chooseNotNull((Object)QueryActionBase.getInfoClassic(e2, option), (Object)QueryActionBase.findInfoFromFileStructure(e2, option));
        if (info2 == null) {
            return;
        }
        this.invokeImpl(e2, QueryActionBase.getConsole(e2), info2);
    }

    @Nullable
    public static JdbcConsoleProvider.Info getInfoClassic(@NotNull AnActionEvent e2, @NotNull DatabaseSettings.ExecOption execOption) {
        if (e2 == null) {
            QueryActionBase.$$$reportNull$$$0(4);
        }
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(5);
        }
        Editor editor2 = (Editor)e2.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
        PsiElement elementAt = JdbcConsoleProvider.elementAt(file, null, editor2);
        if (elementAt == null) {
            return null;
        }
        return JdbcConsoleProvider.findScriptModel(file, elementAt, editor2, execOption);
    }

    @Nullable
    private static JdbcConsoleProvider.Info findInfoFromFileStructure(@NotNull AnActionEvent e2, @NotNull DatabaseSettings.ExecOption execOption) {
        Editor editor2;
        if (e2 == null) {
            QueryActionBase.$$$reportNull$$$0(6);
        }
        if (execOption == null) {
            QueryActionBase.$$$reportNull$$$0(7);
        }
        JBIterable elements2 = JBIterable.of((Object[])((PsiElement[])e2.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
        PsiFile file = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
        FileEditor fileEditor = (FileEditor)e2.getData(PlatformCoreDataKeys.FILE_EDITOR);
        Editor editor3 = editor2 = fileEditor instanceof TextEditor ? DataManagerImpl.validateEditor((Editor)((TextEditor)fileEditor).getEditor(), (Component)((Component)e2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT))) : null;
        if (file == null || elements2.isEmpty() || editor2 == null) {
            return null;
        }
        HashSet<TextRange> set = new HashSet<TextRange>();
        for (PsiElement pe : elements2) {
            if (!file.equals(pe.getContainingFile())) {
                return null;
            }
            set.add(pe.getTextRange());
        }
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        ScriptModel model2 = QueryActionBase.filterRanges(SqlPsiFacade.getInstance((Project)project).createScriptModel(file), set);
        return new JdbcConsoleProvider.Info(file, file, (EditorEx)editor2, model2, execOption, null);
    }

    private static <V> ScriptModel<V> filterRanges(ScriptModel<V> model2, final Set<TextRange> set) {
        return model2.rawTransform(new Function.Mono<SyntaxTraverser<V>>(){

            public SyntaxTraverser<V> fun(SyntaxTraverser<V> s2) {
                return (SyntaxTraverser)s2.regard(Conditions.compose((Function)s2.api.TO_RANGE, range -> set.contains(range)));
            }
        });
    }

    protected void invokeImpl(@NotNull AnActionEvent e2, @Nullable JdbcConsole console, @NotNull JdbcConsoleProvider.Info info2) {
        if (e2 == null) {
            QueryActionBase.$$$reportNull$$$0(8);
        }
        if (info2 == null) {
            QueryActionBase.$$$reportNull$$$0(9);
        }
        JdbcConsoleProvider.chooseStatements(info2, DatabaseBundle.message("no.query.found", new Object[0]), false, scriptModel -> this.invokeImpl(console, (ScriptModel<?>)scriptModel, info2));
    }

    protected abstract void invokeImpl(@Nullable JdbcConsole var1, @NotNull ScriptModel<?> var2, @NotNull JdbcConsoleProvider.Info var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/QueryActionBase";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/QueryActionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldBePromoted";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInfoClassic";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findInfoFromFileStructure";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

