/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportEditorContext
extends DatabaseEditorContext {
    private final ImportManager myManager;
    private final DbNamespace myNamespace;
    private final List<DbTable> myTables;

    public ImportEditorContext(@NotNull DatabaseEditorContext context, @Nullable DbNamespace namespace) {
        if (context == null) {
            ImportEditorContext.$$$reportNull$$$0(0);
        }
        super(context.getProject(), context.getDbms(), context.getModel(), context.getDataSource(), context.getSearchPath(), context.getVirtualFile(), null);
        this.myManager = ImportManager.of(context.getDbms(), DbImplUtilCore.getDatabaseVersion(this.getDataSource()));
        this.myNamespace = namespace;
        this.myTables = this.getContextTables();
    }

    @NotNull
    public List<DbTable> getTables() {
        List<DbTable> list = this.myTables;
        if (list == null) {
            ImportEditorContext.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public DbNamespace getNamespace() {
        return this.myNamespace;
    }

    @NotNull
    public ImportManager getManager() {
        ImportManager importManager = this.myManager;
        if (importManager == null) {
            ImportEditorContext.$$$reportNull$$$0(2);
        }
        return importManager;
    }

    public boolean isTableExists(@NotNull String name2) {
        if (name2 == null) {
            ImportEditorContext.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists(this.myTables, DasUtil.byName(name2));
    }

    @NotNull
    private List<DbTable> getContextTables() {
        DasNamespace namespace = DbImplUtilCore.getTopSingleNamespace(this.myNamespace);
        if (namespace == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ImportEditorContext.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = namespace.getDasChildren(ObjectKind.TABLE).filter(DbTable.class).toList();
        if (list == null) {
            ImportEditorContext.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public ImportType getImportType(@NotNull DeTable consumer2) {
        if (consumer2 == null) {
            ImportEditorContext.$$$reportNull$$$0(6);
        }
        ImportType importType = this.isTableExists(consumer2.name) ? ImportType.EXISTING_TABLE : ImportType.NEW_TABLE;
        if (importType == null) {
            ImportEditorContext.$$$reportNull$$$0(7);
        }
        return importType;
    }

    @NotNull
    public ImportType getImportType(@NotNull String consumerName) {
        if (consumerName == null) {
            ImportEditorContext.$$$reportNull$$$0(8);
        }
        ImportType importType = this.isTableExists(consumerName) ? ImportType.EXISTING_TABLE : ImportType.NEW_TABLE;
        if (importType == null) {
            ImportEditorContext.$$$reportNull$$$0(9);
        }
        return importType;
    }

    @Nullable
    public DbTable findTable(String name2) {
        return (DbTable)ContainerUtil.find(this.myTables, DasUtil.byName(name2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ImportEditorContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ImportEditorContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTables";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextTables";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTableExists";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 7, 9 -> new IllegalStateException(string);
        };
    }
}

