/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.dialects.DefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.UtilKt;
import com.intellij.database.script.generator.ui.ScriptGeneratorTool;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateSqlActions {
    private static final ScriptingOptions SCRIPTING_OPTIONS_FOR_CLIPBOARD = DefaultScriptingOptions.INSTANCE;
    private static final ScriptingOptions SCRIPTING_OPTIONS_FOR_CONSOLE = new CustomScriptingOptions((Map<ScriptingOption<?>, ? extends Object>)ImmutableMap.of(ScriptingOptionStatic.CREATE_OR_REPLACE, (Object)true, ScriptingOptionStatic.CREATE_IF_NOT_EXISTS, (Object)true));

    @NotNull
    private static JBIterable<BasicElement> getElements(AnActionEvent e2, boolean scriptableOnly) {
        JBIterable result2 = DatabaseContextFun.getSelectedElements(e2.getDataContext());
        JBIterable jBIterable = scriptableOnly ? result2.filter(GenerateSqlActions::isElementScriptable) : result2;
        if (jBIterable == null) {
            GenerateSqlActions.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    public static AsyncTask<Void> generateDbDdl(@NotNull DefinitionProvider provider, @NotNull List<DbElement> objects2, @NotNull ErrorHandler handler2, @NotNull StringBuilder builder, boolean markDb) {
        List<DbElement> current;
        DbElement first2;
        LocalDataSource dataSource2;
        if (provider == null) {
            GenerateSqlActions.$$$reportNull$$$0(1);
        }
        if (objects2 == null) {
            GenerateSqlActions.$$$reportNull$$$0(2);
        }
        if (handler2 == null) {
            GenerateSqlActions.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            GenerateSqlActions.$$$reportNull$$$0(4);
        }
        LocalDataSource localDataSource = dataSource2 = (first2 = (DbElement)ContainerUtil.getFirstItem(objects2)) == null ? null : DbImplUtil.getMaybeLocalDataSource(first2.getDataSource());
        if (dataSource2 == null) {
            return AsyncTask.completed(null);
        }
        ObjectPath path = ObjectPaths.of(DasUtil.getNamespace(first2));
        ArrayList rest = new ArrayList();
        if (JdbcUrlParserUtil.isDatabaseBounded(dataSource2)) {
            current = new ArrayList<DbElement>();
            for (DbElement object : objects2) {
                (JdbcUrlParserUtil.outOfBounds((DatabaseConnectionPoint)dataSource2, path, ObjectPaths.of(object)) ? rest : current).add(object);
            }
        } else {
            current = objects2;
        }
        Project project = first2.getProject();
        SearchPath searchPath = SearchPath.of(path);
        return DatabaseSessionManager.getFacade(project, dataSource2, null, searchPath, false, handler2, DGDepartment.CODE_GENERATION).runAsync(SessionsUtil.function(connection2 -> {
            if (!rest.isEmpty() || markDb) {
                builder.append("-- Database ").append(DasUtil.getCatalog(first2)).append("\n");
            }
            provider.load((Iterable<? extends DasObject>)current, (DatabaseConnectionCore)connection2, builder);
            return null;
        })).applyAsync(AsyncUtil.getPoolExecutor(), r -> rest.isEmpty() ? AsyncTask.completed(null) : GenerateSqlActions.generateDbDdl(provider, rest, handler2, builder, true));
    }

    public static ActionStatus checkActionScriptableStatus(@NotNull JBIterable<BasicElement> elements2, @Nullable Predicate<BasicElement> applicabilityPredicate) {
        if (elements2 == null) {
            GenerateSqlActions.$$$reportNull$$$0(5);
        }
        JBIterable unwantedElements = elements2.filter(x -> x instanceof BasicNamespaceOwner);
        JBIterable applicableElements = elements2;
        if (applicabilityPredicate != null) {
            applicableElements = applicableElements.filter(applicabilityPredicate::test);
        }
        if (applicableElements.isEmpty()) {
            return ActionStatus.HIDDEN;
        }
        if (unwantedElements.isNotEmpty()) {
            return ActionStatus.DISABLED;
        }
        BasicModel model2 = (BasicModel)applicableElements.map(BasicNode::getModel).unique().single();
        if (model2 == null) {
            return ActionStatus.DISABLED;
        }
        JBIterable scriptableElements = applicableElements.filter(GenerateSqlActions::isBasicElementScriptable);
        return scriptableElements.isNotEmpty() ? ActionStatus.ENABLED : ActionStatus.DISABLED;
    }

    private static boolean isElementScriptable(@Nullable BasicElement element2) {
        if (element2 == null) {
            return false;
        }
        return element2 instanceof BasicSchemaObject || element2 instanceof BasicSchema;
    }

    private static boolean isBasicElementScriptable(@Nullable BasicElement element2) {
        return element2 != null;
    }

    @NotNull
    private static String doGenerateDDLUnderProgress(@NotNull Collection<BasicElement> selectedElements, @NotNull Project project, boolean forConsole, @Nls String actionName) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(7);
        }
        String string = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GenerateSqlActions.doGenerateDDL(selectedElements, project, forConsole, actionName), DatabaseBundle.message("progress.title.generating.code", new Object[0]), true, project);
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String doGenerateDDL(@NotNull Collection<BasicElement> selectedElements, @NotNull Project project, boolean forConsole, @Nls String actionName) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(10);
        }
        TreePattern scope = null;
        for (BasicElement e2 : selectedElements) {
            if (!(e2 instanceof BasicRoot)) continue;
            scope = GenerateSqlActions.getIntrospectionScope((BasicRoot)e2, project);
            break;
        }
        return GenerateSqlActions.doGenerateDDLUsingScriptingService(project, scope, selectedElements, forConsole, actionName);
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(Project project, @Nullable TreePattern scope, @NotNull Collection<BasicElement> selectedElements, boolean forConsole, @Nls String actionName) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(11);
        }
        Map<BasicModel, List<BasicElement>> groupedByModels = ModelFun.groupByModel(selectedElements);
        StringBuilder b2 = new StringBuilder();
        for (Map.Entry<BasicModel, List<BasicElement>> entry : groupedByModels.entrySet()) {
            BasicModel m = entry.getKey();
            ArrayList<BasicElement> elements2 = new ArrayList<BasicElement>((Collection)entry.getValue());
            GenerateSqlActions.abortIfSyncRequired(project, m, elements2, actionName);
            String text2 = GenerateSqlActions.doGenerateDDLUsingScriptingService(project, scope, m, elements2, forConsole);
            if (text2.length() <= 0) continue;
            if (b2.length() > 0) {
                b2.append("\n\n");
            }
            b2.append(text2);
        }
        String string = b2.toString();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void abortIfSyncRequired(Project project, BasicModel m, Collection<BasicElement> elements2, @Nls String actionName) {
        RawDataSource dataSource2 = ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDataSource(m.getRoot());
        DetailsSyncHelper syncHelper = DetailsSyncHelper.of(project, dataSource2, null);
        if (syncHelper.check(elements2).askAbortIfSyncRequiredAnyThread(actionName)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(@NotNull Project project, @Nullable TreePattern scope, @NotNull BasicModel model2, @NotNull Iterable<? extends BasicElement> selectedElements, boolean forConsole) {
        JBIterable explicitSchemata;
        JBIterable selection2;
        JBIterable visibleDatabasesOfRoot;
        JBIterable databasesSchemata;
        List schemata;
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(13);
        }
        if (model2 == null) {
            GenerateSqlActions.$$$reportNull$$$0(14);
        }
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(15);
        }
        BasicSchema schema2 = (schemata = (databasesSchemata = (visibleDatabasesOfRoot = (selection2 = JBIterable.from(selectedElements)).filter(BasicMultiDatabaseRoot.class).flatten(BasicMultiDatabaseRoot::getDatabases).filter(BasicDatabase.class).filter(d2 -> scope == null || DataSourceSchemaMapping.matches(scope, d2))).append((Iterable)selection2.filter(BasicDatabase.class).filter(db -> !visibleDatabasesOfRoot.contains(db))).flatten(BasicDatabase::getSchemas).filter(BasicSchema.class).filter(s2 -> !s2.isNameSurrogate()).filter(s2 -> scope == null || DataSourceSchemaMapping.matches(scope, s2))).append((Iterable)(explicitSchemata = selection2.filter(BasicSchema.class).filter(s2 -> !databasesSchemata.contains(s2)))).toList()).size() == 1 ? (BasicSchema)schemata.get(0) : null;
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model2, ScriptCategory.CREATE_COMPLETE);
        JBIterable.from((Iterable)schemata).flatten(UtilKt::getScriptableMajorObjects).append((Iterable)selection2.filter(o2 -> !schemata.contains(o2.getSchema()))).addAllTo(taskBuilder.getElements());
        taskBuilder.setCurrentSchema(schema2);
        taskBuilder.setOptions(forConsole ? SCRIPTING_OPTIONS_FOR_CONSOLE : SCRIPTING_OPTIONS_FOR_CLIPBOARD);
        ScriptingResult result2 = ScriptGenerators.INSTANCE.makeScript(project, taskBuilder.build());
        String string = result2.getScriptText();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    private static TreePattern getIntrospectionScope(@NotNull BasicRoot root2, @NotNull Project project) {
        DbModelRegistry modelRegistry2;
        if (root2 == null) {
            GenerateSqlActions.$$$reportNull$$$0(17);
        }
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(18);
        }
        if ((modelRegistry2 = (DbModelRegistry)project.getService(DbModelRegistry.class)) == null) {
            return null;
        }
        RawDataSource ds = modelRegistry2.findDataSource(root2);
        return ds instanceof LocalDataSource ? ((LocalDataSource)ds).getIntrospectionScope() : null;
    }

    @Nullable
    private static DbElement findDbElement(@NotNull BasicElement element2, @NotNull Project project) {
        DbModelRegistry r;
        if (element2 == null) {
            GenerateSqlActions.$$$reportNull$$$0(19);
        }
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(20);
        }
        if ((r = (DbModelRegistry)project.getService(DbModelRegistry.class)) == null) {
            return null;
        }
        return r.findDbElement(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDLUnderProgress";
                break;
            }
            case 12: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDLUsingScriptingService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDbDdl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkActionScriptableStatus";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDLUnderProgress";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDL";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDLUsingScriptingService";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIntrospectionScope";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findDbElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }

    static class ShowSqlGeneratorAction
    extends DumbAwareAction {
        ShowSqlGeneratorAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(1);
            }
            ActionStatus status = GenerateSqlActions.checkActionScriptableStatus(GenerateSqlActions.getElements(e2, false), null);
            e2.getPresentation().setVisible(status.visible || e2.isFromActionToolbar());
            e2.getPresentation().setEnabled(status.enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            JBIterable<BasicElement> basicElements;
            JBIterable scriptableElements;
            if (e2 == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(2);
            }
            if ((scriptableElements = (basicElements = GenerateSqlActions.getElements(e2, false)).filter(GenerateSqlActions::isBasicElementScriptable)).isEmpty()) {
                return;
            }
            Project project = e2.getProject();
            BasicModel model2 = (BasicModel)basicElements.map(BasicNode::getModel).unique().single();
            if (project == null || model2 == null) {
                return;
            }
            ScriptGeneratorTool.INSTANCE.show(project, model2, (Iterable<? extends BasicNode>)scriptableElements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$ShowSqlGeneratorAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$ShowSqlGeneratorAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class SqlActionsGroup
    extends DefaultActionGroup {
        private static final Set<DvTreeNodeRank> APPLICABLE_TREE_NODE_RANKS = EnumSet.of(DvTreeNodeRank.TL_ROOT, DvTreeNodeRank.TL_NAMESPACE, DvTreeNodeRank.TL_FAMILY, DvTreeNodeRank.TL_ELEMENT);

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SqlActionsGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                SqlActionsGroup.$$$reportNull$$$0(1);
            }
            Presentation presentation = e2.getPresentation();
            Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(e2.getDataContext());
            if (CollectionFun.intersects(ranks, APPLICABLE_TREE_NODE_RANKS)) {
                ActionStatus status = "EditorPopup".equals(e2.getPlace()) ? GenerateSqlActions.checkActionScriptableStatus(GenerateSqlActions.getElements(e2, false), null) : ActionStatus.ENABLED;
                presentation.setEnabledAndVisible(status.enabled);
            } else {
                presentation.setEnabledAndVisible(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$SqlActionsGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$SqlActionsGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    static class OpenDdlInConsoleAction
    extends DumbAwareAction {
        OpenDdlInConsoleAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(1);
            }
            boolean enabled = GenerateSqlActions.getElements(e2, true).find(el -> DbImplUtilCore.getDbms(el) != Dbms.MONGO) != null;
            e2.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Project project;
            if (e2 == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(2);
            }
            if ((project = e2.getProject()) == null) {
                return;
            }
            List elements2 = GenerateSqlActions.getElements(e2, true).unique().toList();
            String ddl = GenerateSqlActions.doGenerateDDLUnderProgress(elements2, project, true, e2.getPresentation().getText());
            if (StringUtil.isEmpty((String)ddl)) {
                return;
            }
            BasicElement firstElement = (BasicElement)elements2.get(0);
            DbElement firstDbElement = GenerateSqlActions.findDbElement(firstElement, project);
            DbUIUtil.openInConsole(firstDbElement, ddl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$OpenDdlInConsoleAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$OpenDdlInConsoleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class CopyDdlAction
    extends DumbAwareAction {
        CopyDdlAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CopyDdlAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                CopyDdlAction.$$$reportNull$$$0(1);
            }
            boolean enabled = GenerateSqlActions.getElements(e2, false).find(el -> DbImplUtilCore.getDbms(el) != Dbms.MONGO) != null;
            e2.getPresentation().setEnabled(enabled);
            e2.getPresentation().setVisible(enabled || e2.isFromActionToolbar());
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            List elements2;
            if (e2 == null) {
                CopyDdlAction.$$$reportNull$$$0(2);
            }
            if ((elements2 = GenerateSqlActions.getElements(e2, false).unique().toList()).isEmpty()) {
                return;
            }
            Project project = e2.getProject();
            if (project == null) {
                return;
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(GenerateSqlActions.doGenerateDDLUnderProgress(elements2, project, false, e2.getPresentation().getText())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class CopyDdlFromDbAction
    extends DumbAwareAction {
        CopyDdlFromDbAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(1);
            }
            JBIterable<DbElement> objects2 = this.getObjects(e2.getDataContext());
            JBIterable<DbElement> supported = this.filterSupported(objects2);
            boolean visible = !objects2.isEmpty();
            boolean enabled = visible && !supported.isEmpty();
            e2.getPresentation().setEnabled(enabled);
            e2.getPresentation().setVisible(visible);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            JBIterable<DbElement> objects2;
            DbElement first2;
            DefinitionProvider provider;
            if (e2 == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(2);
            }
            if ((provider = this.getProvider(first2 = (DbElement)(objects2 = this.getObjects(e2.getDataContext())).first())) == null || first2 == null) {
                return;
            }
            AsyncTask.withBgIndicator(AsyncTask.frame(DatabaseBundle.message("action.DatabaseView.CopyDdlFromDbAction.loading.sources", new Object[0])), first2.getProject(), null, true).sync(() -> {
                ErrorHandler handler2 = new ErrorHandler();
                StringBuilder builder = new StringBuilder();
                GenerateSqlActions.generateDbDdl(provider, objects2.filter(provider::isSupported).toList(), handler2, builder, false).whenComplete(AsyncUtil.getEdtExecutor(), (s2, throwable) -> {
                    if (throwable != null) {
                        AsyncUtil.addUnhandledError(handler2, throwable, DbImplUtil.getMaybeLocalDataSource(first2.getDataSource()));
                        if (handler2.hasErrors()) {
                            DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(handler2.getSummary(), MessageType.ERROR).setDisplayId("CopyDdlFromDbAction.error").notify(e2.getProject());
                        }
                    } else {
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(builder.toString()));
                    }
                });
                return null;
            });
        }

        @NotNull
        JBIterable<DbElement> getObjects(DataContext context) {
            JBIterable<DbElement> objects2 = DatabaseContextFun.getSelectedDbElementsExpandingGroups(context);
            DbElement first2 = (DbElement)objects2.first();
            if (first2 == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    CopyDdlFromDbAction.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }
            DbDataSource dataSource2 = first2.getDataSource();
            JBIterable jBIterable = objects2.filter(o2 -> o2 != dataSource2 && o2.getDataSource() == dataSource2);
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @NotNull
        JBIterable<DbElement> filterSupported(@NotNull JBIterable<DbElement> objects2) {
            DefinitionProvider provider;
            if (objects2 == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(5);
            }
            JBIterable jBIterable = (provider = this.getProvider((DbElement)objects2.first())) == null ? JBIterable.empty() : objects2.filter(provider::isSupported);
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        @Nullable
        DefinitionProvider getProvider(@Nullable DbElement first2) {
            if (first2 == null) {
                return null;
            }
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource(first2.getDataSource());
            if (localDataSource == null) {
                return null;
            }
            return AbstractDefinitionProvider.find(localDataSource);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterSupported";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "filterSupported";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

