/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.csv.CsvFileType;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.csv.ui.CsvFormatsUI;
import com.intellij.database.csv.ui.FormatsListAndPreviewPanel;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.dbimport.csv.CsvSource;
import com.intellij.database.editor.CsvTableFileEditorProvider;
import com.intellij.database.editor.FragmentTableFileEditorProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditAsTableAction
extends DumbAwareAction
implements PerformWithDocumentsCommitted {
    private static final String CSV_FORMAT_DIALOG_DIMENSION_SERVICE_KEY = "editAsTableFormatDialogDimension";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            EditAsTableAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e2) {
        boolean isDml;
        boolean visible;
        String place;
        if (e2 == null) {
            EditAsTableAction.$$$reportNull$$$0(1);
        }
        Editor editor2 = "ContextToolbar".equals(place = e2.getPlace()) ? (Editor)e2.getData(CommonDataKeys.EDITOR) : EditAsTableAction.getEditor(e2);
        VirtualFile fileFromEditor = editor2 == null ? null : FileDocumentManager.getInstance().getFile(editor2.getDocument());
        VirtualFile file = fileFromEditor == null ? EditAsTableAction.getFileFromDataGrid(e2) : fileFromEditor;
        Project project = e2.getProject();
        if (project == null || file == null) {
            e2.getPresentation().setText(this.getTemplatePresentation().getText());
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if ("ContextToolbar".equals(place)) {
            visible = FileTypeManager.getInstance().isFileOfType(file, (FileType)CsvFileType.INSTANCE);
            isDml = false;
        } else if (EditorUtil.contextMenuInvokedOutsideOfSelection((AnActionEvent)e2)) {
            visible = false;
            isDml = false;
        } else {
            boolean isCsv;
            Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
            TextRange selection2 = EditAsTableAction.getSelection(editor2);
            boolean oneToken = selection2 != null && EditAsTableAction.isOneTokenSelection(editor2, selection2);
            isDml = selection2 != null && language instanceof SqlLanguageDialect;
            boolean bl = isCsv = language != null && language.isKindOf((Language)PlainTextLanguage.INSTANCE);
            if (isDml && oneToken) {
                isDml = false;
                isCsv = true;
            }
            boolean bl2 = visible = isDml || isCsv || !"EditorPopup".equals(place);
        }
        String text2 = fileFromEditor == null ? DataGridBundle.message((String)"action.FileEditor.ChangeFormat.text", (Object[])new Object[0]) : this.getTemplatePresentation().getText() + (isDml ? "" : "...");
        e2.getPresentation().setText(text2);
        e2.getPresentation().setEnabled(true);
        e2.getPresentation().setVisible(visible);
    }

    public static int getPreviewCharacterCount() {
        return CsvSource.getPreviewCharacterCount();
    }

    @Nullable
    private static VirtualFile getFileFromDataGrid(AnActionEvent e2) {
        DataGrid grid = GridUtil.getDataGrid((DataContext)e2.getDataContext());
        DocumentDataHookUp up = grid == null ? null : GridUtil.getDocumentDataHookUp((CoreGrid)grid);
        return up instanceof CsvDocumentDataHookUp ? FileDocumentManager.getInstance().getFile(up.getDocument()) : null;
    }

    @Nullable
    private static Editor getEditor(AnActionEvent e2) {
        Project project = e2.getProject();
        Editor editor2 = (Editor)e2.getData(CommonDataKeys.EDITOR);
        if (editor2 != null && project != null) {
            return (Editor)ObjectUtils.chooseNotNull((Object)BaseCodeInsightAction.getInjectedEditor((Project)project, (Editor)editor2, (boolean)false), (Object)editor2);
        }
        return editor2;
    }

    private static boolean isOneTokenSelection(@NotNull Editor e2, @NotNull TextRange r) {
        if (e2 == null) {
            EditAsTableAction.$$$reportNull$$$0(2);
        }
        if (r == null) {
            EditAsTableAction.$$$reportNull$$$0(3);
        }
        if (e2.getProject() == null) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)e2.getProject()).getPsiFile(e2.getDocument());
        if (file == null) {
            return false;
        }
        PsiElement elem = file.findElementAt(r.getStartOffset() + r.getLength() / 2);
        if (elem == null) {
            return false;
        }
        return elem.getTextRange().contains(r);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Language language;
        Document document;
        if (e2 == null) {
            EditAsTableAction.$$$reportNull$$$0(4);
        }
        String place = e2.getPlace();
        Project project = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Editor editor2 = "ContextToolbar".equals(place) ? (Editor)e2.getData(CommonDataKeys.EDITOR) : EditAsTableAction.getEditor(e2);
        VirtualFile fileFromEditor = editor2 == null ? null : FileDocumentManager.getInstance().getFile(editor2.getDocument());
        VirtualFile file = fileFromEditor == null ? EditAsTableAction.getFileFromDataGrid(e2) : fileFromEditor;
        Document document2 = document = file == null ? null : FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return;
        }
        TextRange selection2 = EditAsTableAction.getSelection(editor2);
        if (selection2 != null && (language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) instanceof SqlLanguageDialect && !EditAsTableAction.isOneTokenSelection(editor2, selection2)) {
            FragmentTableFileEditorProvider.openFragmentEditor(project, file, selection2, (SqlLanguageDialect)language);
            return;
        }
        CsvFormat format2 = EditAsTableAction.showDataFormatEditorDialog(project, file, document, selection2);
        if (format2 != null) {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
                if (selection2 == null && file instanceof VirtualFileWithId && (EditorUtil.isRealFileEditor((Editor)editor2) || fileFromEditor == null)) {
                    CsvTableFileEditorProvider.openEditor((Project)project, (VirtualFile)file, (CsvFormat)format2);
                } else {
                    FragmentTableFileEditorProvider.openFragmentEditor(project, file, selection2 == null ? TextRange.from((int)0, (int)document.getTextLength()) : selection2, format2);
                }
            });
        }
    }

    @Nullable
    private static TextRange getSelection(@Nullable Editor editor2) {
        if (editor2 == null) {
            return null;
        }
        TextRange range = EditorUtil.getSelectionInAnyMode((Editor)editor2);
        if (range.isEmpty()) {
            if (editor2.getProject() == null) {
                return null;
            }
            SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)PsiDocumentManager.getInstance((Project)editor2.getProject()).getPsiFile(editor2.getDocument()), SqlFile.class);
            if (file == null || !file.getSqlLanguage().getDbms().isPostgres()) {
                return null;
            }
            PsiElement element2 = file.findElementAt(editor2.getCaretModel().getOffset());
            IElementType type = element2 == null ? null : element2.getNode().getElementType();
            return type != null && type.toString().equals("#SQL_RAW_INPUT") ? element2.getTextRange() : null;
        }
        return range;
    }

    @Nullable
    private static CsvFormat showDataFormatEditorDialog(@NotNull Project project, @NotNull VirtualFile file, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            EditAsTableAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            EditAsTableAction.$$$reportNull$$$0(6);
        }
        if (document == null) {
            EditAsTableAction.$$$reportNull$$$0(7);
        }
        Disposable disposable = Disposer.newDisposable();
        String text2 = range == null ? EditAsTableAction.getLimitedText(document) : range.subSequence(document.getCharsSequence()).toString();
        CsvFormatsSelectionUI formatsForm = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(disposable);
        CsvFormat format2 = CsvFormatResolver.getFormat((Project)project, (VirtualFile)file, (boolean)true, null, (CsvFormatResolver.FormatGetter[])new CsvFormatResolver.FormatGetter[]{CsvFormatResolver.FormatGetter.STATE, CsvFormatResolver.FormatGetter.FILE, CsvFormatResolver.FormatGetter.CONTENT});
        formatsForm.select(format2);
        CsvFormat selectedFormat = formatsForm.getSelectedFormat();
        TableCsvFormatPreview preview = new TableCsvFormatPreview(project, Objects.requireNonNull(selectedFormat), (CharSequence)text2, disposable, null);
        FormatsListAndPreviewPanel panel2 = new FormatsListAndPreviewPanel((CsvFormatsUI)formatsForm, (CsvFormatPreview)preview);
        panel2.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        DialogBuilder dialog = new DialogBuilder(project).title(DatabaseBundle.message("dialog.title.format", file.getName(), range != null ? DatabaseBundle.message("dialog.title.format.fragment", new Object[0]) : "")).centerPanel((JComponent)panel2).dimensionKey(CSV_FORMAT_DIALOG_DIMENSION_SERVICE_KEY);
        dialog.addOkAction().setText(DatabaseBundle.message("dialog.ok.action.format", new Object[0]));
        dialog.addCancelAction();
        dialog.setHelpId("edit.as.table.format.configuration.dialog");
        Disposer.register((Disposable)dialog, (Disposable)disposable);
        return dialog.showAndGet() ? formatsForm.getSelectedFormat() : null;
    }

    @NotNull
    private static String getLimitedText(@NotNull Document document) {
        if (document == null) {
            EditAsTableAction.$$$reportNull$$$0(8);
        }
        String string = document.getText().substring(0, Math.min(document.getTextLength(), EditAsTableAction.getPreviewCharacterCount()));
        if (string == null) {
            EditAsTableAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/EditAsTableAction";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/EditAsTableAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLimitedText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOneTokenSelection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDataFormatEditorDialog";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLimitedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

